/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.asyncwithhandler;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryStreamClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextStreamClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.asyncwithhandler.AsyncEndpointCallback;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -1237079492944813869L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_remoteendpoint_usercoder_asynchandler_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.asyncwithhandler"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_remoteendpoint_usercoder_asynchandler_web");
    }

    @Test
    public void sendObjectPrimitivesTextEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.invoke("text", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        for (Object clientEntity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint((AnnotatedClientEndpoint)client);
            this.setEntity(new Object[]{clientEntity});
            this.setClientCallback(new AsyncEndpointCallback(this.entity));
            this.invoke("echo", clientEntity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.invoke("textstream", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnClientTest() throws Exception {
        WSCTextStreamClientEndpoint client = new WSCTextStreamClientEndpoint();
        for (Object clientEntity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint((AnnotatedClientEndpoint)client);
            this.setEntity(new Object[]{clientEntity});
            this.setClientCallback(new AsyncEndpointCallback(this.entity));
            this.invoke("echo", clientEntity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binary", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnClientTest() throws Exception {
        WSCBinaryClientEndpoint client = new WSCBinaryClientEndpoint();
        for (Object clientEntity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint((AnnotatedClientEndpoint)client);
            this.setEntity(new Object[]{clientEntity});
            this.setClientCallback(new AsyncEndpointCallback(this.entity));
            this.invoke("echo", clientEntity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binarystream", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnClientTest() throws Exception {
        WSCBinaryStreamClientEndpoint client = new WSCBinaryStreamClientEndpoint();
        for (Object clientEntity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint((AnnotatedClientEndpoint)client);
            this.setEntity(new Object[]{clientEntity});
            this.setClientCallback(new AsyncEndpointCallback(this.entity));
            this.invoke("echo", clientEntity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }
}

