/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.pathparam.WSOnClosePathParamServer;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;

@ServerEndpoint(value="/full/{param1}/{param2}")
public class WS2FullDifferentPathParamsServer {
    private static final String ERR = "TCK INTENDED ERROR";
    private String[] p = new String[2];

    @OnOpen
    public void onOpen(@PathParam(value="param1") Double p1, @PathParam(value="param2") Float p2) {
        this.p[0] = p1.toString();
        this.p[1] = p2.toString();
    }

    @OnMessage
    public String param(@PathParam(value="param1") Double p1, @PathParam(value="param2") Float p2, String content) throws IOException {
        OPS op = OPS.valueOf((String)content);
        switch (op) {
            case OPEN: {
                content = this.p[0] + this.p[1];
                break;
            }
            case MESSAGE: {
                content = p1.toString() + p2.toString();
                break;
            }
            case IOEXCEPTION: {
                throw new IOException(ERR);
            }
            case RUNTIMEEXCEPTION: {
                throw new RuntimeException(ERR);
            }
        }
        return content;
    }

    @OnError
    public void onError(@PathParam(value="param1") Double p1, @PathParam(value="param2") Float p2, Session session, Throwable t) throws IOException {
        String msg = t.getMessage();
        if (ERR.equals(msg)) {
            session.getBasicRemote().sendText(p1.toString() + p2.toString());
        } else {
            t.printStackTrace();
            String message = IOUtil.printStackTrace((Throwable)t);
            session.getBasicRemote().sendText(message);
        }
    }

    @OnClose
    public void onClose(@PathParam(value="param1") Double p1, @PathParam(value="param2") Float p2) {
        WSOnClosePathParamServer.set(0, p1.toString());
        WSOnClosePathParamServer.set(1, p2.toString());
    }
}

