/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.MessageValidator;
import com.sun.ts.tests.websocket.common.util.SessionUtil;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());
    private static final String CONTEXT_ROOT = "/ws_session_web";
    private static final String SENT_STRING_MESSAGE = "Hello World in String";
    private static ByteBuffer SENT_BYTE_MESSAGE = ByteBuffer.allocate("Hello World in ByteBuffer".getBytes().length + 1);
    private static StringBuffer receivedMessageString = new StringBuffer();
    static volatile CountDownLatch messageLatch;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_session_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.session"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common"});
        archive.addAsWebInfResource(WSClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_session_web");
    }

    @Test
    public void isOpenTest() throws Exception {
        String testName = "isOpenTest";
        Object search = "TCKTestServer opened|session from Server is open=TRUE";
        this.setCountDownLatchCount(2);
        this.setClientCallback(new TCKGetIdEndpoint());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"TCKTestServer"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, (String)search);
        this.invoke(false);
        search = "TCKTestServer received String: testName=" + testName + "|session from Server is still open=TRUE";
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, (String)search);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "testName=isOpenTest");
        this.invokeAgain(true);
    }

    @Test
    public void isOpenTest1() throws Exception {
        String search = "TCKTestServer opened|session from Server is open=TRUE";
        this.setCountDownLatchCount(2);
        this.setClientCallback(new TCKGetIdEndpoint());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"TCKTestServer"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, search);
        this.invoke(false);
        try {
            ClientEndpoint.getCountDownLatch().await(this._ws_wait, TimeUnit.SECONDS);
            if (!this.getSession().isOpen()) {
                throw new Exception("Client side Session is not open");
            }
        }
        catch (Exception ioe) {
            new Exception(ioe);
        }
        this.invoke(true);
    }

    @Test
    public void addMessageHandlerBasicStringTest() throws Exception {
        String search = "Expected IllegalStateException thrown by Second TextMessageHandler|First TextMessageHander received|TCKTestServerString opened|First TextMessageHander received|TCKTestServerString received String: Hello World in String|First TextMessageHander received|TCKTestServerString responds|TCKTestServerString received String: |First TextMessageHander received|TCKTestServerString responds";
        this.setCountDownLatchCount(3);
        this.setClientEndpoint(TCKBasicStringEndpoint.class);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"TCKTestServerString"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, search);
        this.invoke(true);
    }

    @Test
    public void addMessageHandlerBasicByteBufferTest() throws Exception {
        String search = "Expected IllegalStateException thrown by Second ByteBuffer MessageHandler|First Basic ByteBuffer MessageHander received|TCKTestServerByte opened|First Basic ByteBuffer MessageHander received|TCKTestServerByte received ByteBuffer: Hello World in ByteBuffer|TCKTestServerByte responds: Message in bytes";
        this.setCountDownLatchCount(2);
        this.setClientEndpoint(TCKBasicByteEndpoint.class);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"TCKTestServerByte"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, search);
        this.invoke(true);
    }

    @Test
    public void addMessageHandlersTest() throws Exception {
        boolean passed = true;
        String message_sent_bytebuffer = "BasicByteBufferMessageHandler added";
        String message_sent_string = "BasicStringMessageHandler added";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            Set msgHanders = session.getMessageHandlers();
            receivedMessageString.append("Start with MessageHandler=" + msgHanders.size());
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText(message_sent_string);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            ByteBuffer data = ByteBuffer.allocate(message_sent_bytebuffer.getBytes().length);
            data.put(message_sent_bytebuffer.getBytes());
            data.flip();
            messageLatch = new CountDownLatch(3);
            session.getBasicRemote().sendBinary(data);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            for (MessageHandler msgHander : msgHanders) {
                session.removeMessageHandler(msgHander);
                receivedMessageString.append("MessageHandler=" + session.getMessageHandlers().size());
            }
            passed = MessageValidator.checkSearchStrings((String)("TCKBasicEndpoint OnOpen|TCKTestServer opened|Start with MessageHandler=2|TCKTestServer received String:|" + message_sent_string + "|TCKTestServer responds, please close your session|Basic ByteBuffer MessageHander received|TCKTestServer received ByteBuffer:|Basic ByteBuffer MessageHander received|" + message_sent_bytebuffer + "|Basic ByteBuffer MessageHander received|TCKTestServer responds: Message in bytes|MessageHandler=1|MessageHandler=0"), (String)receivedMessageString.toString());
            session.close();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void addMessageHandlersTest1() throws Exception {
        boolean passed = true;
        String message_sent_bytebuffer = "BasicByteBufferMessageHandler added";
        String message_sent_reader = "BasicTextReaderMessageHandler added";
        String message_reader_msghandler = "BasicReaderMessageHander received=";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            Session session = clientContainer.connectToServer(TCKBasicEndpoint1.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            Set msgHanders_1 = session.getMessageHandlers();
            receivedMessageString.append("Start with MessageHandler=" + msgHanders_1.size());
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<Reader>(){

                public void onMessage(Reader r) {
                    char[] buffer = new char[128];
                    try {
                        int i = r.read(buffer);
                        receivedMessageString.append("========BasicReaderMessageHander received=" + new String(buffer, 0, i));
                        messageLatch.countDown();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            messageLatch = new CountDownLatch(4);
            Writer writer = session.getBasicRemote().getSendWriter();
            writer.append("BasicTextReaderMessageHandler added");
            writer.close();
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            Set msgHanders_2 = session.getMessageHandlers();
            receivedMessageString.append("Now we Have MessageHandler=" + msgHanders_2.size());
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer data) {
                    byte[] data1 = new byte[data.remaining()];
                    data.get(data1);
                    receivedMessageString.append(new String(data1));
                    messageLatch.countDown();
                }
            });
            ByteBuffer data = ByteBuffer.allocate("BasicByteBufferMessageHandler added".getBytes().length);
            data.put("BasicByteBufferMessageHandler added".getBytes());
            data.flip();
            messageLatch = new CountDownLatch(3);
            session.getBasicRemote().sendBinary(data);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            Set msgHanders_3 = session.getMessageHandlers();
            receivedMessageString.append("Now it is MessageHandler=" + msgHanders_3.size());
            for (MessageHandler msgHander : msgHanders_3) {
                session.removeMessageHandler(msgHander);
                receivedMessageString.append("MessageHandler=" + session.getMessageHandlers().size());
            }
            passed = MessageValidator.checkSearchStrings((String)"Start with MessageHandler=0|BasicReaderMessageHander received=|TCKTestServer received String:|BasicTextReaderMessageHandler added|TCKTestServer responds, please close your session|Now we Have MessageHandler=1|TCKTestServer received ByteBuffer:|BasicByteBufferMessageHandler added|TCKTestServer responds: Message in bytes|Now it is MessageHandler=2|MessageHandler=1|MessageHandler=0", (String)receivedMessageString.toString());
            session.close();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void closeTest() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close()");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close1Test() throws Exception {
        String testName = "close1Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.getBasicRemote().sendText("testName=" + testName);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKTestServer opened|session from Server is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            passed = false;
            receivedMessageString.append(e.getMessage());
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close2Test() throws Exception {
        String testName = "close2Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.getBasicRemote().sendText("testName=" + testName);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKBasicEndpoint OnClose CloseCode=TOO_BIG|TCKBasicEndpoint OnClose ReasonPhrase=TCKCloseNowWithReason", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close3Test() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer opened|session from WSCloseTestServer is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close()");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close4Test() throws Exception {
        String testName = "close1Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer opened|session from WSCloseTestServer is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            passed = false;
            receivedMessageString.append(e.getMessage());
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close5Test() throws Exception {
        String testName = "close2Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer opened|session from WSCloseTestServer is open=TRUE|TCKBasicEndpoint OnClose CloseCode=TOO_BIG|TCKBasicEndpoint OnClose ReasonPhrase=TCKCloseNowWithReason", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close6Test() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer1"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer1 opened|session from WSCloseTestServer1 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close()");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close7Test() throws Exception {
        String testName = "close1Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer1"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer1 opened|session from WSCloseTestServer1 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            passed = false;
            receivedMessageString.append(e.getMessage());
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close8Test() throws Exception {
        String testName = "close2Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer1"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer1 opened|session from WSCloseTestServer1 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=TOO_BIG|TCKBasicEndpoint OnClose ReasonPhrase=TCKCloseNowWithReason", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close9Test() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer2"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer2 opened|session from WSCloseTestServer2 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close()");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close10Test() throws Exception {
        String testName = "close1Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer2"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer2 opened|session from WSCloseTestServer2 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=NORMAL_CLOSURE", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            passed = false;
            receivedMessageString.append(e.getMessage());
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close11Test() throws Exception {
        String testName = "close2Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/WSCloseTestServer2"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(1);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|WSCloseTestServer2 opened|session from WSCloseTestServer2 is open=TRUE|TCKBasicEndpoint OnClose CloseCode=TOO_BIG|TCKBasicEndpoint OnClose ReasonPhrase=TCKCloseNowWithReason", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void close12Test() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKCloseEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)"TCKCloseEndpoint OnOpen|TCKTestServer opened|TCKCloseEndpoint OnClose|TCKCloseEndpoint OnError", (String)receivedMessageString.toString());
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("=================Session stays open after calling close() from server side");
                session.close();
            }
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void getContainerTest() throws Exception {
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            WebSocketContainer tmp = session.getContainer();
            if (clientContainer != tmp) {
                passed = false;
                logger.log(System.Logger.Level.ERROR, "Incorrect return from getContainer" + String.valueOf(tmp));
                logger.log(System.Logger.Level.ERROR, "Expecting " + String.valueOf(clientContainer));
            }
            session.close();
            if (!passed) {
                throw new Exception("Test failed with incorrect response");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void getId1Test() throws Exception {
        boolean passed = true;
        String testName = "getId1Test";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            String tmp = session.getId();
            receivedMessageString.append("getId returned from client side" + tmp);
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
            passed = MessageValidator.checkSearchStrings((String)("TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKTestServer received String: testName=" + testName), (String)receivedMessageString.toString());
            session.close();
            if (!passed) {
                throw new Exception("Test failed with incorrect response");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void setMaxBinaryMessageBufferSizeTest() throws Exception {
        int size = 98765432;
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            receivedMessageString.append("getMaxBinaryMessageBufferSize returned default value =" + session.getMaxBinaryMessageBufferSize());
            session.setMaxBinaryMessageBufferSize(size);
            int tmp = session.getMaxBinaryMessageBufferSize();
            if (tmp == size) {
                receivedMessageString.append("getMaxBinaryMessageBufferSize returned expected value =" + tmp);
            } else {
                passed = false;
                receivedMessageString.append("getMaxBinaryMessageBufferSize returned unexpected value =" + tmp);
                receivedMessageString.append("expected value =" + size);
            }
            session.close();
        }
        catch (Exception e) {
            passed = false;
            receivedMessageString.append(e.getMessage());
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Test
    public void setMaxTextMessageBufferSizeTest() throws Exception {
        int size = 987654321;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            logger.log(System.Logger.Level.INFO, "getMaxTextMessageBufferSize returned default value =" + session.getMaxTextMessageBufferSize());
            session.setMaxTextMessageBufferSize(size);
            int tmp = session.getMaxTextMessageBufferSize();
            if (tmp == size) {
                logger.log(System.Logger.Level.INFO, "getMaxTextMessageBufferSize returned expected value =" + tmp);
            } else {
                logger.log(System.Logger.Level.INFO, "getMaxTextMessageBufferSize returned unexpected value =" + tmp);
                logger.log(System.Logger.Level.INFO, "expected value =" + size);
            }
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void setTimeoutTest() throws Exception {
        long tt = 9876543210L;
        messageLatch = new CountDownLatch(1);
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            System.out.println("getMaxIdleTimeout returned default value on client side =" + session.getMaxIdleTimeout());
            session.setMaxIdleTimeout(tt);
            long tmp = session.getMaxIdleTimeout();
            if (tmp == tt) {
                logger.log(System.Logger.Level.INFO, "getMaxIdleTimeout returned expected value =" + tmp);
            } else {
                logger.log(System.Logger.Level.INFO, "getMaxIdleTimeout returned unexpected value =" + tmp);
                logger.log(System.Logger.Level.INFO, "expected value =" + tt);
            }
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void setTimeout1Test() throws Exception {
        String testName = "setTimeout1Test";
        boolean passed = true;
        long tt = (long)(this._ws_wait * 4) * 1000L;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer?timeout=" + this._ws_wait));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            System.out.println("getMaxIdleTimeout returned default value on client side =" + session.getMaxIdleTimeout());
            session.setMaxIdleTimeout(tt);
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)(this._ws_wait * 8), (TimeUnit)TimeUnit.SECONDS);
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("Session is still open after timeout");
            }
            logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
            boolean tmp = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKTestServer received String: testName=setTimeout1Test", (String)receivedMessageString.toString());
            if (!tmp) {
                passed = false;
            }
            if (receivedMessageString.indexOf("AnyString=") > -1 || receivedMessageString.indexOf("TCKTestServer second message after sleep") > -1) {
                passed = false;
                logger.log(System.Logger.Level.ERROR, "Test failed due to message sent and/or received after timeout from client side");
            }
            if (!passed) {
                throw new Exception("Test failed with incorrect response");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void setTimeout2Test() throws Exception {
        String testName = "setTimeout2Test";
        boolean passed = true;
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer?timeout=" + this._ws_wait));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            System.out.println("getMaxIdleTimeout returned default value on client side =" + session.getMaxIdleTimeout());
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            SessionUtil.waitUntilClosed((Session)session, (long)(this._ws_wait * 8), (TimeUnit)TimeUnit.SECONDS);
            if (session.isOpen()) {
                passed = false;
                receivedMessageString.append("Session is still open after timeout");
            }
            logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
            boolean tmp = MessageValidator.checkSearchStrings((String)"TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKTestServer received String: testName=setTimeout2Test", (String)receivedMessageString.toString());
            if (!tmp) {
                passed = false;
            }
            if (receivedMessageString.indexOf("AnyString=") > -1 || receivedMessageString.indexOf("TCKTestServer second message after sleep") > -1) {
                passed = false;
                logger.log(System.Logger.Level.ERROR, "Test failed due to message sent and/or received after timeout from server side");
            }
            if (!passed) {
                throw new Exception("Test Failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void getQueryStringTest() throws Exception {
        String testName = "getQueryStringTest";
        boolean passed = true;
        String querystring = "test1=value1&test2=value2&test3=value3";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer?" + querystring));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
            passed = MessageValidator.checkSearchStrings((String)("TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKTestServer received String: testName=" + testName + "|TCKTestServer: expected Query String returned|" + querystring), (String)receivedMessageString.toString());
            if (!passed) {
                throw new Exception("Test Failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void getPathParametersTest() throws Exception {
        String message = "invoke test";
        boolean passed = true;
        String param1 = "test1";
        String param2 = "test2=xyz";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(1);
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServerPathParam/" + param1 + "/" + param2));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(2);
            session.getBasicRemote().sendText(message);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            passed = MessageValidator.checkSearchStrings((String)("TCKBasicEndpoint OnOpen|WSTestServerPathParam opened|WSTestServerPathParam received String: " + message + "|WSTestServerPathParam: pathparams returned;param1=" + param1 + ";param2=" + param2), (String)receivedMessageString.toString());
            session.close();
        }
        catch (Exception e) {
            passed = false;
            e.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test Failed");
        }
    }

    @Test
    public void getRequestURITest() throws Exception {
        String testName = "getRequestURITest";
        boolean passed = true;
        String querystring = "test1=value1&test2=value2&test3=value3";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            StringBuilder uriBuilder = new StringBuilder();
            uriBuilder.append("ws://");
            uriBuilder.append(this._hostname);
            if (this._port != 80) {
                uriBuilder.append(':');
                uriBuilder.append(this._port);
            }
            uriBuilder.append(CONTEXT_ROOT);
            uriBuilder.append("/TCKTestServer?");
            uriBuilder.append(querystring);
            String uri = uriBuilder.toString();
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI(uri));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
            passed = MessageValidator.checkSearchStrings((String)("TCKBasicEndpoint OnOpen|TCKTestServer opened|session from Server is open=TRUE|TCKTestServer received String: testName=" + testName + "|TCKTestServer: getRequestURI returned=" + uri), (String)receivedMessageString.toString());
            if (!passed) {
                throw new Exception("Test Failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void getProtocolVersionTest() throws Exception {
        String expectedProtocolVersion = "13";
        String testName = "getProtocolVersionTest";
        String search = "TCKTestServer opened|session from Server is open=TRUE";
        this.setCountDownLatchCount(2);
        this.setClientCallback(new TCKGetIdEndpoint());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"TCKTestServer"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search);
        this.invoke(false);
        WSClientIT.assertEquals((Object)expectedProtocolVersion, (Object)this.getSession().getProtocolVersion(), (Object[])new Object[]{"getProtocolVersion() is not", expectedProtocolVersion, "as expected"});
        WSClientIT.logMsg((Object[])new Object[]{"getProtocolVersion() is", expectedProtocolVersion, "as expected"});
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "TCKTestServer received String:");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "testName=getProtocolVersionTest");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "TCKTestServer: getProtocolVersion returned=13");
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "testName=" + testName);
        this.invokeAgain(true);
    }

    @Test
    public void getOpenSessionsTest() throws Exception {
        boolean passed = true;
        String testName = "getOpenSessionsTest";
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            messageLatch = new CountDownLatch(2);
            Session session = clientContainer.connectToServer(TCKOpenSessionEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            int os = this.getOpenSessions(receivedMessageString.toString());
            messageLatch = new CountDownLatch(2);
            Session session1 = clientContainer.connectToServer(TCKOpenSessionEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session1.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            int os1 = this.getOpenSessions(receivedMessageString.toString());
            messageLatch = new CountDownLatch(2);
            Session session2 = clientContainer.connectToServer(TCKOpenSessionEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_session_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session2.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            int os2 = this.getOpenSessions(receivedMessageString.toString());
            session.close();
            SessionUtil.waitUntilClosed((Session)session, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session1.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            int os3 = this.getOpenSessions(receivedMessageString.toString());
            session1.close();
            SessionUtil.waitUntilClosed((Session)session1, (long)this._ws_wait, (TimeUnit)TimeUnit.SECONDS);
            messageLatch = new CountDownLatch(4);
            session2.getBasicRemote().sendText("testName=" + testName);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            int os4 = this.getOpenSessions(receivedMessageString.toString());
            session2.close();
            if (os == 1 && (os1 != 2 || os2 != 3)) {
                passed = false;
                System.out.print("Not perfect 12321 pattern for open session");
            }
            if (os4 > os3 || os3 > os2) {
                passed = false;
                System.out.print("Incorrect XXX++ pattern for open session");
            }
            if (os < 1 || os1 < 2 || os2 < 3 || os3 < 2 || os4 < 1) {
                passed = false;
                System.out.print("Cannot have less open session than 12321");
            }
            if (os1 - os > 1 || os2 - os1 > 1) {
                passed = false;
                System.out.print("Too many session are open");
            }
        }
        catch (Exception ioe) {
            passed = false;
            ioe.printStackTrace();
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Incorrect response received");
        }
    }

    public void cleanup() throws Exception {
        super.cleanup();
    }

    private int getOpenSessions(String message) {
        int start = receivedMessageString.lastIndexOf("getOpenSessions=");
        int stop = receivedMessageString.lastIndexOf("========TCKTestServer responded");
        int os = Integer.parseInt(receivedMessageString.substring(start + 16, stop));
        logger.log(System.Logger.Level.INFO, "open session=" + os);
        return os;
    }

    public static final class TCKGetIdEndpoint
    extends EndpointCallback {
        public void onOpen(Session session, EndpointConfig config) {
            ClientEndpoint.getMessageBuilder().append("======Another SessionID=").append(session.getId());
            logger.log(System.Logger.Level.INFO, session.getId());
        }
    }

    public static final class TCKBasicStringEndpoint
    extends ClientEndpoint<String> {
        public void onMessage(String message) {
            TCKBasicStringEndpoint.getMessageBuilder().append("========First TextMessageHander received=").append(message);
            TCKBasicStringEndpoint.getCountDownLatch().countDown();
        }

        public void onOpen(Session session, EndpointConfig config) {
            super.onOpen(session, config);
            try {
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                    public void onMessage(String message) {
                        ClientEndpoint.getMessageBuilder().append("========Second TextMessageHander received=").append(message);
                        ClientEndpoint.getCountDownLatch().countDown();
                    }
                });
            }
            catch (IllegalStateException ile) {
                TCKBasicStringEndpoint.getMessageBuilder().append("========Expected IllegalStateException thrown by Second TextMessageHandler");
            }
            try {
                session.getBasicRemote().sendText(WSClientIT.SENT_STRING_MESSAGE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class TCKBasicByteEndpoint
    extends ClientEndpoint<ByteBuffer> {
        public void onMessage(ByteBuffer message) {
            String message_string = IOUtil.byteBufferToString((ByteBuffer)message);
            TCKBasicByteEndpoint.getMessageBuilder().append("========First Basic ByteBuffer MessageHander received=").append(message_string);
            TCKBasicByteEndpoint.getCountDownLatch().countDown();
        }

        public void onOpen(Session session, EndpointConfig config) {
            super.onOpen(session, config);
            SENT_BYTE_MESSAGE.put("Hello World in ByteBuffer".getBytes());
            SENT_BYTE_MESSAGE.flip();
            try {
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                    public void onMessage(ByteBuffer data) {
                        String message_string = IOUtil.byteBufferToString((ByteBuffer)data);
                        ClientEndpoint.getMessageBuilder().append("========Second Basic ByteBuffer MessageHander received=").append(message_string);
                        ClientEndpoint.getCountDownLatch().countDown();
                    }
                });
            }
            catch (IllegalStateException ile) {
                TCKBasicByteEndpoint.getMessageBuilder().append("========Expected IllegalStateException thrown by Second ByteBuffer MessageHandler");
            }
            try {
                session.getBasicRemote().sendBinary(SENT_BYTE_MESSAGE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class TCKBasicEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            receivedMessageString.append("TCKBasicEndpoint OnOpen");
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer data) {
                    byte[] data1 = new byte[data.remaining()];
                    data.get(data1);
                    receivedMessageString.append("========Basic ByteBuffer MessageHander received=" + new String(data1));
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            receivedMessageString.append("TCKBasicEndpoint OnClose CloseCode=" + String.valueOf(closeReason.getCloseCode()));
            receivedMessageString.append("TCKBasicEndpoint OnClose ReasonPhrase=" + closeReason.getReasonPhrase());
        }
    }

    public static final class TCKBasicEndpoint1
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
        }
    }

    public static final class TCKCloseEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            receivedMessageString.append("TCKCloseEndpoint OnOpen");
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer data) {
                    String message_string = IOUtil.byteBufferToString((ByteBuffer)data);
                    receivedMessageString.append("========Basic ByteBuffer MessageHander received=" + message_string);
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            receivedMessageString.append("TCKCloseEndpoint OnClose");
            receivedMessageString.append("Pass_On_To_Error=");
            int i = 1 / 0;
        }

        public void onError(Session session, Throwable t) {
            receivedMessageString.append("TCKCloseEndpoint OnError");
            receivedMessageString.append(t.getMessage());
        }
    }

    public static final class TCKOpenSessionEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            receivedMessageString.append("onClose");
        }
    }
}

