/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.servercontainer.addendpoint;

import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@ServerEndpoint(value="/TCKTestServerPathParam/{param1}/{param2}")
public class WSTestServerPathParam {
    private static final System.Logger logger = System.getLogger(WSTestServerPathParam.class.getName());

    @OnOpen
    public void init(Session session) throws IOException {
        String message = "========WSTestServerPathParam opened";
        session.getBasicRemote().sendText(message);
    }

    @OnMessage
    public void respond(String message, Session session) {
        logger.log(System.Logger.Level.INFO, "========WSTestServerPathParam received String:" + message);
        StringBuffer sb = new StringBuffer();
        try {
            session.getBasicRemote().sendText("========WSTestServerPathParam received String: " + message);
            Map pathparams = session.getPathParameters();
            Set keys = pathparams.keySet();
            for (Object key : keys) {
                logger.log(System.Logger.Level.INFO, ";" + key.toString() + "=" + (String)pathparams.get(key.toString()));
                sb.append(";" + key.toString() + "=" + (String)pathparams.get(key.toString()));
            }
            session.getBasicRemote().sendText("========WSTestServerPathParam: pathparams returned" + sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        logger.log(System.Logger.Level.INFO, "WSTestServerPathParam onError");
        try {
            session.getBasicRemote().sendText("========WSTestServerPathParam onError");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        t.printStackTrace();
    }
}

