/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MessageValidator {
    private static final System.Logger logger = System.getLogger(MessageValidator.class.getName());

    public static boolean checkSearchStrings(String expected, String actual) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(expected, "|");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        boolean found = true;
        if (list != null && actual != null) {
            String search = null;
            int n = list.size();
            int startIdx = 0;
            int acLength = actual.length();
            for (int i = 0; i < n; ++i) {
                if (startIdx >= acLength) {
                    startIdx = acLength;
                }
                search = (String)list.get(i);
                int searchIdx = actual.indexOf(search, startIdx);
                logger.log(System.Logger.Level.INFO, "[MessageValidator] Scanning for search string: '" + search + "' starting at index location: " + startIdx);
                if (searchIdx < 0) {
                    found = false;
                    StringBuffer sb = new StringBuffer(1024);
                    sb.append("[MessageValidator] Unable to find the following ");
                    sb.append("search string");
                    sb.append(search).append("' at index: ");
                    sb.append(startIdx);
                    logger.log(System.Logger.Level.ERROR, sb.toString());
                    break;
                }
                logger.log(System.Logger.Level.INFO, "[MessageValidator] Found search string: '" + search + "' at index '" + searchIdx);
                startIdx = searchIdx + search.length();
            }
        }
        return found;
    }
}

