/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.egerrit.internal.core.GerritServerInformation;

public class ChangeIdExtractor {
    private GerritServerInformation server = null;
    private String changeId = null;

    public ChangeIdExtractor(String serverAddress) {
        if (!this.isURL(serverAddress)) {
            return;
        }
        this.extractServer(serverAddress);
        if (this.server != null) {
            this.extractChangeId(serverAddress);
        }
    }

    private void extractChangeId(String serverAddress) {
        Pattern pattern = Pattern.compile(String.valueOf(this.server.getServerURI()) + "/#/c/" + "([0-9]+).*");
        Matcher matcher = pattern.matcher(serverAddress);
        if (matcher.matches()) {
            this.changeId = matcher.group(1);
        } else {
            int lastSlashIndex;
            String last = (serverAddress = this.removeTrailingSlash(serverAddress)).substring(lastSlashIndex = serverAddress.lastIndexOf(47) + 1);
            if (this.isInteger(last)) {
                this.changeId = serverAddress.substring(lastSlashIndex);
            }
        }
    }

    private boolean isURL(String text) {
        try {
            URI uri = URIUtil.fromString((String)text);
            return uri.getScheme() != null && uri.getHost() != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public GerritServerInformation getServer() {
        return this.server;
    }

    public String getChangeId() {
        return this.changeId;
    }

    private void extractServer(String serverAddress) {
        int sharpSign = serverAddress.indexOf(35);
        if (sharpSign != -1) {
            serverAddress = serverAddress.substring(0, sharpSign);
        } else {
            int lastSlashIndex;
            String last = (serverAddress = this.removeTrailingSlash(serverAddress)).substring(lastSlashIndex = serverAddress.lastIndexOf(47) + 1);
            if (this.isInteger(last)) {
                serverAddress = serverAddress.substring(0, lastSlashIndex);
            }
        }
        try {
            this.server = new GerritServerInformation(serverAddress, serverAddress);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            return;
        }
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String removeTrailingSlash(String serverAddress) {
        if (serverAddress.endsWith("/")) {
            serverAddress = serverAddress.substring(0, serverAddress.length() - 1);
        }
        return serverAddress;
    }
}

