/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Label;

public class SwitchPatchAction
extends Action {
    private GerritMultipleInput input;
    private boolean leftSide;
    private String inputToSwitchTo;
    private Label labelToUpdate;
    private String shortLabel;

    public SwitchPatchAction(GerritMultipleInput gerritMultipleInput, RevisionInfo revision, Label labelToUpdate, boolean left) {
        this.input = gerritMultipleInput;
        this.leftSide = left;
        this.inputToSwitchTo = revision.getId();
        this.labelToUpdate = labelToUpdate;
        this.shortLabel = String.valueOf(Messages.SwitchPatchAction_0) + revision.get_number();
        boolean hasComments = revision.isCommented();
        this.setText(UIUtils.revisionToString(revision));
        if (hasComments) {
            this.setImageDescriptor(EGerritImages.getDescriptor("icons/showComments.gif"));
        }
    }

    public SwitchPatchAction(GerritMultipleInput gerritMultipleInput, String target, Label labelToUpdate, boolean left) {
        super(target);
        this.input = gerritMultipleInput;
        this.leftSide = left;
        this.inputToSwitchTo = target;
        this.labelToUpdate = labelToUpdate;
        this.shortLabel = target;
    }

    public void run() {
        if (this.leftSide) {
            this.input.switchInputs(this.inputToSwitchTo, null);
        } else {
            this.input.switchInputs(null, this.inputToSwitchTo);
        }
        this.labelToUpdate.setText(this.shortLabel);
    }
}

