/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.ModelFactory;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class MarkerMenuContribution
extends ContributionItem {
    private ITextEditor editor;
    private int fCurrentLine = -1;

    public MarkerMenuContribution(ITextEditor editor) {
        this.editor = editor;
    }

    private IVerticalRulerInfo getRulerInfo() {
        return (IVerticalRulerInfo)this.editor.getAdapter(IVerticalRulerInfo.class);
    }

    public void fill(Menu menu, int index) {
        this.fCurrentLine = this.getRulerInfo().getLineOfLastMouseButtonActivity() + 1;
        IEditorInput editorInput = this.editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return;
        }
        if (ActiveWorkspaceRevision.getInstance().isFilePartOfReview(((IFileEditorInput)editorInput).getFile().getFullPath().toString())) {
            MenuItem menuItem = new MenuItem(menu, 32, index);
            menuItem.setText(Messages.MarkerMenuContribution_0);
            menuItem.addSelectionListener((SelectionListener)this.createDynamicSelectionListener());
        }
    }

    private SelectionAdapter createDynamicSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                RevisionInfo revision = ActiveWorkspaceRevision.getInstance().getActiveRevision();
                InputDialog replyDialog = new InputDialog(shell, Messages.MarkerMenuContribution_1, String.valueOf(Messages.MarkerMenuContribution_2) + revision.get_number() + "/" + revision.getChangeInfo().getRevisions().size(), "", null){

                    protected int getInputTextStyle() {
                        return 2562;
                    }

                    protected Control createDialogArea(Composite parent) {
                        Control res = super.createDialogArea(parent);
                        ((GridData)this.getText().getLayoutData()).heightHint = 100;
                        return res;
                    }
                };
                replyDialog.open();
                if (replyDialog.getReturnCode() == 0) {
                    CommentInfo newComment = ModelFactory.eINSTANCE.createCommentInfo();
                    newComment.setPath(((IFileEditorInput)MarkerMenuContribution.this.editor.getEditorInput()).getFile().getFullPath().toString());
                    newComment.setMessage(replyDialog.getValue());
                    newComment.setLine(MarkerMenuContribution.this.fCurrentLine);
                    ActiveWorkspaceRevision.getInstance().newComment(newComment);
                }
            }
        };
    }
}

