/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.model;

import java.util.ArrayList;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.utils.Messages;

public enum FilesTableModel implements ITableModel
{
    REVIEWED("", 35, true, true, 16384),
    MOD_TYPE("", 30, true, true, 16384),
    FILE_PATH(Messages.FilesTableDefinition_filePath, 250, true, true, 16384),
    COMMENTS(Messages.FilesTableDefinition_comments, 175, true, true, 16384),
    SIZE(Messages.FilesTableDefinition_size, 80, false, true, 16384);

    private final String fHeader;
    private int fwidth;
    private final int fInitialwidth;
    private final boolean fResize;
    private final boolean fMoveable;
    private final int fAlignment;
    private boolean fVisible = true;

    private FilesTableModel(String aName, int aWidth, boolean aResize, boolean aMove, int align) {
        this.fHeader = aName;
        this.fwidth = aWidth;
        this.fInitialwidth = aWidth;
        this.fResize = aResize;
        this.fMoveable = aMove;
        this.fAlignment = align;
        this.fVisible = true;
    }

    @Override
    public String getName() {
        return this.fHeader;
    }

    @Override
    public int getWidth() {
        return this.fwidth;
    }

    @Override
    public boolean getResize() {
        return this.fResize;
    }

    @Override
    public boolean getMoveable() {
        return this.fMoveable;
    }

    @Override
    public int getAlignment() {
        return this.fAlignment;
    }

    @Override
    public String[] getColumnName() {
        ArrayList<String> listName = new ArrayList<String>();
        FilesTableModel[] filesTableModelArray = FilesTableModel.values();
        int n = filesTableModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilesTableModel st = filesTableModelArray[n2];
            listName.add(st.getName());
            ++n2;
        }
        return listName.toArray(new String[0]);
    }

    @Override
    public int getMinimumWidth() {
        int width = 0;
        int index = 0;
        while (index < FilesTableModel.values().length) {
            width += FilesTableModel.values()[index].getWidth();
            ++index;
        }
        return width;
    }

    public boolean isColumnVisible() {
        return this.fVisible;
    }

    public void setColumnVisible(boolean value) {
        this.fVisible = value;
        this.fwidth = value ? this.fInitialwidth : 0;
    }

    public static int[] getDefaultOrder() {
        int size = FilesTableModel.values().length;
        int[] order = new int[size];
        int index = 0;
        while (index < size) {
            order[index] = index;
            ++index;
        }
        return order;
    }
}

