/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.emf.common.util.EList;

public class ModelHelpers {
    private ModelHelpers() {
    }

    public static EList<CommentInfo> sortComments(EList<CommentInfo> comments) {
        Collections.sort(comments, (o1, o2) -> {
            if (o1.getLine() == o2.getLine()) {
                return o1.getUpdated().compareTo(o2.getUpdated());
            }
            if (o1.getLine() < o2.getLine()) {
                return -1;
            }
            return 1;
        });
        return comments;
    }

    public static RevisionInfo getRevision(CommentInfo comment) {
        return ModelHelpers.getFileInfo(comment).getRevision();
    }

    public static FileInfo getFileInfo(CommentInfo comment) {
        return (FileInfo)comment.eContainer();
    }

    public static int getHighestRevisionNumber(Collection<RevisionInfo> revisions) {
        int match = 0;
        for (RevisionInfo rev : revisions) {
            if (rev.get_number() <= match) continue;
            match = rev.get_number();
        }
        return match;
    }
}

