/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.completion;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposal;

abstract class ParamCompleter {
    private String[] fApplicableStrings;

    ParamCompleter(String[] applicableStrings) {
        this.fApplicableStrings = (String[])applicableStrings.clone();
    }

    boolean isApplicable(String query) {
        String applicableStr = this.getApplicableString(query);
        return applicableStr != null && query.length() > applicableStr.length();
    }

    private String getApplicableString(String query) {
        String[] stringArray = this.fApplicableStrings;
        int n = this.fApplicableStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String applicableStr = stringArray[n2];
            if (query.startsWith(applicableStr)) {
                return applicableStr;
            }
            ++n2;
        }
        return null;
    }

    SearchContentProposal[] suggest(String lastWord, String query, GerritClient client) {
        String applicableStr = this.getApplicableString(lastWord);
        if (applicableStr != null) {
            return this.requestCompletionList(lastWord.substring(applicableStr.length()), query, client);
        }
        return null;
    }

    abstract SearchContentProposal[] requestCompletionList(String var1, String var2, GerritClient var3);
}

