/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditionLimiter
implements VerifyListener,
IDocumentListener {
    private static Logger logger = LoggerFactory.getLogger(EditionLimiter.class);
    private IDocument document;
    private AnnotationModel annotations;
    private TextViewer textViewer;
    private StyledText textWidget;
    private String lastTextForShortCircuiting = null;
    private boolean triggeredFromWidget = false;

    public EditionLimiter(TextViewer viewer) {
        this.textViewer = viewer;
        this.textViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 100 || (e.stateMask & 0x400000) == 0x400000 && e.keyCode == 100) {
                    EditionLimiter.this.triggeredFromWidget = true;
                    StyledText txt = (StyledText)e.getSource();
                    int lineLength = 0;
                    int lineNo = 0;
                    int caretOffset = txt.getCaretOffset();
                    if (EditionLimiter.this.document == null) {
                        EditionLimiter.this.initialize();
                    }
                    try {
                        lineNo = EditionLimiter.this.document.getLineOfOffset(caretOffset);
                        lineLength = EditionLimiter.this.document.getLineLength(lineNo);
                        if (!EditionLimiter.this.isEditableLine(EditionLimiter.this.document.getLineOffset(lineNo), 1)) {
                            return;
                        }
                        try {
                            IRegion regionForDeletedLine = EditionLimiter.this.document.getLineInformation(lineNo);
                            EditionLimiter.this.doit(regionForDeletedLine.getOffset(), lineLength, "", false, true);
                            EditionLimiter.this.document.replace(EditionLimiter.this.document.getLineOffset(lineNo), lineLength, "");
                        }
                        catch (BadLocationException e1) {
                            logger.debug("Exception while performing Ctrl-D", (Throwable)e1);
                            return;
                        }
                    }
                    finally {
                        EditionLimiter.this.lastTextForShortCircuiting = null;
                        EditionLimiter.this.triggeredFromWidget = false;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private boolean doit(int start, int length, String text, boolean fromDoc, boolean deletionOnly) {
        if (this.document == null) {
            this.initialize();
        }
        this.printAnnotationsCount();
        try {
            if ("".equals(text)) {
                boolean bl = this.testEmptyText(start, length);
                return bl;
            }
            if (deletionOnly) {
                return true;
            }
            if (!this.isEditableLine(start, text.length())) {
                boolean bl = this.testUnAuthorizeTextArea(start, text, fromDoc);
                return bl;
            }
            return true;
        }
        finally {
            this.printAnnotationsCount();
        }
    }

    private boolean testUnAuthorizeTextArea(int start, String text, boolean fromDoc) {
        boolean annotationAlreadyAdded = false;
        int insertionPosition = start;
        String commentText = text.trim();
        if (!fromDoc) {
            if (!this.isBeginningOfLine(insertionPosition) || this.isBeginningOfLine(insertionPosition) && this.getCurrentAnnotation(start) != null) {
                insertionPosition = this.setInsertPosToNextLine(start);
            }
            if (this.isEditableLine(insertionPosition, text.length())) {
                try {
                    this.document.replace(insertionPosition, 0, commentText);
                    this.textWidget.setCaretOffset(insertionPosition + commentText.length());
                    return false;
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
            try {
                this.document.replace(insertionPosition, 0, TextUtilities.getDefaultLineDelimiter((IDocument)this.document));
                this.annotations.addAnnotation((Annotation)new GerritCommentAnnotation(null, commentText), new Position(insertionPosition, 0));
                annotationAlreadyAdded = true;
                this.document.replace(insertionPosition, 0, commentText);
            }
            catch (BadLocationException e) {
                logger.debug("Exception inserting " + commentText, (Throwable)e);
            }
            this.textWidget.setCaretOffset(insertionPosition + commentText.length());
        }
        if (!annotationAlreadyAdded) {
            this.annotations.addAnnotation((Annotation)new GerritCommentAnnotation(null, commentText), new Position(insertionPosition, commentText.length()));
        }
        return false;
    }

    private int setInsertPosToNextLine(int start) {
        int insertionPosition;
        GerritCommentAnnotation currentAnnotation = this.getCurrentAnnotation(start);
        if (currentAnnotation != null) {
            Position position = this.annotations.getPosition((Annotation)currentAnnotation);
            insertionPosition = this.getNextLine(position.getOffset() + position.getLength());
        } else {
            insertionPosition = this.getNextLine(start);
        }
        if (insertionPosition == -1) {
            try {
                this.document.replace(this.textWidget.getCharCount(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)this.document));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            insertionPosition = this.getNextLine(start);
        }
        return insertionPosition;
    }

    private boolean testEmptyText(int start, int length) {
        if (!this.isEditableLine(start, length)) {
            return false;
        }
        Iterator it = this.annotations.getAnnotationIterator(start, length, true, true);
        Position impactedArea = new Position(start, length);
        while (it.hasNext()) {
            GerritCommentAnnotation comment = (GerritCommentAnnotation)((Object)it.next());
            Position commentPosition = this.annotations.getPosition((Annotation)comment);
            try {
                if (commentPosition.length == 0 && this.document.get(start, length).equals(TextUtilities.getDefaultLineDelimiter((IDocument)this.document))) {
                    this.annotations.removeAnnotation((Annotation)comment);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.completelyIncludes(commentPosition, impactedArea)) continue;
            return false;
        }
        return true;
    }

    private int getNextLine(int offset) {
        try {
            return this.textWidget.getOffsetAtLine(this.textWidget.getLineAtOffset(offset) + 1);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private boolean isBeginningOfLine(int offset) {
        return this.textWidget.getOffsetAtLine(this.textWidget.getLineAtOffset(offset)) == offset;
    }

    private boolean completelyIncludes(Position container, Position contained) {
        return container.includes(contained.offset) && container.includes(contained.offset + contained.length - 1);
    }

    private boolean isEditableLine(int offset, int length) {
        GerritCommentAnnotation annotation;
        Iterator it = this.annotations.getAnnotationIterator(offset, length, true, true);
        if (it.hasNext() && ((annotation = (GerritCommentAnnotation)((Object)it.next())).getComment() == null || annotation.getComment().getAuthor() == null)) {
            return true;
        }
        return this.isInsertingAtTheEndOfExistingComment(offset);
    }

    private GerritCommentAnnotation getCurrentAnnotation(int offset) {
        Iterator it = this.annotations.getAnnotationIterator();
        while (it.hasNext()) {
            GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)it.next());
            Position position = this.annotations.getPosition((Annotation)annotation);
            if (offset < position.getOffset() || offset > position.getOffset() + position.getLength()) continue;
            return annotation;
        }
        return null;
    }

    private boolean isInsertingAtTheEndOfExistingComment(int offset) {
        Iterator it = this.annotations.getAnnotationIterator();
        while (it.hasNext()) {
            Position position;
            GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)it.next());
            if (annotation.getComment() != null && annotation.getComment().getAuthor() != null || (position = this.annotations.getPosition((Annotation)annotation)).getOffset() + position.getLength() != offset) continue;
            return true;
        }
        return false;
    }

    private void printAnnotationsCount() {
        try {
            logger.debug("Annotation count " + this.document.getPositions("__dflt_position_category").length);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    public void verifyText(VerifyEvent e) {
        this.textWidget = (StyledText)e.widget;
        this.triggeredFromWidget = true;
        e.doit = this.doit(e.start, e.end - e.start, e.text, false, false);
        this.lastTextForShortCircuiting = e.text;
        this.triggeredFromWidget = false;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.triggeredFromWidget) {
            return;
        }
        if (event.getText().equals(this.lastTextForShortCircuiting)) {
            return;
        }
        this.lastTextForShortCircuiting = event.getText();
        this.doit(event.getOffset(), event.getLength(), event.fText, true, true);
    }

    public void documentChanged(DocumentEvent event) {
        if (this.triggeredFromWidget) {
            return;
        }
        if (event.getText().equals(this.lastTextForShortCircuiting)) {
            this.lastTextForShortCircuiting = null;
            return;
        }
        this.doit(event.getOffset(), event.getLength(), event.fText, true, false);
        this.lastTextForShortCircuiting = null;
    }

    private void changePositionUpdater() {
        IPositionUpdater[] updaters;
        IPositionUpdater[] iPositionUpdaterArray = updaters = this.document.getPositionUpdaters();
        int n = updaters.length;
        int n2 = 0;
        while (n2 < n) {
            IPositionUpdater potentialInclusiveUpdater = iPositionUpdaterArray[n2];
            if (potentialInclusiveUpdater instanceof InclusivePositionUpdater) {
                return;
            }
            ++n2;
        }
        iPositionUpdaterArray = updaters;
        n = updaters.length;
        n2 = 0;
        while (n2 < n) {
            IPositionUpdater updater = iPositionUpdaterArray[n2];
            if (updater instanceof DefaultPositionUpdater) {
                try {
                    Method getCategory = DefaultPositionUpdater.class.getDeclaredMethod("getCategory", new Class[0]);
                    getCategory.setAccessible(true);
                    if ("__dflt_position_category".equals(getCategory.invoke((Object)updater, new Object[0]))) {
                        this.document.removePositionUpdater(updater);
                        break;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.document.addPositionUpdater((IPositionUpdater)new InclusivePositionUpdater("__dflt_position_category"));
    }

    private void initialize() {
        this.document = this.textViewer.getDocument();
        this.document.addDocumentListener((IDocumentListener)this);
        this.annotations = ((CommentableCompareItem)this.textViewer.getDocument()).getEditableComments();
        this.changePositionUpdater();
    }
}

