/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

class HideControlObservable
extends WritableValue
implements IValueChangeListener {
    private final DataBindingContext bindingContext = new DataBindingContext();
    private final ISWTObservableValue sizeObservable;
    private final Point size = new Point(0, 0);
    private final Control control;

    HideControlObservable(Control control) {
        super((Object)control.getVisible(), Boolean.class);
        this.control = control;
        UpdateValueStrategy never = new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeVisible((Control)control), (IObservableValue)this, never, null);
        this.sizeObservable = SWTObservables.observeSize((Control)control);
        this.sizeObservable.addValueChangeListener((IValueChangeListener)this);
        if (!control.isVisible()) {
            GridData gd = (GridData)control.getLayoutData();
            if (gd == null) {
                gd = new GridData();
            }
            gd.exclude = true;
            control.setLayoutData((Object)gd);
            control.setSize(new Point(0, 0));
        }
    }

    public void doSetValue(Object value) {
        super.doSetValue(value);
        Boolean bool = (Boolean)value;
        if (bool.booleanValue()) {
            GridData gd = (GridData)this.control.getLayoutData();
            if (gd == null) {
                gd = new GridData();
            }
            gd.exclude = false;
            this.control.setLayoutData((Object)gd);
            this.control.setSize(this.size);
            this.control.getParent().layout();
        } else {
            GridData gd = (GridData)this.control.getLayoutData();
            if (gd == null) {
                gd = new GridData();
            }
            gd.exclude = true;
            this.control.setLayoutData((Object)gd);
            this.control.setSize(new Point(0, 0));
            this.control.getParent().layout();
        }
    }

    public synchronized void dispose() {
        this.bindingContext.dispose();
        this.sizeObservable.dispose();
        super.dispose();
    }

    public void handleValueChange(ValueChangeEvent event) {
        Point newSize = (Point)event.getObservableValue().getValue();
        if (newSize.x > this.size.x) {
            this.size.x = newSize.x;
        }
        if (newSize.y > this.size.y) {
            this.size.y = newSize.y;
        }
    }
}

