/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.core.platform.loader.IBundleClassLoader;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.pde.core.plugin.IPluginModelBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends URLClassLoader
implements IBundleClassLoader {
    private IPluginModelBase _model;
    private IProject _project;
    private List<IProject> _dependencies;

    public BundleClassLoader(IPluginModelBase model, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        Assert.isNotNull((Object)urls);
        Assert.isNotNull((Object)model);
        this._model = model;
        this._dependencies = new UniqueEList();
    }

    public BundleClassLoader(IPluginModelBase model, List<IProject> dependencies, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        Assert.isNotNull((Object)urls);
        Assert.isNotNull((Object)model);
        this._model = model;
        this._dependencies = dependencies != null ? dependencies : new UniqueEList();
    }

    @Override
    public IPluginModelBase getPluginModelBase() {
        return this._model;
    }

    public IProject getProject() {
        if (this._project == null && this._model.getUnderlyingResource() != null) {
            this._project = this._model.getUnderlyingResource().getProject();
        }
        return this._project;
    }

    @Override
    public IProject[] getWorkspaceDependencies() {
        return this._dependencies.toArray(new IProject[this._dependencies.size()]);
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    @Override
    public URL findResource(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return super.findResource(name);
    }

    public ClassLoader getParentClassLoader() {
        return this.getParent();
    }

    @Override
    public synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (name != null && name.startsWith("java.")) {
            return Class.forName(name, true, this);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = name.lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        return super.findClass(name);
    }
}

