/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;

public class ServletMultiPartFormData {
    static Parts getParts(ServletRequest servletRequest) {
        CompletableFuture<Parts> futureParts = ServletMultiPartFormData.from(servletRequest, Invocable.InvocationType.NON_BLOCKING);
        return futureParts.join();
    }

    static void onParts(ServletRequest servletRequest, String contentType, Promise.Invocable<Parts> promise) {
        CompletableFuture<Parts> futureParts = ServletMultiPartFormData.from(servletRequest, promise.getInvocationType(), contentType);
        futureParts.whenComplete((BiConsumer)promise);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Parts> from(ServletRequest servletRequest) {
        return ServletMultiPartFormData.from(servletRequest, Invocable.InvocationType.NON_BLOCKING, servletRequest.getContentType());
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    static CompletableFuture<Parts> from(ServletRequest servletRequest, Invocable.InvocationType invocationType) {
        return ServletMultiPartFormData.from(servletRequest, invocationType, servletRequest.getContentType());
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Parts> from(ServletRequest servletRequest, String contentType) {
        return ServletMultiPartFormData.from(servletRequest, Invocable.InvocationType.NON_BLOCKING, contentType);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    static CompletableFuture<Parts> from(ServletRequest servletRequest, final Invocable.InvocationType invocationType, String contentType) {
        CompletableFuture<Parts> futureServletParts = (CompletableFuture<Parts>)servletRequest.getAttribute(ServletMultiPartFormData.class.getName());
        if (futureServletParts == null) {
            MultipartConfigElement config = (MultipartConfigElement)servletRequest.getAttribute("org.eclipse.jetty.multipartConfig");
            if (config == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No multipart configuration element"));
            }
            if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.getValueParameters((String)contentType, null))) {
                return CompletableFuture.failedFuture(new IllegalStateException("Not multipart Content-Type"));
            }
            String boundary = MultiPart.extractBoundary((String)servletRequest.getContentType());
            if (boundary == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No multipart boundary parameter in Content-Type"));
            }
            ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(servletRequest);
            if (servletContextRequest == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No core request"));
            }
            final Path filesDirectory = StringUtil.isBlank((String)config.getLocation()) ? servletContextRequest.getContext().getTempDirectory().toPath() : new File(config.getLocation()).toPath();
            try {
                MultiPartFormData.Parts formParts = MultiPartFormData.getParts((Attributes)servletContextRequest);
                if (formParts != null) {
                    futureServletParts = CompletableFuture.completedFuture(new Parts(filesDirectory, formParts));
                } else {
                    Request source;
                    ServletContextHandler contextHandler = servletContextRequest.getServletContext().getServletContextHandler();
                    ByteBufferPool byteBufferPool = servletContextRequest.getComponents().getByteBufferPool();
                    ConnectionMetaData connectionMetaData = servletContextRequest.getConnectionMetaData();
                    Connection connection = connectionMetaData.getConnection();
                    if (servletRequest instanceof ServletApiRequest) {
                        ServletApiRequest servletApiRequest = (ServletApiRequest)servletRequest;
                        source = servletApiRequest.getRequest();
                    } else {
                        int n;
                        if (connection instanceof AbstractConnection) {
                            AbstractConnection c = (AbstractConnection)connection;
                            n = c.getInputBufferSize();
                        } else {
                            n = 2048;
                        }
                        int bufferSize = n;
                        source = new InputStreamContentSource((InputStream)servletRequest.getInputStream(), new ByteBufferPool.Sized(byteBufferPool, false, bufferSize));
                    }
                    MultiPartConfig multiPartConfig = Request.getMultiPartConfig((Request)servletContextRequest, (Path)filesDirectory).location(filesDirectory).maxParts(contextHandler.getMaxFormKeys()).maxMemoryPartSize((long)config.getFileSizeThreshold()).maxPartSize(config.getMaxFileSize()).maxSize(config.getMaxRequestSize()).build();
                    final CompletableFuture<Parts> futureConvertParts = futureServletParts = new CompletableFuture();
                    Promise.Invocable<MultiPartFormData.Parts> onParts = new Promise.Invocable<MultiPartFormData.Parts>(){

                        public void failed(Throwable x) {
                            futureConvertParts.completeExceptionally(x);
                        }

                        public void succeeded(MultiPartFormData.Parts parts) {
                            futureConvertParts.complete(new Parts(filesDirectory, parts));
                        }

                        public Invocable.InvocationType getInvocationType() {
                            return invocationType;
                        }
                    };
                    MultiPartFormData.onParts((Content.Source)source, (Attributes)servletContextRequest, (String)contentType, (MultiPartConfig)multiPartConfig, (Promise.Invocable)onParts);
                }
                servletRequest.setAttribute(ServletMultiPartFormData.class.getName(), futureServletParts);
            }
            catch (Throwable failure) {
                return CompletableFuture.failedFuture(failure);
            }
        }
        return futureServletParts;
    }

    public static class Parts {
        private final List<Part> parts = new ArrayList<Part>();

        public Parts(Path directory, MultiPartFormData.Parts parts) {
            parts.forEach(part -> this.parts.add(new ServletPart(directory, (MultiPart.Part)part)));
        }

        public Part getPart(String name) {
            return this.parts.stream().filter(part -> part.getName().equals(name)).findFirst().orElse(null);
        }

        public Collection<Part> getParts() {
            return List.copyOf(this.parts);
        }
    }

    private static class ServletPart
    implements Part {
        private final Path _directory;
        private final MultiPart.Part _part;

        private ServletPart(Path directory, MultiPart.Part part) {
            this._directory = directory;
            this._part = part;
        }

        public InputStream getInputStream() throws IOException {
            return Content.Source.asInputStream((Content.Source)this._part.newContentSource(null, 0L, -1L));
        }

        public String getContentType() {
            return this._part.getHeaders().get(HttpHeader.CONTENT_TYPE);
        }

        public String getName() {
            return this._part.getName();
        }

        public String getSubmittedFileName() {
            return this._part.getFileName();
        }

        public long getSize() {
            return this._part.getLength();
        }

        public void write(String fileName) throws IOException {
            Path filePath = Path.of(fileName, new String[0]);
            if (!filePath.isAbsolute() && Files.isDirectory(this._directory, new LinkOption[0])) {
                filePath = this._directory.resolve(filePath).normalize();
            }
            this._part.writeTo(filePath);
        }

        public void delete() throws IOException {
            this._part.delete();
        }

        public String getHeader(String name) {
            return this._part.getHeaders().get(name);
        }

        public Collection<String> getHeaders(String name) {
            return this._part.getHeaders().getValuesList(name);
        }

        public Collection<String> getHeaderNames() {
            return this._part.getHeaders().getFieldNamesCollection();
        }

        public String toString() {
            return "%s@%x[part=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this._part);
        }
    }
}

