/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.conn.gmf;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.conn.gmf.ApplyLayoutRequest;
import org.eclipse.elk.conn.gmf.IEditPartFilter;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class GmfDiagramLayoutConnector
implements IDiagramLayoutConnector {
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<CommandStack> COMMAND_STACK = new Property("gmf.applyLayoutCommandStack");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("gmf.coordinateOffset");
    public static final IProperty<Integer> ANIMATION_TIME = new Property("gmf.animationTime", (Object)0);
    @Inject
    private IEditPartFilter editPartFilter;

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        EditPart ep = editPart;
        while (ep != null && !(ep instanceof DiagramEditPart) && !(ep instanceof RootEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof RootEditPart) {
            RootEditPart root = (RootEditPart)ep;
            ep = null;
            for (Object child : root.getChildren()) {
                if (!(child instanceof DiagramEditPart)) continue;
                ep = (EditPart)child;
            }
        }
        return (DiagramEditPart)ep;
    }

    protected DiagramEditor getDiagramEditor(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof DiagramEditor) {
            return (DiagramEditor)workbenchPart;
        }
        if (workbenchPart instanceof IAdaptable) {
            return (DiagramEditor)workbenchPart.getAdapter(DiagramEditor.class);
        }
        return null;
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        DiagramEditor diagramEditor = this.getDiagramEditor(workbenchPart);
        IGraphicalEditPart layoutRootPart = null;
        ArrayList<ShapeNodeEditPart> selectedParts = null;
        if (diagramPart instanceof ShapeNodeEditPart || diagramPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)diagramPart;
        } else if (diagramPart instanceof IGraphicalEditPart) {
            TopGraphicEditPart tgEditPart = ((IGraphicalEditPart)diagramPart).getTopGraphicEditPart();
            if (tgEditPart instanceof ShapeNodeEditPart) {
                layoutRootPart = (IGraphicalEditPart)tgEditPart;
            }
        } else if (diagramPart instanceof Collection) {
            Collection selection = (Collection)diagramPart;
            for (Object object : selection) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                if (layoutRootPart != null) {
                    EditPart parent = GmfDiagramLayoutConnector.commonParent((EditPart)layoutRootPart, (EditPart)object);
                    if (parent == null || parent instanceof RootEditPart) continue;
                    layoutRootPart = (IGraphicalEditPart)parent;
                    continue;
                }
                if (object instanceof ConnectionEditPart) continue;
                layoutRootPart = (IGraphicalEditPart)object;
            }
            if (layoutRootPart != null) {
                selectedParts = new ArrayList<ShapeNodeEditPart>(selection.size());
                for (Object object : selection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    EditPart editPart = (EditPart)object;
                    while (editPart != null && editPart.getParent() != layoutRootPart) {
                        editPart = editPart.getParent();
                    }
                    if (!(editPart instanceof ShapeNodeEditPart) || !this.editPartFilter.filter(editPart) || selectedParts.contains(editPart)) continue;
                    selectedParts.add((ShapeNodeEditPart)editPart);
                }
            }
        }
        if (layoutRootPart == null && diagramEditor != null) {
            layoutRootPart = diagramEditor.getDiagramEditPart();
        }
        if (layoutRootPart == null) {
            throw new IllegalArgumentException("Not supported by this layout connector: Workbench part " + String.valueOf(workbenchPart) + ", Edit part " + String.valueOf(diagramPart));
        }
        LayoutMapping mapping = this.buildLayoutGraph(layoutRootPart, selectedParts, workbenchPart);
        return mapping;
    }

    protected static EditPart commonParent(EditPart editPart1, EditPart editPart2) {
        EditPart ep1 = editPart1;
        EditPart ep2 = editPart2;
        do {
            if (GmfDiagramLayoutConnector.isParent(ep1, ep2)) {
                return ep1;
            }
            if (GmfDiagramLayoutConnector.isParent(ep2, ep1)) {
                return ep2;
            }
            ep1 = ep1.getParent();
            ep2 = ep2.getParent();
        } while (ep1 != null && ep2 != null);
        return null;
    }

    protected static boolean isParent(EditPart parent, EditPart child) {
        EditPart editPart = child;
        do {
            if (editPart != parent) continue;
            return true;
        } while ((editPart = editPart.getParent()) != null);
        return false;
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, IWorkbenchPart workbenchPart) {
        ElkNode topNode;
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)GmfDiagramLayoutConnector.getDiagramEditPart((EditPart)layoutRootPart));
        if (layoutRootPart instanceof ShapeNodeEditPart) {
            topNode = this.createNode(mapping, (ShapeNodeEditPart)layoutRootPart, null, null, null);
        } else {
            topNode = ElkGraphUtil.createGraph();
            Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
            if (layoutRootPart instanceof DiagramEditPart) {
                String labelText = ((DiagramEditPart)layoutRootPart).getDiagramView().getName();
                if (labelText.length() > 0) {
                    ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                    label.setText(labelText);
                }
            } else {
                topNode.setLocation((double)rootBounds.x, (double)rootBounds.y);
            }
            topNode.setDimensions((double)rootBounds.width, (double)rootBounds.height);
            mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        }
        mapping.setLayoutGraph(topNode);
        if (selection != null && !selection.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            Maybe kinsets = new Maybe();
            for (ShapeNodeEditPart editPart : selection) {
                ElkNode node = this.createNode(mapping, editPart, layoutRootPart, topNode, (Maybe<ElkPadding>)kinsets);
                minx = Math.min(minx, node.getX());
                miny = Math.min(miny, node.getY());
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)editPart, node, (IGraphicalEditPart)editPart);
            }
            mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
        } else {
            this.buildLayoutGraphRecursively(mapping, layoutRootPart, topNode, layoutRootPart);
        }
        this.processConnections(mapping);
        return mapping;
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        boolean zoomToFit = (Boolean)settings.getProperty(CoreOptions.ZOOM_TO_FIT);
        IWorkbenchPart workbenchPart = mapping.getWorkbenchPart();
        int animationTime = this.calcAnimationTime(mapping, settings, workbenchPart != null && !workbenchPart.getSite().getPage().isPartVisible(workbenchPart));
        mapping.setProperty(ANIMATION_TIME, (Object)animationTime);
        Object layoutGraphObj = mapping.getParentElement();
        if (zoomToFit && layoutGraphObj instanceof EditPart) {
            double oldScale;
            double desiredHeight;
            double scaleY;
            DiagramEditPart diagramEditPart = GmfDiagramLayoutConnector.getDiagramEditPart((EditPart)layoutGraphObj);
            if (diagramEditPart == null) {
                this.applyLayout(mapping, animationTime);
                return;
            }
            ZoomManager zoomManager = ((RenderedDiagramRootEditPart)diagramEditPart.getRoot()).getZoomManager();
            ElkNode parentNode = mapping.getLayoutGraph();
            Dimension available = zoomManager.getViewport().getClientArea().getSize();
            double desiredWidth = parentNode.getWidth();
            double scaleX = Math.min((double)available.width / desiredWidth, zoomManager.getMaxZoom());
            double scale = Math.min(scaleX, scaleY = Math.min((double)available.height / (desiredHeight = parentNode.getHeight()), zoomManager.getMaxZoom()));
            if (scale < (oldScale = zoomManager.getZoom())) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
            this.applyLayout(mapping, animationTime);
            if (scale > oldScale) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
        } else {
            this.applyLayout(mapping, animationTime);
        }
    }

    protected int calcAnimationTime(LayoutMapping mapping, IPropertyHolder settings, boolean viewerNotVisible) {
        boolean animate = (Boolean)settings.getProperty(CoreOptions.ANIMATE);
        if (animate) {
            int factor;
            int maxTime;
            int minTime = (Integer)settings.getProperty(CoreOptions.MIN_ANIM_TIME);
            if (minTime < 0) {
                minTime = 0;
            }
            if ((maxTime = ((Integer)settings.getProperty(CoreOptions.MAX_ANIM_TIME)).intValue()) < minTime) {
                maxTime = minTime;
            }
            if ((factor = ((Integer)settings.getProperty(CoreOptions.ANIM_TIME_FACTOR)).intValue()) > 0) {
                int graphSize = GmfDiagramLayoutConnector.countNodes(mapping.getLayoutGraph());
                int time = minTime + (int)((double)factor * Math.sqrt(graphSize));
                return time <= maxTime ? time : maxTime;
            }
            return minTime;
        }
        return 0;
    }

    protected static int countNodes(ElkNode node) {
        int count = 0;
        for (ElkNode child : node.getChildren()) {
            count += GmfDiagramLayoutConnector.countNodes(child) + 1;
        }
        return count;
    }

    protected void applyLayout(LayoutMapping mapping, int animationTime) {
        this.transferLayout(mapping);
        if (animationTime > 0) {
            Animation.markBegin();
            this.applyLayout(mapping);
            Animation.run((int)animationTime);
        } else {
            this.applyLayout(mapping);
        }
    }

    protected void transferLayout(LayoutMapping mapping) {
        DiagramEditPart diagramEditPart;
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            applyLayoutRequest.addElement((ElkGraphElement)entry.getKey(), (GraphicalEditPart)((IGraphicalEditPart)entry.getValue()));
        }
        ElkNode layoutGraph = mapping.getLayoutGraph();
        applyLayoutRequest.setUpperBound(layoutGraph.getWidth(), layoutGraph.getHeight());
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            GmfDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
        if (((InternalTransactionalEditingDomain)(diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART)).getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    protected static void addOffset(ElkNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((ElkNode)parentNode, (double)offset.x, (double)offset.y);
    }

    protected void applyLayout(LayoutMapping mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        if (applyLayoutCommand != null) {
            CommandStack commandStack = (CommandStack)mapping.getProperty(COMMAND_STACK);
            IWorkbenchPart workbenchPart = mapping.getWorkbenchPart();
            if (commandStack == null) {
                Object adapter;
                if (workbenchPart != null && (adapter = workbenchPart.getAdapter(CommandStack.class)) instanceof CommandStack) {
                    commandStack = (CommandStack)adapter;
                }
                if (commandStack == null) {
                    IGraphicalEditPart parentElement = (IGraphicalEditPart)mapping.getParentElement();
                    commandStack = parentElement.getDiagramEditDomain().getDiagramCommandStack();
                }
            }
            commandStack.execute(applyLayoutCommand);
            DiagramEditor diagramEditor = this.getDiagramEditor(workbenchPart);
            if (diagramEditor != null) {
                GmfDiagramLayoutConnector.refreshDiagram(diagramEditor, (IGraphicalEditPart)mapping.getParentElement());
            }
        }
    }

    protected void buildLayoutGraphRecursively(LayoutMapping mapping, IGraphicalEditPart parentEditPart, ElkNode parentLayoutNode, IGraphicalEditPart currentEditPart) {
        Maybe kinsets = new Maybe();
        for (Object obj : currentEditPart.getChildren()) {
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                AbstractBorderItemEditPart borderItem = (AbstractBorderItemEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)borderItem)) continue;
                this.createPort(mapping, borderItem, parentEditPart, parentLayoutNode);
                continue;
            }
            if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)compartment)) continue;
                boolean compExp = true;
                IFigure compartmentFigure = compartment.getFigure();
                if (compartmentFigure instanceof ResizableCompartmentFigure) {
                    ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                    compExp = resizCompFigure.isExpanded();
                }
                if (!compExp) continue;
                this.buildLayoutGraphRecursively(mapping, parentEditPart, parentLayoutNode, (IGraphicalEditPart)compartment);
                continue;
            }
            if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)childNodeEditPart)) continue;
                ElkNode node = this.createNode(mapping, childNodeEditPart, parentEditPart, parentLayoutNode, (Maybe<ElkPadding>)kinsets);
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)childNodeEditPart, node, (IGraphicalEditPart)childNodeEditPart);
                continue;
            }
            if (!(obj instanceof IGraphicalEditPart)) continue;
            this.createNodeLabel(mapping, (IGraphicalEditPart)obj, parentEditPart, parentLayoutNode);
        }
    }

    protected ElkNode createNode(LayoutMapping mapping, ShapeNodeEditPart nodeEditPart, IGraphicalEditPart parentEditPart, ElkNode parentElkNode, Maybe<ElkPadding> elkinsets) {
        IFigure nodeFigure = nodeEditPart.getFigure();
        ElkNode childLayoutNode = ElkGraphUtil.createNode((ElkNode)parentElkNode);
        Rectangle childBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeFigure);
        Rectangle containerBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeFigure.getParent());
        childLayoutNode.setX((double)(childBounds.x - containerBounds.x));
        childLayoutNode.setY((double)(childBounds.y - containerBounds.y));
        childLayoutNode.setDimensions((double)childBounds.width, (double)childBounds.height);
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            childLayoutNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)minSize.width, (double)minSize.height));
        }
        catch (SWTException minSize) {
            // empty catch block
        }
        if (parentElkNode != null) {
            if (elkinsets.get() == null) {
                Insets insets = this.calcSpecificInsets(parentEditPart.getFigure(), nodeFigure);
                ElkPadding ei = new ElkPadding((double)insets.top, (double)insets.right, (double)insets.bottom, (double)insets.left);
                childLayoutNode.setProperty(CoreOptions.PADDING, (Object)ei);
                elkinsets.set((Object)ei);
            }
            parentElkNode.getChildren().add((Object)childLayoutNode);
        }
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)nodeEditPart);
        return childLayoutNode;
    }

    protected Insets calcSpecificInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    protected ElkPort createPort(LayoutMapping mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)elknode);
        Rectangle portBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
        double xpos = portBounds.x - nodeBounds.x;
        double ypos = portBounds.y - nodeBounds.y;
        port.setLocation(xpos, ypos);
        port.setDimensions((double)portBounds.width, (double)portBounds.height);
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IFigure labelFigure = ((IGraphicalEditPart)portChildObj).getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            }
            if (text == null) continue;
            ElkLabel portLabel = ElkGraphUtil.createLabel((ElkGraphElement)port);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, (Object)((IGraphicalEditPart)portChildObj));
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            portLabel.setLocation((double)(labelBounds.x - portBounds.x), (double)(labelBounds.y - portBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                portLabel.setDimensions((double)size.width, (double)size.height);
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        return port;
    }

    protected ElkLabel createNodeLabel(LayoutMapping mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode) {
        Label label;
        IFigure labelFigure = labelEditPart.getFigure();
        String text = null;
        Font font = null;
        if (labelFigure instanceof WrappingLabel) {
            WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
            text = wrappingLabel.getText();
            font = wrappingLabel.getFont();
        } else if (labelFigure instanceof Label) {
            label = (Label)labelFigure;
            text = label.getText();
            font = label.getFont();
        }
        if (text != null) {
            label = ElkGraphUtil.createLabel((ElkGraphElement)elknode);
            label.setText(text);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            Rectangle nodeBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
            label.setLocation((double)(labelBounds.x - nodeBounds.x), (double)(labelBounds.y - nodeBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                label.setDimensions((double)size.width, (double)size.height);
                if (font != null && !font.isDisposed()) {
                    label.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    label.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
            return label;
        }
        return null;
    }

    protected void addConnections(LayoutMapping mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            ConnectionEditPart connectionEditPart;
            if (!(targetConn instanceof ConnectionEditPart) || !this.editPartFilter.filter((EditPart)(connectionEditPart = (ConnectionEditPart)targetConn))) continue;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping mapping) {
        HashMap<EReference, ElkEdge> reference2EdgeMap = new HashMap<EReference, ElkEdge>();
        for (ConnectionEditPart connection : (List)mapping.getProperty(CONNECTIONS)) {
            ElkGraphElement targetElem;
            ElkGraphElement sourceElem;
            ElkEdge edge;
            boolean isOppositeEdge = false;
            Optional<EdgeLabelPlacement> edgeLabelPlacement = Optional.empty();
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (ElkEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = Optional.of(EdgeLabelPlacement.TAIL);
                    isOppositeEdge = true;
                } else {
                    edge = ElkGraphUtil.createEdge(null);
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = ElkGraphUtil.createEdge(null);
            }
            BiMap inverseGraphMap = mapping.getGraphMap().inverse();
            EditPart sourceObj = connection.getSource();
            if (sourceObj instanceof ConnectionEditPart) {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getSource());
                if (sourceElem == null) {
                    sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getTarget());
                }
            } else {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)sourceObj);
            }
            ElkNode sourceShape = null;
            ElkPort sourcePort = null;
            ElkNode sourceNode = null;
            if (sourceElem instanceof ElkNode) {
                sourceShape = sourceNode = (ElkNode)sourceElem;
            } else {
                if (!(sourceElem instanceof ElkPort)) continue;
                sourcePort = (ElkPort)sourceElem;
                sourceNode = sourcePort.getParent();
                sourceShape = sourcePort;
            }
            EditPart targetObj = connection.getTarget();
            if (targetObj instanceof ConnectionEditPart) {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getTarget());
                if (targetElem == null) {
                    targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getSource());
                }
            } else {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)targetObj);
            }
            ElkNode targetShape = null;
            ElkNode targetNode = null;
            ElkPort targetPort = null;
            if (targetElem instanceof ElkNode) {
                targetShape = targetNode = (ElkNode)targetElem;
            } else {
                if (!(targetElem instanceof ElkPort)) continue;
                targetPort = (ElkPort)targetElem;
                targetNode = targetPort.getParent();
                targetShape = targetPort;
            }
            ElkNode edgeContainment = ElkGraphUtil.findLowestCommonAncestor((ElkNode)sourceNode, (ElkNode)targetNode);
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)edgeContainment);
            if (!isOppositeEdge) {
                edge.getSources().add((Object)sourceShape);
                edge.getTargets().add((Object)targetShape);
                edgeContainment.getContainedEdges().add((Object)edge);
                mapping.getGraphMap().put((Object)edge, (Object)connection);
                this.setEdgeLayout(edge, connection, offset);
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset);
        }
    }

    protected void setEdgeLayout(ElkEdge edge, ConnectionEditPart connection, KVector offset) {
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        ElkEdgeSection edgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
        Point firstPoint = pointList.getPoint(0);
        edgeSection.setStartX((double)firstPoint.x - offset.x);
        edgeSection.setStartY((double)firstPoint.y - offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)((double)point.x - offset.x), (double)((double)point.y - offset.y));
            ++i;
        }
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        edgeSection.setEndX((double)lastPoint.x - offset.x);
        edgeSection.setEndY((double)lastPoint.y - offset.y);
    }

    protected void processEdgeLabels(LayoutMapping mapping, ConnectionEditPart connection, ElkEdge edge, Optional<EdgeLabelPlacement> placement, KVector offset) {
        for (Object obj : connection.getChildren()) {
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            Object labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.width = wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap();
                    iconBounds.height = wrappingLabel.getIcon().getBounds().height;
                    labelText = "O " + (String)labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + (String)labelText;
                }
            }
            if (labelText != null && ((String)labelText).length() > 0) {
                label = ElkGraphUtil.createLabel((ElkGraphElement)edge);
                if (!placement.isPresent()) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement.get());
                }
                Font font = labelFigure.getFont();
                if (font != null && !font.isDisposed()) {
                    label.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    label.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
                label.setLocation((double)labelBounds.x - offset.x, (double)labelBounds.y - offset.y);
                if (iconBounds != null) {
                    label.setWidth((double)(labelBounds.width + iconBounds.width));
                } else {
                    label.setWidth((double)labelBounds.width);
                }
                label.setHeight((double)labelBounds.height);
                label.setText((String)labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = ElkGraphUtil.createLabel(null);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    private static void refreshDiagram(DiagramEditor editor, IGraphicalEditPart rootPart) {
        IGraphicalEditPart editPart = rootPart;
        if (editPart == null) {
            editPart = editor.getDiagramEditPart();
        }
        for (Object obj : editPart.getViewer().getEditPartRegistry().values()) {
            IFigure figure;
            if (!(obj instanceof ShapeNodeEditPart) || !((figure = ((ShapeNodeEditPart)obj).getFigure()) instanceof BorderedNodeFigure)) continue;
            IFigure portContainer = ((BorderedNodeFigure)figure).getBorderItemContainer();
            portContainer.invalidate();
            portContainer.validate();
        }
    }
}

