/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.labelspacing;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.util.labelspacing.TextAlignment;

public enum LabelLocation {
    OUT_T_L((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT)), TextAlignment.LEFT),
    OUT_T_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.CENTER),
    OUT_T_R((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT)), TextAlignment.RIGHT),
    OUT_B_L((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT)), TextAlignment.LEFT),
    OUT_B_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.CENTER),
    OUT_B_R((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT)), TextAlignment.RIGHT),
    OUT_L_T((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    OUT_L_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    OUT_L_B((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    OUT_R_T((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    OUT_R_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    OUT_R_B((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    IN_T_L((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    IN_T_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.CENTER),
    IN_T_R((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    IN_C_L((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    IN_C_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.CENTER),
    IN_C_R((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    IN_B_L((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.LEFT),
    IN_B_C((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)), TextAlignment.CENTER),
    IN_B_R((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)), TextAlignment.RIGHT),
    UNDEFINED((List<? extends Set<NodeLabelPlacement>>)ImmutableList.of(), null);

    private final List<? extends Set<NodeLabelPlacement>> assignedPlacements;
    private final TextAlignment horizontalAlignment;

    private LabelLocation(List<? extends Set<NodeLabelPlacement>> assignedPlacements, TextAlignment horizontalAlignment) {
        this.assignedPlacements = assignedPlacements;
        this.horizontalAlignment = horizontalAlignment;
    }

    public static LabelLocation fromNodeLabelPlacement(EnumSet<NodeLabelPlacement> labelPlacement) {
        LabelLocation[] labelLocationArray = LabelLocation.values();
        int n = labelLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabelLocation location = labelLocationArray[n2];
            if (location.assignedPlacements.contains(labelPlacement)) {
                return location;
            }
            ++n2;
        }
        return UNDEFINED;
    }

    public TextAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

