/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.EdgeLabelPlacementStrategy;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;

public final class LabelDummySwitcher
implements ILayoutProcessor {
    private double[] layerWidths;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy switching", 1.0f);
        ArrayList labelDummies = Lists.newArrayList();
        ArrayList nodesToSwap = Lists.newArrayList();
        ArrayList leftLongEdgeDummies = Lists.newArrayList();
        ArrayList rightLongEdgeDummies = Lists.newArrayList();
        EdgeLabelPlacementStrategy strategy = (EdgeLabelPlacementStrategy)layeredGraph.getProperty(LayeredOptions.EDGE_CENTER_LABEL_PLACEMENT_STRATEGY);
        if (strategy == EdgeLabelPlacementStrategy.WIDEST_LAYER) {
            List<Layer> layers = layeredGraph.getLayers();
            this.layerWidths = new double[layers.size()];
            int i = 0;
            while (i < layers.size()) {
                this.layerWidths[i] = LGraphUtil.findMaxNonDummyNodeWidth(layers.get(i), false);
                ++i;
            }
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer.getNodes()) {
                if (node.getType() != LNode.NodeType.LABEL) continue;
                labelDummies.add(node);
                leftLongEdgeDummies.clear();
                rightLongEdgeDummies.clear();
                LNode source = node;
                do {
                    if ((source = source.getIncomingEdges().iterator().next().getSource().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                    leftLongEdgeDummies.add(source);
                } while (source.getType() == LNode.NodeType.LONG_EDGE);
                LNode target = node;
                do {
                    if ((target = target.getOutgoingEdges().iterator().next().getTarget().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
                    rightLongEdgeDummies.add(target);
                } while (target.getType() == LNode.NodeType.LONG_EDGE);
                switch (strategy) {
                    case WIDEST_LAYER: {
                        this.findSwapCandidateForWidestLayer(node, leftLongEdgeDummies, rightLongEdgeDummies, nodesToSwap);
                        break;
                    }
                    default: {
                        this.findSwapCandidateCenter(node, leftLongEdgeDummies, rightLongEdgeDummies, nodesToSwap);
                    }
                }
            }
        }
        for (Pair swapPair : nodesToSwap) {
            this.swapNodes((LNode)((Object)swapPair.getFirst()), (LNode)((Object)swapPair.getSecond()));
        }
        for (LNode labelDummy : labelDummies) {
            this.updateLongEdgeSourceTargetInfo(labelDummy);
        }
        this.layerWidths = null;
        monitor.done();
    }

    private void findSwapCandidateForWidestLayer(LNode node, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies, List<Pair<LNode, LNode>> nodesToSwap) {
        double maxWidth = 0.0;
        LNode swapCandidate = null;
        for (LNode dummy : Iterables.concat(rightLongEdgeDummies, leftLongEdgeDummies)) {
            double width = LGraphUtil.findMaxNonDummyNodeWidth(dummy.getLayer(), false);
            if (!(width > maxWidth)) continue;
            maxWidth = width;
            swapCandidate = dummy;
        }
        if (swapCandidate != null) {
            nodesToSwap.add((Pair<LNode, LNode>)new Pair((Object)node, swapCandidate));
        }
    }

    private void findSwapCandidateCenter(LNode node, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies, List<Pair<LNode, LNode>> nodesToSwap) {
        int rightSize;
        int leftSize = leftLongEdgeDummies.size();
        if (leftSize > (rightSize = rightLongEdgeDummies.size()) + 1) {
            int pos = (leftSize + rightSize) / 2;
            nodesToSwap.add((Pair<LNode, LNode>)new Pair((Object)node, (Object)leftLongEdgeDummies.get(pos)));
        } else if (rightSize > leftSize + 1) {
            int pos = (rightSize - leftSize) / 2 - 1;
            nodesToSwap.add((Pair<LNode, LNode>)new Pair((Object)node, (Object)rightLongEdgeDummies.get(pos)));
        }
    }

    private void swapNodes(LNode dummy1, LNode dummy2) {
        LEdge edge;
        Layer layer1 = dummy1.getLayer();
        Layer layer2 = dummy2.getLayer();
        LPort inputPort1 = dummy1.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort1 = dummy1.getPorts(PortType.OUTPUT).iterator().next();
        LPort inputPort2 = dummy2.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort2 = dummy2.getPorts(PortType.OUTPUT).iterator().next();
        LEdge[] incomingEdges1 = inputPort1.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges1 = outputPort1.getOutgoingEdges().toArray(new LEdge[1]);
        LEdge[] incomingEdges2 = inputPort2.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges2 = outputPort2.getOutgoingEdges().toArray(new LEdge[1]);
        dummy1.setLayer(layer2);
        LEdge[] lEdgeArray = incomingEdges2;
        int n = incomingEdges2.length;
        int n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort1);
            ++n2;
        }
        lEdgeArray = outgoingEdges2;
        n = outgoingEdges2.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort1);
            ++n2;
        }
        dummy2.setLayer(layer1);
        lEdgeArray = incomingEdges1;
        n = incomingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort2);
            ++n2;
        }
        lEdgeArray = outgoingEdges1;
        n = outgoingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort2);
            ++n2;
        }
    }

    private void updateLongEdgeSourceTargetInfo(LNode labelDummy) {
        this.doUpdateLongEdgeSourceTargetInfo(labelDummy, node -> node.getIncomingEdges().iterator().next().getSource().getNode(), InternalProperties.LONG_EDGE_TARGET);
        this.doUpdateLongEdgeSourceTargetInfo(labelDummy, node -> node.getOutgoingEdges().iterator().next().getTarget().getNode(), InternalProperties.LONG_EDGE_SOURCE);
    }

    private void doUpdateLongEdgeSourceTargetInfo(LNode labelDummy, Function<LNode, LNode> nextElement, IProperty<LPort> longEdgeProperty) {
        LNode longEdgeDummy = nextElement.apply(labelDummy);
        while (longEdgeDummy.getType() == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(longEdgeProperty, null);
            longEdgeDummy = nextElement.apply(longEdgeDummy);
        }
    }
}

