/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.force.IGraphImporter;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.alg.force.properties.InternalProperties;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public class KGraphImporter
implements IGraphImporter<KNode> {
    @Override
    public FGraph importGraph(KNode kgraph) {
        FGraph fgraph = new FGraph();
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        fgraph.copyProperties((IPropertyHolder)sourceShapeLayout);
        fgraph.setProperty(InternalProperties.ORIGIN, kgraph);
        HashMap<KNode, FNode> elemMap = new HashMap<KNode, FNode>();
        this.transformNodes(kgraph, fgraph, elemMap);
        this.transformEdges(kgraph, fgraph, elemMap);
        return fgraph;
    }

    private void transformNodes(KNode parentNode, FGraph fgraph, Map<KNode, FNode> elemMap) {
        int index = 0;
        for (KNode knode : parentNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            String label = "";
            if (!knode.getLabels().isEmpty()) {
                label = ((KLabel)knode.getLabels().get(0)).getText();
            }
            FNode newNode = new FNode(label);
            newNode.copyProperties((IPropertyHolder)nodeLayout);
            newNode.setProperty(InternalProperties.ORIGIN, knode);
            newNode.id = index++;
            newNode.getPosition().x = nodeLayout.getXpos() + nodeLayout.getWidth() / 2.0f;
            newNode.getPosition().y = nodeLayout.getYpos() + nodeLayout.getHeight() / 2.0f;
            newNode.getSize().x = Math.max(nodeLayout.getWidth(), 1.0f);
            newNode.getSize().y = Math.max(nodeLayout.getHeight(), 1.0f);
            fgraph.getNodes().add(newNode);
            elemMap.put(knode, newNode);
            PortConstraints portConstraints = (PortConstraints)nodeLayout.getProperty(ForceOptions.PORT_CONSTRAINTS);
            if (portConstraints != PortConstraints.UNDEFINED) continue;
            portConstraints = PortConstraints.FREE;
        }
    }

    private void transformEdges(KNode parentNode, FGraph fgraph, Map<KNode, FNode> elemMap) {
        for (KNode knode : parentNode.getChildren()) {
            for (KEdge kedge : knode.getOutgoingEdges()) {
                if (kedge.getTarget().getParent() != parentNode || knode == kedge.getTarget()) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
                FEdge newEdge = new FEdge();
                newEdge.copyProperties((IPropertyHolder)edgeLayout);
                newEdge.setProperty(InternalProperties.ORIGIN, kedge);
                newEdge.setSource(elemMap.get(knode));
                newEdge.setTarget(elemMap.get(kedge.getTarget()));
                fgraph.getEdges().add(newEdge);
                for (KLabel klabel : kedge.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
                    FLabel newLabel = new FLabel(newEdge, klabel.getText());
                    newLabel.setProperty(InternalProperties.ORIGIN, klabel);
                    newLabel.getSize().x = Math.max(labelLayout.getWidth(), 1.0f);
                    newLabel.getSize().y = Math.max(labelLayout.getHeight(), 1.0f);
                    newLabel.refreshPosition();
                    fgraph.getLabels().add(newLabel);
                }
            }
        }
    }

    @Override
    public void applyLayout(FGraph fgraph) {
        KNode kgraph = (KNode)fgraph.getProperty(InternalProperties.ORIGIN);
        KShapeLayout parentLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        float borderSpacing = ((Float)fgraph.getProperty(ForceOptions.SPACING_BORDER)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = ((Float)ForceOptions.SPACING_BORDER.getDefault()).floatValue();
            fgraph.setProperty(ForceOptions.SPACING_BORDER, Float.valueOf(borderSpacing));
        }
        double minXPos = 2.147483647E9;
        double minYPos = 2.147483647E9;
        double maxXPos = -2.147483648E9;
        double maxYPos = -2.147483648E9;
        for (FNode node : fgraph.getNodes()) {
            KVector pos = node.getPosition();
            KVector size = node.getSize();
            minXPos = Math.min(minXPos, pos.x - size.x / 2.0);
            minYPos = Math.min(minYPos, pos.y - size.y / 2.0);
            maxXPos = Math.max(maxXPos, pos.x + size.x / 2.0);
            maxYPos = Math.max(maxYPos, pos.y + size.y / 2.0);
        }
        KVector offset = new KVector((double)borderSpacing - minXPos, (double)borderSpacing - minYPos);
        for (FNode fnode : fgraph.getNodes()) {
            Object object = fnode.getProperty(InternalProperties.ORIGIN);
            if (!(object instanceof KNode)) continue;
            KNode knode = (KNode)object;
            KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            KVector nodePos = fnode.getPosition().add(offset);
            nodeLayout.setXpos((float)nodePos.x - nodeLayout.getWidth() / 2.0f);
            nodeLayout.setYpos((float)nodePos.y - nodeLayout.getHeight() / 2.0f);
        }
        for (FEdge fedge : fgraph.getEdges()) {
            KEdge kedge = (KEdge)fedge.getProperty(InternalProperties.ORIGIN);
            KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            edgeLayout.getBendPoints().clear();
            edgeLayout.getSourcePoint().applyVector(fedge.getSourcePoint());
            edgeLayout.getTargetPoint().applyVector(fedge.getTargetPoint());
        }
        for (FLabel flabel : fgraph.getLabels()) {
            KLabel klabel = (KLabel)flabel.getProperty(InternalProperties.ORIGIN);
            KShapeLayout klabelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            KVector labelPos = flabel.getPosition().add(offset);
            klabelLayout.applyVector(labelPos);
        }
        KInsets insets = parentLayout.getInsets();
        float width = (float)(maxXPos - minXPos) + 2.0f * borderSpacing + insets.getLeft() + insets.getRight();
        float height = (float)(maxYPos - minYPos) + 2.0f * borderSpacing + insets.getTop() + insets.getBottom();
        ElkUtil.resizeNode((KNode)kgraph, (float)width, (float)height, (boolean)false, (boolean)true);
    }
}

