/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import org.eclipse.elk.alg.layered.KlayLayered;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.transform.KGraphTransformer;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.KNode;

public final class LayeredLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "org.eclipse.elk.layered";
    private final KlayLayered klayLayered = new KlayLayered();

    public void layout(KNode kgraph, IElkProgressMonitor progressMonitor) {
        KGraphTransformer graphImporter = new KGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        KShapeLayout kgraphLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        if (kgraphLayout.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.klayLayered.doCompoundLayout(layeredGraph, progressMonitor);
        } else {
            this.klayLayered.doLayout(layeredGraph, progressMonitor);
        }
        if (!progressMonitor.isCanceled()) {
            graphImporter.applyLayout(layeredGraph);
        }
    }

    public KlayLayered.TestExecutionState startLayoutTest(KNode kgraph) {
        KGraphTransformer graphImporter = new KGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        return this.klayLayered.prepareLayoutTest(layeredGraph);
    }

    public KlayLayered getLayoutAlgorithm() {
        return this.klayLayered;
    }
}

