/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import com.google.common.collect.BoundType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.PortIterable;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class InLayerEdgeAllCrossingsCounter {
    private final Map<LNode, Integer> eastNodeCardinalities = Maps.newHashMap();
    private final Map<LNode, Integer> westNodeCardinalities = Maps.newHashMap();
    private final Map<LPort, Integer> portPositions = Maps.newHashMap();
    private final LNode[] nodeOrder;
    private final SortedMultiset<Integer> inLayerPorts;
    private final Set<LEdge> inLayerEdges = Sets.newHashSet();

    public InLayerEdgeAllCrossingsCounter(LNode[] nodeOrder) {
        this.inLayerPorts = TreeMultiset.create();
        this.nodeOrder = nodeOrder;
        this.initializeLayer(nodeOrder);
    }

    private void initializeLayer(LNode[] layer) {
        int eastPortId = 0;
        int westPortId = 0;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            eastPortId = this.setPortIdsAndNodeCardinality(eastPortId, node, PortSide.EAST, this.eastNodeCardinalities);
            westPortId = this.setPortIdsAndNodeCardinality(westPortId, node, PortSide.WEST, this.westNodeCardinalities);
            ++n2;
        }
    }

    private int setPortIdsAndNodeCardinality(int portId, LNode node, PortSide side, Map<LNode, Integer> cardinalities) {
        int currentPortId = portId;
        int cardinality = 0;
        boolean hasPorts = false;
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
        for (LPort port : ports) {
            hasPorts = true;
            this.portPositions.put(port, currentPortId);
            if (!this.portOrderIsFixedFor(node) && port.getDegree() <= 1) continue;
            ++cardinality;
            ++currentPortId;
        }
        if (!this.portOrderIsFixedFor(node) && hasPorts) {
            ++cardinality;
            ++currentPortId;
        }
        cardinalities.put(node, cardinality);
        return currentPortId;
    }

    private boolean portOrderIsFixedFor(LNode node) {
        return ((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed();
    }

    public int countCrossings() {
        int crossings = 0;
        crossings = this.iterateEdgesTopDownAndCountCrossingsOnSide(PortSide.WEST);
        return crossings += this.iterateEdgesTopDownAndCountCrossingsOnSide(PortSide.EAST);
    }

    private int iterateEdgesTopDownAndCountCrossingsOnSide(PortSide portSide) {
        int crossings = 0;
        LNode[] lNodeArray = this.nodeOrder;
        int n = this.nodeOrder.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, portSide);
            for (LPort port : ports) {
                for (LEdge edge : port.getConnectedEdges()) {
                    if (edge.isSelfLoop()) continue;
                    crossings += this.countCrossingsOn(edge, port);
                }
            }
            ++n2;
        }
        return crossings;
    }

    protected int countCrossingsOn(LEdge edge, LPort port) {
        int crossings = 0;
        if (this.isInLayer(edge)) {
            if (this.notVisited(edge)) {
                this.add(edge);
            } else {
                this.remove(edge);
                crossings += this.numberOfPortsInBetweenEndsOf(edge, this.inLayerPorts);
            }
        } else {
            int portsOnNodeWithFreePortOrder = this.inLayerPorts.count((Object)this.positionOf(port));
            crossings += this.inLayerEdges.size() - portsOnNodeWithFreePortOrder;
        }
        return crossings;
    }

    private boolean notVisited(LEdge edge) {
        return !this.inLayerEdges.contains((Object)edge);
    }

    private int numberOfPortsInBetweenEndsOf(LEdge edge, SortedMultiset<Integer> set) {
        int lowerBound = Math.min(this.positionOf(edge.getTarget()), this.positionOf(edge.getSource()));
        int upperBound = Math.max(this.positionOf(edge.getTarget()), this.positionOf(edge.getSource()));
        return set.subMultiset((Object)lowerBound, BoundType.OPEN, (Object)upperBound, BoundType.OPEN).size();
    }

    private void remove(LEdge edge) {
        this.inLayerPorts.remove((Object)this.positionOf(edge.getSource()));
        this.inLayerPorts.remove((Object)this.positionOf(edge.getTarget()));
        this.inLayerEdges.remove((Object)edge);
    }

    private void add(LEdge edge) {
        this.inLayerEdges.add(edge);
        this.inLayerPorts.add((Object)this.positionOf(edge.getSource()));
        this.inLayerPorts.add((Object)this.positionOf(edge.getTarget()));
    }

    protected boolean isInLayer(LEdge edge) {
        Layer targetLayer;
        Layer sourceLayer = edge.getSource().getNode().getLayer();
        return sourceLayer == (targetLayer = edge.getTarget().getNode().getLayer());
    }

    protected int positionOf(LPort port) {
        return this.portPositions.get((Object)port);
    }

    public void notifyOfSwitch(LNode wasUpperNode, LNode wasLowerNode) {
        this.updatePortIds(wasUpperNode, wasLowerNode, PortSide.EAST, this.eastNodeCardinalities);
        this.updatePortIds(wasUpperNode, wasLowerNode, PortSide.WEST, this.westNodeCardinalities);
    }

    private void updatePortIds(LNode firstNode, LNode secondNode, PortSide side, Map<LNode, Integer> cardinalities) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(firstNode, side);
        for (LPort port : ports) {
            this.portPositions.put(port, this.positionOf(port) + cardinalities.get((Object)secondNode));
        }
        ports = PortIterable.inNorthSouthEastWestOrder(secondNode, side);
        for (LPort port : ports) {
            this.portPositions.put(port, this.positionOf(port) - cardinalities.get((Object)firstNode));
        }
    }
}

