/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.alg.mrtree.properties.MrTreeOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public class ComponentsProcessor {
    private List<TEdge>[] incidence;
    private boolean[] visited;

    private void initialize(TGraph graph) {
        int n = graph.getNodes().size();
        this.incidence = new List[n];
        this.visited = new boolean[n];
        for (TNode node : graph.getNodes()) {
            this.incidence[node.id] = new LinkedList<TEdge>();
        }
        for (TEdge edge : graph.getEdges()) {
            this.incidence[edge.getSource().id].add(edge);
            this.incidence[edge.getTarget().id].add(edge);
        }
    }

    public List<TGraph> split(TGraph graph) {
        Boolean separate = (Boolean)graph.getProperty(MrTreeOptions.SEPARATE_CONNECTED_COMPONENTS);
        if (separate == null || separate.booleanValue()) {
            this.initialize(graph);
            ArrayList<TGraph> components = new ArrayList<TGraph>();
            for (TNode node : graph.getNodes()) {
                TGraph comp = this.dfs(node, null);
                if (comp == null) continue;
                comp.copyProperties((IPropertyHolder)graph);
                components.add(comp);
            }
            this.incidence = null;
            this.visited = null;
            if (components.size() > 1) {
                for (TGraph comp : components) {
                    int id = 0;
                    for (TNode node : comp.getNodes()) {
                        node.id = id++;
                    }
                }
            }
            return components;
        }
        return Lists.newArrayList((Object[])new TGraph[]{graph});
    }

    private TGraph dfs(TNode node, TGraph graph) {
        if (!this.visited[node.id]) {
            this.visited[node.id] = true;
            TGraph component = graph;
            if (component == null) {
                component = new TGraph();
            }
            component.getNodes().add(node);
            for (TEdge edge : this.incidence[node.id]) {
                if (edge.getSource() != node) {
                    this.dfs(edge.getSource(), component);
                }
                if (edge.getTarget() != node) {
                    this.dfs(edge.getTarget(), component);
                }
                component.getEdges().add(edge);
            }
            return component;
        }
        return null;
    }

    public TGraph pack(List<TGraph> components) {
        if (components.size() == 1) {
            return components.get(0);
        }
        if (components.size() <= 0) {
            return new TGraph();
        }
        for (TGraph graph : components) {
            int priority = 0;
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            double maxx = -2.147483648E9;
            double maxy = -2.147483648E9;
            for (TNode node : graph.getNodes()) {
                priority += ((Integer)node.getProperty(MrTreeOptions.PRIORITY)).intValue();
                minx = Math.min(minx, node.getPosition().x);
                miny = Math.min(miny, node.getPosition().y);
                maxx = Math.max(maxx, node.getPosition().x + node.getSize().x);
                maxy = Math.max(maxy, node.getPosition().y + node.getSize().y);
            }
            graph.setProperty(MrTreeOptions.PRIORITY, priority);
            graph.setProperty(InternalProperties.BB_UPLEFT, new KVector(minx, miny));
            graph.setProperty(InternalProperties.BB_LOWRIGHT, new KVector(maxx, maxy));
        }
        Collections.sort(components, new Comparator<TGraph>(){

            @Override
            public int compare(TGraph graph1, TGraph graph2) {
                int prio = (Integer)graph2.getProperty(MrTreeOptions.PRIORITY) - (Integer)graph1.getProperty(MrTreeOptions.PRIORITY);
                if (prio == 0) {
                    KVector size1 = ((KVector)graph1.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph1.getProperty(InternalProperties.BB_UPLEFT));
                    KVector size2 = ((KVector)graph2.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph2.getProperty(InternalProperties.BB_UPLEFT));
                    return Double.compare(size1.x * size1.y, size2.x * size2.y);
                }
                return prio;
            }
        });
        TGraph result = new TGraph();
        result.copyProperties((IPropertyHolder)components.get(0));
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (TGraph graph : components) {
            KVector size = ((KVector)graph.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph.getProperty(InternalProperties.BB_UPLEFT));
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)result.getProperty(MrTreeOptions.ASPECT_RATIO)).floatValue()));
        double spacing = ((Float)result.getProperty(MrTreeOptions.SPACING_NODE)).doubleValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (TGraph graph : components) {
            KVector size = ((KVector)graph.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph.getProperty(InternalProperties.BB_UPLEFT));
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.moveGraph(result, graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        HashMap propMerge = new HashMap();
        HashMap debug = new HashMap();
        for (TGraph tGraph : components) {
            boolean debugMode = (Boolean)tGraph.getProperty(CoreOptions.DEBUG_MODE);
            Map propComp = tGraph.getAllProperties();
            for (Map.Entry entry : propComp.entrySet()) {
                if (propMerge.containsKey(entry.getKey())) {
                    if (((IProperty)entry.getKey()).getDefault() == entry.getValue()) continue;
                    if (debugMode && debug.containsKey(entry.getKey())) {
                        System.err.println("Found different values for property " + ((IProperty)entry.getKey()).getId() + " in components.");
                        continue;
                    }
                    propMerge.put((IProperty)entry.getKey(), entry.getValue());
                    result.setProperty((IProperty)entry.getKey(), entry.getValue());
                    if (!debugMode) continue;
                    debug.put((IProperty)entry.getKey(), entry.getValue());
                    continue;
                }
                propMerge.put((IProperty)entry.getKey(), entry.getValue());
                result.setProperty((IProperty)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private void moveGraph(TGraph destGraph, TGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        graphOffset.sub((KVector)sourceGraph.getProperty(InternalProperties.BB_UPLEFT));
        for (TNode node : sourceGraph.getNodes()) {
            node.getPosition().add(graphOffset);
            destGraph.getNodes().add(node);
        }
        for (TEdge edge : sourceGraph.getEdges()) {
            for (KVector bendpoint : edge.getBendPoints()) {
                bendpoint.add(graphOffset);
            }
            destGraph.getEdges().add(edge);
        }
    }
}

