/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.conn.gmf;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.conn.gmf.ApplyLayoutRequest;
import org.eclipse.elk.conn.gmf.IEditPartFilter;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KLayoutDataFactory;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.klayoutdata.impl.KEdgeLayoutImpl;
import org.eclipse.elk.core.klayoutdata.impl.KShapeLayoutImpl;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KGraphFactory;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KLabeledGraphElement;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class GmfDiagramLayoutConnector
implements IDiagramLayoutConnector {
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<CommandStack> COMMAND_STACK = new Property("gmf.applyLayoutCommandStack");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("gmf.coordinateOffset");
    public static final IProperty<Integer> ANIMATION_TIME = new Property("gmf.animationTime", (Object)0);
    @Inject
    private IEditPartFilter editPartFilter;

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        EditPart ep = editPart;
        while (ep != null && !(ep instanceof DiagramEditPart) && !(ep instanceof RootEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof RootEditPart) {
            RootEditPart root = (RootEditPart)ep;
            ep = null;
            for (Object child : root.getChildren()) {
                if (!(child instanceof DiagramEditPart)) continue;
                ep = (EditPart)child;
            }
        }
        return (DiagramEditPart)ep;
    }

    protected DiagramEditor getDiagramEditor(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof DiagramEditor) {
            return (DiagramEditor)workbenchPart;
        }
        return null;
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        DiagramEditor diagramEditor = this.getDiagramEditor(workbenchPart);
        IGraphicalEditPart layoutRootPart = null;
        ArrayList<ShapeNodeEditPart> selectedParts = null;
        if (diagramPart instanceof ShapeNodeEditPart || diagramPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)diagramPart;
        } else if (diagramPart instanceof IGraphicalEditPart) {
            TopGraphicEditPart tgEditPart = ((IGraphicalEditPart)diagramPart).getTopGraphicEditPart();
            if (tgEditPart instanceof ShapeNodeEditPart) {
                layoutRootPart = (IGraphicalEditPart)tgEditPart;
            }
        } else if (diagramPart instanceof Collection) {
            Collection selection = (Collection)diagramPart;
            for (Object object : selection) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                if (layoutRootPart != null) {
                    EditPart parent = GmfDiagramLayoutConnector.commonParent((EditPart)layoutRootPart, (EditPart)object);
                    if (parent == null || parent instanceof RootEditPart) continue;
                    layoutRootPart = (IGraphicalEditPart)parent;
                    continue;
                }
                if (object instanceof ConnectionEditPart) continue;
                layoutRootPart = (IGraphicalEditPart)object;
            }
            if (layoutRootPart != null) {
                selectedParts = new ArrayList<ShapeNodeEditPart>(selection.size());
                for (Object object : selection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    EditPart editPart = (EditPart)object;
                    while (editPart != null && editPart.getParent() != layoutRootPart) {
                        editPart = editPart.getParent();
                    }
                    if (!(editPart instanceof ShapeNodeEditPart) || !this.editPartFilter.filter(editPart) || selectedParts.contains(editPart)) continue;
                    selectedParts.add((ShapeNodeEditPart)editPart);
                }
            }
        }
        if (layoutRootPart == null && diagramEditor != null) {
            layoutRootPart = diagramEditor.getDiagramEditPart();
        }
        if (layoutRootPart == null) {
            throw new IllegalArgumentException("Not supported by this layout connector: Workbench part " + workbenchPart + ", Edit part " + diagramPart);
        }
        LayoutMapping mapping = this.buildLayoutGraph(layoutRootPart, selectedParts, workbenchPart);
        return mapping;
    }

    protected static EditPart commonParent(EditPart editPart1, EditPart editPart2) {
        EditPart ep1 = editPart1;
        EditPart ep2 = editPart2;
        do {
            if (GmfDiagramLayoutConnector.isParent(ep1, ep2)) {
                return ep1;
            }
            if (GmfDiagramLayoutConnector.isParent(ep2, ep1)) {
                return ep2;
            }
            ep1 = ep1.getParent();
            ep2 = ep2.getParent();
        } while (ep1 != null && ep2 != null);
        return null;
    }

    protected static boolean isParent(EditPart parent, EditPart child) {
        EditPart editPart = child;
        do {
            if (editPart != parent) continue;
            return true;
        } while ((editPart = editPart.getParent()) != null);
        return false;
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, IWorkbenchPart workbenchPart) {
        KNode topNode;
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)GmfDiagramLayoutConnector.getDiagramEditPart((EditPart)layoutRootPart));
        if (layoutRootPart instanceof ShapeNodeEditPart) {
            topNode = this.createNode(mapping, (ShapeNodeEditPart)layoutRootPart, null, null, null);
        } else {
            topNode = ElkUtil.createInitializedNode();
            KShapeLayout shapeLayout = (KShapeLayout)topNode.getData(KShapeLayout.class);
            Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
            if (layoutRootPart instanceof DiagramEditPart) {
                String labelText = ((DiagramEditPart)layoutRootPart).getDiagramView().getName();
                if (labelText.length() > 0) {
                    KLabel label = ElkUtil.createInitializedLabel((KLabeledGraphElement)topNode);
                    label.setText(labelText);
                }
            } else {
                shapeLayout.setPos((float)rootBounds.x, (float)rootBounds.y);
            }
            shapeLayout.setSize((float)rootBounds.width, (float)rootBounds.height);
            shapeLayout.resetModificationFlag();
            mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        }
        mapping.setLayoutGraph(topNode);
        if (selection != null && !selection.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            Maybe kinsets = new Maybe();
            for (ShapeNodeEditPart editPart : selection) {
                KNode node = this.createNode(mapping, editPart, layoutRootPart, topNode, (Maybe<KInsets>)kinsets);
                KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
                minx = Math.min(minx, (double)nodeLayout.getXpos());
                miny = Math.min(miny, (double)nodeLayout.getYpos());
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)editPart, node, (IGraphicalEditPart)editPart);
            }
            mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
        } else {
            this.buildLayoutGraphRecursively(mapping, layoutRootPart, topNode, layoutRootPart);
        }
        this.processConnections(mapping);
        return mapping;
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        boolean zoomToFit = (Boolean)settings.getProperty(CoreOptions.ZOOM_TO_FIT);
        IWorkbenchPart workbenchPart = mapping.getWorkbenchPart();
        int animationTime = this.calcAnimationTime(mapping, settings, workbenchPart != null && !workbenchPart.getSite().getPage().isPartVisible(workbenchPart));
        mapping.setProperty(ANIMATION_TIME, (Object)animationTime);
        Object layoutGraphObj = mapping.getParentElement();
        if (zoomToFit && layoutGraphObj instanceof EditPart) {
            double oldScale;
            float desiredHeight;
            double scaleY;
            DiagramEditPart diagramEditPart = GmfDiagramLayoutConnector.getDiagramEditPart((EditPart)layoutGraphObj);
            if (diagramEditPart == null) {
                this.applyLayout(mapping, animationTime);
                return;
            }
            ZoomManager zoomManager = ((RenderedDiagramRootEditPart)diagramEditPart.getRoot()).getZoomManager();
            KNode parentNode = mapping.getLayoutGraph();
            KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
            Dimension available = zoomManager.getViewport().getClientArea().getSize();
            float desiredWidth = parentLayout.getWidth();
            double scaleX = Math.min((double)((float)available.width / desiredWidth), zoomManager.getMaxZoom());
            double scale = Math.min(scaleX, scaleY = Math.min((double)((float)available.height / (desiredHeight = parentLayout.getHeight())), zoomManager.getMaxZoom()));
            if (scale < (oldScale = zoomManager.getZoom())) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
            this.applyLayout(mapping, animationTime);
            if (scale > oldScale) {
                zoomManager.setViewLocation(new Point(0, 0));
                zoomManager.setZoom(scale);
                zoomManager.setViewLocation(new Point(0, 0));
            }
        } else {
            this.applyLayout(mapping, animationTime);
        }
    }

    protected int calcAnimationTime(LayoutMapping mapping, IPropertyHolder settings, boolean viewerNotVisible) {
        boolean animate = (Boolean)settings.getProperty(CoreOptions.ANIMATE);
        if (animate) {
            int factor;
            int maxTime;
            int minTime = (Integer)settings.getProperty(CoreOptions.MIN_ANIM_TIME);
            if (minTime < 0) {
                minTime = 0;
            }
            if ((maxTime = ((Integer)settings.getProperty(CoreOptions.MAX_ANIM_TIME)).intValue()) < minTime) {
                maxTime = minTime;
            }
            if ((factor = ((Integer)settings.getProperty(CoreOptions.ANIM_TIME_FACTOR)).intValue()) > 0) {
                int graphSize = GmfDiagramLayoutConnector.countNodes(mapping.getLayoutGraph());
                int time = minTime + (int)((double)factor * Math.sqrt(graphSize));
                return time <= maxTime ? time : maxTime;
            }
            return minTime;
        }
        return 0;
    }

    protected static int countNodes(KNode node) {
        int count = 0;
        for (KNode child : node.getChildren()) {
            count += GmfDiagramLayoutConnector.countNodes(child) + 1;
        }
        return count;
    }

    protected void applyLayout(LayoutMapping mapping, int animationTime) {
        this.transferLayout(mapping);
        if (animationTime > 0) {
            Animation.markBegin();
            this.applyLayout(mapping);
            Animation.run((int)animationTime);
        } else {
            this.applyLayout(mapping);
        }
    }

    protected void transferLayout(LayoutMapping mapping) {
        DiagramEditPart diagramEditPart;
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            applyLayoutRequest.addElement((KGraphElement)entry.getKey(), (GraphicalEditPart)((IGraphicalEditPart)entry.getValue()));
        }
        KShapeLayout graphLayout = (KShapeLayout)mapping.getLayoutGraph().getData(KShapeLayout.class);
        applyLayoutRequest.setUpperBound(graphLayout.getWidth(), graphLayout.getHeight());
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            GmfDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
        if (((InternalTransactionalEditingDomain)(diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART)).getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    protected static void addOffset(KNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (KNode child : parentNode.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)child.getData(KShapeLayout.class);
            minx = Math.min(minx, (double)nodeLayout.getXpos());
            miny = Math.min(miny, (double)nodeLayout.getYpos());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((KNode)parentNode, (float)((float)offset.x), (float)((float)offset.y));
    }

    protected void applyLayout(LayoutMapping mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        if (applyLayoutCommand != null) {
            CommandStack commandStack = (CommandStack)mapping.getProperty(COMMAND_STACK);
            IWorkbenchPart workbenchPart = mapping.getWorkbenchPart();
            if (commandStack == null) {
                Object adapter;
                if (workbenchPart != null && (adapter = workbenchPart.getAdapter(CommandStack.class)) instanceof CommandStack) {
                    commandStack = (CommandStack)adapter;
                }
                if (commandStack == null) {
                    IGraphicalEditPart parentElement = (IGraphicalEditPart)mapping.getParentElement();
                    commandStack = parentElement.getDiagramEditDomain().getDiagramCommandStack();
                }
            }
            commandStack.execute(applyLayoutCommand);
            DiagramEditor diagramEditor = this.getDiagramEditor(workbenchPart);
            if (diagramEditor != null) {
                GmfDiagramLayoutConnector.refreshDiagram(diagramEditor, (IGraphicalEditPart)mapping.getParentElement());
            }
        }
    }

    protected void buildLayoutGraphRecursively(LayoutMapping mapping, IGraphicalEditPart parentEditPart, KNode parentLayoutNode, IGraphicalEditPart currentEditPart) {
        Maybe kinsets = new Maybe();
        for (Object obj : currentEditPart.getChildren()) {
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                AbstractBorderItemEditPart borderItem = (AbstractBorderItemEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)borderItem)) continue;
                this.createPort(mapping, borderItem, parentEditPart, parentLayoutNode);
                continue;
            }
            if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)compartment)) continue;
                boolean compExp = true;
                IFigure compartmentFigure = compartment.getFigure();
                if (compartmentFigure instanceof ResizableCompartmentFigure) {
                    ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                    compExp = resizCompFigure.isExpanded();
                }
                if (!compExp) continue;
                this.buildLayoutGraphRecursively(mapping, parentEditPart, parentLayoutNode, (IGraphicalEditPart)compartment);
                continue;
            }
            if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)childNodeEditPart)) continue;
                KNode node = this.createNode(mapping, childNodeEditPart, parentEditPart, parentLayoutNode, (Maybe<KInsets>)kinsets);
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)childNodeEditPart, node, (IGraphicalEditPart)childNodeEditPart);
                continue;
            }
            if (!(obj instanceof IGraphicalEditPart)) continue;
            this.createNodeLabel(mapping, (IGraphicalEditPart)obj, parentEditPart, parentLayoutNode);
        }
    }

    protected KNode createNode(LayoutMapping mapping, ShapeNodeEditPart nodeEditPart, IGraphicalEditPart parentEditPart, KNode parentKNode, Maybe<KInsets> kinsets) {
        IFigure nodeFigure = nodeEditPart.getFigure();
        KNode childLayoutNode = ElkUtil.createInitializedNode();
        Rectangle childBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeFigure);
        Rectangle containerBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeFigure.getParent());
        KShapeLayout nodeLayout = (KShapeLayout)childLayoutNode.getData(KShapeLayout.class);
        nodeLayout.setXpos((float)(childBounds.x - containerBounds.x));
        nodeLayout.setYpos((float)(childBounds.y - containerBounds.y));
        nodeLayout.setSize((float)childBounds.width, (float)childBounds.height);
        ((KShapeLayoutImpl)nodeLayout).resetModificationFlag();
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            nodeLayout.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)minSize.width, (double)minSize.height));
        }
        catch (SWTException sWTException) {}
        if (parentKNode != null) {
            if (kinsets.get() == null) {
                KInsets ki = ((KShapeLayout)parentKNode.getData(KShapeLayout.class)).getInsets();
                Insets insets = this.calcSpecificInsets(parentEditPart.getFigure(), nodeFigure);
                ki.setLeft((float)insets.left);
                ki.setTop((float)insets.top);
                ki.setRight((float)insets.right);
                ki.setBottom((float)insets.bottom);
                kinsets.set((Object)ki);
            }
            parentKNode.getChildren().add((Object)childLayoutNode);
        }
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)nodeEditPart);
        return childLayoutNode;
    }

    protected Insets calcSpecificInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    protected KPort createPort(LayoutMapping mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, KNode knode) {
        KPort port = ElkUtil.createInitializedPort();
        port.setNode(knode);
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        Rectangle portBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
        float xpos = portBounds.x - nodeBounds.x;
        float ypos = portBounds.y - nodeBounds.y;
        portLayout.setPos(xpos, ypos);
        portLayout.setSize((float)portBounds.width, (float)portBounds.height);
        ((KShapeLayoutImpl)portLayout).resetModificationFlag();
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IFigure labelFigure = ((IGraphicalEditPart)portChildObj).getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            }
            if (text == null) continue;
            KLabel portLabel = ElkUtil.createInitializedLabel((KLabeledGraphElement)port);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, (Object)((IGraphicalEditPart)portChildObj));
            KShapeLayout labelLayout = (KShapeLayout)portLabel.getData(KShapeLayout.class);
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            labelLayout.setXpos((float)(labelBounds.x - portBounds.x));
            labelLayout.setYpos((float)(labelBounds.y - portBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                labelLayout.setWidth((float)size.width);
                labelLayout.setHeight((float)size.height);
            }
            catch (SWTException sWTException) {}
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
        }
        return port;
    }

    protected KLabel createNodeLabel(LayoutMapping mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, KNode knode) {
        Label label;
        IFigure labelFigure = labelEditPart.getFigure();
        String text = null;
        Font font = null;
        if (labelFigure instanceof WrappingLabel) {
            WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
            text = wrappingLabel.getText();
            font = wrappingLabel.getFont();
        } else if (labelFigure instanceof Label) {
            label = (Label)labelFigure;
            text = label.getText();
            font = label.getFont();
        }
        if (text != null) {
            label = ElkUtil.createInitializedLabel((KLabeledGraphElement)knode);
            label.setText(text);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            Rectangle nodeBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
            labelLayout.setXpos((float)(labelBounds.x - nodeBounds.x));
            labelLayout.setYpos((float)(labelBounds.y - nodeBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                labelLayout.setSize((float)size.width, (float)size.height);
                if (font != null && !font.isDisposed()) {
                    labelLayout.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    labelLayout.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
            }
            catch (SWTException sWTException) {}
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
            return label;
        }
        return null;
    }

    protected void addConnections(LayoutMapping mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            ConnectionEditPart connectionEditPart;
            if (!(targetConn instanceof ConnectionEditPart) || !this.editPartFilter.filter((EditPart)(connectionEditPart = (ConnectionEditPart)targetConn))) continue;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping mapping) {
        HashMap<EReference, KEdge> reference2EdgeMap = new HashMap<EReference, KEdge>();
        for (ConnectionEditPart connection : (List)mapping.getProperty(CONNECTIONS)) {
            KGraphElement targetElem;
            KGraphElement sourceElem;
            KEdge edge;
            boolean isOppositeEdge = false;
            EdgeLabelPlacement edgeLabelPlacement = EdgeLabelPlacement.UNDEFINED;
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (KEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = EdgeLabelPlacement.TAIL;
                    isOppositeEdge = true;
                } else {
                    edge = ElkUtil.createInitializedEdge();
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = ElkUtil.createInitializedEdge();
            }
            BiMap inverseGraphMap = mapping.getGraphMap().inverse();
            EditPart sourceObj = connection.getSource();
            if (sourceObj instanceof ConnectionEditPart) {
                sourceElem = (KGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getSource());
                if (sourceElem == null) {
                    sourceElem = (KGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getTarget());
                }
            } else {
                sourceElem = (KGraphElement)inverseGraphMap.get((Object)sourceObj);
            }
            KNode sourceNode = null;
            KPort sourcePort = null;
            if (sourceElem instanceof KNode) {
                sourceNode = (KNode)sourceElem;
            } else {
                if (!(sourceElem instanceof KPort)) continue;
                sourcePort = (KPort)sourceElem;
                sourceNode = sourcePort.getNode();
            }
            EditPart targetObj = connection.getTarget();
            if (targetObj instanceof ConnectionEditPart) {
                targetElem = (KGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getTarget());
                if (targetElem == null) {
                    targetElem = (KGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getSource());
                }
            } else {
                targetElem = (KGraphElement)inverseGraphMap.get((Object)targetObj);
            }
            KNode targetNode = null;
            KPort targetPort = null;
            if (targetElem instanceof KNode) {
                targetNode = (KNode)targetElem;
            } else {
                if (!(targetElem instanceof KPort)) continue;
                targetPort = (KPort)targetElem;
                targetNode = targetPort.getNode();
            }
            KVector offset = new KVector();
            if (ElkUtil.isDescendant((KNode)targetNode, (KNode)sourceNode)) {
                ElkUtil.toAbsolute((KVector)offset, (KNode)sourceNode);
            } else {
                ElkUtil.toAbsolute((KVector)offset, (KNode)sourceNode.getParent());
            }
            if (!isOppositeEdge) {
                edge.setSource(sourceNode);
                if (sourcePort != null) {
                    edge.setSourcePort(sourcePort);
                }
                edge.setTarget(targetNode);
                if (targetPort != null) {
                    edge.setTargetPort(targetPort);
                }
                mapping.getGraphMap().put((Object)edge, (Object)connection);
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                this.setEdgeLayout(edgeLayout, connection, offset);
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset);
        }
    }

    protected void setEdgeLayout(KEdgeLayout edgeLayout, ConnectionEditPart connection, KVector offset) {
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        KPoint sourcePoint = edgeLayout.getSourcePoint();
        Point firstPoint = pointList.getPoint(0);
        sourcePoint.setX((float)firstPoint.x - (float)offset.x);
        sourcePoint.setY((float)firstPoint.y - (float)offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            KPoint kpoint = KLayoutDataFactory.eINSTANCE.createKPoint();
            kpoint.setX((float)point.x - (float)offset.x);
            kpoint.setY((float)point.y - (float)offset.y);
            edgeLayout.getBendPoints().add((Object)kpoint);
            ++i;
        }
        KPoint targetPoint = edgeLayout.getTargetPoint();
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        targetPoint.setX((float)lastPoint.x - (float)offset.x);
        targetPoint.setY((float)lastPoint.y - (float)offset.y);
        ((KEdgeLayoutImpl)edgeLayout).resetModificationFlag();
    }

    protected void processEdgeLabels(LayoutMapping mapping, ConnectionEditPart connection, KEdge edge, EdgeLabelPlacement placement, KVector offset) {
        for (Object obj : connection.getChildren()) {
            KShapeLayout labelLayout;
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = GmfDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            String labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.width = wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap();
                    iconBounds.height = wrappingLabel.getIcon().getBounds().height;
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            }
            if (labelText != null && labelText.length() > 0) {
                label = ElkUtil.createInitializedLabel((KLabeledGraphElement)edge);
                labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (placement == EdgeLabelPlacement.UNDEFINED) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            labelLayout.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            labelLayout.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            labelLayout.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    labelLayout.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement);
                }
                Font font = labelFigure.getFont();
                if (font != null && !font.isDisposed()) {
                    labelLayout.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    labelLayout.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
                labelLayout.setXpos((float)labelBounds.x - (float)offset.x);
                labelLayout.setYpos((float)labelBounds.y - (float)offset.y);
                if (iconBounds != null) {
                    labelLayout.setWidth((float)(labelBounds.width + iconBounds.width));
                } else {
                    labelLayout.setWidth((float)labelBounds.width);
                }
                labelLayout.setHeight((float)labelBounds.height);
                ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
                label.setText(labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = KGraphFactory.eINSTANCE.createKLabel();
            labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
            label.getData().add((Object)labelLayout);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    private static void refreshDiagram(DiagramEditor editor, IGraphicalEditPart rootPart) {
        IGraphicalEditPart editPart = rootPart;
        if (editPart == null) {
            editPart = editor.getDiagramEditPart();
        }
        for (Object obj : editPart.getViewer().getEditPartRegistry().values()) {
            IFigure figure;
            if (!(obj instanceof ShapeNodeEditPart) || !((figure = ((ShapeNodeEditPart)obj).getFigure()) instanceof BorderedNodeFigure)) continue;
            IFigure portContainer = ((BorderedNodeFigure)figure).getBorderItemContainer();
            portContainer.invalidate();
            portContainer.validate();
        }
    }
}

