/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.graph;

import java.io.IOException;
import org.eclipse.elk.core.RecursiveGraphLayoutEngine;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.debug.views.graph.LayoutGraphView;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.KGraphData;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.PersistentEntry;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class LoadGraphAction
extends Action {
    private static final String ACTION_ID = "org.eclipse.elk.debug.loadGraph";
    private static final String ICON_PATH = "icons/import.gif";
    private static final String LAST_FILE_NAME_PREF = "loadGraphAction.lastGraphFile";

    public LoadGraphAction() {
        this.setId(ACTION_ID);
        this.setText("Load Graph");
        this.setToolTipText("Load, layout, and display a saved ELK graph.");
        this.setImageDescriptor(ElkDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.core.debug", (String)ICON_PATH));
    }

    public void run() {
        IPreferenceStore preferenceStore = ElkDebugPlugin.getDefault().getPreferenceStore();
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.kgraph", "*.kgx", "*.kgt", "*.xmi", "*.*"});
        fileDialog.setText("Select Graph File");
        fileDialog.setFileName(preferenceStore.getString(LAST_FILE_NAME_PREF));
        String fileName = fileDialog.open();
        if (fileName != null) {
            preferenceStore.setValue(LAST_FILE_NAME_PREF, fileName);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createFileURI((String)fileName);
            Resource resource = resourceSet.createResource(uri);
            try {
                resource.load(null);
                KNode content = (KNode)resource.getContents().get(0);
                this.layout(content);
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }
    }

    private void layout(KNode graph) {
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        TreeIterator contentIter = graph.eAllContents();
        while (contentIter.hasNext()) {
            EObject obj = (EObject)contentIter.next();
            if (!(obj instanceof KGraphData)) continue;
            KGraphData graphData = (KGraphData)obj;
            for (PersistentEntry entry : graphData.getPersistentEntries()) {
                Object value;
                LayoutOptionData optionData = dataService.getOptionData(entry.getKey());
                if (optionData == null || (value = optionData.parseValue(entry.getValue())) == null) continue;
                graphData.setProperty((IProperty)optionData, value);
            }
        }
        KShapeLayout graphLayout = (KShapeLayout)graph.getData(KShapeLayout.class);
        BasicProgressMonitor monitor = new BasicProgressMonitor();
        if (graphLayout != null && !((Boolean)graphLayout.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
            RecursiveGraphLayoutEngine layoutEngine = new RecursiveGraphLayoutEngine();
            layoutEngine.layout(graph, (IElkProgressMonitor)monitor);
        }
        LayoutGraphView.updateWithGraph(graph);
    }
}

