/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import java.util.EnumSet;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.options.BoxLayouterOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.EdgeType;
import org.eclipse.elk.core.options.FixedLayouterOptions;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.RandomLayouterOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.ExclusiveBounds;
import org.eclipse.elk.core.util.nodespacing.Spacing;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class CoreOptions
implements ILayoutMetaDataProvider {
    public static final IProperty<String> ALGORITHM = new Property("org.eclipse.elk.algorithm");
    private static final Alignment ALIGNMENT_DEFAULT = Alignment.AUTOMATIC;
    public static final IProperty<Alignment> ALIGNMENT = new Property("org.eclipse.elk.alignment", (Object)ALIGNMENT_DEFAULT, null, null);
    private static final Comparable<? super Float> ASPECT_RATIO_LOWER_BOUND = ExclusiveBounds.greaterThan(0.0);
    public static final IProperty<Float> ASPECT_RATIO = new Property("org.eclipse.elk.aspectRatio", null, ASPECT_RATIO_LOWER_BOUND, null);
    public static final IProperty<KVectorChain> BEND_POINTS = new Property("org.eclipse.elk.bendPoints");
    private static final boolean DEBUG_MODE_DEFAULT = false;
    public static final IProperty<Boolean> DEBUG_MODE = new Property("org.eclipse.elk.debugMode", (Object)false, null, null);
    private static final Direction DIRECTION_DEFAULT = Direction.UNDEFINED;
    public static final IProperty<Direction> DIRECTION = new Property("org.eclipse.elk.direction", (Object)DIRECTION_DEFAULT, null, null);
    private static final EdgeRouting EDGE_ROUTING_DEFAULT = EdgeRouting.UNDEFINED;
    public static final IProperty<EdgeRouting> EDGE_ROUTING = new Property("org.eclipse.elk.edgeRouting", (Object)EDGE_ROUTING_DEFAULT, null, null);
    private static final boolean EXPAND_NODES_DEFAULT = false;
    public static final IProperty<Boolean> EXPAND_NODES = new Property("org.eclipse.elk.expandNodes", (Object)false, null, null);
    private static final HierarchyHandling HIERARCHY_HANDLING_DEFAULT = HierarchyHandling.INHERIT;
    public static final IProperty<HierarchyHandling> HIERARCHY_HANDLING = new Property("org.eclipse.elk.hierarchyHandling", (Object)HIERARCHY_HANDLING_DEFAULT, null, null);
    private static final boolean INTERACTIVE_DEFAULT = false;
    public static final IProperty<Boolean> INTERACTIVE = new Property("org.eclipse.elk.interactive", (Object)false, null, null);
    private static final boolean LAYOUT_HIERARCHY_DEFAULT = false;
    public static final IProperty<Boolean> LAYOUT_HIERARCHY = new Property("org.eclipse.elk.layoutHierarchy", (Object)false, null, null);
    private static final PortConstraints PORT_CONSTRAINTS_DEFAULT = PortConstraints.UNDEFINED;
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = new Property("org.eclipse.elk.portConstraints", (Object)PORT_CONSTRAINTS_DEFAULT, null, null);
    public static final IProperty<KVector> POSITION = new Property("org.eclipse.elk.position");
    public static final IProperty<Integer> PRIORITY = new Property("org.eclipse.elk.priority");
    public static final IProperty<Integer> RANDOM_SEED = new Property("org.eclipse.elk.randomSeed");
    public static final IProperty<Boolean> SEPARATE_CONNECTED_COMPONENTS = new Property("org.eclipse.elk.separateConnectedComponents");
    public static final IProperty<KVectorChain> JUNCTION_POINTS = new Property("org.eclipse.elk.junctionPoints");
    private static final boolean COMMENT_BOX_DEFAULT = false;
    public static final IProperty<Boolean> COMMENT_BOX = new Property("org.eclipse.elk.commentBox", (Object)false, null, null);
    private static final boolean HYPERNODE_DEFAULT = false;
    public static final IProperty<Boolean> HYPERNODE = new Property("org.eclipse.elk.hypernode", (Object)false, null, null);
    public static final IProperty<ILabelManager> LABEL_MANAGER = new Property("org.eclipse.elk.labelManager");
    private static final Spacing.Margins MARGINS_DEFAULT = new Spacing.Margins();
    public static final IProperty<Spacing.Margins> MARGINS = new Property("org.eclipse.elk.margins", (Object)MARGINS_DEFAULT, null, null);
    private static final boolean NO_LAYOUT_DEFAULT = false;
    public static final IProperty<Boolean> NO_LAYOUT = new Property("org.eclipse.elk.noLayout", (Object)false, null, null);
    private static final float SCALE_FACTOR_DEFAULT = 1.0f;
    private static final Comparable<? super Float> SCALE_FACTOR_LOWER_BOUND = ExclusiveBounds.greaterThan(0.0);
    public static final IProperty<Float> SCALE_FACTOR = new Property("org.eclipse.elk.scaleFactor", (Object)Float.valueOf(1.0f), SCALE_FACTOR_LOWER_BOUND, null);
    private static final boolean ANIMATE_DEFAULT = true;
    public static final IProperty<Boolean> ANIMATE = new Property("org.eclipse.elk.animate", (Object)true, null, null);
    private static final int ANIM_TIME_FACTOR_DEFAULT = 100;
    private static final Comparable<? super Integer> ANIM_TIME_FACTOR_LOWER_BOUND = 0;
    public static final IProperty<Integer> ANIM_TIME_FACTOR = new Property("org.eclipse.elk.animTimeFactor", (Object)100, ANIM_TIME_FACTOR_LOWER_BOUND, null);
    private static final boolean LAYOUT_ANCESTORS_DEFAULT = false;
    public static final IProperty<Boolean> LAYOUT_ANCESTORS = new Property("org.eclipse.elk.layoutAncestors", (Object)false, null, null);
    private static final int MAX_ANIM_TIME_DEFAULT = 4000;
    private static final Comparable<? super Integer> MAX_ANIM_TIME_LOWER_BOUND = 0;
    public static final IProperty<Integer> MAX_ANIM_TIME = new Property("org.eclipse.elk.maxAnimTime", (Object)4000, MAX_ANIM_TIME_LOWER_BOUND, null);
    private static final int MIN_ANIM_TIME_DEFAULT = 400;
    private static final Comparable<? super Integer> MIN_ANIM_TIME_LOWER_BOUND = 0;
    public static final IProperty<Integer> MIN_ANIM_TIME = new Property("org.eclipse.elk.minAnimTime", (Object)400, MIN_ANIM_TIME_LOWER_BOUND, null);
    private static final boolean PROGRESS_BAR_DEFAULT = false;
    public static final IProperty<Boolean> PROGRESS_BAR = new Property("org.eclipse.elk.progressBar", (Object)false, null, null);
    private static final boolean VALIDATE_OPTIONS_DEFAULT = true;
    public static final IProperty<Boolean> VALIDATE_OPTIONS = new Property("org.eclipse.elk.validateOptions", (Object)true, null, null);
    private static final boolean ZOOM_TO_FIT_DEFAULT = false;
    public static final IProperty<Boolean> ZOOM_TO_FIT = new Property("org.eclipse.elk.zoomToFit", (Object)false, null, null);
    private static final float SPACING_BORDER_DEFAULT = 12.0f;
    private static final Comparable<? super Float> SPACING_BORDER_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> SPACING_BORDER = new Property("org.eclipse.elk.spacing.border", (Object)Float.valueOf(12.0f), SPACING_BORDER_LOWER_BOUND, null);
    private static final float SPACING_LABEL_DEFAULT = 0.0f;
    private static final Comparable<? super Float> SPACING_LABEL_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> SPACING_LABEL = new Property("org.eclipse.elk.spacing.label", (Object)Float.valueOf(0.0f), SPACING_LABEL_LOWER_BOUND, null);
    private static final float SPACING_NODE_DEFAULT = 20.0f;
    private static final Comparable<? super Float> SPACING_NODE_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> SPACING_NODE = new Property("org.eclipse.elk.spacing.node", (Object)Float.valueOf(20.0f), SPACING_NODE_LOWER_BOUND, null);
    private static final float SPACING_PORT_DEFAULT = 10.0f;
    private static final Comparable<? super Float> SPACING_PORT_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> SPACING_PORT = new Property("org.eclipse.elk.spacing.port", (Object)Float.valueOf(10.0f), SPACING_PORT_LOWER_BOUND, null);
    public static final IProperty<Spacing.Margins> SPACING_PORT_SURROUNDING = new Property("org.eclipse.elk.spacing.portSurrounding");
    public static final IProperty<Integer> PARTITIONING_PARTITION = new Property("org.eclipse.elk.partitioning.partition");
    private static final Boolean PARTITIONING_ACTIVATE_DEFAULT = false;
    public static final IProperty<Boolean> PARTITIONING_ACTIVATE = new Property("org.eclipse.elk.partitioning.activate", (Object)PARTITIONING_ACTIVATE_DEFAULT, null, null);
    private static final Spacing.Insets NODE_LABELS_INSETS_DEFAULT = new Spacing.Insets(0.0, 0.0, 0.0, 0.0);
    public static final IProperty<Spacing.Insets> NODE_LABELS_INSETS = new Property("org.eclipse.elk.nodeLabels.insets", (Object)NODE_LABELS_INSETS_DEFAULT, null, null);
    private static final EnumSet<NodeLabelPlacement> NODE_LABELS_PLACEMENT_DEFAULT = NodeLabelPlacement.fixed();
    public static final IProperty<EnumSet<NodeLabelPlacement>> NODE_LABELS_PLACEMENT = new Property("org.eclipse.elk.nodeLabels.placement", NODE_LABELS_PLACEMENT_DEFAULT, null, null);
    private static final PortAlignment PORT_ALIGNMENT_BASIC_DEFAULT = PortAlignment.JUSTIFIED;
    public static final IProperty<PortAlignment> PORT_ALIGNMENT_BASIC = new Property("org.eclipse.elk.portAlignment.basic", (Object)PORT_ALIGNMENT_BASIC_DEFAULT, null, null);
    private static final PortAlignment PORT_ALIGNMENT_NORTH_DEFAULT = PortAlignment.UNDEFINED;
    public static final IProperty<PortAlignment> PORT_ALIGNMENT_NORTH = new Property("org.eclipse.elk.portAlignment.north", (Object)PORT_ALIGNMENT_NORTH_DEFAULT, null, null);
    private static final PortAlignment PORT_ALIGNMENT_SOUTH_DEFAULT = PortAlignment.UNDEFINED;
    public static final IProperty<PortAlignment> PORT_ALIGNMENT_SOUTH = new Property("org.eclipse.elk.portAlignment.south", (Object)PORT_ALIGNMENT_SOUTH_DEFAULT, null, null);
    private static final PortAlignment PORT_ALIGNMENT_WEST_DEFAULT = PortAlignment.UNDEFINED;
    public static final IProperty<PortAlignment> PORT_ALIGNMENT_WEST = new Property("org.eclipse.elk.portAlignment.west", (Object)PORT_ALIGNMENT_WEST_DEFAULT, null, null);
    private static final PortAlignment PORT_ALIGNMENT_EAST_DEFAULT = PortAlignment.UNDEFINED;
    public static final IProperty<PortAlignment> PORT_ALIGNMENT_EAST = new Property("org.eclipse.elk.portAlignment.east", (Object)PORT_ALIGNMENT_EAST_DEFAULT, null, null);
    private static final EnumSet<SizeConstraint> NODE_SIZE_CONSTRAINTS_DEFAULT = EnumSet.noneOf(SizeConstraint.class);
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = new Property("org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS_DEFAULT, null, null);
    private static final EnumSet<SizeOptions> NODE_SIZE_OPTIONS_DEFAULT = EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE, SizeOptions.APPLY_ADDITIONAL_INSETS);
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = new Property("org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS_DEFAULT, null, null);
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = new Property("org.eclipse.elk.nodeSize.minimum");
    private static final float NODE_SIZE_MIN_WIDTH_DEFAULT = 0.0f;
    private static final Comparable<? super Float> NODE_SIZE_MIN_WIDTH_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> NODE_SIZE_MIN_WIDTH = new Property("org.eclipse.elk.nodeSize.minWidth", (Object)Float.valueOf(0.0f), NODE_SIZE_MIN_WIDTH_LOWER_BOUND, null);
    private static final float NODE_SIZE_MIN_HEIGHT_DEFAULT = 0.0f;
    private static final Comparable<? super Float> NODE_SIZE_MIN_HEIGHT_LOWER_BOUND = Float.valueOf(0.0f);
    public static final IProperty<Float> NODE_SIZE_MIN_HEIGHT = new Property("org.eclipse.elk.nodeSize.minHeight", (Object)Float.valueOf(0.0f), NODE_SIZE_MIN_HEIGHT_LOWER_BOUND, null);
    private static final EdgeLabelPlacement EDGE_LABELS_PLACEMENT_DEFAULT = EdgeLabelPlacement.UNDEFINED;
    public static final IProperty<EdgeLabelPlacement> EDGE_LABELS_PLACEMENT = new Property("org.eclipse.elk.edgeLabels.placement", (Object)EDGE_LABELS_PLACEMENT_DEFAULT, null, null);
    public static final IProperty<String> FONT_NAME = new Property("org.eclipse.elk.font.name");
    private static final Comparable<? super Integer> FONT_SIZE_LOWER_BOUND = 1;
    public static final IProperty<Integer> FONT_SIZE = new Property("org.eclipse.elk.font.size", null, FONT_SIZE_LOWER_BOUND, null);
    public static final IProperty<KVector> PORT_ANCHOR = new Property("org.eclipse.elk.port.anchor");
    private static final Comparable<? super Integer> PORT_INDEX_LOWER_BOUND = 0;
    public static final IProperty<Integer> PORT_INDEX = new Property("org.eclipse.elk.port.index", null, PORT_INDEX_LOWER_BOUND, null);
    private static final PortSide PORT_SIDE_DEFAULT = PortSide.UNDEFINED;
    public static final IProperty<PortSide> PORT_SIDE = new Property("org.eclipse.elk.port.side", (Object)PORT_SIDE_DEFAULT, null, null);
    public static final IProperty<Float> PORT_BORDER_OFFSET = new Property("org.eclipse.elk.port.borderOffset");
    private static final PortLabelPlacement PORT_LABELS_PLACEMENT_DEFAULT = PortLabelPlacement.OUTSIDE;
    public static final IProperty<PortLabelPlacement> PORT_LABELS_PLACEMENT = new Property("org.eclipse.elk.portLabels.placement", (Object)PORT_LABELS_PLACEMENT_DEFAULT, null, null);
    private static final boolean INSIDE_SELF_LOOPS_ACTIVATE_DEFAULT = false;
    public static final IProperty<Boolean> INSIDE_SELF_LOOPS_ACTIVATE = new Property("org.eclipse.elk.insideSelfLoops.activate", (Object)false, null, null);
    private static final boolean INSIDE_SELF_LOOPS_YO_DEFAULT = false;
    public static final IProperty<Boolean> INSIDE_SELF_LOOPS_YO = new Property("org.eclipse.elk.insideSelfLoops.yo", (Object)false, null, null);
    private static final float EDGE_THICKNESS_DEFAULT = 1.0f;
    public static final IProperty<Float> EDGE_THICKNESS = new Property("org.eclipse.elk.edge.thickness", (Object)Float.valueOf(1.0f), null, null);
    private static final EdgeType EDGE_TYPE_DEFAULT = EdgeType.NONE;
    public static final IProperty<EdgeType> EDGE_TYPE = new Property("org.eclipse.elk.edge.type", (Object)EDGE_TYPE_DEFAULT, null, null);
    private static final boolean SCALE_FACTOR_DEP_LAYOUT_HIERARCHY = false;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData("org.eclipse.elk.algorithm", "", "Layout Algorithm", "Select a specific layout algorithm.", null, null, null, LayoutOptionData.Type.STRING, String.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.alignment", "", "Alignment", "Alignment of the selected node relative to other nodes, the exact meaning depends on the used algorithm.", (Object)ALIGNMENT_DEFAULT, null, null, LayoutOptionData.Type.ENUM, Alignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.animate"));
        registry.register(new LayoutOptionData("org.eclipse.elk.aspectRatio", "", "Aspect Ratio", "The desired aspect ratio of the drawing, that is the quotient of width by height.", null, ASPECT_RATIO_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.aspectRatio"));
        registry.register(new LayoutOptionData("org.eclipse.elk.bendPoints", "", "Bend Points", "A fixed list of bend points for the edge. This is used by the 'Fixed Layout' algorithm to specify a pre-defined routing for an edge. The vector chain must include the source point, any bend points, and the target point, so it must have at least two points.", null, null, null, LayoutOptionData.Type.OBJECT, KVectorChain.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.bendPoints"));
        registry.register(new LayoutOptionData("org.eclipse.elk.debugMode", "", "Debug Mode", "Whether additional debug information shall be generated.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.debugMode"));
        registry.register(new LayoutOptionData("org.eclipse.elk.direction", "", "Direction", "Overall direction of edges: horizontal (right / left) or vertical (down / up).", (Object)DIRECTION_DEFAULT, null, null, LayoutOptionData.Type.ENUM, Direction.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.direction"));
        registry.register(new LayoutOptionData("org.eclipse.elk.edgeRouting", "", "Edge Routing", "What kind of edge routing style should be applied for the content of a parent node. Algorithms may also set this option to single edges in order to mark them as splines. The bend point list of edges with this option set to SPLINES must be interpreted as control points for a piecewise cubic spline.", (Object)EDGE_ROUTING_DEFAULT, null, null, LayoutOptionData.Type.ENUM, EdgeRouting.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.edgeRouting"));
        registry.register(new LayoutOptionData("org.eclipse.elk.expandNodes", "", "Expand Nodes", "If active, nodes are expanded to fill the area of their parent.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.expandNodes"));
        registry.register(new LayoutOptionData("org.eclipse.elk.hierarchyHandling", "", "Hierarchy Handling", "Determines whether the descendants should be layouted separately or together with their parents. If the root node is set to inherit (or not set at all), the option is assumed as SEPARATE_CHILDREN.", (Object)HIERARCHY_HANDLING_DEFAULT, null, null, LayoutOptionData.Type.ENUM, HierarchyHandling.class, EnumSet.of(LayoutOptionData.Target.PARENTS, LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.hierarchyHandling"));
        registry.register(new LayoutOptionData("org.eclipse.elk.interactive", "", "Interactive", "Whether the algorithm should be run in interactive mode for the content of a parent node. What this means exactly depends on how the specific algorithm interprets this option. Usually in the interactive mode algorithms try to modify the current layout as little as possible.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.layoutHierarchy", "", "Layout Hierarchy", "Whether the whole hierarchy shall be layouted. If this option is not set, each hierarchy level of the graph is processed independently, possibly by different layout algorithms, beginning with the lowest level. If it is set, the algorithm is responsible to process all hierarchy levels that are contained in the associated parent node.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.layoutHierarchy"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portConstraints", "", "Port Constraints", "Defines constraints of the position of the ports of a node.", (Object)PORT_CONSTRAINTS_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortConstraints.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.portConstraints"));
        registry.register(new LayoutOptionData("org.eclipse.elk.position", "", "Position", "The position of a node, port, or label. This is used by the 'Fixed Layout' algorithm to specify a pre-defined position.", null, null, null, LayoutOptionData.Type.OBJECT, KVector.class, EnumSet.of(LayoutOptionData.Target.NODES, LayoutOptionData.Target.PORTS, LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.position"));
        registry.register(new LayoutOptionData("org.eclipse.elk.priority", "", "Priority", "Defines the priority of an object; its meaning depends on the specific layout algorithm and the context where it is used.", null, null, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.NODES, LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.priority"));
        registry.register(new LayoutOptionData("org.eclipse.elk.randomSeed", "", "Randomization Seed", "Seed used for pseudo-random number generators to control the layout algorithm. If the value is 0, the seed shall be determined pseudo-randomly (e.g. from the system time).", null, null, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.randomSeed"));
        registry.register(new LayoutOptionData("org.eclipse.elk.separateConnectedComponents", "", "Separate Connected Components", "Whether each connected component should be processed separately.", null, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.separateConnComp"));
        registry.register(new LayoutOptionData("org.eclipse.elk.junctionPoints", "", "Junction Points", "This option is not used as option, but as output of the layout algorithms. It is attached to edges and determines the points where junction symbols should be drawn in order to represent hyperedges with orthogonal routing. Whether such points are computed depends on the chosen layout algorithm and edge routing style. The points are put into the vector chain with no specific order.", null, null, null, LayoutOptionData.Type.OBJECT, KVectorChain.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.junctionPoints"));
        registry.register(new LayoutOptionData("org.eclipse.elk.commentBox", "", "Comment Box", "Whether the node should be regarded as a comment box instead of a regular node. In that case its placement should be similar to how labels are handled. Any edges incident to a comment box specify to which graph elements the comment is related.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.commentBox"));
        registry.register(new LayoutOptionData("org.eclipse.elk.hypernode", "", "Hypernode", "Whether the node should be handled as a hypernode.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.hypernode"));
        registry.register(new LayoutOptionData("org.eclipse.elk.labelManager", "", "Label Manager", "Label managers can shorten labels upon a layout algorithm's request.", null, null, null, LayoutOptionData.Type.OBJECT, ILabelManager.class, EnumSet.of(LayoutOptionData.Target.PARENTS, LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.HIDDEN, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.margins", "", "Margins", "Margins define additional space around the actual bounds of a graph element. For instance, ports or labels being placed on the outside of a node's border might introduce such a margin. The margin is used to guarantee non-overlap of other graph elements with those ports or labels.", MARGINS_DEFAULT, null, null, LayoutOptionData.Type.OBJECT, Spacing.Margins.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.margins"));
        registry.register(new LayoutOptionData("org.eclipse.elk.noLayout", "", "No Layout", "No layout is done for the associated element. This is used to mark parts of a diagram to avoid their inclusion in the layout graph, or to mark parts of the layout graph to prevent layout engines from processing them. If you wish to exclude the contents of a compound node from automatic layout, while the node itself is still considered on its own layer, use the 'Fixed Layout' algorithm for that node.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.NODES, LayoutOptionData.Target.EDGES, LayoutOptionData.Target.PORTS, LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.HIDDEN, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.scaleFactor", "", "Scale Factor", "The scaling factor to be applied to the corresponding node in recursive layout. It causes the corresponding node's size to be adjusted, and its ports and labels to be sized and placed accordingly after the layout of that node has been determined (and before the node itself and its siblings are arranged). The scaling is not reverted afterwards, so the resulting layout graph contains the adjusted size and position data. This option is currently not supported if 'Layout Hierarchy' is set.", Float.valueOf(1.0f), SCALE_FACTOR_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.scaleFactor"));
        registry.addDependency("org.eclipse.elk.scaleFactor", "org.eclipse.elk.layoutHierarchy", false);
        registry.register(new LayoutOptionData("org.eclipse.elk.animate", "", "Animate", "Whether the shift from the old layout to the new computed layout shall be animated.", true, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.animate"));
        registry.register(new LayoutOptionData("org.eclipse.elk.animTimeFactor", "", "Animation Time Factor", "Factor for computation of animation time. The higher the value, the longer the animation time. If the value is 0, the resulting time is always equal to the minimum defined by 'Minimal Animation Time'.", 100, ANIM_TIME_FACTOR_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.animTimeFactor"));
        registry.register(new LayoutOptionData("org.eclipse.elk.layoutAncestors", "", "Layout Ancestors", "Whether the hierarchy levels on the path from the selected element to the root of the diagram shall be included in the layout process.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.layoutAncestors"));
        registry.register(new LayoutOptionData("org.eclipse.elk.maxAnimTime", "", "Maximal Animation Time", "The maximal time for animations, in milliseconds.", 4000, MAX_ANIM_TIME_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.maxAnimTime"));
        registry.register(new LayoutOptionData("org.eclipse.elk.minAnimTime", "", "Minimal Animation Time", "The minimal time for animations, in milliseconds.", 400, MIN_ANIM_TIME_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.minAnimTime"));
        registry.register(new LayoutOptionData("org.eclipse.elk.progressBar", "", "Progress Bar", "Whether a progress bar shall be displayed during layout computations.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.progressBar"));
        registry.register(new LayoutOptionData("org.eclipse.elk.validateOptions", "", "Validate Options", "Whether layout options shall be validated before any layout algorithm is applied. If this option is enabled and at least one error is found, the layout process is aborted and a message is shown to the user.", true, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.zoomToFit", "", "Zoom to Fit", "Whether the zoom level shall be set to view the whole diagram after layout.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.zoomToFit"));
        registry.register(new LayoutOptionData("org.eclipse.elk.spacing.border", "spacing", "Border Spacing", "Spacing of the content of a parent node to its inner border. The inner border is the node border, which is given by width and height, with subtracted insets.", Float.valueOf(12.0f), SPACING_BORDER_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.borderSpacing"));
        registry.register(new LayoutOptionData("org.eclipse.elk.spacing.label", "spacing", "Label Spacing", "Determines the amount of space to be left around labels.", Float.valueOf(0.0f), SPACING_LABEL_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.EDGES, LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.labelSpacing"));
        registry.register(new LayoutOptionData("org.eclipse.elk.spacing.node", "spacing", "Node Spacing", "Overall spacing between elements. This is mostly interpreted as the minimal distance between each two nodes and may also influence the spacing between edges.", Float.valueOf(20.0f), SPACING_NODE_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.spacing"));
        registry.register(new LayoutOptionData("org.eclipse.elk.spacing.port", "spacing", "Port Spacing", "Spacing between ports of a given node.", Float.valueOf(10.0f), SPACING_PORT_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.portSpacing"));
        registry.register(new LayoutOptionData("org.eclipse.elk.spacing.portSurrounding", "spacing", "Additional Port Space", "Additional space around the sets of ports on each node side. For each side of a node, this option can reserve additional space before and after the ports on each side. For example, a top spacing of 20 makes sure that the first port on the western and eastern side is 20 units away from the northern border.", null, null, null, LayoutOptionData.Type.OBJECT, Spacing.Margins.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.partitioning.partition", "partitioning", "Layout Partition", "Partition to which the node belongs to. If 'layoutPartitions' is true, all nodes are expected to have a partition.", null, null, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS, LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.partition"));
        registry.register(new LayoutOptionData("org.eclipse.elk.partitioning.activate", "partitioning", "Layout Partitioning", "Whether to activate partitioned layout.", PARTITIONING_ACTIVATE_DEFAULT, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.layoutPartitions"));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeLabels.insets", "nodeLabels", "Node Label Insets", "Define insets for node labels that are placed inside of a node.", NODE_LABELS_INSETS_DEFAULT, null, null, LayoutOptionData.Type.OBJECT, Spacing.Insets.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.nodeLabelInset"));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeLabels.placement", "nodeLabels", "Node Label Placement", "Hints for where node labels are to be placed; if empty, the node label's position is not modified.", NODE_LABELS_PLACEMENT_DEFAULT, null, null, LayoutOptionData.Type.ENUMSET, NodeLabelPlacement.class, EnumSet.of(LayoutOptionData.Target.NODES, LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.nodeLabelPlacement"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portAlignment.basic", "portAlignment", "Port Alignment", "Defines the default port distribution for a node. May be overridden for each side individually.", (Object)PORT_ALIGNMENT_BASIC_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortAlignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, "de.cau.cs.kieler.portAlignment"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portAlignment.north", "portAlignment", "Port Alignment (North)", "Defines how ports on the northern side are placed, overriding the node's general port alignment.", (Object)PORT_ALIGNMENT_NORTH_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortAlignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.portAlignment.north"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portAlignment.south", "portAlignment", "Port Alignment (South)", "Defines how ports on the southern side are placed, overriding the node's general port alignment.", (Object)PORT_ALIGNMENT_SOUTH_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortAlignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.portAlignment.south"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portAlignment.west", "portAlignment", "Port Alignment (West)", "Defines how ports on the western side are placed, overriding the node's general port alignment.", (Object)PORT_ALIGNMENT_WEST_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortAlignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.portAlignment.west"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portAlignment.east", "portAlignment", "Port Alignment (East)", "Defines how ports on the eastern side are placed, overriding the node's general port alignment.", (Object)PORT_ALIGNMENT_EAST_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortAlignment.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, "de.cau.cs.kieler.portAlignment.east"));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeSize.constraints", "nodeSize", "Node Size Constraints", "Constraints for determining node sizes. Each member of the set specifies something that should be taken into account when calculating node sizes. The empty set corresponds to node sizes being fixed.", NODE_SIZE_CONSTRAINTS_DEFAULT, null, null, LayoutOptionData.Type.ENUMSET, SizeConstraint.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeSize.options", "nodeSize", "Node Size Options", "Options modifying the behavior of the size constraints set on a node. Each member of the set specifies something that should be taken into account when calculating node sizes. The empty set corresponds to no further modifications.", NODE_SIZE_OPTIONS_DEFAULT, null, null, LayoutOptionData.Type.ENUMSET, SizeOptions.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeSize.minimum", "nodeSize", "Node Size Minimum", "The minimal size to which a node can be reduced.", null, null, null, LayoutOptionData.Type.OBJECT, KVector.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeSize.minWidth", "nodeSize", "Minimum Width", null, Float.valueOf(0.0f), NODE_SIZE_MIN_WIDTH_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.nodeSize.minHeight", "nodeSize", "Minimum Height", null, Float.valueOf(0.0f), NODE_SIZE_MIN_HEIGHT_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.edgeLabels.placement", "edgeLabels", "Edge Label Placement", "Gives a hint on where to put edge labels.", (Object)EDGE_LABELS_PLACEMENT_DEFAULT, null, null, LayoutOptionData.Type.ENUM, EdgeLabelPlacement.class, EnumSet.of(LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.edgeLabelPlacement"));
        registry.register(new LayoutOptionData("org.eclipse.elk.font.name", "font", "Font Name", "Font name used for a label.", null, null, null, LayoutOptionData.Type.STRING, String.class, EnumSet.of(LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.fontName"));
        registry.register(new LayoutOptionData("org.eclipse.elk.font.size", "font", "Font Size", "Font size used for a label.", null, FONT_SIZE_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.LABELS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.fontSize"));
        registry.register(new LayoutOptionData("org.eclipse.elk.port.anchor", "port", "Port Anchor Offset", "The offset to the port position where connections shall be attached.", null, null, null, LayoutOptionData.Type.OBJECT, KVector.class, EnumSet.of(LayoutOptionData.Target.PORTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.portAnchor"));
        registry.register(new LayoutOptionData("org.eclipse.elk.port.index", "port", "Port Index", "The index of a port in the fixed order around a node. The order is assumed as clockwise, starting with the leftmost port on the top side. This option must be set if 'Port Constraints' is set to FIXED_ORDER and no specific positions are given for the ports. Additionally, the option 'Port Side' must be defined in this case.", null, PORT_INDEX_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PORTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.portIndex"));
        registry.register(new LayoutOptionData("org.eclipse.elk.port.side", "port", "Port Side", "The side of a node on which a port is situated. This option must be set if 'Port Constraints' is set to FIXED_SIDE or FIXED_ORDER and no specific positions are given for the ports.", (Object)PORT_SIDE_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortSide.class, EnumSet.of(LayoutOptionData.Target.PORTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.portSide"));
        registry.register(new LayoutOptionData("org.eclipse.elk.port.borderOffset", "port", "Port Border Offset", "The offset of ports on the node border. With a positive offset the port is moved outside of the node, while with a negative offset the port is moved towards the inside. An offset of 0 means that the port is placed directly on the node border, i.e. if the port side is north, the port's south border touches the nodes's north border; if the port side is east, the port's west border touches the nodes's east border; if the port side is south, the port's north border touches the node's south border; if the port side is west, the port's east border touches the node's west border.", null, null, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PORTS), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.offset"));
        registry.register(new LayoutOptionData("org.eclipse.elk.portLabels.placement", "portLabels", "Port Label Placement", "Decides on a placement method for port labels.", (Object)PORT_LABELS_PLACEMENT_DEFAULT, null, null, LayoutOptionData.Type.ENUM, PortLabelPlacement.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.portLabelPlacement"));
        registry.register(new LayoutOptionData("org.eclipse.elk.insideSelfLoops.activate", "insideSelfLoops", "Activate Inside Self Loops", "Whether this node allows to route self loops inside of it instead of around it. If set to true, this will make the node a compound node if it isn't already, and will require the layout algorithm to support compound nodes with hierarchical ports.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.selfLoopInside"));
        registry.register(new LayoutOptionData("org.eclipse.elk.insideSelfLoops.yo", "insideSelfLoops", "Inside Self Loop", "Whether a self loop should be routed inside a node instead of around that node.", false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.selfLoopInside"));
        registry.register(new LayoutOptionData("org.eclipse.elk.edge.thickness", "edge", "Edge Thickness", "The thickness of an edge. This is a hint on the line width used to draw an edge, possibly requiring more space to be reserved for it.", Float.valueOf(1.0f), null, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.thickness"));
        registry.register(new LayoutOptionData("org.eclipse.elk.edge.type", "edge", "Edge Type", "The type of an edge. This is usually used for UML class diagrams, where associations must be handled differently from generalizations.", (Object)EDGE_TYPE_DEFAULT, null, null, LayoutOptionData.Type.ENUM, EdgeType.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.HIDDEN, "de.cau.cs.kieler.edgeType"));
        registry.register(new LayoutCategoryData("org.eclipse.elk.layered", "Layered", "The layer-based method was introduced by Sugiyama, Tagawa and Toda in 1981. It emphasizes the direction of edges by pointing as many edges as possible into the same direction. The nodes are arranged in layers, which are sometimes called \"hierarchies\", and then reordered such that the number of edge crossings is minimized. Afterwards, concrete coordinates are computed for the nodes and edge bend points."));
        registry.register(new LayoutCategoryData("org.eclipse.elk.orthogonal", "Orthogonal", "Orthogonal methods that follow the \"topology-shape-metrics\" approach by Batini, Nardelli and Tamassia '86. The first phase determines the topology of the drawing by applying a planarization technique, which results in a planar representation of the graph. The orthogonal shape is computed in the second phase, which aims at minimizing the number of edge bends, and is called orthogonalization. The third phase leads to concrete coordinates for nodes and edge bend points by applying a compaction method, thus defining the metrics."));
        registry.register(new LayoutCategoryData("org.eclipse.elk.force", "Force", "Layout algorithms that follow physical analogies by simulating a system of attractive and repulsive forces. The first successful method of this kind was proposed by Eades in 1984."));
        registry.register(new LayoutCategoryData("org.eclipse.elk.circle", "Circle", "Circular layout algorithms emphasize cycles or biconnected components of a graph by arranging them in circles. This is useful if a drawing is desired where such components are clearly grouped, or where cycles are shown as prominent OPTIONS of the graph."));
        registry.register(new LayoutCategoryData("org.eclipse.elk.tree", "Tree", "Specialized layout methods for trees, i.e. acyclic graphs. The regular structure of graphs that have no undirected cycles can be emphasized using an algorithm of this type."));
        registry.register(new LayoutCategoryData("org.eclipse.elk.planar", "Planar", "Algorithms that require a planar or upward planar graph. Most of these algorithms are theoretically interesting, but not practically usable."));
        new FixedLayouterOptions().apply(registry);
        new BoxLayouterOptions().apply(registry);
        new RandomLayouterOptions().apply(registry);
    }
}

