/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.awt.geom.Rectangle2D;
import org.eclipse.elk.core.comments.AbstractNormalizedHeuristic;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.ShapeLayoutBoundsProvider;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KNode;

public final class AlignmentHeuristic
extends AbstractNormalizedHeuristic {
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private static final int TOP = 2;
    private static final int LEFT = 1;
    private static final int RIGHT = 4;
    private static final int BOTTOM = 8;
    private static final int TOP_LEFT = 3;
    private static final int BOTTOM_LEFT = 9;
    private static final int TOP_RIGHT = 6;
    private static final int BOTTOM_RIGHT = 12;

    public AlignmentHeuristic withMaximumAlignmentOffset(double offset) {
        if (offset <= 0.0) {
            throw new IllegalArgumentException("Maximum alignment offset must be > 0.");
        }
        super.withBounds(offset, 0.0);
        return this;
    }

    public AlignmentHeuristic withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    @Override
    public AlignmentHeuristic withNormalizationFunction(AbstractNormalizedHeuristic.NormalizationFunction normalizationFunction) {
        super.withNormalizationFunction(normalizationFunction);
        return this;
    }

    @Override
    public double raw(KNode comment, KGraphElement element) {
        if (element instanceof KNode) {
            Rectangle2D.Double nodeBounds;
            KNode node = (KNode)element;
            Rectangle2D.Double commentBounds = this.boundsProvider.boundsFor(comment);
            double alignment = AlignmentHeuristic.alignment(commentBounds, nodeBounds = this.boundsProvider.boundsFor(node));
            return alignment == -1.0 ? this.getWorstRawValue() : alignment;
        }
        return this.getWorstRawValue();
    }

    public static double alignment(Rectangle2D.Double bounds1, Rectangle2D.Double bounds2) {
        int topLeftOutcode = bounds2.outcode(bounds1.x, bounds1.y);
        int bottomRightOutcode = bounds2.outcode(bounds1.x + bounds1.width, bounds1.y + bounds1.height);
        if ((bottomRightOutcode & topLeftOutcode & 3) == 3 || (bottomRightOutcode & topLeftOutcode & 6) == 6 || (bottomRightOutcode & topLeftOutcode & 9) == 9 || (bottomRightOutcode & topLeftOutcode & 0xC) == 12) {
            return -1.0;
        }
        double horizontalAlignmentOffset = Math.min(Math.abs(bounds2.x - bounds1.x), Math.abs(bounds2.x + bounds2.width - bounds1.x - bounds1.width));
        double verticalAlignmentOffset = Math.min(Math.abs(bounds2.y - bounds1.y), Math.abs(bounds2.y + bounds2.height - bounds1.y - bounds1.height));
        if (bounds2.intersects(bounds1)) {
            return Math.min(horizontalAlignmentOffset, verticalAlignmentOffset);
        }
        if ((bottomRightOutcode & 2) != 0 || (topLeftOutcode & 8) != 0) {
            return horizontalAlignmentOffset;
        }
        if ((bottomRightOutcode & 1) != 0 || (topLeftOutcode & 4) != 0) {
            return verticalAlignmentOffset;
        }
        if (bounds1.y == bounds2.y + bounds2.height || bounds1.y + bounds1.height == bounds2.y) {
            return horizontalAlignmentOffset;
        }
        if (bounds1.x == bounds2.x + bounds2.width || bounds1.x + bounds1.width == bounds2.x) {
            return verticalAlignmentOffset;
        }
        return -1.0;
    }
}

