/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.util.Random;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KLayoutDataFactory;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KNode;

public class RandomLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "org.eclipse.elk.alg.random";
    private static final float DEF_ASPECT_RATIO = 1.6f;
    private static final float DEF_SPACING = 15.0f;
    private static final int MAX_BENDS = 5;
    private static final float RAND_FACT = 0.2f;

    @Override
    public void layout(KNode parentNode, IElkProgressMonitor progressMonitor) {
        Float offset;
        Float spacing;
        progressMonitor.begin("Random Layout", 1.0f);
        if (parentNode.getChildren().isEmpty()) {
            progressMonitor.done();
            return;
        }
        KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
        Integer randomSeed = (Integer)parentLayout.getProperty(CoreOptions.RANDOM_SEED);
        Random random = randomSeed != null && randomSeed != 0 ? new Random(randomSeed.intValue()) : new Random();
        Float aspectRatio = (Float)parentLayout.getProperty(CoreOptions.ASPECT_RATIO);
        if (aspectRatio == null || aspectRatio.floatValue() <= 0.0f) {
            aspectRatio = Float.valueOf(1.6f);
        }
        if ((spacing = (Float)parentLayout.getProperty(CoreOptions.SPACING_NODE)) == null || spacing.floatValue() < 0.0f) {
            spacing = Float.valueOf(15.0f);
        }
        if ((offset = (Float)parentLayout.getProperty(CoreOptions.SPACING_BORDER)) == null || offset.floatValue() < 0.0f) {
            offset = Float.valueOf(15.0f);
        }
        this.randomize(parentNode, random, aspectRatio.floatValue(), spacing.floatValue(), offset.floatValue());
        progressMonitor.done();
    }

    private void randomize(KNode parent, Random random, float aspectRatio, float spacing, float offset) {
        float nodesArea = 0.0f;
        float maxWidth = 0.0f;
        float maxHeight = 0.0f;
        int m = 1;
        for (KNode node : parent.getChildren()) {
            m += node.getOutgoingEdges().size();
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            float width = nodeLayout.getWidth();
            maxWidth = Math.max(maxWidth, width);
            float height = nodeLayout.getHeight();
            maxHeight = Math.max(maxHeight, height);
            nodesArea += width * height;
        }
        int n = parent.getChildren().size();
        float drawArea = nodesArea + 2.0f * spacing * spacing * (float)m * (float)n;
        float areaSqrt = (float)Math.sqrt(drawArea);
        float drawWidth = Math.max(areaSqrt * aspectRatio, maxWidth);
        float drawHeight = Math.max(areaSqrt / aspectRatio, maxHeight);
        for (KNode node : parent.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            float x = offset + random.nextFloat() * (drawWidth - nodeLayout.getWidth());
            float y = offset + random.nextFloat() * (drawHeight - nodeLayout.getHeight());
            nodeLayout.setPos(x, y);
        }
        float totalWidth = drawWidth + 2.0f * offset;
        float totalHeight = drawHeight + 2.0f * offset;
        for (KNode source : parent.getChildren()) {
            for (KEdge edge : source.getOutgoingEdges()) {
                KNode target = edge.getTarget();
                if (source.getParent() != target.getParent()) continue;
                this.randomize(edge, source, target, random, totalWidth, totalHeight);
            }
        }
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        KInsets insets = parentLayout.getInsets();
        ElkUtil.resizeNode(parent, totalWidth += insets.getLeft() + insets.getRight(), totalHeight += insets.getTop() + insets.getBottom(), false, true);
    }

    private void randomize(KEdge edge, KNode source, KNode target, Random random, float drawWidth, float drawHeight) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KShapeLayout sourceLayout = (KShapeLayout)source.getData(KShapeLayout.class);
        float sourceX = sourceLayout.getXpos();
        float sourceY = sourceLayout.getYpos();
        float sourceWidth = sourceLayout.getWidth() / 2.0f;
        float sourceHeight = sourceLayout.getHeight() / 2.0f;
        if (edge.getSourcePort() != null) {
            KShapeLayout portLayout = (KShapeLayout)edge.getSourcePort().getData(KShapeLayout.class);
            sourceWidth = portLayout.getWidth() / 2.0f;
            sourceHeight = portLayout.getHeight() / 2.0f;
            sourceX += portLayout.getXpos();
            sourceY += portLayout.getYpos();
        }
        sourceX += sourceWidth;
        sourceY += sourceHeight;
        KShapeLayout targetLayout = (KShapeLayout)target.getData(KShapeLayout.class);
        float targetX = targetLayout.getXpos();
        float targetY = targetLayout.getYpos();
        float targetWidth = targetLayout.getWidth() / 2.0f;
        float targetHeight = targetLayout.getHeight() / 2.0f;
        if (edge.getTargetPort() != null) {
            KShapeLayout portLayout = (KShapeLayout)edge.getTargetPort().getData(KShapeLayout.class);
            targetWidth = portLayout.getWidth() / 2.0f;
            targetHeight = portLayout.getHeight() / 2.0f;
            targetX += portLayout.getXpos();
            targetY += portLayout.getYpos();
        }
        targetY += targetHeight;
        float sourcePX = targetX += targetWidth;
        if (targetX > sourceX + sourceWidth) {
            sourcePX = sourceX + sourceWidth;
        } else if (targetX < sourceX - sourceWidth) {
            sourcePX = sourceX - sourceWidth;
        }
        float sourcePY = targetY;
        if (targetY > sourceY + sourceHeight) {
            sourcePY = sourceY + sourceHeight;
        } else if (targetY < sourceY - sourceHeight) {
            sourcePY = sourceY - sourceHeight;
        }
        if (sourcePX > sourceX - sourceWidth && sourcePX < sourceX + sourceWidth && sourcePY > sourceY - sourceHeight && sourcePY < sourceY + sourceHeight) {
            sourcePX = sourceX + sourceWidth;
        }
        KPoint sourcePoint = edgeLayout.getSourcePoint();
        sourcePoint.setPos(sourcePX, sourcePY);
        float targetPX = sourceX;
        if (sourceX > targetX + targetWidth) {
            targetPX = targetX + targetWidth;
        } else if (sourceX < targetX - targetWidth) {
            targetPX = targetX - targetWidth;
        }
        float targetPY = sourceY;
        if (sourceY > targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        } else if (sourceY < targetY - targetHeight) {
            targetPY = targetY - targetHeight;
        }
        if (targetPX > targetX - targetWidth && targetPX < targetX + targetWidth && targetPY > targetY - targetHeight && targetPY < targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        }
        KPoint targetPoint = edgeLayout.getTargetPoint();
        targetPoint.setPos(targetPX, targetPY);
        edgeLayout.getBendPoints().clear();
        int bendsNum = random.nextInt(5);
        if (source == target) {
            ++bendsNum;
        }
        float xdiff = targetPX - sourcePX;
        float ydiff = targetPY - sourcePY;
        float totalDist = (float)Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        float maxRand = totalDist * 0.2f;
        float xincr = xdiff / (float)(bendsNum + 1);
        float yincr = ydiff / (float)(bendsNum + 1);
        float x = sourcePX;
        float y = sourcePY;
        int i = 0;
        while (i < bendsNum) {
            x += xincr;
            y += yincr;
            float randx = x + random.nextFloat() * maxRand - maxRand / 2.0f;
            if (randx < 0.0f) {
                randx = 1.0f;
            } else if (randx > drawWidth) {
                randx = drawWidth - 1.0f;
            }
            float randy = y + random.nextFloat() * maxRand - maxRand / 2.0f;
            if (randy < 0.0f) {
                randy = 1.0f;
            } else if (randy > drawHeight) {
                randy = drawHeight - 1.0f;
            }
            KPoint bendPoint = KLayoutDataFactory.eINSTANCE.createKPoint();
            bendPoint.setX(randx);
            bendPoint.setY(randy);
            edgeLayout.getBendPoints().add((Object)bendPoint);
            ++i;
        }
    }
}

