/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.force.graph.FBendpoint;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.alg.force.properties.InternalProperties;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class ComponentsProcessor {
    public List<FGraph> split(FGraph graph) {
        Boolean separate = (Boolean)graph.getProperty(ForceOptions.SEPARATE_CONNECTED_COMPONENTS);
        if (separate == null || separate.booleanValue()) {
            boolean[] visited = new boolean[graph.getNodes().size()];
            List<FEdge>[] incidence = this.buildIncidenceLists(graph);
            LinkedList<FGraph> components = new LinkedList<FGraph>();
            for (FNode node : graph.getNodes()) {
                FGraph comp = this.dfs(node, null, visited, incidence);
                if (comp == null) continue;
                comp.copyProperties((IPropertyHolder)graph);
                components.add(comp);
            }
            if (components.size() > 1) {
                for (FGraph comp : components) {
                    int id = 0;
                    for (FNode node : comp.getNodes()) {
                        node.id = id++;
                    }
                }
            }
            return components;
        }
        return Lists.newArrayList((Object[])new FGraph[]{graph});
    }

    private List<FEdge>[] buildIncidenceLists(FGraph graph) {
        int n = graph.getNodes().size();
        List[] incidence = new List[n];
        for (FNode node : graph.getNodes()) {
            incidence[node.id] = new LinkedList();
        }
        for (FEdge edge : graph.getEdges()) {
            incidence[edge.getSource().id].add(edge);
            incidence[edge.getTarget().id].add(edge);
        }
        return incidence;
    }

    private FGraph dfs(FNode node, FGraph graph, boolean[] visited, List<FEdge>[] incidence) {
        if (!visited[node.id]) {
            visited[node.id] = true;
            FGraph component = graph;
            if (component == null) {
                component = new FGraph();
            }
            component.getNodes().add(node);
            for (FEdge edge : incidence[node.id]) {
                if (edge.getSource() != node) {
                    this.dfs(edge.getSource(), component, visited, incidence);
                }
                if (edge.getTarget() != node) {
                    this.dfs(edge.getTarget(), component, visited, incidence);
                }
                component.getEdges().add(edge);
                component.getLabels().addAll(edge.getLabels());
            }
            return component;
        }
        return null;
    }

    public FGraph recombine(List<FGraph> components) {
        if (components.size() == 1) {
            return components.get(0);
        }
        if (components.size() <= 0) {
            return new FGraph();
        }
        for (FGraph graph : components) {
            int priority = 0;
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            double maxx = -2.147483648E9;
            double maxy = -2.147483648E9;
            for (FNode node : graph.getNodes()) {
                priority += ((Integer)node.getProperty(ForceOptions.PRIORITY)).intValue();
                minx = Math.min(minx, node.getPosition().x);
                miny = Math.min(miny, node.getPosition().y);
                maxx = Math.max(maxx, node.getPosition().x + node.getSize().x);
                maxy = Math.max(maxy, node.getPosition().y + node.getSize().y);
            }
            graph.setProperty(ForceOptions.PRIORITY, priority);
            graph.setProperty(InternalProperties.BB_UPLEFT, new KVector(minx, miny));
            graph.setProperty(InternalProperties.BB_LOWRIGHT, new KVector(maxx, maxy));
        }
        Collections.sort(components, new Comparator<FGraph>(){

            @Override
            public int compare(FGraph graph1, FGraph graph2) {
                int prio = (Integer)graph2.getProperty(ForceOptions.PRIORITY) - (Integer)graph1.getProperty(ForceOptions.PRIORITY);
                if (prio == 0) {
                    KVector size1 = ((KVector)graph1.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph1.getProperty(InternalProperties.BB_UPLEFT));
                    KVector size2 = ((KVector)graph2.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph2.getProperty(InternalProperties.BB_UPLEFT));
                    return Double.compare(size1.x * size1.y, size2.x * size2.y);
                }
                return prio;
            }
        });
        FGraph result = new FGraph();
        result.copyProperties((IPropertyHolder)components.get(0));
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (FGraph graph : components) {
            KVector size = ((KVector)graph.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph.getProperty(InternalProperties.BB_UPLEFT));
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)result.getProperty(ForceOptions.ASPECT_RATIO)).floatValue()));
        double spacing = ((Float)result.getProperty(ForceOptions.SPACING_NODE)).doubleValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (FGraph graph : components) {
            KVector size = ((KVector)graph.getProperty(InternalProperties.BB_LOWRIGHT)).clone().sub((KVector)graph.getProperty(InternalProperties.BB_UPLEFT));
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.moveGraph(result, graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        return result;
    }

    private void moveGraph(FGraph destGraph, FGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        graphOffset.sub((KVector)sourceGraph.getProperty(InternalProperties.BB_UPLEFT));
        for (FNode node : sourceGraph.getNodes()) {
            node.getPosition().add(graphOffset);
            destGraph.getNodes().add(node);
        }
        for (FEdge edge : sourceGraph.getEdges()) {
            for (FBendpoint bendpoint : edge.getBendpoints()) {
                bendpoint.getPosition().add(graphOffset);
            }
            destGraph.getEdges().add(edge);
        }
        for (FLabel label : sourceGraph.getLabels()) {
            label.getPosition().add(graphOffset);
            destGraph.getLabels().add(label);
        }
    }
}

