/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LInsets;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;

public final class LGraph
extends LGraphElement
implements Iterable<Layer> {
    private static final long serialVersionUID = -8006835373897072852L;
    private final KVector size = new KVector();
    private final LInsets insets = new LInsets(0.0, 0.0, 0.0, 0.0);
    private final KVector offset = new KVector();
    private final List<LNode> layerlessNodes = Lists.newArrayList();
    private final List<Layer> layers = Lists.newArrayList();

    public String toString() {
        if (this.layers.isEmpty()) {
            return "G-unlayered" + this.layerlessNodes.toString();
        }
        if (this.layerlessNodes.isEmpty()) {
            return "G-layered" + this.layers.toString();
        }
        return "G[layerless" + this.layerlessNodes.toString() + ", layers" + this.layers.toString() + "]";
    }

    public KVector getSize() {
        return this.size;
    }

    public KVector getActualSize() {
        float borderSpacing = ((Float)this.getProperty(LayeredOptions.SPACING_BORDER)).floatValue();
        return new KVector(this.size.x + this.insets.left + this.insets.right + (double)(2.0f * borderSpacing), this.size.y + this.insets.top + this.insets.bottom + (double)(2.0f * borderSpacing));
    }

    public LInsets getInsets() {
        return this.insets;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public List<LNode> getLayerlessNodes() {
        return this.layerlessNodes;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    public LNode[][] toNodeArray() {
        LNode[][] lgraphArray = new LNode[this.layers.size()][];
        ListIterator<Layer> layerIter = this.layers.listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            lgraphArray[layerIndex] = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
        }
        return lgraphArray;
    }
}

