/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.GraphIssue;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.ui.LayoutOptionLabelProvider;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.ui.views.AlgorithmCellEditor;
import org.eclipse.elk.core.ui.views.LayoutPropertySource;
import org.eclipse.elk.core.ui.views.MultipleOptionsCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class LayoutPropertyDescriptor
implements IPropertyDescriptor {
    private final LayoutPropertySource source;
    private final LayoutOptionData optionData;
    private final Set<LayoutOptionData.Target> elementTargets;
    private LayoutOptionLabelProvider labelProvider;

    public LayoutPropertyDescriptor(LayoutPropertySource source, LayoutOptionData theoptionData, Set<LayoutOptionData.Target> theelementTargets) {
        this.source = source;
        this.optionData = theoptionData;
        this.elementTargets = theelementTargets;
    }

    public LayoutOptionData getOptionData() {
        return this.optionData;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        switch (this.optionData.getType()) {
            case STRING: {
                if (CoreOptions.ALGORITHM.equals(this.optionData)) {
                    return new AlgorithmCellEditor(parent);
                }
                return new TextCellEditor(parent);
            }
            case INT: {
                TextCellEditor intEditor = new TextCellEditor(parent);
                intEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            int i = Integer.parseInt((String)value);
                            List<GraphIssue> issues = LayoutPropertyDescriptor.this.source.validatePropertyValue(LayoutPropertyDescriptor.this.optionData, i);
                            if (issues != null && !issues.isEmpty()) {
                                return issues.get(0).getMessage();
                            }
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return Messages.getString("kiml.ui.6");
                        }
                    }
                });
                return intEditor;
            }
            case FLOAT: {
                TextCellEditor floatEditor = new TextCellEditor(parent);
                floatEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            float f = Float.parseFloat((String)value);
                            List<GraphIssue> issues = LayoutPropertyDescriptor.this.source.validatePropertyValue(LayoutPropertyDescriptor.this.optionData, Float.valueOf(f));
                            if (issues != null && !issues.isEmpty()) {
                                return issues.get(0).getMessage();
                            }
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return Messages.getString("kiml.ui.7");
                        }
                    }
                });
                return floatEditor;
            }
            case BOOLEAN: 
            case ENUM: {
                return new ComboBoxCellEditor(parent, this.optionData.getChoices(), 8);
            }
            case ENUMSET: {
                return new MultipleOptionsCellEditor(parent, this.optionData.getChoices());
            }
            case OBJECT: {
                return new TextCellEditor(parent);
            }
        }
        return null;
    }

    public String getCategory() {
        EnumSet targets = EnumSet.copyOf(this.optionData.getTargets());
        if (this.elementTargets != null) {
            targets.retainAll(this.elementTargets);
        }
        if (targets.size() == 1) {
            switch ((LayoutOptionData.Target)targets.iterator().next()) {
                case PARENTS: {
                    if (this.elementTargets != null && this.elementTargets.contains(LayoutOptionData.Target.NODES)) {
                        return Messages.getString("kiml.ui.74");
                    }
                    return Messages.getString("kiml.ui.73");
                }
                case NODES: {
                    return Messages.getString("kiml.ui.75");
                }
                case EDGES: {
                    return Messages.getString("kiml.ui.76");
                }
                case PORTS: {
                    return Messages.getString("kiml.ui.77");
                }
                case LABELS: {
                    return Messages.getString("kiml.ui.78");
                }
            }
        }
        return null;
    }

    public String getDescription() {
        String description = this.optionData.getDescription();
        int firstPeriodIndex = description.indexOf(46);
        if (firstPeriodIndex > 0) {
            return description.substring(0, firstPeriodIndex + 1);
        }
        return description;
    }

    public String getLongDescription() {
        return this.optionData.getDescription();
    }

    public String getDisplayName() {
        return this.optionData.getName();
    }

    public String[] getFilterFlags() {
        if (this.optionData.getVisibility() == LayoutOptionData.Visibility.ADVANCED) {
            return new String[]{"org.eclipse.ui.views.properties.expert"};
        }
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.optionData.getId();
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LayoutOptionLabelProvider(this.optionData);
        }
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return anotherProperty instanceof LayoutPropertyDescriptor && this.optionData.getId().equals(anotherProperty.getId());
    }
}

