/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.transform;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeType;
import org.eclipse.elk.alg.graphviz.dot.dot.DotFactory;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.EdgeTarget;
import org.eclipse.elk.alg.graphviz.dot.dot.Graph;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphType;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Node;
import org.eclipse.elk.alg.graphviz.dot.dot.NodeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.dot.Subgraph;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KLayoutDataFactory;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphData;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.common.util.EList;

public class DotExporter {
    public static final float DEF_SPACING_SMALL = 20.0f;
    public static final float DEF_SPACING_LARGE = 40.0f;
    public static final float DEF_SPACING_XLARGE = 60.0f;
    public static final float DPI = 72.0f;
    public static final IProperty<Command> COMMAND = new Property("dotExporter.command", (Object)Command.DOT);
    public static final IProperty<Boolean> USE_EDGE_IDS = new Property("dotExporter.useEdgeIds", (Object)false);
    public static final IProperty<Boolean> HIERARCHY = new Property("dotExporter.hierarchy", (Object)false);
    public static final IProperty<Boolean> TRANSFORM_NODE_LAYOUT = new Property("dotExporter.transformNodeLayout", (Object)true);
    public static final IProperty<Boolean> TRANSFORM_EDGE_LAYOUT = new Property("dotExporter.transformEdgeLayout", (Object)true);
    public static final IProperty<Boolean> TRANSFORM_NODE_LABELS = new Property("dotExporter.transformNodeLabels", (Object)true);
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = new Property("dotExporter.adaptPortPositions", (Object)false);
    public static final IProperty<Float> BORDER_SPACING = new Property("dotExporter.borderSpacing", (Object)Float.valueOf(10.0f));
    private static final double FONT_SIZE_MULT = 1.4;
    private static final String ATTRIBUTE_DELIM = "\", \t\n\r";
    private static final IProperty<BiMap<String, KGraphElement>> GRAPH_ELEMS = new Property("dotExporter.graphElemMap");
    protected static final IProperty<Boolean> USE_SPLINES = new Property("dotExporter.useSplines", (Object)false);
    private static final IProperty<Integer> NEXT_NODE_ID = new Property("dotExporter.nextNodeId", (Object)1);
    private static final IProperty<Integer> NEXT_EDGE_ID = new Property("dotExporter.nextEdgeId", (Object)1);
    private static final IProperty<String> CLUSTER_DUMMY = new Property("dotExporter.clusterDummy");
    private static final char MIN_OUT_CHAR = ' ';
    private static final char MAX_OUT_CHAR = '~';

    public void transform(IDotTransformationData<KNode, GraphvizModel> transData) {
        HashBiMap graphElems = HashBiMap.create();
        transData.setProperty(GRAPH_ELEMS, graphElems);
        KNode kgraph = transData.getSourceGraph();
        GraphvizModel graphvizModel = DotFactory.eINSTANCE.createGraphvizModel();
        Graph graph = DotFactory.eINSTANCE.createGraph();
        graph.setType(GraphType.DIGRAPH);
        graphvizModel.getGraphs().add((Object)graph);
        this.transformNodes(kgraph, (List<Statement>)graph.getStatements(), new KVector(), transData);
        this.transformEdges(kgraph, (List<Statement>)graph.getStatements(), transData);
        transData.getTargetGraphs().add(graphvizModel);
    }

    public void transferLayout(IDotTransformationData<KNode, GraphvizModel> transData) {
        float borderSpacing = ((Float)transData.getProperty(BORDER_SPACING)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = 10.0f;
            transData.setProperty(BORDER_SPACING, Float.valueOf(borderSpacing));
        }
        Graph graph = (Graph)transData.getTargetGraphs().get(0).getGraphs().get(0);
        KVector baseOffset = new KVector();
        this.applyLayout(transData.getSourceGraph(), (List<Statement>)graph.getStatements(), baseOffset, borderSpacing, transData);
        LinkedList<Statement> statements = new LinkedList<Statement>((Collection<Statement>)graph.getStatements());
        KVector edgeOffset = baseOffset.add((double)borderSpacing, (double)borderSpacing);
        while (!statements.isEmpty()) {
            Statement statement = statements.removeFirst();
            if (statement instanceof EdgeStatement) {
                this.applyEdgeLayout((EdgeStatement)statement, edgeOffset, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            statements.addAll((Collection<Statement>)((Subgraph)statement).getStatements());
        }
    }

    private void transformNodes(KNode parent, List<Statement> statements, KVector offset, IDotTransformationData<KNode, GraphvizModel> transData) {
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        this.setGraphAttributes(statements, (KGraphData)parentLayout, transData);
        boolean hierarchy = (Boolean)transData.getProperty(HIERARCHY);
        boolean transformNodeLayout = (Boolean)transData.getProperty(TRANSFORM_NODE_LAYOUT);
        boolean transformNodeLabels = (Boolean)transData.getProperty(TRANSFORM_NODE_LABELS);
        for (KNode childNode : parent.getChildren()) {
            String nodeID;
            KShapeLayout nodeLayout = (KShapeLayout)childNode.getData(KShapeLayout.class);
            NodeStatement nodeStatement = DotFactory.eINSTANCE.createNodeStatement();
            EList<Attribute> attributes = nodeStatement.getAttributes();
            if (hierarchy && !childNode.getChildren().isEmpty()) {
                String clusterNodeID = this.getNodeID(childNode, NodeType.CLUSTER, transData);
                Subgraph subgraph = DotFactory.eINSTANCE.createSubgraph();
                subgraph.setName(clusterNodeID);
                statements.add(subgraph);
                double subgraphx = nodeLayout.getXpos() + nodeLayout.getInsets().getLeft();
                double subgraphy = nodeLayout.getYpos() + nodeLayout.getInsets().getTop();
                this.transformNodes(childNode, (List<Statement>)subgraph.getStatements(), new KVector(offset).add(subgraphx, subgraphy), transData);
                nodeID = this.getNodeID(childNode, NodeType.DUMMY, transData);
                attributes.add(DotExporter.createAttribute("style", "invis"));
                attributes.add(DotExporter.createAttribute("width", 0));
                attributes.add(DotExporter.createAttribute("height", 0));
                subgraph.getStatements().add((Object)nodeStatement);
            } else {
                nodeID = this.getNodeID(childNode, NodeType.NODE, transData);
                ElkUtil.resizeNode((KNode)childNode);
                if (nodeLayout.getWidth() > 0.0f) {
                    attributes.add(DotExporter.createAttribute("width", nodeLayout.getWidth() / 72.0f));
                }
                if (nodeLayout.getHeight() > 0.0f) {
                    attributes.add(DotExporter.createAttribute("height", nodeLayout.getHeight() / 72.0f));
                }
                if (transformNodeLabels && !childNode.getLabels().isEmpty() && ((KLabel)childNode.getLabels().get(0)).getText().length() > 0) {
                    attributes.add(DotExporter.createAttribute("label", DotExporter.createString(((KLabel)childNode.getLabels().get(0)).getText())));
                }
                if (transformNodeLayout && (nodeLayout.getXpos() != 0.0f || nodeLayout.getYpos() != 0.0f)) {
                    double xpos = (double)(nodeLayout.getXpos() + nodeLayout.getWidth() / 2.0f) + offset.x;
                    double ypos = (double)(nodeLayout.getYpos() + nodeLayout.getHeight() / 2.0f) + offset.y;
                    String posString = "\"" + Double.toString(xpos) + "," + Double.toString(ypos) + "\"";
                    attributes.add(DotExporter.createAttribute("pos", posString));
                }
                statements.add(nodeStatement);
            }
            Node node = DotFactory.eINSTANCE.createNode();
            node.setName(nodeID);
            nodeStatement.setNode(node);
        }
    }

    private void transformEdges(KNode parent, List<Statement> statements, IDotTransformationData<KNode, GraphvizModel> transData) {
        boolean hierarchy = (Boolean)transData.getProperty(HIERARCHY);
        boolean transformEdgeLayout = (Boolean)transData.getProperty(TRANSFORM_EDGE_LAYOUT);
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        Direction direction = (Direction)parentLayout.getProperty(CoreOptions.DIRECTION);
        boolean vertical = direction == Direction.DOWN || direction == Direction.UP || direction == Direction.UNDEFINED;
        LinkedList nodes = new LinkedList(parent.getChildren());
        BiMap nodeIds = ((BiMap)transData.getProperty(GRAPH_ELEMS)).inverse();
        while (!nodes.isEmpty()) {
            KNode source = (KNode)nodes.removeFirst();
            for (KEdge edge : source.getOutgoingEdges()) {
                KNode target = edge.getTarget();
                if (source.getParent() != target.getParent() && (!hierarchy || !this.isInsideGraph(target, transData.getSourceGraph()))) continue;
                EdgeStatement edgeStatement = DotFactory.eINSTANCE.createEdgeStatement();
                EList<Attribute> attributes = edgeStatement.getAttributes();
                Node sourceNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !source.getChildren().isEmpty()) {
                    sourceNode.setName((String)((KShapeLayout)source.getData(KShapeLayout.class)).getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("ltail", (String)nodeIds.get((Object)source)));
                } else {
                    sourceNode.setName((String)nodeIds.get((Object)source));
                }
                edgeStatement.setSourceNode(sourceNode);
                EdgeTarget edgeTarget = DotFactory.eINSTANCE.createEdgeTarget();
                Node targetNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !target.getChildren().isEmpty()) {
                    targetNode.setName((String)((KShapeLayout)target.getData(KShapeLayout.class)).getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("lhead", (String)nodeIds.get((Object)target)));
                } else {
                    targetNode.setName((String)nodeIds.get((Object)target));
                }
                edgeTarget.setTargetnode(targetNode);
                edgeStatement.getEdgeTargets().add((Object)edgeTarget);
                this.setEdgeLabels(edge, (List<Attribute>)attributes, vertical);
                if (((Boolean)transData.getProperty(USE_EDGE_IDS)).booleanValue()) {
                    String edgeID = this.getEdgeID(edge, transData);
                    attributes.add(DotExporter.createAttribute("comment", "\"" + edgeID + "\""));
                }
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                KPoint targetPoint = edgeLayout.getTargetPoint();
                if (transformEdgeLayout && (edgeLayout.getBendPoints().size() > 0 || sourcePoint.getX() != 0.0f || sourcePoint.getY() != 0.0f || targetPoint.getX() != 0.0f || targetPoint.getY() != 0.0f)) {
                    KNode referenceNode = source;
                    if (!ElkUtil.isDescendant((KNode)target, (KNode)source)) {
                        referenceNode = source.getParent();
                    }
                    StringBuilder pos = new StringBuilder();
                    Iterator pointIter = edgeLayout.createVectorChain().iterator();
                    while (pointIter.hasNext()) {
                        KVector point = (KVector)pointIter.next();
                        ElkUtil.toAbsolute((KVector)point, (KNode)referenceNode);
                        pos.append(point.x);
                        pos.append(",");
                        pos.append(point.y);
                        if (!pointIter.hasNext()) continue;
                        pos.append(" ");
                    }
                    attributes.add(DotExporter.createAttribute("pos", "\"" + pos + "\""));
                }
                statements.add(edgeStatement);
            }
            if (!hierarchy) continue;
            nodes.addAll(source.getChildren());
        }
    }

    private boolean isInsideGraph(KNode node, KNode root) {
        KNode n = node;
        do {
            if (n != root) continue;
            return true;
        } while ((n = n.getParent()) != null);
        return false;
    }

    protected void setGraphAttributes(List<Statement> statements, KGraphData parentLayout, IDotTransformationData<KNode, GraphvizModel> transData) {
    }

    protected List<Attribute> setGeneralNodeAttributes(List<Statement> statements) {
        AttributeStatement nodeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        nodeAttrStatement.setType(AttributeType.NODE);
        EList<Attribute> nodeAttrs = nodeAttrStatement.getAttributes();
        statements.add(nodeAttrStatement);
        nodeAttrs.add(DotExporter.createAttribute("shape", "box"));
        nodeAttrs.add(DotExporter.createAttribute("fixedsize", "true"));
        return nodeAttrs;
    }

    protected List<Attribute> setGeneralEdgeAttributes(List<Statement> statements) {
        AttributeStatement edgeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        edgeAttrStatement.setType(AttributeType.EDGE);
        EList<Attribute> edgeAttrs = edgeAttrStatement.getAttributes();
        statements.add(edgeAttrStatement);
        edgeAttrs.add(DotExporter.createAttribute("dir", "none"));
        return edgeAttrs;
    }

    public static Attribute createAttribute(String name, String value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue(value);
        return attribute;
    }

    public static Attribute createAttribute(String name, int value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    public static Attribute createAttribute(String name, float value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    protected void setEdgeLabels(KEdge kedge, List<Attribute> attributes, boolean isVertical) {
        if (kedge.getLabels().isEmpty()) {
            return;
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        StringBuilder midLabel = new StringBuilder();
        StringBuilder headLabel = new StringBuilder();
        StringBuilder tailLabel = new StringBuilder();
        String fontName = null;
        int fontSize = 0;
        boolean isCenterFontName = false;
        boolean isCenterFontSize = false;
        for (KLabel label : kedge.getLabels()) {
            StringBuilder buffer = midLabel;
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            EdgeLabelPlacement placement = (EdgeLabelPlacement)labelLayout.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            boolean takeFontName = false;
            boolean takeFontSize = false;
            switch (placement) {
                case HEAD: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = headLabel;
                    break;
                }
                case TAIL: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = tailLabel;
                    break;
                }
                default: {
                    takeFontName = fontName == null || !isCenterFontName;
                    isCenterFontName = true;
                    takeFontSize = fontSize <= 0 || !isCenterFontSize;
                    isCenterFontSize = true;
                }
            }
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(label.getText());
            if (takeFontName) {
                fontName = (String)labelLayout.getProperty(CoreOptions.FONT_NAME);
            }
            if (!takeFontSize || (fontSize = ((Integer)labelLayout.getProperty(CoreOptions.FONT_SIZE)).intValue()) <= 0) continue;
            fontSize = (int)((double)fontSize * 1.4);
        }
        if (midLabel.length() > 0) {
            float labelSpacing = ((Float)edgeLayout.getProperty(CoreOptions.SPACING_LABEL)).floatValue();
            if (labelSpacing < 1.0f) {
                labelSpacing = 0.0f;
            }
            int charsToAdd = (int)labelSpacing - 1;
            int i = 0;
            while (i < charsToAdd) {
                midLabel.append(isVertical ? "O" : "\nO");
                ++i;
            }
            attributes.add(DotExporter.createAttribute("label", DotExporter.createString(midLabel.toString())));
        }
        if (headLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("headlabel", DotExporter.createString(headLabel.toString())));
        }
        if (tailLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("taillabel", DotExporter.createString(tailLabel.toString())));
        }
        if (fontName != null && fontName.length() > 0) {
            attributes.add(DotExporter.createAttribute("fontname", "\"" + fontName + "\""));
        }
        if (fontSize > 0) {
            attributes.add(DotExporter.createAttribute("fontsize", fontSize));
        }
    }

    private static String createString(String label) {
        StringBuilder escapeBuffer = new StringBuilder(label.length() + 2);
        escapeBuffer.append("\"");
        int i = 0;
        while (i < label.length()) {
            char c = label.charAt(i);
            if (c == '\"' || c == '\\' || c > '~') {
                escapeBuffer.append('_');
            } else if (c == '\n') {
                escapeBuffer.append("\\n");
            } else if (c >= ' ') {
                escapeBuffer.append(c);
            }
            ++i;
        }
        escapeBuffer.append('\"');
        return escapeBuffer.toString();
    }

    private String getNodeID(KNode node, NodeType type, IDotTransformationData<KNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_NODE_ID);
        transData.setProperty(NEXT_NODE_ID, id + 1);
        String idstring = null;
        switch (type) {
            case NODE: {
                idstring = "node" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case CLUSTER: {
                idstring = "cluster" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case DUMMY: {
                idstring = "dummy" + id;
                ((KShapeLayout)node.getData(KShapeLayout.class)).setProperty(CLUSTER_DUMMY, (Object)idstring);
            }
        }
        return idstring;
    }

    private String getEdgeID(KEdge edge, IDotTransformationData<KNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_EDGE_ID);
        transData.setProperty(NEXT_EDGE_ID, id + 1);
        String idstring = "edge" + id;
        ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)edge);
        return idstring;
    }

    private void applyLayout(KNode parentNode, List<Statement> statements, KVector baseOffset, float borderSpacing, IDotTransformationData<KNode, GraphvizModel> transData) {
        float spacing = borderSpacing;
        KVector nodeOffset = new KVector();
        block3: for (Statement statement : statements) {
            AttributeStatement attributeStatement;
            if (!(statement instanceof AttributeStatement) || (attributeStatement = (AttributeStatement)statement).getType() != AttributeType.GRAPH) continue;
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!attribute.getName().equals("bb")) continue;
                try {
                    StringTokenizer tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    double leftx = Double.parseDouble(tokenizer.nextToken());
                    double bottomy = Double.parseDouble(tokenizer.nextToken());
                    double rightx = Double.parseDouble(tokenizer.nextToken());
                    double topy = Double.parseDouble(tokenizer.nextToken());
                    KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
                    KInsets insets = parentLayout.getInsets();
                    float width = (float)(rightx - leftx) + insets.getLeft() + insets.getRight();
                    float height = (float)(bottomy - topy) + insets.getTop() + insets.getBottom();
                    if (parentNode == transData.getSourceGraph()) {
                        width += 2.0f * spacing;
                        height += 2.0f * spacing;
                        baseOffset.add(-leftx, -topy);
                    } else {
                        parentLayout.setXpos((float)(baseOffset.x + leftx - (double)insets.getLeft() + (double)spacing));
                        parentLayout.setYpos((float)(baseOffset.y + topy - (double)insets.getTop() + (double)spacing));
                        spacing = 0.0f;
                        nodeOffset.x = -(baseOffset.x + leftx);
                        nodeOffset.y = -(baseOffset.y + topy);
                    }
                    ElkUtil.resizeNode((KNode)parentNode, (float)width, (float)height, (boolean)false, (boolean)true);
                    parentLayout.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        for (Statement statement : statements) {
            if (statement instanceof NodeStatement) {
                this.applyNodeLayout((NodeStatement)statement, nodeOffset, spacing, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            Subgraph subgraph = (Subgraph)statement;
            KNode knode = (KNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)subgraph.getName());
            this.applyLayout(knode, (List<Statement>)subgraph.getStatements(), baseOffset, spacing, transData);
            KShapeLayout subGraphLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            subGraphLayout.setXpos(subGraphLayout.getXpos() + (float)nodeOffset.x);
            subGraphLayout.setYpos(subGraphLayout.getYpos() + (float)nodeOffset.y);
        }
    }

    private void applyNodeLayout(NodeStatement nodeStatement, KVector offset, float spacing, IDotTransformationData<KNode, GraphvizModel> transData) {
        KNode knode = (KNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)nodeStatement.getNode().getName());
        if (knode == null) {
            return;
        }
        KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        float xpos = 0.0f;
        float ypos = 0.0f;
        float width = 0.0f;
        float height = 0.0f;
        for (Attribute attribute : nodeStatement.getAttributes()) {
            try {
                StringTokenizer tokenizer;
                if (attribute.getName().equals("pos")) {
                    KVector pos = new KVector();
                    pos.parse(attribute.getValue());
                    xpos = (float)(pos.x + offset.x + (double)spacing);
                    ypos = (float)(pos.y + offset.y + (double)spacing);
                    continue;
                }
                if (attribute.getName().equals("width")) {
                    tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    width = Float.parseFloat(tokenizer.nextToken()) * 72.0f;
                    continue;
                }
                if (!attribute.getName().equals("height")) continue;
                tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                height = Float.parseFloat(tokenizer.nextToken()) * 72.0f;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nodeLayout.setXpos(xpos - width / 2.0f);
        nodeLayout.setYpos(ypos - height / 2.0f);
    }

    private void applyEdgeLayout(EdgeStatement edgeStatement, KVector edgeOffset, IDotTransformationData<KNode, GraphvizModel> transData) {
        String labelPos;
        ((Float)transData.getProperty(BORDER_SPACING)).floatValue();
        Map<String, String> attributeMap = DotExporter.createAttributeMap(edgeStatement.getAttributes());
        KEdge kedge = (KEdge)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)attributeMap.get("comment"));
        if (kedge == null) {
            return;
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        EList edgePoints = edgeLayout.getBendPoints();
        edgePoints.clear();
        String posString = attributeMap.get("pos");
        if (posString == null) {
            posString = "";
        }
        KNode referenceNode = kedge.getSource();
        if (!ElkUtil.isDescendant((KNode)kedge.getTarget(), (KNode)referenceNode)) {
            referenceNode = referenceNode.getParent();
        }
        KVector reference = new KVector();
        while (referenceNode != null && referenceNode != transData.getSourceGraph()) {
            KShapeLayout nodeLayout = (KShapeLayout)referenceNode.getData(KShapeLayout.class);
            reference.x += (double)(nodeLayout.getXpos() + nodeLayout.getInsets().getLeft());
            reference.y += (double)(nodeLayout.getYpos() + nodeLayout.getInsets().getTop());
            referenceNode = referenceNode.getParent();
        }
        KVector offset = edgeOffset.clone().sub(reference);
        LinkedList<KVectorChain> splines = new LinkedList<KVectorChain>();
        Pair<KVector, KVector> endpoints = DotExporter.parseSplinePoints(posString, splines, offset);
        KVector sourcePoint = (KVector)endpoints.getFirst();
        KVector targetPoint = (KVector)endpoints.getSecond();
        if (!splines.isEmpty()) {
            KLayoutDataFactory layoutDataFactory = KLayoutDataFactory.eINSTANCE;
            if (sourcePoint == null) {
                List list = (List)splines.get(0);
                if (!list.isEmpty()) {
                    sourcePoint = (KVector)list.remove(0);
                } else {
                    KShapeLayout sourceLayout = (KShapeLayout)kedge.getSource().getData(KShapeLayout.class);
                    sourcePoint = new KVector();
                    sourcePoint.x = sourceLayout.getXpos() + sourceLayout.getWidth() / 2.0f;
                    sourcePoint.y = sourceLayout.getYpos() + sourceLayout.getHeight() / 2.0f;
                }
            }
            if (targetPoint == null) {
                List list = (List)splines.get(splines.size() - 1);
                if (!list.isEmpty()) {
                    targetPoint = (KVector)list.remove(list.size() - 1);
                } else {
                    KShapeLayout targetLayout = (KShapeLayout)kedge.getTarget().getData(KShapeLayout.class);
                    targetPoint = new KVector();
                    targetPoint.x = targetLayout.getXpos() + targetLayout.getWidth() / 2.0f;
                    targetPoint.y = targetLayout.getYpos() + targetLayout.getHeight() / 2.0f;
                }
            }
            for (KVectorChain kVectorChain : splines) {
                for (KVector point : kVectorChain) {
                    KPoint controlPoint = layoutDataFactory.createKPoint();
                    controlPoint.applyVector(point);
                    edgePoints.add(controlPoint);
                }
            }
            edgeLayout.getSourcePoint().applyVector(sourcePoint);
            edgeLayout.getTargetPoint().applyVector(targetPoint);
            boolean bl = (Boolean)transData.getProperty(ADAPT_PORT_POSITIONS);
            if (bl && (kedge.getSourcePort() != null || kedge.getTargetPort() != null)) {
                KShapeLayout portLayout;
                referenceNode = kedge.getSource();
                if (!ElkUtil.isDescendant((KNode)kedge.getTarget(), (KNode)referenceNode)) {
                    referenceNode = referenceNode.getParent();
                }
                if (kedge.getSourcePort() != null) {
                    ElkUtil.toAbsolute((KVector)sourcePoint, (KNode)referenceNode);
                    ElkUtil.toRelative((KVector)sourcePoint, (KNode)kedge.getSource().getParent());
                    portLayout = (KShapeLayout)kedge.getSourcePort().getData(KShapeLayout.class);
                    KShapeLayout sourceLayout = (KShapeLayout)kedge.getSource().getData(KShapeLayout.class);
                    portLayout.setXpos((float)sourcePoint.x - sourceLayout.getXpos() - portLayout.getWidth() / 2.0f);
                    portLayout.setYpos((float)sourcePoint.y - sourceLayout.getYpos() - portLayout.getHeight() / 2.0f);
                }
                if (kedge.getTargetPort() != null) {
                    ElkUtil.toAbsolute((KVector)targetPoint, (KNode)referenceNode);
                    ElkUtil.toRelative((KVector)targetPoint, (KNode)kedge.getTarget().getParent());
                    portLayout = (KShapeLayout)kedge.getTargetPort().getData(KShapeLayout.class);
                    KShapeLayout targetLayout = (KShapeLayout)kedge.getTarget().getData(KShapeLayout.class);
                    portLayout.setXpos((float)targetPoint.x - targetLayout.getXpos() - portLayout.getWidth() / 2.0f);
                    portLayout.setYpos((float)targetPoint.y - targetLayout.getYpos() - portLayout.getHeight() / 2.0f);
                }
            }
        }
        if (((Boolean)transData.getProperty(USE_SPLINES)).booleanValue()) {
            edgeLayout.setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
        if ((labelPos = attributeMap.get("lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.CENTER, offset);
        }
        if ((labelPos = attributeMap.get("head_lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.HEAD, offset);
        }
        if ((labelPos = attributeMap.get("tail_lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.TAIL, offset);
        }
    }

    private void applyEdgeLabelPos(KEdge kedge, String posString, EdgeLabelPlacement placement, KVector offset) {
        float combinedWidth = 0.0f;
        float combinedHeight = 0.0f;
        for (KLabel label : kedge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            EdgeLabelPlacement elp = (EdgeLabelPlacement)labelLayout.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            if (elp != placement && (elp != EdgeLabelPlacement.UNDEFINED || placement != EdgeLabelPlacement.CENTER)) continue;
            combinedWidth = Math.max(combinedWidth, labelLayout.getWidth());
            combinedHeight += labelLayout.getHeight();
        }
        try {
            KVector pos = new KVector();
            pos.parse(posString);
            float xpos = (float)(pos.x - (double)(combinedWidth / 2.0f) + offset.x);
            float ypos = (float)(pos.y - (double)(combinedHeight / 2.0f) + offset.y);
            for (KLabel label : kedge.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                EdgeLabelPlacement elp = (EdgeLabelPlacement)labelLayout.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
                if (elp != placement && (elp != EdgeLabelPlacement.UNDEFINED || placement != EdgeLabelPlacement.CENTER)) continue;
                float xoffset = (combinedWidth - labelLayout.getWidth()) / 2.0f;
                labelLayout.setXpos(xpos + xoffset);
                labelLayout.setYpos(ypos);
                ypos += labelLayout.getHeight();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private static Map<String, String> createAttributeMap(List<Attribute> attributes) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeMap.put(attribute.getName(), attribute.getValue());
        }
        return attributeMap;
    }

    private static Pair<KVector, KVector> parseSplinePoints(String posString, List<KVectorChain> splines, KVector offset) {
        KVector sourcePoint = null;
        KVector targetPoint = null;
        StringTokenizer splinesTokenizer = new StringTokenizer(posString, "\";");
        while (splinesTokenizer.hasMoreTokens()) {
            KVectorChain pointList = new KVectorChain();
            StringTokenizer posTokenizer = new StringTokenizer(splinesTokenizer.nextToken(), " \t");
            while (posTokenizer.hasMoreTokens()) {
                String token = posTokenizer.nextToken();
                try {
                    if (token.startsWith("s")) {
                        if (sourcePoint != null) continue;
                        sourcePoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        sourcePoint.parse(token.substring(commaIndex + 1));
                        sourcePoint.add(offset);
                        continue;
                    }
                    if (token.startsWith("e")) {
                        if (targetPoint != null) continue;
                        targetPoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        targetPoint.parse(token.substring(commaIndex + 1));
                        targetPoint.add(offset);
                        continue;
                    }
                    KVector point = new KVector();
                    point.parse(token);
                    pointList.add((Object)point.add(offset));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            splines.add(pointList);
        }
        return new Pair(sourcePoint, targetPoint);
    }

    private static enum NodeType {
        NODE,
        CLUSTER,
        DUMMY;

    }
}

