/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.elk.alg.graphviz.dot.dot.Attribute;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeStatement;
import org.eclipse.elk.alg.graphviz.dot.dot.AttributeType;
import org.eclipse.elk.alg.graphviz.dot.dot.DotFactory;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.dot.Statement;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.DotExporter;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.alg.graphviz.dot.transform.NeatoModel;
import org.eclipse.elk.alg.graphviz.dot.transform.OverlapMode;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphData;
import org.eclipse.elk.graph.KNode;
import org.eclipse.emf.common.util.EList;

public class LayoutDotExporter
extends DotExporter {
    private static final float NSLIMIT_BASE = 100.0f;

    public void transform(IDotTransformationData<KNode, GraphvizModel> transData) {
        KShapeLayout parentLayout = (KShapeLayout)((KNode)transData.getSourceGraph()).getData(KShapeLayout.class);
        Command command = (Command)transData.getProperty(COMMAND);
        transData.setProperty(USE_EDGE_IDS, (Object)true);
        transData.setProperty(HIERARCHY, (Object)(parentLayout.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && (command == Command.DOT || command == Command.FDP) ? 1 : 0));
        transData.setProperty(TRANSFORM_NODE_LAYOUT, (Object)((Boolean)parentLayout.getProperty(CoreOptions.INTERACTIVE)));
        transData.setProperty(TRANSFORM_EDGE_LAYOUT, (Object)false);
        transData.setProperty(TRANSFORM_NODE_LABELS, (Object)false);
        transData.setProperty(ADAPT_PORT_POSITIONS, (Object)((Boolean)parentLayout.getProperty(GraphvizMetaDataProvider.ADAPT_PORT_POSITIONS)));
        transData.setProperty(BORDER_SPACING, (Object)((Float)parentLayout.getProperty(CoreOptions.SPACING_BORDER)));
        super.transform(transData);
    }

    protected void setGraphAttributes(List<Statement> statements, KGraphData parentLayout, IDotTransformationData<KNode, GraphvizModel> transData) {
        String splineMode;
        Integer maxiter;
        Command command = (Command)transData.getProperty(COMMAND);
        AttributeStatement graphAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        graphAttrStatement.setType(AttributeType.GRAPH);
        EList graphAttrs = graphAttrStatement.getAttributes();
        statements.add((Statement)graphAttrStatement);
        this.setGeneralNodeAttributes(statements);
        List edgeAttrs = this.setGeneralEdgeAttributes(statements);
        Float spacing = (Float)parentLayout.getProperty(CoreOptions.SPACING_NODE);
        if (spacing == null || spacing.floatValue() < 0.0f) {
            switch (command) {
                case NEATO: 
                case FDP: 
                case CIRCO: {
                    spacing = Float.valueOf(40.0f);
                    break;
                }
                case TWOPI: {
                    spacing = Float.valueOf(60.0f);
                    break;
                }
                default: {
                    spacing = Float.valueOf(20.0f);
                }
            }
        }
        switch (command) {
            case DOT: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"nodesep", (float)(spacing.floatValue() / 72.0f)));
                float rankSepFactor = ((Float)parentLayout.getProperty(GraphvizMetaDataProvider.LAYER_SPACING_FACTOR)).floatValue();
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"ranksep", (float)(rankSepFactor * spacing.floatValue() / 72.0f)));
                switch ((Direction)parentLayout.getProperty(CoreOptions.DIRECTION)) {
                    case UP: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"BT"));
                        break;
                    }
                    case LEFT: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"RL"));
                        break;
                    }
                    case RIGHT: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"LR"));
                        break;
                    }
                    default: {
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"rankdir", (String)"TB"));
                    }
                }
                Float iterationsFactor = (Float)parentLayout.getProperty(GraphvizMetaDataProvider.ITERATIONS_FACTOR);
                if (iterationsFactor != null && iterationsFactor.floatValue() > 0.0f) {
                    graphAttrs.add(LayoutDotExporter.createAttribute((String)"mclimit", (float)iterationsFactor.floatValue()));
                    if (iterationsFactor.floatValue() < 1.0f) {
                        float simplexLimit = iterationsFactor.floatValue() * 100.0f;
                        graphAttrs.add(LayoutDotExporter.createAttribute((String)"nslimit", (float)simplexLimit));
                    }
                }
                if (parentLayout.getProperty(CoreOptions.HIERARCHY_HANDLING) != HierarchyHandling.INCLUDE_CHILDREN) break;
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"compound", (String)"true"));
                break;
            }
            case TWOPI: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"ranksep", (float)(spacing.floatValue() / 72.0f)));
                break;
            }
            case CIRCO: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"mindist", (float)(spacing.floatValue() / 72.0f)));
                break;
            }
            case NEATO: {
                NeatoModel model;
                edgeAttrs.add(LayoutDotExporter.createAttribute((String)"len", (float)(spacing.floatValue() / 72.0f)));
                Integer seed = (Integer)parentLayout.getProperty(CoreOptions.RANDOM_SEED);
                if (seed == null) {
                    seed = 1;
                } else if (seed == 0) {
                    seed = -1;
                } else if (seed < 0) {
                    seed = -seed.intValue();
                }
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"start", (String)("random" + seed)));
                Float epsilon = (Float)parentLayout.getProperty(GraphvizMetaDataProvider.EPSILON);
                if (epsilon != null && epsilon.floatValue() > 0.0f) {
                    graphAttrs.add(LayoutDotExporter.createAttribute((String)"epsilon", (float)epsilon.floatValue()));
                }
                if ((model = (NeatoModel)parentLayout.getProperty(GraphvizMetaDataProvider.NEATO_MODEL)) == NeatoModel.SHORTPATH) break;
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"model", (String)model.literal()));
                break;
            }
            case FDP: {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"K", (float)(spacing.floatValue() / 72.0f)));
            }
        }
        if ((command == Command.NEATO || command == Command.FDP) && (maxiter = (Integer)parentLayout.getProperty(GraphvizMetaDataProvider.MAXITER)) != null && maxiter > 0) {
            graphAttrs.add(LayoutDotExporter.createAttribute((String)"maxiter", (int)maxiter));
        }
        if (command != Command.DOT) {
            OverlapMode mode = (OverlapMode)parentLayout.getProperty(GraphvizMetaDataProvider.OVERLAP_MODE);
            if (mode != OverlapMode.NONE) {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"overlap", (String)mode.literal()));
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"sep", (String)("\"+" + Math.round(spacing.floatValue() / 2.0f) + "\"")));
            }
            Boolean pack = (Boolean)parentLayout.getProperty(CoreOptions.SEPARATE_CONNECTED_COMPONENTS);
            if (command == Command.TWOPI || pack != null && pack.booleanValue()) {
                graphAttrs.add(LayoutDotExporter.createAttribute((String)"pack", (int)spacing.intValue()));
            }
        }
        EdgeRouting edgeRouting = (EdgeRouting)parentLayout.getProperty(CoreOptions.EDGE_ROUTING);
        switch (edgeRouting) {
            case POLYLINE: {
                splineMode = "polyline";
                break;
            }
            case ORTHOGONAL: {
                splineMode = "ortho";
                break;
            }
            default: {
                splineMode = "spline";
                transData.setProperty(USE_SPLINES, (Object)true);
            }
        }
        graphAttrs.add(LayoutDotExporter.createAttribute((String)"splines", (String)splineMode));
        if (((Boolean)parentLayout.getProperty(GraphvizMetaDataProvider.CONCENTRATE)).booleanValue()) {
            graphAttrs.add(LayoutDotExporter.createAttribute((String)"concentrate", (String)"true"));
        }
    }

    protected void setEdgeLabels(KEdge kedge, List<Attribute> attributes, boolean isVertical) {
        super.setEdgeLabels(kedge, attributes, isVertical);
        if (Iterables.any((Iterable)kedge.getLabels(), label -> {
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            EdgeLabelPlacement elp = (EdgeLabelPlacement)labelLayout.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            return elp == EdgeLabelPlacement.HEAD || elp == EdgeLabelPlacement.TAIL;
        })) {
            KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            float distance = ((Float)edgeLayout.getProperty(GraphvizMetaDataProvider.LABEL_DISTANCE)).floatValue();
            if (distance >= 0.0f) {
                attributes.add(LayoutDotExporter.createAttribute((String)"labeldistance", (float)distance));
            }
            float angle = ((Float)edgeLayout.getProperty(GraphvizMetaDataProvider.LABEL_ANGLE)).floatValue();
            attributes.add(LayoutDotExporter.createAttribute((String)"labelangle", (float)angle));
        }
    }
}

