/*******************************************************************************
 * Copyright (c) 2019 Kiel University and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.elk.core.meta.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.elk.core.meta.services.MetaDataGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/*******************************************************************************
 * Copyright (c) 2016 Kiel University and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
@SuppressWarnings("all")
public class InternalMetaDataParser extends AbstractInternalAntlrParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "RULE_STRING", "RULE_ID", "RULE_HEX", "RULE_INT", "RULE_DECIMAL", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_WS", "RULE_ANY_OTHER", "'package'", "'bundle'", "'{'", "'label'", "'metadataClass'", "'documentationFolder'", "'idPrefix'", "'}'", "'group'", "'documentation'", "'deprecated'", "'advanced'", "'programmatic'", "'output'", "'global'", "'option'", "':'", "'description'", "'default'", "'='", "'lowerBound'", "'upperBound'", "'targets'", "','", "'legacyIds'", "'requires'", "'=='", "'algorithm'", "'('", "'#'", "')'", "'category'", "'preview'", "'features'", "'validator'", "'supports'", "'/'", "'-'", "'+='", "'-='", "'*='", "'/='", "'%='", "'<'", "'>'", "'>='", "'||'", "'&&'", "'!='", "'==='", "'!=='", "'instanceof'", "'->'", "'..<'", "'..'", "'=>'", "'<>'", "'?:'", "'+'", "'*'", "'**'", "'%'", "'!'", "'as'", "'++'", "'--'", "'.'", "'::'", "'?.'", "'['", "']'", "'|'", "';'", "'if'", "'else'", "'switch'", "'case'", "'for'", "'while'", "'do'", "'var'", "'val'", "'extends'", "'static'", "'import'", "'extension'", "'super'", "'new'", "'false'", "'true'", "'null'", "'typeof'", "'throw'", "'return'", "'try'", "'finally'", "'synchronized'", "'catch'", "'?'", "'&'", "'parents'", "'nodes'", "'edges'", "'ports'", "'labels'", "'self_loops'", "'inside_self_loops'", "'multi_edges'", "'edge_labels'", "'compound'", "'clusters'", "'disconnected'"
    };
    public static final int RULE_HEX=6;
    public static final int T__50=50;
    public static final int T__59=59;
    public static final int T__55=55;
    public static final int T__56=56;
    public static final int T__57=57;
    public static final int T__58=58;
    public static final int T__51=51;
    public static final int T__52=52;
    public static final int T__53=53;
    public static final int T__54=54;
    public static final int T__60=60;
    public static final int T__61=61;
    public static final int RULE_ID=5;
    public static final int RULE_INT=7;
    public static final int T__66=66;
    public static final int RULE_ML_COMMENT=9;
    public static final int T__67=67;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__62=62;
    public static final int T__63=63;
    public static final int T__64=64;
    public static final int T__65=65;
    public static final int T__37=37;
    public static final int T__38=38;
    public static final int T__39=39;
    public static final int T__33=33;
    public static final int T__34=34;
    public static final int T__35=35;
    public static final int T__36=36;
    public static final int T__30=30;
    public static final int T__31=31;
    public static final int T__32=32;
    public static final int T__48=48;
    public static final int T__49=49;
    public static final int T__44=44;
    public static final int T__45=45;
    public static final int T__46=46;
    public static final int T__47=47;
    public static final int T__40=40;
    public static final int T__41=41;
    public static final int T__42=42;
    public static final int T__43=43;
    public static final int T__91=91;
    public static final int T__100=100;
    public static final int T__92=92;
    public static final int T__93=93;
    public static final int T__102=102;
    public static final int T__94=94;
    public static final int T__101=101;
    public static final int T__90=90;
    public static final int T__19=19;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__99=99;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int T__95=95;
    public static final int T__96=96;
    public static final int T__97=97;
    public static final int T__98=98;
    public static final int RULE_DECIMAL=8;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int T__28=28;
    public static final int T__29=29;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__122=122;
    public static final int T__70=70;
    public static final int T__121=121;
    public static final int T__71=71;
    public static final int T__124=124;
    public static final int T__72=72;
    public static final int T__123=123;
    public static final int T__120=120;
    public static final int RULE_STRING=4;
    public static final int RULE_SL_COMMENT=10;
    public static final int T__77=77;
    public static final int T__119=119;
    public static final int T__78=78;
    public static final int T__118=118;
    public static final int T__79=79;
    public static final int T__73=73;
    public static final int T__115=115;
    public static final int EOF=-1;
    public static final int T__74=74;
    public static final int T__114=114;
    public static final int T__75=75;
    public static final int T__117=117;
    public static final int T__76=76;
    public static final int T__116=116;
    public static final int T__80=80;
    public static final int T__111=111;
    public static final int T__81=81;
    public static final int T__110=110;
    public static final int T__82=82;
    public static final int T__113=113;
    public static final int T__83=83;
    public static final int T__112=112;
    public static final int RULE_WS=11;
    public static final int RULE_ANY_OTHER=12;
    public static final int T__88=88;
    public static final int T__108=108;
    public static final int T__89=89;
    public static final int T__107=107;
    public static final int T__109=109;
    public static final int T__84=84;
    public static final int T__104=104;
    public static final int T__85=85;
    public static final int T__103=103;
    public static final int T__86=86;
    public static final int T__106=106;
    public static final int T__87=87;
    public static final int T__105=105;

    // delegates
    // delegators


        public InternalMetaDataParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalMetaDataParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalMetaDataParser.tokenNames; }
    public String getGrammarFileName() { return "InternalMetaData.g"; }



     	private MetaDataGrammarAccess grammarAccess;

        public InternalMetaDataParser(TokenStream input, MetaDataGrammarAccess grammarAccess) {
            this(input);
            this.grammarAccess = grammarAccess;
            registerRules(grammarAccess.getGrammar());
        }

        @Override
        protected String getFirstRuleName() {
        	return "MdModel";
       	}

       	@Override
       	protected MetaDataGrammarAccess getGrammarAccess() {
       		return grammarAccess;
       	}




    // $ANTLR start "entryRuleMdModel"
    // InternalMetaData.g:72:1: entryRuleMdModel returns [EObject current=null] : iv_ruleMdModel= ruleMdModel EOF ;
    public final EObject entryRuleMdModel() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdModel = null;


        try {
            // InternalMetaData.g:72:48: (iv_ruleMdModel= ruleMdModel EOF )
            // InternalMetaData.g:73:2: iv_ruleMdModel= ruleMdModel EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdModelRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdModel=ruleMdModel();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdModel; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdModel"


    // $ANTLR start "ruleMdModel"
    // InternalMetaData.g:79:1: ruleMdModel returns [EObject current=null] : (otherlv_0= 'package' ( (lv_name_1_0= ruleQualifiedName ) ) ( (lv_importSection_2_0= ruleXImportSection ) )? ( (lv_bundle_3_0= ruleMdBundle ) ) )? ;
    public final EObject ruleMdModel() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_importSection_2_0 = null;

        EObject lv_bundle_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:85:2: ( (otherlv_0= 'package' ( (lv_name_1_0= ruleQualifiedName ) ) ( (lv_importSection_2_0= ruleXImportSection ) )? ( (lv_bundle_3_0= ruleMdBundle ) ) )? )
            // InternalMetaData.g:86:2: (otherlv_0= 'package' ( (lv_name_1_0= ruleQualifiedName ) ) ( (lv_importSection_2_0= ruleXImportSection ) )? ( (lv_bundle_3_0= ruleMdBundle ) ) )?
            {
            // InternalMetaData.g:86:2: (otherlv_0= 'package' ( (lv_name_1_0= ruleQualifiedName ) ) ( (lv_importSection_2_0= ruleXImportSection ) )? ( (lv_bundle_3_0= ruleMdBundle ) ) )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==13) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // InternalMetaData.g:87:3: otherlv_0= 'package' ( (lv_name_1_0= ruleQualifiedName ) ) ( (lv_importSection_2_0= ruleXImportSection ) )? ( (lv_bundle_3_0= ruleMdBundle ) )
                    {
                    otherlv_0=(Token)match(input,13,FOLLOW_3); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			newLeafNode(otherlv_0, grammarAccess.getMdModelAccess().getPackageKeyword_0());
                      		
                    }
                    // InternalMetaData.g:91:3: ( (lv_name_1_0= ruleQualifiedName ) )
                    // InternalMetaData.g:92:4: (lv_name_1_0= ruleQualifiedName )
                    {
                    // InternalMetaData.g:92:4: (lv_name_1_0= ruleQualifiedName )
                    // InternalMetaData.g:93:5: lv_name_1_0= ruleQualifiedName
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getMdModelAccess().getNameQualifiedNameParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_4);
                    lv_name_1_0=ruleQualifiedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getMdModelRule());
                      					}
                      					set(
                      						current,
                      						"name",
                      						lv_name_1_0,
                      						"org.eclipse.xtext.xbase.Xbase.QualifiedName");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }

                    // InternalMetaData.g:110:3: ( (lv_importSection_2_0= ruleXImportSection ) )?
                    int alt1=2;
                    int LA1_0 = input.LA(1);

                    if ( (LA1_0==97) ) {
                        alt1=1;
                    }
                    switch (alt1) {
                        case 1 :
                            // InternalMetaData.g:111:4: (lv_importSection_2_0= ruleXImportSection )
                            {
                            // InternalMetaData.g:111:4: (lv_importSection_2_0= ruleXImportSection )
                            // InternalMetaData.g:112:5: lv_importSection_2_0= ruleXImportSection
                            {
                            if ( state.backtracking==0 ) {

                              					newCompositeNode(grammarAccess.getMdModelAccess().getImportSectionXImportSectionParserRuleCall_2_0());
                              				
                            }
                            pushFollow(FOLLOW_5);
                            lv_importSection_2_0=ruleXImportSection();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					if (current==null) {
                              						current = createModelElementForParent(grammarAccess.getMdModelRule());
                              					}
                              					set(
                              						current,
                              						"importSection",
                              						lv_importSection_2_0,
                              						"org.eclipse.xtext.xbase.Xtype.XImportSection");
                              					afterParserOrEnumRuleCall();
                              				
                            }

                            }


                            }
                            break;

                    }

                    // InternalMetaData.g:129:3: ( (lv_bundle_3_0= ruleMdBundle ) )
                    // InternalMetaData.g:130:4: (lv_bundle_3_0= ruleMdBundle )
                    {
                    // InternalMetaData.g:130:4: (lv_bundle_3_0= ruleMdBundle )
                    // InternalMetaData.g:131:5: lv_bundle_3_0= ruleMdBundle
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getMdModelAccess().getBundleMdBundleParserRuleCall_3_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_bundle_3_0=ruleMdBundle();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getMdModelRule());
                      					}
                      					set(
                      						current,
                      						"bundle",
                      						lv_bundle_3_0,
                      						"org.eclipse.elk.core.meta.MetaData.MdBundle");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdModel"


    // $ANTLR start "entryRuleMdBundle"
    // InternalMetaData.g:152:1: entryRuleMdBundle returns [EObject current=null] : iv_ruleMdBundle= ruleMdBundle EOF ;
    public final EObject entryRuleMdBundle() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdBundle = null;


        try {
            // InternalMetaData.g:152:49: (iv_ruleMdBundle= ruleMdBundle EOF )
            // InternalMetaData.g:153:2: iv_ruleMdBundle= ruleMdBundle EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdBundleRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdBundle=ruleMdBundle();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdBundle; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdBundle"


    // $ANTLR start "ruleMdBundle"
    // InternalMetaData.g:159:1: ruleMdBundle returns [EObject current=null] : ( () (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )? ( (lv_members_13_0= ruleMdBundleMember ) )* ) ;
    public final EObject ruleMdBundle() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token lv_label_5_0=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token otherlv_10=null;
        Token otherlv_12=null;
        AntlrDatatypeRuleToken lv_targetClass_7_0 = null;

        AntlrDatatypeRuleToken lv_documentationFolder_9_0 = null;

        AntlrDatatypeRuleToken lv_idPrefix_11_0 = null;

        EObject lv_members_13_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:165:2: ( ( () (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )? ( (lv_members_13_0= ruleMdBundleMember ) )* ) )
            // InternalMetaData.g:166:2: ( () (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )? ( (lv_members_13_0= ruleMdBundleMember ) )* )
            {
            // InternalMetaData.g:166:2: ( () (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )? ( (lv_members_13_0= ruleMdBundleMember ) )* )
            // InternalMetaData.g:167:3: () (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )? ( (lv_members_13_0= ruleMdBundleMember ) )*
            {
            // InternalMetaData.g:167:3: ()
            // InternalMetaData.g:168:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getMdBundleAccess().getMdBundleAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:174:3: (otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}' )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==14) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // InternalMetaData.g:175:4: otherlv_1= 'bundle' otherlv_2= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) ) otherlv_12= '}'
                    {
                    otherlv_1=(Token)match(input,14,FOLLOW_6); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getMdBundleAccess().getBundleKeyword_1_0());
                      			
                    }
                    otherlv_2=(Token)match(input,15,FOLLOW_7); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getMdBundleAccess().getLeftCurlyBracketKeyword_1_1());
                      			
                    }
                    // InternalMetaData.g:183:4: ( ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) ) )
                    // InternalMetaData.g:184:5: ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) )
                    {
                    // InternalMetaData.g:184:5: ( ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* ) )
                    // InternalMetaData.g:185:6: ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* )
                    {
                    getUnorderedGroupHelper().enter(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());
                    // InternalMetaData.g:188:6: ( ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )* )
                    // InternalMetaData.g:189:7: ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )*
                    {
                    // InternalMetaData.g:189:7: ( ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) ) )*
                    loop3:
                    do {
                        int alt3=5;
                        int LA3_0 = input.LA(1);

                        if ( LA3_0 == 16 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 0) ) {
                            alt3=1;
                        }
                        else if ( LA3_0 == 17 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 1) ) {
                            alt3=2;
                        }
                        else if ( LA3_0 == 18 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 2) ) {
                            alt3=3;
                        }
                        else if ( LA3_0 == 19 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 3) ) {
                            alt3=4;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    // InternalMetaData.g:190:5: ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) )
                    	    {
                    	    // InternalMetaData.g:190:5: ({...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) ) )
                    	    // InternalMetaData.g:191:6: {...}? => ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) )
                    	    {
                    	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 0) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 0)");
                    	    }
                    	    // InternalMetaData.g:191:108: ( ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) ) )
                    	    // InternalMetaData.g:192:7: ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) )
                    	    {
                    	    getUnorderedGroupHelper().select(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 0);
                    	    // InternalMetaData.g:195:10: ({...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) ) )
                    	    // InternalMetaData.g:195:11: {...}? => (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) )
                    	    {
                    	    if ( !((true)) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "true");
                    	    }
                    	    // InternalMetaData.g:195:20: (otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) ) )
                    	    // InternalMetaData.g:195:21: otherlv_4= 'label' ( (lv_label_5_0= RULE_STRING ) )
                    	    {
                    	    otherlv_4=(Token)match(input,16,FOLLOW_8); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      										newLeafNode(otherlv_4, grammarAccess.getMdBundleAccess().getLabelKeyword_1_2_0_0());
                    	      									
                    	    }
                    	    // InternalMetaData.g:199:10: ( (lv_label_5_0= RULE_STRING ) )
                    	    // InternalMetaData.g:200:11: (lv_label_5_0= RULE_STRING )
                    	    {
                    	    // InternalMetaData.g:200:11: (lv_label_5_0= RULE_STRING )
                    	    // InternalMetaData.g:201:12: lv_label_5_0= RULE_STRING
                    	    {
                    	    lv_label_5_0=(Token)match(input,RULE_STRING,FOLLOW_7); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      												newLeafNode(lv_label_5_0, grammarAccess.getMdBundleAccess().getLabelSTRINGTerminalRuleCall_1_2_0_1_0());
                    	      											
                    	    }
                    	    if ( state.backtracking==0 ) {

                    	      												if (current==null) {
                    	      													current = createModelElement(grammarAccess.getMdBundleRule());
                    	      												}
                    	      												setWithLastConsumed(
                    	      													current,
                    	      													"label",
                    	      													lv_label_5_0,
                    	      													"org.eclipse.xtext.xbase.Xtype.STRING");
                    	      											
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }

                    	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // InternalMetaData.g:223:5: ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) )
                    	    {
                    	    // InternalMetaData.g:223:5: ({...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) ) )
                    	    // InternalMetaData.g:224:6: {...}? => ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) )
                    	    {
                    	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 1) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 1)");
                    	    }
                    	    // InternalMetaData.g:224:108: ( ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) ) )
                    	    // InternalMetaData.g:225:7: ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) )
                    	    {
                    	    getUnorderedGroupHelper().select(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 1);
                    	    // InternalMetaData.g:228:10: ({...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) ) )
                    	    // InternalMetaData.g:228:11: {...}? => (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) )
                    	    {
                    	    if ( !((true)) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "true");
                    	    }
                    	    // InternalMetaData.g:228:20: (otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) ) )
                    	    // InternalMetaData.g:228:21: otherlv_6= 'metadataClass' ( (lv_targetClass_7_0= ruleQualifiedName ) )
                    	    {
                    	    otherlv_6=(Token)match(input,17,FOLLOW_3); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      										newLeafNode(otherlv_6, grammarAccess.getMdBundleAccess().getMetadataClassKeyword_1_2_1_0());
                    	      									
                    	    }
                    	    // InternalMetaData.g:232:10: ( (lv_targetClass_7_0= ruleQualifiedName ) )
                    	    // InternalMetaData.g:233:11: (lv_targetClass_7_0= ruleQualifiedName )
                    	    {
                    	    // InternalMetaData.g:233:11: (lv_targetClass_7_0= ruleQualifiedName )
                    	    // InternalMetaData.g:234:12: lv_targetClass_7_0= ruleQualifiedName
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      												newCompositeNode(grammarAccess.getMdBundleAccess().getTargetClassQualifiedNameParserRuleCall_1_2_1_1_0());
                    	      											
                    	    }
                    	    pushFollow(FOLLOW_7);
                    	    lv_targetClass_7_0=ruleQualifiedName();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      												if (current==null) {
                    	      													current = createModelElementForParent(grammarAccess.getMdBundleRule());
                    	      												}
                    	      												set(
                    	      													current,
                    	      													"targetClass",
                    	      													lv_targetClass_7_0,
                    	      													"org.eclipse.xtext.xbase.Xbase.QualifiedName");
                    	      												afterParserOrEnumRuleCall();
                    	      											
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }

                    	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    // InternalMetaData.g:257:5: ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) )
                    	    {
                    	    // InternalMetaData.g:257:5: ({...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) ) )
                    	    // InternalMetaData.g:258:6: {...}? => ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) )
                    	    {
                    	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 2) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 2)");
                    	    }
                    	    // InternalMetaData.g:258:108: ( ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) ) )
                    	    // InternalMetaData.g:259:7: ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) )
                    	    {
                    	    getUnorderedGroupHelper().select(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 2);
                    	    // InternalMetaData.g:262:10: ({...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) ) )
                    	    // InternalMetaData.g:262:11: {...}? => (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) )
                    	    {
                    	    if ( !((true)) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "true");
                    	    }
                    	    // InternalMetaData.g:262:20: (otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) ) )
                    	    // InternalMetaData.g:262:21: otherlv_8= 'documentationFolder' ( (lv_documentationFolder_9_0= rulePath ) )
                    	    {
                    	    otherlv_8=(Token)match(input,18,FOLLOW_3); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      										newLeafNode(otherlv_8, grammarAccess.getMdBundleAccess().getDocumentationFolderKeyword_1_2_2_0());
                    	      									
                    	    }
                    	    // InternalMetaData.g:266:10: ( (lv_documentationFolder_9_0= rulePath ) )
                    	    // InternalMetaData.g:267:11: (lv_documentationFolder_9_0= rulePath )
                    	    {
                    	    // InternalMetaData.g:267:11: (lv_documentationFolder_9_0= rulePath )
                    	    // InternalMetaData.g:268:12: lv_documentationFolder_9_0= rulePath
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      												newCompositeNode(grammarAccess.getMdBundleAccess().getDocumentationFolderPathParserRuleCall_1_2_2_1_0());
                    	      											
                    	    }
                    	    pushFollow(FOLLOW_7);
                    	    lv_documentationFolder_9_0=rulePath();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      												if (current==null) {
                    	      													current = createModelElementForParent(grammarAccess.getMdBundleRule());
                    	      												}
                    	      												set(
                    	      													current,
                    	      													"documentationFolder",
                    	      													lv_documentationFolder_9_0,
                    	      													"org.eclipse.elk.core.meta.MetaData.Path");
                    	      												afterParserOrEnumRuleCall();
                    	      											
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }

                    	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());

                    	    }


                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    // InternalMetaData.g:291:5: ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) )
                    	    {
                    	    // InternalMetaData.g:291:5: ({...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) ) )
                    	    // InternalMetaData.g:292:6: {...}? => ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) )
                    	    {
                    	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 3) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 3)");
                    	    }
                    	    // InternalMetaData.g:292:108: ( ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) ) )
                    	    // InternalMetaData.g:293:7: ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) )
                    	    {
                    	    getUnorderedGroupHelper().select(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2(), 3);
                    	    // InternalMetaData.g:296:10: ({...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) ) )
                    	    // InternalMetaData.g:296:11: {...}? => (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) )
                    	    {
                    	    if ( !((true)) ) {
                    	        if (state.backtracking>0) {state.failed=true; return current;}
                    	        throw new FailedPredicateException(input, "ruleMdBundle", "true");
                    	    }
                    	    // InternalMetaData.g:296:20: (otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) ) )
                    	    // InternalMetaData.g:296:21: otherlv_10= 'idPrefix' ( (lv_idPrefix_11_0= ruleQualifiedName ) )
                    	    {
                    	    otherlv_10=(Token)match(input,19,FOLLOW_3); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      										newLeafNode(otherlv_10, grammarAccess.getMdBundleAccess().getIdPrefixKeyword_1_2_3_0());
                    	      									
                    	    }
                    	    // InternalMetaData.g:300:10: ( (lv_idPrefix_11_0= ruleQualifiedName ) )
                    	    // InternalMetaData.g:301:11: (lv_idPrefix_11_0= ruleQualifiedName )
                    	    {
                    	    // InternalMetaData.g:301:11: (lv_idPrefix_11_0= ruleQualifiedName )
                    	    // InternalMetaData.g:302:12: lv_idPrefix_11_0= ruleQualifiedName
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      												newCompositeNode(grammarAccess.getMdBundleAccess().getIdPrefixQualifiedNameParserRuleCall_1_2_3_1_0());
                    	      											
                    	    }
                    	    pushFollow(FOLLOW_7);
                    	    lv_idPrefix_11_0=ruleQualifiedName();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      												if (current==null) {
                    	      													current = createModelElementForParent(grammarAccess.getMdBundleRule());
                    	      												}
                    	      												set(
                    	      													current,
                    	      													"idPrefix",
                    	      													lv_idPrefix_11_0,
                    	      													"org.eclipse.xtext.xbase.Xbase.QualifiedName");
                    	      												afterParserOrEnumRuleCall();
                    	      											
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }

                    	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);


                    }


                    }

                    getUnorderedGroupHelper().leave(grammarAccess.getMdBundleAccess().getUnorderedGroup_1_2());

                    }

                    otherlv_12=(Token)match(input,20,FOLLOW_9); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_12, grammarAccess.getMdBundleAccess().getRightCurlyBracketKeyword_1_3());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:337:3: ( (lv_members_13_0= ruleMdBundleMember ) )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( (LA5_0==21||(LA5_0>=23 && LA5_0<=28)||LA5_0==40||LA5_0==44) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // InternalMetaData.g:338:4: (lv_members_13_0= ruleMdBundleMember )
            	    {
            	    // InternalMetaData.g:338:4: (lv_members_13_0= ruleMdBundleMember )
            	    // InternalMetaData.g:339:5: lv_members_13_0= ruleMdBundleMember
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getMdBundleAccess().getMembersMdBundleMemberParserRuleCall_2_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_9);
            	    lv_members_13_0=ruleMdBundleMember();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getMdBundleRule());
            	      					}
            	      					add(
            	      						current,
            	      						"members",
            	      						lv_members_13_0,
            	      						"org.eclipse.elk.core.meta.MetaData.MdBundleMember");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdBundle"


    // $ANTLR start "entryRuleMdBundleMember"
    // InternalMetaData.g:360:1: entryRuleMdBundleMember returns [EObject current=null] : iv_ruleMdBundleMember= ruleMdBundleMember EOF ;
    public final EObject entryRuleMdBundleMember() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdBundleMember = null;


        try {
            // InternalMetaData.g:360:55: (iv_ruleMdBundleMember= ruleMdBundleMember EOF )
            // InternalMetaData.g:361:2: iv_ruleMdBundleMember= ruleMdBundleMember EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdBundleMemberRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdBundleMember=ruleMdBundleMember();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdBundleMember; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdBundleMember"


    // $ANTLR start "ruleMdBundleMember"
    // InternalMetaData.g:367:1: ruleMdBundleMember returns [EObject current=null] : (this_MdGroupOrOption_0= ruleMdGroupOrOption | this_MdAlgorithm_1= ruleMdAlgorithm | this_MdCategory_2= ruleMdCategory ) ;
    public final EObject ruleMdBundleMember() throws RecognitionException {
        EObject current = null;

        EObject this_MdGroupOrOption_0 = null;

        EObject this_MdAlgorithm_1 = null;

        EObject this_MdCategory_2 = null;



        	enterRule();

        try {
            // InternalMetaData.g:373:2: ( (this_MdGroupOrOption_0= ruleMdGroupOrOption | this_MdAlgorithm_1= ruleMdAlgorithm | this_MdCategory_2= ruleMdCategory ) )
            // InternalMetaData.g:374:2: (this_MdGroupOrOption_0= ruleMdGroupOrOption | this_MdAlgorithm_1= ruleMdAlgorithm | this_MdCategory_2= ruleMdCategory )
            {
            // InternalMetaData.g:374:2: (this_MdGroupOrOption_0= ruleMdGroupOrOption | this_MdAlgorithm_1= ruleMdAlgorithm | this_MdCategory_2= ruleMdCategory )
            int alt6=3;
            switch ( input.LA(1) ) {
            case 21:
            case 24:
            case 25:
            case 26:
            case 27:
            case 28:
                {
                alt6=1;
                }
                break;
            case 23:
                {
                switch ( input.LA(2) ) {
                case 24:
                case 25:
                case 26:
                case 27:
                case 28:
                    {
                    alt6=1;
                    }
                    break;
                case 44:
                    {
                    alt6=3;
                    }
                    break;
                case 40:
                    {
                    alt6=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 6, 2, input);

                    throw nvae;
                }

                }
                break;
            case 40:
                {
                alt6=2;
                }
                break;
            case 44:
                {
                alt6=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // InternalMetaData.g:375:3: this_MdGroupOrOption_0= ruleMdGroupOrOption
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getMdBundleMemberAccess().getMdGroupOrOptionParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_MdGroupOrOption_0=ruleMdGroupOrOption();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_MdGroupOrOption_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:384:3: this_MdAlgorithm_1= ruleMdAlgorithm
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getMdBundleMemberAccess().getMdAlgorithmParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_MdAlgorithm_1=ruleMdAlgorithm();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_MdAlgorithm_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:393:3: this_MdCategory_2= ruleMdCategory
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getMdBundleMemberAccess().getMdCategoryParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_MdCategory_2=ruleMdCategory();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_MdCategory_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdBundleMember"


    // $ANTLR start "entryRuleMdGroupOrOption"
    // InternalMetaData.g:405:1: entryRuleMdGroupOrOption returns [EObject current=null] : iv_ruleMdGroupOrOption= ruleMdGroupOrOption EOF ;
    public final EObject entryRuleMdGroupOrOption() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdGroupOrOption = null;


        try {
            // InternalMetaData.g:405:56: (iv_ruleMdGroupOrOption= ruleMdGroupOrOption EOF )
            // InternalMetaData.g:406:2: iv_ruleMdGroupOrOption= ruleMdGroupOrOption EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdGroupOrOptionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdGroupOrOption=ruleMdGroupOrOption();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdGroupOrOption; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdGroupOrOption"


    // $ANTLR start "ruleMdGroupOrOption"
    // InternalMetaData.g:412:1: ruleMdGroupOrOption returns [EObject current=null] : (this_MdGroup_0= ruleMdGroup | this_MdOption_1= ruleMdOption ) ;
    public final EObject ruleMdGroupOrOption() throws RecognitionException {
        EObject current = null;

        EObject this_MdGroup_0 = null;

        EObject this_MdOption_1 = null;



        	enterRule();

        try {
            // InternalMetaData.g:418:2: ( (this_MdGroup_0= ruleMdGroup | this_MdOption_1= ruleMdOption ) )
            // InternalMetaData.g:419:2: (this_MdGroup_0= ruleMdGroup | this_MdOption_1= ruleMdOption )
            {
            // InternalMetaData.g:419:2: (this_MdGroup_0= ruleMdGroup | this_MdOption_1= ruleMdOption )
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==21) ) {
                alt7=1;
            }
            else if ( ((LA7_0>=23 && LA7_0<=28)) ) {
                alt7=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }
            switch (alt7) {
                case 1 :
                    // InternalMetaData.g:420:3: this_MdGroup_0= ruleMdGroup
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getMdGroupOrOptionAccess().getMdGroupParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_MdGroup_0=ruleMdGroup();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_MdGroup_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:429:3: this_MdOption_1= ruleMdOption
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getMdGroupOrOptionAccess().getMdOptionParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_MdOption_1=ruleMdOption();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_MdOption_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdGroupOrOption"


    // $ANTLR start "entryRuleMdGroup"
    // InternalMetaData.g:441:1: entryRuleMdGroup returns [EObject current=null] : iv_ruleMdGroup= ruleMdGroup EOF ;
    public final EObject entryRuleMdGroup() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdGroup = null;


        try {
            // InternalMetaData.g:441:48: (iv_ruleMdGroup= ruleMdGroup EOF )
            // InternalMetaData.g:442:2: iv_ruleMdGroup= ruleMdGroup EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdGroupRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdGroup=ruleMdGroup();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdGroup; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdGroup"


    // $ANTLR start "ruleMdGroup"
    // InternalMetaData.g:448:1: ruleMdGroup returns [EObject current=null] : (otherlv_0= 'group' ( (lv_name_1_0= RULE_ID ) ) otherlv_2= '{' (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )? ( (lv_children_5_0= ruleMdGroupOrOption ) )* otherlv_6= '}' ) ;
    public final EObject ruleMdGroup() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token lv_name_1_0=null;
        Token otherlv_2=null;
        Token otherlv_3=null;
        Token lv_documentation_4_0=null;
        Token otherlv_6=null;
        EObject lv_children_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:454:2: ( (otherlv_0= 'group' ( (lv_name_1_0= RULE_ID ) ) otherlv_2= '{' (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )? ( (lv_children_5_0= ruleMdGroupOrOption ) )* otherlv_6= '}' ) )
            // InternalMetaData.g:455:2: (otherlv_0= 'group' ( (lv_name_1_0= RULE_ID ) ) otherlv_2= '{' (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )? ( (lv_children_5_0= ruleMdGroupOrOption ) )* otherlv_6= '}' )
            {
            // InternalMetaData.g:455:2: (otherlv_0= 'group' ( (lv_name_1_0= RULE_ID ) ) otherlv_2= '{' (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )? ( (lv_children_5_0= ruleMdGroupOrOption ) )* otherlv_6= '}' )
            // InternalMetaData.g:456:3: otherlv_0= 'group' ( (lv_name_1_0= RULE_ID ) ) otherlv_2= '{' (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )? ( (lv_children_5_0= ruleMdGroupOrOption ) )* otherlv_6= '}'
            {
            otherlv_0=(Token)match(input,21,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getMdGroupAccess().getGroupKeyword_0());
              		
            }
            // InternalMetaData.g:460:3: ( (lv_name_1_0= RULE_ID ) )
            // InternalMetaData.g:461:4: (lv_name_1_0= RULE_ID )
            {
            // InternalMetaData.g:461:4: (lv_name_1_0= RULE_ID )
            // InternalMetaData.g:462:5: lv_name_1_0= RULE_ID
            {
            lv_name_1_0=(Token)match(input,RULE_ID,FOLLOW_6); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(lv_name_1_0, grammarAccess.getMdGroupAccess().getNameIDTerminalRuleCall_1_0());
              				
            }
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdGroupRule());
              					}
              					setWithLastConsumed(
              						current,
              						"name",
              						lv_name_1_0,
              						"org.eclipse.xtext.xbase.Xtype.ID");
              				
            }

            }


            }

            otherlv_2=(Token)match(input,15,FOLLOW_10); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getMdGroupAccess().getLeftCurlyBracketKeyword_2());
              		
            }
            // InternalMetaData.g:482:3: (otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) ) )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==22) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // InternalMetaData.g:483:4: otherlv_3= 'documentation' ( (lv_documentation_4_0= RULE_STRING ) )
                    {
                    otherlv_3=(Token)match(input,22,FOLLOW_8); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_3, grammarAccess.getMdGroupAccess().getDocumentationKeyword_3_0());
                      			
                    }
                    // InternalMetaData.g:487:4: ( (lv_documentation_4_0= RULE_STRING ) )
                    // InternalMetaData.g:488:5: (lv_documentation_4_0= RULE_STRING )
                    {
                    // InternalMetaData.g:488:5: (lv_documentation_4_0= RULE_STRING )
                    // InternalMetaData.g:489:6: lv_documentation_4_0= RULE_STRING
                    {
                    lv_documentation_4_0=(Token)match(input,RULE_STRING,FOLLOW_11); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_documentation_4_0, grammarAccess.getMdGroupAccess().getDocumentationSTRINGTerminalRuleCall_3_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdGroupRule());
                      						}
                      						setWithLastConsumed(
                      							current,
                      							"documentation",
                      							lv_documentation_4_0,
                      							"org.eclipse.xtext.xbase.Xtype.STRING");
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:506:3: ( (lv_children_5_0= ruleMdGroupOrOption ) )*
            loop9:
            do {
                int alt9=2;
                int LA9_0 = input.LA(1);

                if ( (LA9_0==21||(LA9_0>=23 && LA9_0<=28)) ) {
                    alt9=1;
                }


                switch (alt9) {
            	case 1 :
            	    // InternalMetaData.g:507:4: (lv_children_5_0= ruleMdGroupOrOption )
            	    {
            	    // InternalMetaData.g:507:4: (lv_children_5_0= ruleMdGroupOrOption )
            	    // InternalMetaData.g:508:5: lv_children_5_0= ruleMdGroupOrOption
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getMdGroupAccess().getChildrenMdGroupOrOptionParserRuleCall_4_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_11);
            	    lv_children_5_0=ruleMdGroupOrOption();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getMdGroupRule());
            	      					}
            	      					add(
            	      						current,
            	      						"children",
            	      						lv_children_5_0,
            	      						"org.eclipse.elk.core.meta.MetaData.MdGroupOrOption");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop9;
                }
            } while (true);

            otherlv_6=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getMdGroupAccess().getRightCurlyBracketKeyword_5());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdGroup"


    // $ANTLR start "entryRuleMdOption"
    // InternalMetaData.g:533:1: entryRuleMdOption returns [EObject current=null] : iv_ruleMdOption= ruleMdOption EOF ;
    public final EObject entryRuleMdOption() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdOption = null;


        try {
            // InternalMetaData.g:533:49: (iv_ruleMdOption= ruleMdOption EOF )
            // InternalMetaData.g:534:2: iv_ruleMdOption= ruleMdOption EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdOptionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdOption=ruleMdOption();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdOption; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdOption"


    // $ANTLR start "ruleMdOption"
    // InternalMetaData.g:540:1: ruleMdOption returns [EObject current=null] : ( ( (lv_deprecated_0_0= 'deprecated' ) )? ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )? otherlv_5= 'option' ( (lv_name_6_0= RULE_ID ) ) (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )? otherlv_9= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) ) ( (lv_dependencies_34_0= ruleMdOptionDependency ) )* otherlv_35= '}' ) ;
    public final EObject ruleMdOption() throws RecognitionException {
        EObject current = null;

        Token lv_deprecated_0_0=null;
        Token lv_advanced_1_0=null;
        Token lv_programmatic_2_0=null;
        Token lv_output_3_0=null;
        Token lv_global_4_0=null;
        Token otherlv_5=null;
        Token lv_name_6_0=null;
        Token otherlv_7=null;
        Token otherlv_9=null;
        Token otherlv_11=null;
        Token lv_label_12_0=null;
        Token otherlv_13=null;
        Token lv_description_14_0=null;
        Token otherlv_15=null;
        Token lv_documentation_16_0=null;
        Token otherlv_17=null;
        Token otherlv_18=null;
        Token otherlv_20=null;
        Token otherlv_21=null;
        Token otherlv_23=null;
        Token otherlv_24=null;
        Token otherlv_26=null;
        Token otherlv_28=null;
        Token otherlv_30=null;
        Token otherlv_32=null;
        Token otherlv_35=null;
        EObject lv_type_8_0 = null;

        EObject lv_defaultValue_19_0 = null;

        EObject lv_lowerBound_22_0 = null;

        EObject lv_upperBound_25_0 = null;

        Enumerator lv_targets_27_0 = null;

        Enumerator lv_targets_29_0 = null;

        AntlrDatatypeRuleToken lv_legacyIds_31_0 = null;

        AntlrDatatypeRuleToken lv_legacyIds_33_0 = null;

        EObject lv_dependencies_34_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:546:2: ( ( ( (lv_deprecated_0_0= 'deprecated' ) )? ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )? otherlv_5= 'option' ( (lv_name_6_0= RULE_ID ) ) (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )? otherlv_9= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) ) ( (lv_dependencies_34_0= ruleMdOptionDependency ) )* otherlv_35= '}' ) )
            // InternalMetaData.g:547:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )? otherlv_5= 'option' ( (lv_name_6_0= RULE_ID ) ) (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )? otherlv_9= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) ) ( (lv_dependencies_34_0= ruleMdOptionDependency ) )* otherlv_35= '}' )
            {
            // InternalMetaData.g:547:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )? otherlv_5= 'option' ( (lv_name_6_0= RULE_ID ) ) (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )? otherlv_9= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) ) ( (lv_dependencies_34_0= ruleMdOptionDependency ) )* otherlv_35= '}' )
            // InternalMetaData.g:548:3: ( (lv_deprecated_0_0= 'deprecated' ) )? ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )? otherlv_5= 'option' ( (lv_name_6_0= RULE_ID ) ) (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )? otherlv_9= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) ) ( (lv_dependencies_34_0= ruleMdOptionDependency ) )* otherlv_35= '}'
            {
            // InternalMetaData.g:548:3: ( (lv_deprecated_0_0= 'deprecated' ) )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==23) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // InternalMetaData.g:549:4: (lv_deprecated_0_0= 'deprecated' )
                    {
                    // InternalMetaData.g:549:4: (lv_deprecated_0_0= 'deprecated' )
                    // InternalMetaData.g:550:5: lv_deprecated_0_0= 'deprecated'
                    {
                    lv_deprecated_0_0=(Token)match(input,23,FOLLOW_12); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_deprecated_0_0, grammarAccess.getMdOptionAccess().getDeprecatedDeprecatedKeyword_0_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getMdOptionRule());
                      					}
                      					setWithLastConsumed(current, "deprecated", true, "deprecated");
                      				
                    }

                    }


                    }
                    break;

            }

            // InternalMetaData.g:562:3: ( ( (lv_advanced_1_0= 'advanced' ) ) | ( (lv_programmatic_2_0= 'programmatic' ) ) | ( (lv_output_3_0= 'output' ) ) | ( (lv_global_4_0= 'global' ) ) )?
            int alt11=5;
            switch ( input.LA(1) ) {
                case 24:
                    {
                    alt11=1;
                    }
                    break;
                case 25:
                    {
                    alt11=2;
                    }
                    break;
                case 26:
                    {
                    alt11=3;
                    }
                    break;
                case 27:
                    {
                    alt11=4;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // InternalMetaData.g:563:4: ( (lv_advanced_1_0= 'advanced' ) )
                    {
                    // InternalMetaData.g:563:4: ( (lv_advanced_1_0= 'advanced' ) )
                    // InternalMetaData.g:564:5: (lv_advanced_1_0= 'advanced' )
                    {
                    // InternalMetaData.g:564:5: (lv_advanced_1_0= 'advanced' )
                    // InternalMetaData.g:565:6: lv_advanced_1_0= 'advanced'
                    {
                    lv_advanced_1_0=(Token)match(input,24,FOLLOW_13); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_advanced_1_0, grammarAccess.getMdOptionAccess().getAdvancedAdvancedKeyword_1_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdOptionRule());
                      						}
                      						setWithLastConsumed(current, "advanced", true, "advanced");
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:578:4: ( (lv_programmatic_2_0= 'programmatic' ) )
                    {
                    // InternalMetaData.g:578:4: ( (lv_programmatic_2_0= 'programmatic' ) )
                    // InternalMetaData.g:579:5: (lv_programmatic_2_0= 'programmatic' )
                    {
                    // InternalMetaData.g:579:5: (lv_programmatic_2_0= 'programmatic' )
                    // InternalMetaData.g:580:6: lv_programmatic_2_0= 'programmatic'
                    {
                    lv_programmatic_2_0=(Token)match(input,25,FOLLOW_13); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_programmatic_2_0, grammarAccess.getMdOptionAccess().getProgrammaticProgrammaticKeyword_1_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdOptionRule());
                      						}
                      						setWithLastConsumed(current, "programmatic", true, "programmatic");
                      					
                    }

                    }


                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:593:4: ( (lv_output_3_0= 'output' ) )
                    {
                    // InternalMetaData.g:593:4: ( (lv_output_3_0= 'output' ) )
                    // InternalMetaData.g:594:5: (lv_output_3_0= 'output' )
                    {
                    // InternalMetaData.g:594:5: (lv_output_3_0= 'output' )
                    // InternalMetaData.g:595:6: lv_output_3_0= 'output'
                    {
                    lv_output_3_0=(Token)match(input,26,FOLLOW_13); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_output_3_0, grammarAccess.getMdOptionAccess().getOutputOutputKeyword_1_2_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdOptionRule());
                      						}
                      						setWithLastConsumed(current, "output", true, "output");
                      					
                    }

                    }


                    }


                    }
                    break;
                case 4 :
                    // InternalMetaData.g:608:4: ( (lv_global_4_0= 'global' ) )
                    {
                    // InternalMetaData.g:608:4: ( (lv_global_4_0= 'global' ) )
                    // InternalMetaData.g:609:5: (lv_global_4_0= 'global' )
                    {
                    // InternalMetaData.g:609:5: (lv_global_4_0= 'global' )
                    // InternalMetaData.g:610:6: lv_global_4_0= 'global'
                    {
                    lv_global_4_0=(Token)match(input,27,FOLLOW_13); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_global_4_0, grammarAccess.getMdOptionAccess().getGlobalGlobalKeyword_1_3_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdOptionRule());
                      						}
                      						setWithLastConsumed(current, "global", true, "global");
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_5=(Token)match(input,28,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getMdOptionAccess().getOptionKeyword_2());
              		
            }
            // InternalMetaData.g:627:3: ( (lv_name_6_0= RULE_ID ) )
            // InternalMetaData.g:628:4: (lv_name_6_0= RULE_ID )
            {
            // InternalMetaData.g:628:4: (lv_name_6_0= RULE_ID )
            // InternalMetaData.g:629:5: lv_name_6_0= RULE_ID
            {
            lv_name_6_0=(Token)match(input,RULE_ID,FOLLOW_14); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(lv_name_6_0, grammarAccess.getMdOptionAccess().getNameIDTerminalRuleCall_3_0());
              				
            }
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdOptionRule());
              					}
              					setWithLastConsumed(
              						current,
              						"name",
              						lv_name_6_0,
              						"org.eclipse.xtext.xbase.Xtype.ID");
              				
            }

            }


            }

            // InternalMetaData.g:645:3: (otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) ) )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==29) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // InternalMetaData.g:646:4: otherlv_7= ':' ( (lv_type_8_0= ruleJvmTypeReference ) )
                    {
                    otherlv_7=(Token)match(input,29,FOLLOW_15); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_7, grammarAccess.getMdOptionAccess().getColonKeyword_4_0());
                      			
                    }
                    // InternalMetaData.g:650:4: ( (lv_type_8_0= ruleJvmTypeReference ) )
                    // InternalMetaData.g:651:5: (lv_type_8_0= ruleJvmTypeReference )
                    {
                    // InternalMetaData.g:651:5: (lv_type_8_0= ruleJvmTypeReference )
                    // InternalMetaData.g:652:6: lv_type_8_0= ruleJvmTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getMdOptionAccess().getTypeJvmTypeReferenceParserRuleCall_4_1_0());
                      					
                    }
                    pushFollow(FOLLOW_6);
                    lv_type_8_0=ruleJvmTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getMdOptionRule());
                      						}
                      						set(
                      							current,
                      							"type",
                      							lv_type_8_0,
                      							"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_9=(Token)match(input,15,FOLLOW_16); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_9, grammarAccess.getMdOptionAccess().getLeftCurlyBracketKeyword_5());
              		
            }
            // InternalMetaData.g:674:3: ( ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) ) )
            // InternalMetaData.g:675:4: ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) )
            {
            // InternalMetaData.g:675:4: ( ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* ) )
            // InternalMetaData.g:676:5: ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* )
            {
            getUnorderedGroupHelper().enter(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());
            // InternalMetaData.g:679:5: ( ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )* )
            // InternalMetaData.g:680:6: ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )*
            {
            // InternalMetaData.g:680:6: ( ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) ) )*
            loop15:
            do {
                int alt15=9;
                alt15 = dfa15.predict(input);
                switch (alt15) {
            	case 1 :
            	    // InternalMetaData.g:681:4: ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:681:4: ({...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:682:5: {...}? => ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 0) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 0)");
            	    }
            	    // InternalMetaData.g:682:105: ( ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:683:6: ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 0);
            	    // InternalMetaData.g:686:9: ({...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:686:10: {...}? => (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:686:19: (otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:686:20: otherlv_11= 'label' ( (lv_label_12_0= RULE_STRING ) )
            	    {
            	    otherlv_11=(Token)match(input,16,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_11, grammarAccess.getMdOptionAccess().getLabelKeyword_6_0_0());
            	      								
            	    }
            	    // InternalMetaData.g:690:9: ( (lv_label_12_0= RULE_STRING ) )
            	    // InternalMetaData.g:691:10: (lv_label_12_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:691:10: (lv_label_12_0= RULE_STRING )
            	    // InternalMetaData.g:692:11: lv_label_12_0= RULE_STRING
            	    {
            	    lv_label_12_0=(Token)match(input,RULE_STRING,FOLLOW_16); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_label_12_0, grammarAccess.getMdOptionAccess().getLabelSTRINGTerminalRuleCall_6_0_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdOptionRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"label",
            	      												lv_label_12_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    // InternalMetaData.g:714:4: ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:714:4: ({...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:715:5: {...}? => ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 1) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 1)");
            	    }
            	    // InternalMetaData.g:715:105: ( ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:716:6: ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 1);
            	    // InternalMetaData.g:719:9: ({...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:719:10: {...}? => (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:719:19: (otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:719:20: otherlv_13= 'description' ( (lv_description_14_0= RULE_STRING ) )
            	    {
            	    otherlv_13=(Token)match(input,30,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_13, grammarAccess.getMdOptionAccess().getDescriptionKeyword_6_1_0());
            	      								
            	    }
            	    // InternalMetaData.g:723:9: ( (lv_description_14_0= RULE_STRING ) )
            	    // InternalMetaData.g:724:10: (lv_description_14_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:724:10: (lv_description_14_0= RULE_STRING )
            	    // InternalMetaData.g:725:11: lv_description_14_0= RULE_STRING
            	    {
            	    lv_description_14_0=(Token)match(input,RULE_STRING,FOLLOW_16); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_description_14_0, grammarAccess.getMdOptionAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdOptionRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"description",
            	      												lv_description_14_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 3 :
            	    // InternalMetaData.g:747:4: ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:747:4: ({...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:748:5: {...}? => ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 2) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 2)");
            	    }
            	    // InternalMetaData.g:748:105: ( ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:749:6: ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 2);
            	    // InternalMetaData.g:752:9: ({...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:752:10: {...}? => (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:752:19: (otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:752:20: otherlv_15= 'documentation' ( (lv_documentation_16_0= RULE_STRING ) )
            	    {
            	    otherlv_15=(Token)match(input,22,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_15, grammarAccess.getMdOptionAccess().getDocumentationKeyword_6_2_0());
            	      								
            	    }
            	    // InternalMetaData.g:756:9: ( (lv_documentation_16_0= RULE_STRING ) )
            	    // InternalMetaData.g:757:10: (lv_documentation_16_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:757:10: (lv_documentation_16_0= RULE_STRING )
            	    // InternalMetaData.g:758:11: lv_documentation_16_0= RULE_STRING
            	    {
            	    lv_documentation_16_0=(Token)match(input,RULE_STRING,FOLLOW_16); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_documentation_16_0, grammarAccess.getMdOptionAccess().getDocumentationSTRINGTerminalRuleCall_6_2_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdOptionRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"documentation",
            	      												lv_documentation_16_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 4 :
            	    // InternalMetaData.g:780:4: ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:780:4: ({...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) ) )
            	    // InternalMetaData.g:781:5: {...}? => ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 3) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 3)");
            	    }
            	    // InternalMetaData.g:781:105: ( ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) ) )
            	    // InternalMetaData.g:782:6: ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 3);
            	    // InternalMetaData.g:785:9: ({...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) ) )
            	    // InternalMetaData.g:785:10: {...}? => (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:785:19: (otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) ) )
            	    // InternalMetaData.g:785:20: otherlv_17= 'default' otherlv_18= '=' ( (lv_defaultValue_19_0= ruleXExpression ) )
            	    {
            	    otherlv_17=(Token)match(input,31,FOLLOW_17); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_17, grammarAccess.getMdOptionAccess().getDefaultKeyword_6_3_0());
            	      								
            	    }
            	    otherlv_18=(Token)match(input,32,FOLLOW_18); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_18, grammarAccess.getMdOptionAccess().getEqualsSignKeyword_6_3_1());
            	      								
            	    }
            	    // InternalMetaData.g:793:9: ( (lv_defaultValue_19_0= ruleXExpression ) )
            	    // InternalMetaData.g:794:10: (lv_defaultValue_19_0= ruleXExpression )
            	    {
            	    // InternalMetaData.g:794:10: (lv_defaultValue_19_0= ruleXExpression )
            	    // InternalMetaData.g:795:11: lv_defaultValue_19_0= ruleXExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdOptionAccess().getDefaultValueXExpressionParserRuleCall_6_3_2_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_16);
            	    lv_defaultValue_19_0=ruleXExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      											}
            	      											set(
            	      												current,
            	      												"defaultValue",
            	      												lv_defaultValue_19_0,
            	      												"org.eclipse.xtext.xbase.Xbase.XExpression");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 5 :
            	    // InternalMetaData.g:818:4: ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:818:4: ({...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) ) )
            	    // InternalMetaData.g:819:5: {...}? => ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 4) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 4)");
            	    }
            	    // InternalMetaData.g:819:105: ( ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) ) )
            	    // InternalMetaData.g:820:6: ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 4);
            	    // InternalMetaData.g:823:9: ({...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) ) )
            	    // InternalMetaData.g:823:10: {...}? => (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:823:19: (otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) ) )
            	    // InternalMetaData.g:823:20: otherlv_20= 'lowerBound' otherlv_21= '=' ( (lv_lowerBound_22_0= ruleXExpression ) )
            	    {
            	    otherlv_20=(Token)match(input,33,FOLLOW_17); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_20, grammarAccess.getMdOptionAccess().getLowerBoundKeyword_6_4_0());
            	      								
            	    }
            	    otherlv_21=(Token)match(input,32,FOLLOW_18); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_21, grammarAccess.getMdOptionAccess().getEqualsSignKeyword_6_4_1());
            	      								
            	    }
            	    // InternalMetaData.g:831:9: ( (lv_lowerBound_22_0= ruleXExpression ) )
            	    // InternalMetaData.g:832:10: (lv_lowerBound_22_0= ruleXExpression )
            	    {
            	    // InternalMetaData.g:832:10: (lv_lowerBound_22_0= ruleXExpression )
            	    // InternalMetaData.g:833:11: lv_lowerBound_22_0= ruleXExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdOptionAccess().getLowerBoundXExpressionParserRuleCall_6_4_2_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_16);
            	    lv_lowerBound_22_0=ruleXExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      											}
            	      											set(
            	      												current,
            	      												"lowerBound",
            	      												lv_lowerBound_22_0,
            	      												"org.eclipse.xtext.xbase.Xbase.XExpression");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 6 :
            	    // InternalMetaData.g:856:4: ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:856:4: ({...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) ) )
            	    // InternalMetaData.g:857:5: {...}? => ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 5) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 5)");
            	    }
            	    // InternalMetaData.g:857:105: ( ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) ) )
            	    // InternalMetaData.g:858:6: ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 5);
            	    // InternalMetaData.g:861:9: ({...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) ) )
            	    // InternalMetaData.g:861:10: {...}? => (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:861:19: (otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) ) )
            	    // InternalMetaData.g:861:20: otherlv_23= 'upperBound' otherlv_24= '=' ( (lv_upperBound_25_0= ruleXExpression ) )
            	    {
            	    otherlv_23=(Token)match(input,34,FOLLOW_17); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_23, grammarAccess.getMdOptionAccess().getUpperBoundKeyword_6_5_0());
            	      								
            	    }
            	    otherlv_24=(Token)match(input,32,FOLLOW_18); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_24, grammarAccess.getMdOptionAccess().getEqualsSignKeyword_6_5_1());
            	      								
            	    }
            	    // InternalMetaData.g:869:9: ( (lv_upperBound_25_0= ruleXExpression ) )
            	    // InternalMetaData.g:870:10: (lv_upperBound_25_0= ruleXExpression )
            	    {
            	    // InternalMetaData.g:870:10: (lv_upperBound_25_0= ruleXExpression )
            	    // InternalMetaData.g:871:11: lv_upperBound_25_0= ruleXExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdOptionAccess().getUpperBoundXExpressionParserRuleCall_6_5_2_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_16);
            	    lv_upperBound_25_0=ruleXExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      											}
            	      											set(
            	      												current,
            	      												"upperBound",
            	      												lv_upperBound_25_0,
            	      												"org.eclipse.xtext.xbase.Xbase.XExpression");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 7 :
            	    // InternalMetaData.g:894:4: ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) )
            	    {
            	    // InternalMetaData.g:894:4: ({...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) ) )
            	    // InternalMetaData.g:895:5: {...}? => ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 6) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 6)");
            	    }
            	    // InternalMetaData.g:895:105: ( ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) ) )
            	    // InternalMetaData.g:896:6: ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 6);
            	    // InternalMetaData.g:899:9: ({...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* ) )
            	    // InternalMetaData.g:899:10: {...}? => (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:899:19: (otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )* )
            	    // InternalMetaData.g:899:20: otherlv_26= 'targets' ( (lv_targets_27_0= ruleMdOptionTargetType ) ) (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )*
            	    {
            	    otherlv_26=(Token)match(input,35,FOLLOW_19); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_26, grammarAccess.getMdOptionAccess().getTargetsKeyword_6_6_0());
            	      								
            	    }
            	    // InternalMetaData.g:903:9: ( (lv_targets_27_0= ruleMdOptionTargetType ) )
            	    // InternalMetaData.g:904:10: (lv_targets_27_0= ruleMdOptionTargetType )
            	    {
            	    // InternalMetaData.g:904:10: (lv_targets_27_0= ruleMdOptionTargetType )
            	    // InternalMetaData.g:905:11: lv_targets_27_0= ruleMdOptionTargetType
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdOptionAccess().getTargetsMdOptionTargetTypeEnumRuleCall_6_6_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_20);
            	    lv_targets_27_0=ruleMdOptionTargetType();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      											}
            	      											add(
            	      												current,
            	      												"targets",
            	      												lv_targets_27_0,
            	      												"org.eclipse.elk.core.meta.MetaData.MdOptionTargetType");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:922:9: (otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) ) )*
            	    loop13:
            	    do {
            	        int alt13=2;
            	        int LA13_0 = input.LA(1);

            	        if ( (LA13_0==36) ) {
            	            alt13=1;
            	        }


            	        switch (alt13) {
            	    	case 1 :
            	    	    // InternalMetaData.g:923:10: otherlv_28= ',' ( (lv_targets_29_0= ruleMdOptionTargetType ) )
            	    	    {
            	    	    otherlv_28=(Token)match(input,36,FOLLOW_19); if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      										newLeafNode(otherlv_28, grammarAccess.getMdOptionAccess().getCommaKeyword_6_6_2_0());
            	    	      									
            	    	    }
            	    	    // InternalMetaData.g:927:10: ( (lv_targets_29_0= ruleMdOptionTargetType ) )
            	    	    // InternalMetaData.g:928:11: (lv_targets_29_0= ruleMdOptionTargetType )
            	    	    {
            	    	    // InternalMetaData.g:928:11: (lv_targets_29_0= ruleMdOptionTargetType )
            	    	    // InternalMetaData.g:929:12: lv_targets_29_0= ruleMdOptionTargetType
            	    	    {
            	    	    if ( state.backtracking==0 ) {

            	    	      												newCompositeNode(grammarAccess.getMdOptionAccess().getTargetsMdOptionTargetTypeEnumRuleCall_6_6_2_1_0());
            	    	      											
            	    	    }
            	    	    pushFollow(FOLLOW_20);
            	    	    lv_targets_29_0=ruleMdOptionTargetType();

            	    	    state._fsp--;
            	    	    if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      												if (current==null) {
            	    	      													current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	    	      												}
            	    	      												add(
            	    	      													current,
            	    	      													"targets",
            	    	      													lv_targets_29_0,
            	    	      													"org.eclipse.elk.core.meta.MetaData.MdOptionTargetType");
            	    	      												afterParserOrEnumRuleCall();
            	    	      											
            	    	    }

            	    	    }


            	    	    }


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop13;
            	        }
            	    } while (true);


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;
            	case 8 :
            	    // InternalMetaData.g:953:4: ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) )
            	    {
            	    // InternalMetaData.g:953:4: ({...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) ) )
            	    // InternalMetaData.g:954:5: {...}? => ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 7) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 7)");
            	    }
            	    // InternalMetaData.g:954:105: ( ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) ) )
            	    // InternalMetaData.g:955:6: ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdOptionAccess().getUnorderedGroup_6(), 7);
            	    // InternalMetaData.g:958:9: ({...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* ) )
            	    // InternalMetaData.g:958:10: {...}? => (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdOption", "true");
            	    }
            	    // InternalMetaData.g:958:19: (otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )* )
            	    // InternalMetaData.g:958:20: otherlv_30= 'legacyIds' ( (lv_legacyIds_31_0= ruleQualifiedName ) ) (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )*
            	    {
            	    otherlv_30=(Token)match(input,37,FOLLOW_3); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_30, grammarAccess.getMdOptionAccess().getLegacyIdsKeyword_6_7_0());
            	      								
            	    }
            	    // InternalMetaData.g:962:9: ( (lv_legacyIds_31_0= ruleQualifiedName ) )
            	    // InternalMetaData.g:963:10: (lv_legacyIds_31_0= ruleQualifiedName )
            	    {
            	    // InternalMetaData.g:963:10: (lv_legacyIds_31_0= ruleQualifiedName )
            	    // InternalMetaData.g:964:11: lv_legacyIds_31_0= ruleQualifiedName
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdOptionAccess().getLegacyIdsQualifiedNameParserRuleCall_6_7_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_20);
            	    lv_legacyIds_31_0=ruleQualifiedName();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      											}
            	      											add(
            	      												current,
            	      												"legacyIds",
            	      												lv_legacyIds_31_0,
            	      												"org.eclipse.xtext.xbase.Xbase.QualifiedName");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:981:9: (otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) ) )*
            	    loop14:
            	    do {
            	        int alt14=2;
            	        int LA14_0 = input.LA(1);

            	        if ( (LA14_0==36) ) {
            	            alt14=1;
            	        }


            	        switch (alt14) {
            	    	case 1 :
            	    	    // InternalMetaData.g:982:10: otherlv_32= ',' ( (lv_legacyIds_33_0= ruleQualifiedName ) )
            	    	    {
            	    	    otherlv_32=(Token)match(input,36,FOLLOW_3); if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      										newLeafNode(otherlv_32, grammarAccess.getMdOptionAccess().getCommaKeyword_6_7_2_0());
            	    	      									
            	    	    }
            	    	    // InternalMetaData.g:986:10: ( (lv_legacyIds_33_0= ruleQualifiedName ) )
            	    	    // InternalMetaData.g:987:11: (lv_legacyIds_33_0= ruleQualifiedName )
            	    	    {
            	    	    // InternalMetaData.g:987:11: (lv_legacyIds_33_0= ruleQualifiedName )
            	    	    // InternalMetaData.g:988:12: lv_legacyIds_33_0= ruleQualifiedName
            	    	    {
            	    	    if ( state.backtracking==0 ) {

            	    	      												newCompositeNode(grammarAccess.getMdOptionAccess().getLegacyIdsQualifiedNameParserRuleCall_6_7_2_1_0());
            	    	      											
            	    	    }
            	    	    pushFollow(FOLLOW_20);
            	    	    lv_legacyIds_33_0=ruleQualifiedName();

            	    	    state._fsp--;
            	    	    if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      												if (current==null) {
            	    	      													current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	    	      												}
            	    	      												add(
            	    	      													current,
            	    	      													"legacyIds",
            	    	      													lv_legacyIds_33_0,
            	    	      													"org.eclipse.xtext.xbase.Xbase.QualifiedName");
            	    	      												afterParserOrEnumRuleCall();
            	    	      											
            	    	    }

            	    	    }


            	    	    }


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop14;
            	        }
            	    } while (true);


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);


            }


            }

            getUnorderedGroupHelper().leave(grammarAccess.getMdOptionAccess().getUnorderedGroup_6());

            }

            // InternalMetaData.g:1019:3: ( (lv_dependencies_34_0= ruleMdOptionDependency ) )*
            loop16:
            do {
                int alt16=2;
                int LA16_0 = input.LA(1);

                if ( (LA16_0==38) ) {
                    alt16=1;
                }


                switch (alt16) {
            	case 1 :
            	    // InternalMetaData.g:1020:4: (lv_dependencies_34_0= ruleMdOptionDependency )
            	    {
            	    // InternalMetaData.g:1020:4: (lv_dependencies_34_0= ruleMdOptionDependency )
            	    // InternalMetaData.g:1021:5: lv_dependencies_34_0= ruleMdOptionDependency
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getMdOptionAccess().getDependenciesMdOptionDependencyParserRuleCall_7_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_21);
            	    lv_dependencies_34_0=ruleMdOptionDependency();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getMdOptionRule());
            	      					}
            	      					add(
            	      						current,
            	      						"dependencies",
            	      						lv_dependencies_34_0,
            	      						"org.eclipse.elk.core.meta.MetaData.MdOptionDependency");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop16;
                }
            } while (true);

            otherlv_35=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_35, grammarAccess.getMdOptionAccess().getRightCurlyBracketKeyword_8());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdOption"


    // $ANTLR start "entryRuleMdOptionDependency"
    // InternalMetaData.g:1046:1: entryRuleMdOptionDependency returns [EObject current=null] : iv_ruleMdOptionDependency= ruleMdOptionDependency EOF ;
    public final EObject entryRuleMdOptionDependency() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdOptionDependency = null;


        try {
            // InternalMetaData.g:1046:59: (iv_ruleMdOptionDependency= ruleMdOptionDependency EOF )
            // InternalMetaData.g:1047:2: iv_ruleMdOptionDependency= ruleMdOptionDependency EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdOptionDependencyRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdOptionDependency=ruleMdOptionDependency();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdOptionDependency; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdOptionDependency"


    // $ANTLR start "ruleMdOptionDependency"
    // InternalMetaData.g:1053:1: ruleMdOptionDependency returns [EObject current=null] : (otherlv_0= 'requires' ( ( ruleQualifiedName ) ) (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )? ) ;
    public final EObject ruleMdOptionDependency() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_value_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1059:2: ( (otherlv_0= 'requires' ( ( ruleQualifiedName ) ) (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )? ) )
            // InternalMetaData.g:1060:2: (otherlv_0= 'requires' ( ( ruleQualifiedName ) ) (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )? )
            {
            // InternalMetaData.g:1060:2: (otherlv_0= 'requires' ( ( ruleQualifiedName ) ) (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )? )
            // InternalMetaData.g:1061:3: otherlv_0= 'requires' ( ( ruleQualifiedName ) ) (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )?
            {
            otherlv_0=(Token)match(input,38,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getMdOptionDependencyAccess().getRequiresKeyword_0());
              		
            }
            // InternalMetaData.g:1065:3: ( ( ruleQualifiedName ) )
            // InternalMetaData.g:1066:4: ( ruleQualifiedName )
            {
            // InternalMetaData.g:1066:4: ( ruleQualifiedName )
            // InternalMetaData.g:1067:5: ruleQualifiedName
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdOptionDependencyRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getMdOptionDependencyAccess().getTargetMdOptionCrossReference_1_0());
              				
            }
            pushFollow(FOLLOW_22);
            ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:1081:3: (otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) ) )?
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0==39) ) {
                alt17=1;
            }
            switch (alt17) {
                case 1 :
                    // InternalMetaData.g:1082:4: otherlv_2= '==' ( (lv_value_3_0= ruleXExpression ) )
                    {
                    otherlv_2=(Token)match(input,39,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getMdOptionDependencyAccess().getEqualsSignEqualsSignKeyword_2_0());
                      			
                    }
                    // InternalMetaData.g:1086:4: ( (lv_value_3_0= ruleXExpression ) )
                    // InternalMetaData.g:1087:5: (lv_value_3_0= ruleXExpression )
                    {
                    // InternalMetaData.g:1087:5: (lv_value_3_0= ruleXExpression )
                    // InternalMetaData.g:1088:6: lv_value_3_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getMdOptionDependencyAccess().getValueXExpressionParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_value_3_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getMdOptionDependencyRule());
                      						}
                      						set(
                      							current,
                      							"value",
                      							lv_value_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdOptionDependency"


    // $ANTLR start "entryRuleMdAlgorithm"
    // InternalMetaData.g:1110:1: entryRuleMdAlgorithm returns [EObject current=null] : iv_ruleMdAlgorithm= ruleMdAlgorithm EOF ;
    public final EObject entryRuleMdAlgorithm() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdAlgorithm = null;


        try {
            // InternalMetaData.g:1110:52: (iv_ruleMdAlgorithm= ruleMdAlgorithm EOF )
            // InternalMetaData.g:1111:2: iv_ruleMdAlgorithm= ruleMdAlgorithm EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdAlgorithmRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdAlgorithm=ruleMdAlgorithm();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdAlgorithm; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdAlgorithm"


    // $ANTLR start "ruleMdAlgorithm"
    // InternalMetaData.g:1117:1: ruleMdAlgorithm returns [EObject current=null] : ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'algorithm' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '(' ( (lv_provider_4_0= ruleJvmTypeReference ) ) (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )? otherlv_7= ')' otherlv_8= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) ) ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )* otherlv_29= '}' ) ;
    public final EObject ruleMdAlgorithm() throws RecognitionException {
        EObject current = null;

        Token lv_deprecated_0_0=null;
        Token otherlv_1=null;
        Token lv_name_2_0=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token lv_parameter_6_0=null;
        Token otherlv_7=null;
        Token otherlv_8=null;
        Token otherlv_10=null;
        Token lv_label_11_0=null;
        Token otherlv_12=null;
        Token otherlv_14=null;
        Token lv_description_15_0=null;
        Token otherlv_16=null;
        Token lv_documentation_17_0=null;
        Token otherlv_18=null;
        Token otherlv_20=null;
        Token otherlv_22=null;
        Token otherlv_24=null;
        Token otherlv_26=null;
        Token otherlv_29=null;
        EObject lv_provider_4_0 = null;

        AntlrDatatypeRuleToken lv_targetClass_13_0 = null;

        AntlrDatatypeRuleToken lv_previewImage_21_0 = null;

        Enumerator lv_supportedFeatures_23_0 = null;

        Enumerator lv_supportedFeatures_25_0 = null;

        EObject lv_validator_27_0 = null;

        EObject lv_supportedOptions_28_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1123:2: ( ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'algorithm' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '(' ( (lv_provider_4_0= ruleJvmTypeReference ) ) (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )? otherlv_7= ')' otherlv_8= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) ) ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )* otherlv_29= '}' ) )
            // InternalMetaData.g:1124:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'algorithm' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '(' ( (lv_provider_4_0= ruleJvmTypeReference ) ) (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )? otherlv_7= ')' otherlv_8= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) ) ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )* otherlv_29= '}' )
            {
            // InternalMetaData.g:1124:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'algorithm' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '(' ( (lv_provider_4_0= ruleJvmTypeReference ) ) (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )? otherlv_7= ')' otherlv_8= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) ) ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )* otherlv_29= '}' )
            // InternalMetaData.g:1125:3: ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'algorithm' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '(' ( (lv_provider_4_0= ruleJvmTypeReference ) ) (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )? otherlv_7= ')' otherlv_8= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) ) ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )* otherlv_29= '}'
            {
            // InternalMetaData.g:1125:3: ( (lv_deprecated_0_0= 'deprecated' ) )?
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( (LA18_0==23) ) {
                alt18=1;
            }
            switch (alt18) {
                case 1 :
                    // InternalMetaData.g:1126:4: (lv_deprecated_0_0= 'deprecated' )
                    {
                    // InternalMetaData.g:1126:4: (lv_deprecated_0_0= 'deprecated' )
                    // InternalMetaData.g:1127:5: lv_deprecated_0_0= 'deprecated'
                    {
                    lv_deprecated_0_0=(Token)match(input,23,FOLLOW_23); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_deprecated_0_0, grammarAccess.getMdAlgorithmAccess().getDeprecatedDeprecatedKeyword_0_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getMdAlgorithmRule());
                      					}
                      					setWithLastConsumed(current, "deprecated", true, "deprecated");
                      				
                    }

                    }


                    }
                    break;

            }

            otherlv_1=(Token)match(input,40,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getMdAlgorithmAccess().getAlgorithmKeyword_1());
              		
            }
            // InternalMetaData.g:1143:3: ( (lv_name_2_0= RULE_ID ) )
            // InternalMetaData.g:1144:4: (lv_name_2_0= RULE_ID )
            {
            // InternalMetaData.g:1144:4: (lv_name_2_0= RULE_ID )
            // InternalMetaData.g:1145:5: lv_name_2_0= RULE_ID
            {
            lv_name_2_0=(Token)match(input,RULE_ID,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(lv_name_2_0, grammarAccess.getMdAlgorithmAccess().getNameIDTerminalRuleCall_2_0());
              				
            }
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdAlgorithmRule());
              					}
              					setWithLastConsumed(
              						current,
              						"name",
              						lv_name_2_0,
              						"org.eclipse.xtext.xbase.Xtype.ID");
              				
            }

            }


            }

            otherlv_3=(Token)match(input,41,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getMdAlgorithmAccess().getLeftParenthesisKeyword_3());
              		
            }
            // InternalMetaData.g:1165:3: ( (lv_provider_4_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:1166:4: (lv_provider_4_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:1166:4: (lv_provider_4_0= ruleJvmTypeReference )
            // InternalMetaData.g:1167:5: lv_provider_4_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getMdAlgorithmAccess().getProviderJvmTypeReferenceParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_25);
            lv_provider_4_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
              					}
              					set(
              						current,
              						"provider",
              						lv_provider_4_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:1184:3: (otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) ) )?
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==42) ) {
                alt19=1;
            }
            switch (alt19) {
                case 1 :
                    // InternalMetaData.g:1185:4: otherlv_5= '#' ( (lv_parameter_6_0= RULE_ID ) )
                    {
                    otherlv_5=(Token)match(input,42,FOLLOW_3); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_5, grammarAccess.getMdAlgorithmAccess().getNumberSignKeyword_5_0());
                      			
                    }
                    // InternalMetaData.g:1189:4: ( (lv_parameter_6_0= RULE_ID ) )
                    // InternalMetaData.g:1190:5: (lv_parameter_6_0= RULE_ID )
                    {
                    // InternalMetaData.g:1190:5: (lv_parameter_6_0= RULE_ID )
                    // InternalMetaData.g:1191:6: lv_parameter_6_0= RULE_ID
                    {
                    lv_parameter_6_0=(Token)match(input,RULE_ID,FOLLOW_26); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_parameter_6_0, grammarAccess.getMdAlgorithmAccess().getParameterIDTerminalRuleCall_5_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdAlgorithmRule());
                      						}
                      						setWithLastConsumed(
                      							current,
                      							"parameter",
                      							lv_parameter_6_0,
                      							"org.eclipse.xtext.xbase.Xtype.ID");
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,43,FOLLOW_6); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_7, grammarAccess.getMdAlgorithmAccess().getRightParenthesisKeyword_6());
              		
            }
            otherlv_8=(Token)match(input,15,FOLLOW_27); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_8, grammarAccess.getMdAlgorithmAccess().getLeftCurlyBracketKeyword_7());
              		
            }
            // InternalMetaData.g:1216:3: ( ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) ) )
            // InternalMetaData.g:1217:4: ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) )
            {
            // InternalMetaData.g:1217:4: ( ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* ) )
            // InternalMetaData.g:1218:5: ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* )
            {
            getUnorderedGroupHelper().enter(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());
            // InternalMetaData.g:1221:5: ( ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )* )
            // InternalMetaData.g:1222:6: ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )*
            {
            // InternalMetaData.g:1222:6: ( ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) ) | ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) ) )*
            loop21:
            do {
                int alt21=9;
                alt21 = dfa21.predict(input);
                switch (alt21) {
            	case 1 :
            	    // InternalMetaData.g:1223:4: ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1223:4: ({...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1224:5: {...}? => ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 0) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 0)");
            	    }
            	    // InternalMetaData.g:1224:108: ( ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1225:6: ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 0);
            	    // InternalMetaData.g:1228:9: ({...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1228:10: {...}? => (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1228:19: (otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1228:20: otherlv_10= 'label' ( (lv_label_11_0= RULE_STRING ) )
            	    {
            	    otherlv_10=(Token)match(input,16,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_10, grammarAccess.getMdAlgorithmAccess().getLabelKeyword_8_0_0());
            	      								
            	    }
            	    // InternalMetaData.g:1232:9: ( (lv_label_11_0= RULE_STRING ) )
            	    // InternalMetaData.g:1233:10: (lv_label_11_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1233:10: (lv_label_11_0= RULE_STRING )
            	    // InternalMetaData.g:1234:11: lv_label_11_0= RULE_STRING
            	    {
            	    lv_label_11_0=(Token)match(input,RULE_STRING,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_label_11_0, grammarAccess.getMdAlgorithmAccess().getLabelSTRINGTerminalRuleCall_8_0_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"label",
            	      												lv_label_11_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    // InternalMetaData.g:1256:4: ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1256:4: ({...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) ) )
            	    // InternalMetaData.g:1257:5: {...}? => ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 1) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 1)");
            	    }
            	    // InternalMetaData.g:1257:108: ( ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) ) )
            	    // InternalMetaData.g:1258:6: ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 1);
            	    // InternalMetaData.g:1261:9: ({...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) ) )
            	    // InternalMetaData.g:1261:10: {...}? => (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1261:19: (otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) ) )
            	    // InternalMetaData.g:1261:20: otherlv_12= 'metadataClass' ( (lv_targetClass_13_0= ruleQualifiedName ) )
            	    {
            	    otherlv_12=(Token)match(input,17,FOLLOW_3); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_12, grammarAccess.getMdAlgorithmAccess().getMetadataClassKeyword_8_1_0());
            	      								
            	    }
            	    // InternalMetaData.g:1265:9: ( (lv_targetClass_13_0= ruleQualifiedName ) )
            	    // InternalMetaData.g:1266:10: (lv_targetClass_13_0= ruleQualifiedName )
            	    {
            	    // InternalMetaData.g:1266:10: (lv_targetClass_13_0= ruleQualifiedName )
            	    // InternalMetaData.g:1267:11: lv_targetClass_13_0= ruleQualifiedName
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdAlgorithmAccess().getTargetClassQualifiedNameParserRuleCall_8_1_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_27);
            	    lv_targetClass_13_0=ruleQualifiedName();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											set(
            	      												current,
            	      												"targetClass",
            	      												lv_targetClass_13_0,
            	      												"org.eclipse.xtext.xbase.Xbase.QualifiedName");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 3 :
            	    // InternalMetaData.g:1290:4: ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1290:4: ({...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1291:5: {...}? => ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 2) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 2)");
            	    }
            	    // InternalMetaData.g:1291:108: ( ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1292:6: ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 2);
            	    // InternalMetaData.g:1295:9: ({...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1295:10: {...}? => (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1295:19: (otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1295:20: otherlv_14= 'description' ( (lv_description_15_0= RULE_STRING ) )
            	    {
            	    otherlv_14=(Token)match(input,30,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_14, grammarAccess.getMdAlgorithmAccess().getDescriptionKeyword_8_2_0());
            	      								
            	    }
            	    // InternalMetaData.g:1299:9: ( (lv_description_15_0= RULE_STRING ) )
            	    // InternalMetaData.g:1300:10: (lv_description_15_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1300:10: (lv_description_15_0= RULE_STRING )
            	    // InternalMetaData.g:1301:11: lv_description_15_0= RULE_STRING
            	    {
            	    lv_description_15_0=(Token)match(input,RULE_STRING,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_description_15_0, grammarAccess.getMdAlgorithmAccess().getDescriptionSTRINGTerminalRuleCall_8_2_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"description",
            	      												lv_description_15_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 4 :
            	    // InternalMetaData.g:1323:4: ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1323:4: ({...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1324:5: {...}? => ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 3) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 3)");
            	    }
            	    // InternalMetaData.g:1324:108: ( ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1325:6: ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 3);
            	    // InternalMetaData.g:1328:9: ({...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1328:10: {...}? => (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1328:19: (otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1328:20: otherlv_16= 'documentation' ( (lv_documentation_17_0= RULE_STRING ) )
            	    {
            	    otherlv_16=(Token)match(input,22,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_16, grammarAccess.getMdAlgorithmAccess().getDocumentationKeyword_8_3_0());
            	      								
            	    }
            	    // InternalMetaData.g:1332:9: ( (lv_documentation_17_0= RULE_STRING ) )
            	    // InternalMetaData.g:1333:10: (lv_documentation_17_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1333:10: (lv_documentation_17_0= RULE_STRING )
            	    // InternalMetaData.g:1334:11: lv_documentation_17_0= RULE_STRING
            	    {
            	    lv_documentation_17_0=(Token)match(input,RULE_STRING,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_documentation_17_0, grammarAccess.getMdAlgorithmAccess().getDocumentationSTRINGTerminalRuleCall_8_3_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"documentation",
            	      												lv_documentation_17_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 5 :
            	    // InternalMetaData.g:1356:4: ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1356:4: ({...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) ) )
            	    // InternalMetaData.g:1357:5: {...}? => ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 4) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 4)");
            	    }
            	    // InternalMetaData.g:1357:108: ( ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) ) )
            	    // InternalMetaData.g:1358:6: ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 4);
            	    // InternalMetaData.g:1361:9: ({...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) ) )
            	    // InternalMetaData.g:1361:10: {...}? => (otherlv_18= 'category' ( ( ruleQualifiedName ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1361:19: (otherlv_18= 'category' ( ( ruleQualifiedName ) ) )
            	    // InternalMetaData.g:1361:20: otherlv_18= 'category' ( ( ruleQualifiedName ) )
            	    {
            	    otherlv_18=(Token)match(input,44,FOLLOW_3); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_18, grammarAccess.getMdAlgorithmAccess().getCategoryKeyword_8_4_0());
            	      								
            	    }
            	    // InternalMetaData.g:1365:9: ( ( ruleQualifiedName ) )
            	    // InternalMetaData.g:1366:10: ( ruleQualifiedName )
            	    {
            	    // InternalMetaData.g:1366:10: ( ruleQualifiedName )
            	    // InternalMetaData.g:1367:11: ruleQualifiedName
            	    {
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdAlgorithmAccess().getCategoryMdCategoryCrossReference_8_4_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_27);
            	    ruleQualifiedName();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 6 :
            	    // InternalMetaData.g:1387:4: ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1387:4: ({...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) ) )
            	    // InternalMetaData.g:1388:5: {...}? => ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 5) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 5)");
            	    }
            	    // InternalMetaData.g:1388:108: ( ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) ) )
            	    // InternalMetaData.g:1389:6: ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 5);
            	    // InternalMetaData.g:1392:9: ({...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) ) )
            	    // InternalMetaData.g:1392:10: {...}? => (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1392:19: (otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) ) )
            	    // InternalMetaData.g:1392:20: otherlv_20= 'preview' ( (lv_previewImage_21_0= rulePath ) )
            	    {
            	    otherlv_20=(Token)match(input,45,FOLLOW_3); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_20, grammarAccess.getMdAlgorithmAccess().getPreviewKeyword_8_5_0());
            	      								
            	    }
            	    // InternalMetaData.g:1396:9: ( (lv_previewImage_21_0= rulePath ) )
            	    // InternalMetaData.g:1397:10: (lv_previewImage_21_0= rulePath )
            	    {
            	    // InternalMetaData.g:1397:10: (lv_previewImage_21_0= rulePath )
            	    // InternalMetaData.g:1398:11: lv_previewImage_21_0= rulePath
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdAlgorithmAccess().getPreviewImagePathParserRuleCall_8_5_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_27);
            	    lv_previewImage_21_0=rulePath();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											set(
            	      												current,
            	      												"previewImage",
            	      												lv_previewImage_21_0,
            	      												"org.eclipse.elk.core.meta.MetaData.Path");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 7 :
            	    // InternalMetaData.g:1421:4: ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) )
            	    {
            	    // InternalMetaData.g:1421:4: ({...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) ) )
            	    // InternalMetaData.g:1422:5: {...}? => ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 6) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 6)");
            	    }
            	    // InternalMetaData.g:1422:108: ( ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) ) )
            	    // InternalMetaData.g:1423:6: ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 6);
            	    // InternalMetaData.g:1426:9: ({...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* ) )
            	    // InternalMetaData.g:1426:10: {...}? => (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1426:19: (otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )* )
            	    // InternalMetaData.g:1426:20: otherlv_22= 'features' ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) ) (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )*
            	    {
            	    otherlv_22=(Token)match(input,46,FOLLOW_28); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_22, grammarAccess.getMdAlgorithmAccess().getFeaturesKeyword_8_6_0());
            	      								
            	    }
            	    // InternalMetaData.g:1430:9: ( (lv_supportedFeatures_23_0= ruleMdGraphFeature ) )
            	    // InternalMetaData.g:1431:10: (lv_supportedFeatures_23_0= ruleMdGraphFeature )
            	    {
            	    // InternalMetaData.g:1431:10: (lv_supportedFeatures_23_0= ruleMdGraphFeature )
            	    // InternalMetaData.g:1432:11: lv_supportedFeatures_23_0= ruleMdGraphFeature
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdAlgorithmAccess().getSupportedFeaturesMdGraphFeatureEnumRuleCall_8_6_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_29);
            	    lv_supportedFeatures_23_0=ruleMdGraphFeature();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											add(
            	      												current,
            	      												"supportedFeatures",
            	      												lv_supportedFeatures_23_0,
            	      												"org.eclipse.elk.core.meta.MetaData.MdGraphFeature");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:1449:9: (otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) ) )*
            	    loop20:
            	    do {
            	        int alt20=2;
            	        int LA20_0 = input.LA(1);

            	        if ( (LA20_0==36) ) {
            	            alt20=1;
            	        }


            	        switch (alt20) {
            	    	case 1 :
            	    	    // InternalMetaData.g:1450:10: otherlv_24= ',' ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) )
            	    	    {
            	    	    otherlv_24=(Token)match(input,36,FOLLOW_28); if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      										newLeafNode(otherlv_24, grammarAccess.getMdAlgorithmAccess().getCommaKeyword_8_6_2_0());
            	    	      									
            	    	    }
            	    	    // InternalMetaData.g:1454:10: ( (lv_supportedFeatures_25_0= ruleMdGraphFeature ) )
            	    	    // InternalMetaData.g:1455:11: (lv_supportedFeatures_25_0= ruleMdGraphFeature )
            	    	    {
            	    	    // InternalMetaData.g:1455:11: (lv_supportedFeatures_25_0= ruleMdGraphFeature )
            	    	    // InternalMetaData.g:1456:12: lv_supportedFeatures_25_0= ruleMdGraphFeature
            	    	    {
            	    	    if ( state.backtracking==0 ) {

            	    	      												newCompositeNode(grammarAccess.getMdAlgorithmAccess().getSupportedFeaturesMdGraphFeatureEnumRuleCall_8_6_2_1_0());
            	    	      											
            	    	    }
            	    	    pushFollow(FOLLOW_29);
            	    	    lv_supportedFeatures_25_0=ruleMdGraphFeature();

            	    	    state._fsp--;
            	    	    if (state.failed) return current;
            	    	    if ( state.backtracking==0 ) {

            	    	      												if (current==null) {
            	    	      													current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	    	      												}
            	    	      												add(
            	    	      													current,
            	    	      													"supportedFeatures",
            	    	      													lv_supportedFeatures_25_0,
            	    	      													"org.eclipse.elk.core.meta.MetaData.MdGraphFeature");
            	    	      												afterParserOrEnumRuleCall();
            	    	      											
            	    	    }

            	    	    }


            	    	    }


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop20;
            	        }
            	    } while (true);


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;
            	case 8 :
            	    // InternalMetaData.g:1480:4: ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1480:4: ({...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) ) )
            	    // InternalMetaData.g:1481:5: {...}? => ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 7) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 7)");
            	    }
            	    // InternalMetaData.g:1481:108: ( ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) ) )
            	    // InternalMetaData.g:1482:6: ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8(), 7);
            	    // InternalMetaData.g:1485:9: ({...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) ) )
            	    // InternalMetaData.g:1485:10: {...}? => (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdAlgorithm", "true");
            	    }
            	    // InternalMetaData.g:1485:19: (otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) ) )
            	    // InternalMetaData.g:1485:20: otherlv_26= 'validator' ( (lv_validator_27_0= ruleJvmTypeReference ) )
            	    {
            	    otherlv_26=(Token)match(input,47,FOLLOW_15); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_26, grammarAccess.getMdAlgorithmAccess().getValidatorKeyword_8_7_0());
            	      								
            	    }
            	    // InternalMetaData.g:1489:9: ( (lv_validator_27_0= ruleJvmTypeReference ) )
            	    // InternalMetaData.g:1490:10: (lv_validator_27_0= ruleJvmTypeReference )
            	    {
            	    // InternalMetaData.g:1490:10: (lv_validator_27_0= ruleJvmTypeReference )
            	    // InternalMetaData.g:1491:11: lv_validator_27_0= ruleJvmTypeReference
            	    {
            	    if ( state.backtracking==0 ) {

            	      											newCompositeNode(grammarAccess.getMdAlgorithmAccess().getValidatorJvmTypeReferenceParserRuleCall_8_7_1_0());
            	      										
            	    }
            	    pushFollow(FOLLOW_27);
            	    lv_validator_27_0=ruleJvmTypeReference();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	      											}
            	      											set(
            	      												current,
            	      												"validator",
            	      												lv_validator_27_0,
            	      												"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
            	      											afterParserOrEnumRuleCall();
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);


            }


            }

            getUnorderedGroupHelper().leave(grammarAccess.getMdAlgorithmAccess().getUnorderedGroup_8());

            }

            // InternalMetaData.g:1521:3: ( (lv_supportedOptions_28_0= ruleMdOptionSupport ) )*
            loop22:
            do {
                int alt22=2;
                int LA22_0 = input.LA(1);

                if ( (LA22_0==48) ) {
                    alt22=1;
                }


                switch (alt22) {
            	case 1 :
            	    // InternalMetaData.g:1522:4: (lv_supportedOptions_28_0= ruleMdOptionSupport )
            	    {
            	    // InternalMetaData.g:1522:4: (lv_supportedOptions_28_0= ruleMdOptionSupport )
            	    // InternalMetaData.g:1523:5: lv_supportedOptions_28_0= ruleMdOptionSupport
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getMdAlgorithmAccess().getSupportedOptionsMdOptionSupportParserRuleCall_9_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_30);
            	    lv_supportedOptions_28_0=ruleMdOptionSupport();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getMdAlgorithmRule());
            	      					}
            	      					add(
            	      						current,
            	      						"supportedOptions",
            	      						lv_supportedOptions_28_0,
            	      						"org.eclipse.elk.core.meta.MetaData.MdOptionSupport");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop22;
                }
            } while (true);

            otherlv_29=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_29, grammarAccess.getMdAlgorithmAccess().getRightCurlyBracketKeyword_10());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdAlgorithm"


    // $ANTLR start "entryRuleMdCategory"
    // InternalMetaData.g:1548:1: entryRuleMdCategory returns [EObject current=null] : iv_ruleMdCategory= ruleMdCategory EOF ;
    public final EObject entryRuleMdCategory() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdCategory = null;


        try {
            // InternalMetaData.g:1548:51: (iv_ruleMdCategory= ruleMdCategory EOF )
            // InternalMetaData.g:1549:2: iv_ruleMdCategory= ruleMdCategory EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdCategoryRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdCategory=ruleMdCategory();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdCategory; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdCategory"


    // $ANTLR start "ruleMdCategory"
    // InternalMetaData.g:1555:1: ruleMdCategory returns [EObject current=null] : ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'category' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) ) otherlv_11= '}' ) ;
    public final EObject ruleMdCategory() throws RecognitionException {
        EObject current = null;

        Token lv_deprecated_0_0=null;
        Token otherlv_1=null;
        Token lv_name_2_0=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token lv_label_6_0=null;
        Token otherlv_7=null;
        Token lv_description_8_0=null;
        Token otherlv_9=null;
        Token lv_documentation_10_0=null;
        Token otherlv_11=null;


        	enterRule();

        try {
            // InternalMetaData.g:1561:2: ( ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'category' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) ) otherlv_11= '}' ) )
            // InternalMetaData.g:1562:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'category' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) ) otherlv_11= '}' )
            {
            // InternalMetaData.g:1562:2: ( ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'category' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) ) otherlv_11= '}' )
            // InternalMetaData.g:1563:3: ( (lv_deprecated_0_0= 'deprecated' ) )? otherlv_1= 'category' ( (lv_name_2_0= RULE_ID ) ) otherlv_3= '{' ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) ) otherlv_11= '}'
            {
            // InternalMetaData.g:1563:3: ( (lv_deprecated_0_0= 'deprecated' ) )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==23) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // InternalMetaData.g:1564:4: (lv_deprecated_0_0= 'deprecated' )
                    {
                    // InternalMetaData.g:1564:4: (lv_deprecated_0_0= 'deprecated' )
                    // InternalMetaData.g:1565:5: lv_deprecated_0_0= 'deprecated'
                    {
                    lv_deprecated_0_0=(Token)match(input,23,FOLLOW_31); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_deprecated_0_0, grammarAccess.getMdCategoryAccess().getDeprecatedDeprecatedKeyword_0_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getMdCategoryRule());
                      					}
                      					setWithLastConsumed(current, "deprecated", true, "deprecated");
                      				
                    }

                    }


                    }
                    break;

            }

            otherlv_1=(Token)match(input,44,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getMdCategoryAccess().getCategoryKeyword_1());
              		
            }
            // InternalMetaData.g:1581:3: ( (lv_name_2_0= RULE_ID ) )
            // InternalMetaData.g:1582:4: (lv_name_2_0= RULE_ID )
            {
            // InternalMetaData.g:1582:4: (lv_name_2_0= RULE_ID )
            // InternalMetaData.g:1583:5: lv_name_2_0= RULE_ID
            {
            lv_name_2_0=(Token)match(input,RULE_ID,FOLLOW_6); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(lv_name_2_0, grammarAccess.getMdCategoryAccess().getNameIDTerminalRuleCall_2_0());
              				
            }
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdCategoryRule());
              					}
              					setWithLastConsumed(
              						current,
              						"name",
              						lv_name_2_0,
              						"org.eclipse.xtext.xbase.Xtype.ID");
              				
            }

            }


            }

            otherlv_3=(Token)match(input,15,FOLLOW_32); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getMdCategoryAccess().getLeftCurlyBracketKeyword_3());
              		
            }
            // InternalMetaData.g:1603:3: ( ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) ) )
            // InternalMetaData.g:1604:4: ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) )
            {
            // InternalMetaData.g:1604:4: ( ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* ) )
            // InternalMetaData.g:1605:5: ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* )
            {
            getUnorderedGroupHelper().enter(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4());
            // InternalMetaData.g:1608:5: ( ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )* )
            // InternalMetaData.g:1609:6: ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )*
            {
            // InternalMetaData.g:1609:6: ( ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) ) | ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) ) )*
            loop24:
            do {
                int alt24=4;
                int LA24_0 = input.LA(1);

                if ( LA24_0 == 16 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 0) ) {
                    alt24=1;
                }
                else if ( LA24_0 == 30 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 1) ) {
                    alt24=2;
                }
                else if ( LA24_0 == 22 && getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 2) ) {
                    alt24=3;
                }


                switch (alt24) {
            	case 1 :
            	    // InternalMetaData.g:1610:4: ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1610:4: ({...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1611:5: {...}? => ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 0) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 0)");
            	    }
            	    // InternalMetaData.g:1611:107: ( ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1612:6: ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 0);
            	    // InternalMetaData.g:1615:9: ({...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1615:10: {...}? => (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "true");
            	    }
            	    // InternalMetaData.g:1615:19: (otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1615:20: otherlv_5= 'label' ( (lv_label_6_0= RULE_STRING ) )
            	    {
            	    otherlv_5=(Token)match(input,16,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_5, grammarAccess.getMdCategoryAccess().getLabelKeyword_4_0_0());
            	      								
            	    }
            	    // InternalMetaData.g:1619:9: ( (lv_label_6_0= RULE_STRING ) )
            	    // InternalMetaData.g:1620:10: (lv_label_6_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1620:10: (lv_label_6_0= RULE_STRING )
            	    // InternalMetaData.g:1621:11: lv_label_6_0= RULE_STRING
            	    {
            	    lv_label_6_0=(Token)match(input,RULE_STRING,FOLLOW_32); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_label_6_0, grammarAccess.getMdCategoryAccess().getLabelSTRINGTerminalRuleCall_4_0_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdCategoryRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"label",
            	      												lv_label_6_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4());

            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    // InternalMetaData.g:1643:4: ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1643:4: ({...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1644:5: {...}? => ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 1) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 1)");
            	    }
            	    // InternalMetaData.g:1644:107: ( ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1645:6: ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 1);
            	    // InternalMetaData.g:1648:9: ({...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1648:10: {...}? => (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "true");
            	    }
            	    // InternalMetaData.g:1648:19: (otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1648:20: otherlv_7= 'description' ( (lv_description_8_0= RULE_STRING ) )
            	    {
            	    otherlv_7=(Token)match(input,30,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_7, grammarAccess.getMdCategoryAccess().getDescriptionKeyword_4_1_0());
            	      								
            	    }
            	    // InternalMetaData.g:1652:9: ( (lv_description_8_0= RULE_STRING ) )
            	    // InternalMetaData.g:1653:10: (lv_description_8_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1653:10: (lv_description_8_0= RULE_STRING )
            	    // InternalMetaData.g:1654:11: lv_description_8_0= RULE_STRING
            	    {
            	    lv_description_8_0=(Token)match(input,RULE_STRING,FOLLOW_32); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_description_8_0, grammarAccess.getMdCategoryAccess().getDescriptionSTRINGTerminalRuleCall_4_1_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdCategoryRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"description",
            	      												lv_description_8_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4());

            	    }


            	    }


            	    }
            	    break;
            	case 3 :
            	    // InternalMetaData.g:1676:4: ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) )
            	    {
            	    // InternalMetaData.g:1676:4: ({...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) ) )
            	    // InternalMetaData.g:1677:5: {...}? => ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) )
            	    {
            	    if ( ! getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 2) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "getUnorderedGroupHelper().canSelect(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 2)");
            	    }
            	    // InternalMetaData.g:1677:107: ( ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) ) )
            	    // InternalMetaData.g:1678:6: ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) )
            	    {
            	    getUnorderedGroupHelper().select(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4(), 2);
            	    // InternalMetaData.g:1681:9: ({...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) ) )
            	    // InternalMetaData.g:1681:10: {...}? => (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) )
            	    {
            	    if ( !((true)) ) {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        throw new FailedPredicateException(input, "ruleMdCategory", "true");
            	    }
            	    // InternalMetaData.g:1681:19: (otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) ) )
            	    // InternalMetaData.g:1681:20: otherlv_9= 'documentation' ( (lv_documentation_10_0= RULE_STRING ) )
            	    {
            	    otherlv_9=(Token)match(input,22,FOLLOW_8); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									newLeafNode(otherlv_9, grammarAccess.getMdCategoryAccess().getDocumentationKeyword_4_2_0());
            	      								
            	    }
            	    // InternalMetaData.g:1685:9: ( (lv_documentation_10_0= RULE_STRING ) )
            	    // InternalMetaData.g:1686:10: (lv_documentation_10_0= RULE_STRING )
            	    {
            	    // InternalMetaData.g:1686:10: (lv_documentation_10_0= RULE_STRING )
            	    // InternalMetaData.g:1687:11: lv_documentation_10_0= RULE_STRING
            	    {
            	    lv_documentation_10_0=(Token)match(input,RULE_STRING,FOLLOW_32); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      											newLeafNode(lv_documentation_10_0, grammarAccess.getMdCategoryAccess().getDocumentationSTRINGTerminalRuleCall_4_2_1_0());
            	      										
            	    }
            	    if ( state.backtracking==0 ) {

            	      											if (current==null) {
            	      												current = createModelElement(grammarAccess.getMdCategoryRule());
            	      											}
            	      											setWithLastConsumed(
            	      												current,
            	      												"documentation",
            	      												lv_documentation_10_0,
            	      												"org.eclipse.xtext.xbase.Xtype.STRING");
            	      										
            	    }

            	    }


            	    }


            	    }


            	    }

            	    getUnorderedGroupHelper().returnFromSelection(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4());

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop24;
                }
            } while (true);


            }


            }

            getUnorderedGroupHelper().leave(grammarAccess.getMdCategoryAccess().getUnorderedGroup_4());

            }

            otherlv_11=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_11, grammarAccess.getMdCategoryAccess().getRightCurlyBracketKeyword_5());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdCategory"


    // $ANTLR start "entryRuleMdOptionSupport"
    // InternalMetaData.g:1724:1: entryRuleMdOptionSupport returns [EObject current=null] : iv_ruleMdOptionSupport= ruleMdOptionSupport EOF ;
    public final EObject entryRuleMdOptionSupport() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleMdOptionSupport = null;


        try {
            // InternalMetaData.g:1724:56: (iv_ruleMdOptionSupport= ruleMdOptionSupport EOF )
            // InternalMetaData.g:1725:2: iv_ruleMdOptionSupport= ruleMdOptionSupport EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getMdOptionSupportRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleMdOptionSupport=ruleMdOptionSupport();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleMdOptionSupport; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleMdOptionSupport"


    // $ANTLR start "ruleMdOptionSupport"
    // InternalMetaData.g:1731:1: ruleMdOptionSupport returns [EObject current=null] : (otherlv_0= 'supports' ( ( ruleQualifiedName ) ) (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )? (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )? ) ;
    public final EObject ruleMdOptionSupport() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token lv_documentation_5_0=null;
        EObject lv_value_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1737:2: ( (otherlv_0= 'supports' ( ( ruleQualifiedName ) ) (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )? (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )? ) )
            // InternalMetaData.g:1738:2: (otherlv_0= 'supports' ( ( ruleQualifiedName ) ) (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )? (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )? )
            {
            // InternalMetaData.g:1738:2: (otherlv_0= 'supports' ( ( ruleQualifiedName ) ) (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )? (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )? )
            // InternalMetaData.g:1739:3: otherlv_0= 'supports' ( ( ruleQualifiedName ) ) (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )? (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )?
            {
            otherlv_0=(Token)match(input,48,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getMdOptionSupportAccess().getSupportsKeyword_0());
              		
            }
            // InternalMetaData.g:1743:3: ( ( ruleQualifiedName ) )
            // InternalMetaData.g:1744:4: ( ruleQualifiedName )
            {
            // InternalMetaData.g:1744:4: ( ruleQualifiedName )
            // InternalMetaData.g:1745:5: ruleQualifiedName
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getMdOptionSupportRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getMdOptionSupportAccess().getOptionMdOptionCrossReference_1_0());
              				
            }
            pushFollow(FOLLOW_33);
            ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:1759:3: (otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) ) )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==32) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // InternalMetaData.g:1760:4: otherlv_2= '=' ( (lv_value_3_0= ruleXExpression ) )
                    {
                    otherlv_2=(Token)match(input,32,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getMdOptionSupportAccess().getEqualsSignKeyword_2_0());
                      			
                    }
                    // InternalMetaData.g:1764:4: ( (lv_value_3_0= ruleXExpression ) )
                    // InternalMetaData.g:1765:5: (lv_value_3_0= ruleXExpression )
                    {
                    // InternalMetaData.g:1765:5: (lv_value_3_0= ruleXExpression )
                    // InternalMetaData.g:1766:6: lv_value_3_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getMdOptionSupportAccess().getValueXExpressionParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_34);
                    lv_value_3_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getMdOptionSupportRule());
                      						}
                      						set(
                      							current,
                      							"value",
                      							lv_value_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:1784:3: (otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) ) )?
            int alt26=2;
            int LA26_0 = input.LA(1);

            if ( (LA26_0==22) ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // InternalMetaData.g:1785:4: otherlv_4= 'documentation' ( (lv_documentation_5_0= RULE_STRING ) )
                    {
                    otherlv_4=(Token)match(input,22,FOLLOW_8); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_4, grammarAccess.getMdOptionSupportAccess().getDocumentationKeyword_3_0());
                      			
                    }
                    // InternalMetaData.g:1789:4: ( (lv_documentation_5_0= RULE_STRING ) )
                    // InternalMetaData.g:1790:5: (lv_documentation_5_0= RULE_STRING )
                    {
                    // InternalMetaData.g:1790:5: (lv_documentation_5_0= RULE_STRING )
                    // InternalMetaData.g:1791:6: lv_documentation_5_0= RULE_STRING
                    {
                    lv_documentation_5_0=(Token)match(input,RULE_STRING,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_documentation_5_0, grammarAccess.getMdOptionSupportAccess().getDocumentationSTRINGTerminalRuleCall_3_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getMdOptionSupportRule());
                      						}
                      						setWithLastConsumed(
                      							current,
                      							"documentation",
                      							lv_documentation_5_0,
                      							"org.eclipse.xtext.xbase.Xtype.STRING");
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdOptionSupport"


    // $ANTLR start "entryRulePath"
    // InternalMetaData.g:1812:1: entryRulePath returns [String current=null] : iv_rulePath= rulePath EOF ;
    public final String entryRulePath() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_rulePath = null;


        try {
            // InternalMetaData.g:1812:44: (iv_rulePath= rulePath EOF )
            // InternalMetaData.g:1813:2: iv_rulePath= rulePath EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPathRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_rulePath=rulePath();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePath.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRulePath"


    // $ANTLR start "rulePath"
    // InternalMetaData.g:1819:1: rulePath returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_QualifiedName_0= ruleQualifiedName ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )* ) ;
    public final AntlrDatatypeRuleToken rulePath() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_QualifiedName_0 = null;

        AntlrDatatypeRuleToken this_QualifiedName_3 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1825:2: ( (this_QualifiedName_0= ruleQualifiedName ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )* ) )
            // InternalMetaData.g:1826:2: (this_QualifiedName_0= ruleQualifiedName ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )* )
            {
            // InternalMetaData.g:1826:2: (this_QualifiedName_0= ruleQualifiedName ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )* )
            // InternalMetaData.g:1827:3: this_QualifiedName_0= ruleQualifiedName ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getPathAccess().getQualifiedNameParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_35);
            this_QualifiedName_0=ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(this_QualifiedName_0);
              		
            }
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:1837:3: ( (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName )*
            loop28:
            do {
                int alt28=2;
                int LA28_0 = input.LA(1);

                if ( ((LA28_0>=49 && LA28_0<=50)) ) {
                    alt28=1;
                }


                switch (alt28) {
            	case 1 :
            	    // InternalMetaData.g:1838:4: (kw= '/' | kw= '-' ) this_QualifiedName_3= ruleQualifiedName
            	    {
            	    // InternalMetaData.g:1838:4: (kw= '/' | kw= '-' )
            	    int alt27=2;
            	    int LA27_0 = input.LA(1);

            	    if ( (LA27_0==49) ) {
            	        alt27=1;
            	    }
            	    else if ( (LA27_0==50) ) {
            	        alt27=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 27, 0, input);

            	        throw nvae;
            	    }
            	    switch (alt27) {
            	        case 1 :
            	            // InternalMetaData.g:1839:5: kw= '/'
            	            {
            	            kw=(Token)match(input,49,FOLLOW_3); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              					current.merge(kw);
            	              					newLeafNode(kw, grammarAccess.getPathAccess().getSolidusKeyword_1_0_0());
            	              				
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // InternalMetaData.g:1845:5: kw= '-'
            	            {
            	            kw=(Token)match(input,50,FOLLOW_3); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              					current.merge(kw);
            	              					newLeafNode(kw, grammarAccess.getPathAccess().getHyphenMinusKeyword_1_0_1());
            	              				
            	            }

            	            }
            	            break;

            	    }

            	    if ( state.backtracking==0 ) {

            	      				newCompositeNode(grammarAccess.getPathAccess().getQualifiedNameParserRuleCall_1_1());
            	      			
            	    }
            	    pushFollow(FOLLOW_35);
            	    this_QualifiedName_3=ruleQualifiedName();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				current.merge(this_QualifiedName_3);
            	      			
            	    }
            	    if ( state.backtracking==0 ) {

            	      				afterParserOrEnumRuleCall();
            	      			
            	    }

            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "rulePath"


    // $ANTLR start "entryRuleXExpression"
    // InternalMetaData.g:1866:1: entryRuleXExpression returns [EObject current=null] : iv_ruleXExpression= ruleXExpression EOF ;
    public final EObject entryRuleXExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXExpression = null;


        try {
            // InternalMetaData.g:1866:52: (iv_ruleXExpression= ruleXExpression EOF )
            // InternalMetaData.g:1867:2: iv_ruleXExpression= ruleXExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXExpression=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXExpression"


    // $ANTLR start "ruleXExpression"
    // InternalMetaData.g:1873:1: ruleXExpression returns [EObject current=null] : this_XAssignment_0= ruleXAssignment ;
    public final EObject ruleXExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XAssignment_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1879:2: (this_XAssignment_0= ruleXAssignment )
            // InternalMetaData.g:1880:2: this_XAssignment_0= ruleXAssignment
            {
            if ( state.backtracking==0 ) {

              		newCompositeNode(grammarAccess.getXExpressionAccess().getXAssignmentParserRuleCall());
              	
            }
            pushFollow(FOLLOW_2);
            this_XAssignment_0=ruleXAssignment();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current = this_XAssignment_0;
              		afterParserOrEnumRuleCall();
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXExpression"


    // $ANTLR start "entryRuleXAssignment"
    // InternalMetaData.g:1891:1: entryRuleXAssignment returns [EObject current=null] : iv_ruleXAssignment= ruleXAssignment EOF ;
    public final EObject entryRuleXAssignment() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXAssignment = null;


        try {
            // InternalMetaData.g:1891:52: (iv_ruleXAssignment= ruleXAssignment EOF )
            // InternalMetaData.g:1892:2: iv_ruleXAssignment= ruleXAssignment EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXAssignmentRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXAssignment=ruleXAssignment();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXAssignment; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXAssignment"


    // $ANTLR start "ruleXAssignment"
    // InternalMetaData.g:1898:1: ruleXAssignment returns [EObject current=null] : ( ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) ) | (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? ) ) ;
    public final EObject ruleXAssignment() throws RecognitionException {
        EObject current = null;

        EObject lv_value_3_0 = null;

        EObject this_XOrExpression_4 = null;

        EObject lv_rightOperand_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:1904:2: ( ( ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) ) | (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? ) ) )
            // InternalMetaData.g:1905:2: ( ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) ) | (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? ) )
            {
            // InternalMetaData.g:1905:2: ( ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) ) | (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? ) )
            int alt30=2;
            switch ( input.LA(1) ) {
            case RULE_ID:
                {
                int LA30_1 = input.LA(2);

                if ( (LA30_1==EOF||(LA30_1>=RULE_STRING && LA30_1<=RULE_DECIMAL)||(LA30_1>=15 && LA30_1<=16)||LA30_1==20||LA30_1==22||(LA30_1>=29 && LA30_1<=31)||(LA30_1>=33 && LA30_1<=39)||(LA30_1>=41 && LA30_1<=43)||(LA30_1>=48 && LA30_1<=83)||(LA30_1>=85 && LA30_1<=110)) ) {
                    alt30=2;
                }
                else if ( (LA30_1==32) ) {
                    alt30=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 1, input);

                    throw nvae;
                }
                }
                break;
            case 95:
                {
                int LA30_2 = input.LA(2);

                if ( (LA30_2==32) ) {
                    alt30=1;
                }
                else if ( (LA30_2==EOF||(LA30_2>=RULE_STRING && LA30_2<=RULE_DECIMAL)||(LA30_2>=15 && LA30_2<=16)||LA30_2==20||LA30_2==22||(LA30_2>=29 && LA30_2<=31)||(LA30_2>=33 && LA30_2<=39)||(LA30_2>=41 && LA30_2<=43)||(LA30_2>=48 && LA30_2<=83)||(LA30_2>=85 && LA30_2<=110)) ) {
                    alt30=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 2, input);

                    throw nvae;
                }
                }
                break;
            case 96:
                {
                int LA30_3 = input.LA(2);

                if ( (LA30_3==EOF||(LA30_3>=RULE_STRING && LA30_3<=RULE_DECIMAL)||(LA30_3>=15 && LA30_3<=16)||LA30_3==20||LA30_3==22||(LA30_3>=29 && LA30_3<=31)||(LA30_3>=33 && LA30_3<=39)||(LA30_3>=41 && LA30_3<=43)||(LA30_3>=48 && LA30_3<=83)||(LA30_3>=85 && LA30_3<=110)) ) {
                    alt30=2;
                }
                else if ( (LA30_3==32) ) {
                    alt30=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 3, input);

                    throw nvae;
                }
                }
                break;
            case 97:
                {
                int LA30_4 = input.LA(2);

                if ( (LA30_4==EOF||(LA30_4>=RULE_STRING && LA30_4<=RULE_DECIMAL)||(LA30_4>=15 && LA30_4<=16)||LA30_4==20||LA30_4==22||(LA30_4>=29 && LA30_4<=31)||(LA30_4>=33 && LA30_4<=39)||(LA30_4>=41 && LA30_4<=43)||(LA30_4>=48 && LA30_4<=83)||(LA30_4>=85 && LA30_4<=110)) ) {
                    alt30=2;
                }
                else if ( (LA30_4==32) ) {
                    alt30=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 4, input);

                    throw nvae;
                }
                }
                break;
            case 98:
                {
                int LA30_5 = input.LA(2);

                if ( (LA30_5==EOF||(LA30_5>=RULE_STRING && LA30_5<=RULE_DECIMAL)||(LA30_5>=15 && LA30_5<=16)||LA30_5==20||LA30_5==22||(LA30_5>=29 && LA30_5<=31)||(LA30_5>=33 && LA30_5<=39)||(LA30_5>=41 && LA30_5<=43)||(LA30_5>=48 && LA30_5<=83)||(LA30_5>=85 && LA30_5<=110)) ) {
                    alt30=2;
                }
                else if ( (LA30_5==32) ) {
                    alt30=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 5, input);

                    throw nvae;
                }
                }
                break;
            case RULE_STRING:
            case RULE_HEX:
            case RULE_INT:
            case RULE_DECIMAL:
            case 15:
            case 41:
            case 42:
            case 50:
            case 56:
            case 71:
            case 75:
            case 82:
            case 86:
            case 88:
            case 90:
            case 91:
            case 92:
            case 99:
            case 100:
            case 101:
            case 102:
            case 103:
            case 104:
            case 105:
            case 106:
            case 107:
            case 109:
                {
                alt30=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;
            }

            switch (alt30) {
                case 1 :
                    // InternalMetaData.g:1906:3: ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) )
                    {
                    // InternalMetaData.g:1906:3: ( () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) ) )
                    // InternalMetaData.g:1907:4: () ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ( (lv_value_3_0= ruleXAssignment ) )
                    {
                    // InternalMetaData.g:1907:4: ()
                    // InternalMetaData.g:1908:5: 
                    {
                    if ( state.backtracking==0 ) {

                      					current = forceCreateModelElement(
                      						grammarAccess.getXAssignmentAccess().getXAssignmentAction_0_0(),
                      						current);
                      				
                    }

                    }

                    // InternalMetaData.g:1914:4: ( ( ruleFeatureCallID ) )
                    // InternalMetaData.g:1915:5: ( ruleFeatureCallID )
                    {
                    // InternalMetaData.g:1915:5: ( ruleFeatureCallID )
                    // InternalMetaData.g:1916:6: ruleFeatureCallID
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXAssignmentRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXAssignmentAccess().getFeatureJvmIdentifiableElementCrossReference_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_17);
                    ruleFeatureCallID();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getXAssignmentAccess().getOpSingleAssignParserRuleCall_0_2());
                      			
                    }
                    pushFollow(FOLLOW_18);
                    ruleOpSingleAssign();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				afterParserOrEnumRuleCall();
                      			
                    }
                    // InternalMetaData.g:1937:4: ( (lv_value_3_0= ruleXAssignment ) )
                    // InternalMetaData.g:1938:5: (lv_value_3_0= ruleXAssignment )
                    {
                    // InternalMetaData.g:1938:5: (lv_value_3_0= ruleXAssignment )
                    // InternalMetaData.g:1939:6: lv_value_3_0= ruleXAssignment
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXAssignmentAccess().getValueXAssignmentParserRuleCall_0_3_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_value_3_0=ruleXAssignment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXAssignmentRule());
                      						}
                      						set(
                      							current,
                      							"value",
                      							lv_value_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XAssignment");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:1958:3: (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? )
                    {
                    // InternalMetaData.g:1958:3: (this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )? )
                    // InternalMetaData.g:1959:4: this_XOrExpression_4= ruleXOrExpression ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )?
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getXAssignmentAccess().getXOrExpressionParserRuleCall_1_0());
                      			
                    }
                    pushFollow(FOLLOW_36);
                    this_XOrExpression_4=ruleXOrExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_XOrExpression_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }
                    // InternalMetaData.g:1967:4: ( ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) ) )?
                    int alt29=2;
                    alt29 = dfa29.predict(input);
                    switch (alt29) {
                        case 1 :
                            // InternalMetaData.g:1968:5: ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) ) ( (lv_rightOperand_7_0= ruleXAssignment ) )
                            {
                            // InternalMetaData.g:1968:5: ( ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) ) )
                            // InternalMetaData.g:1969:6: ( ( () ( ( ruleOpMultiAssign ) ) ) )=> ( () ( ( ruleOpMultiAssign ) ) )
                            {
                            // InternalMetaData.g:1979:6: ( () ( ( ruleOpMultiAssign ) ) )
                            // InternalMetaData.g:1980:7: () ( ( ruleOpMultiAssign ) )
                            {
                            // InternalMetaData.g:1980:7: ()
                            // InternalMetaData.g:1981:8: 
                            {
                            if ( state.backtracking==0 ) {

                              								current = forceCreateModelElementAndSet(
                              									grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0(),
                              									current);
                              							
                            }

                            }

                            // InternalMetaData.g:1987:7: ( ( ruleOpMultiAssign ) )
                            // InternalMetaData.g:1988:8: ( ruleOpMultiAssign )
                            {
                            // InternalMetaData.g:1988:8: ( ruleOpMultiAssign )
                            // InternalMetaData.g:1989:9: ruleOpMultiAssign
                            {
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElement(grammarAccess.getXAssignmentRule());
                              									}
                              								
                            }
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getXAssignmentAccess().getFeatureJvmIdentifiableElementCrossReference_1_1_0_0_1_0());
                              								
                            }
                            pushFollow(FOLLOW_18);
                            ruleOpMultiAssign();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }


                            }


                            }

                            // InternalMetaData.g:2005:5: ( (lv_rightOperand_7_0= ruleXAssignment ) )
                            // InternalMetaData.g:2006:6: (lv_rightOperand_7_0= ruleXAssignment )
                            {
                            // InternalMetaData.g:2006:6: (lv_rightOperand_7_0= ruleXAssignment )
                            // InternalMetaData.g:2007:7: lv_rightOperand_7_0= ruleXAssignment
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getXAssignmentAccess().getRightOperandXAssignmentParserRuleCall_1_1_1_0());
                              						
                            }
                            pushFollow(FOLLOW_2);
                            lv_rightOperand_7_0=ruleXAssignment();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getXAssignmentRule());
                              							}
                              							set(
                              								current,
                              								"rightOperand",
                              								lv_rightOperand_7_0,
                              								"org.eclipse.xtext.xbase.Xbase.XAssignment");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXAssignment"


    // $ANTLR start "entryRuleOpSingleAssign"
    // InternalMetaData.g:2030:1: entryRuleOpSingleAssign returns [String current=null] : iv_ruleOpSingleAssign= ruleOpSingleAssign EOF ;
    public final String entryRuleOpSingleAssign() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpSingleAssign = null;


        try {
            // InternalMetaData.g:2030:54: (iv_ruleOpSingleAssign= ruleOpSingleAssign EOF )
            // InternalMetaData.g:2031:2: iv_ruleOpSingleAssign= ruleOpSingleAssign EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpSingleAssignRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpSingleAssign=ruleOpSingleAssign();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpSingleAssign.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpSingleAssign"


    // $ANTLR start "ruleOpSingleAssign"
    // InternalMetaData.g:2037:1: ruleOpSingleAssign returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : kw= '=' ;
    public final AntlrDatatypeRuleToken ruleOpSingleAssign() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2043:2: (kw= '=' )
            // InternalMetaData.g:2044:2: kw= '='
            {
            kw=(Token)match(input,32,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(kw);
              		newLeafNode(kw, grammarAccess.getOpSingleAssignAccess().getEqualsSignKeyword());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpSingleAssign"


    // $ANTLR start "entryRuleOpMultiAssign"
    // InternalMetaData.g:2052:1: entryRuleOpMultiAssign returns [String current=null] : iv_ruleOpMultiAssign= ruleOpMultiAssign EOF ;
    public final String entryRuleOpMultiAssign() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpMultiAssign = null;


        try {
            // InternalMetaData.g:2052:53: (iv_ruleOpMultiAssign= ruleOpMultiAssign EOF )
            // InternalMetaData.g:2053:2: iv_ruleOpMultiAssign= ruleOpMultiAssign EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpMultiAssignRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpMultiAssign=ruleOpMultiAssign();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpMultiAssign.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpMultiAssign"


    // $ANTLR start "ruleOpMultiAssign"
    // InternalMetaData.g:2059:1: ruleOpMultiAssign returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '+=' | kw= '-=' | kw= '*=' | kw= '/=' | kw= '%=' | (kw= '<' kw= '<' kw= '=' ) | (kw= '>' (kw= '>' )? kw= '>=' ) ) ;
    public final AntlrDatatypeRuleToken ruleOpMultiAssign() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2065:2: ( (kw= '+=' | kw= '-=' | kw= '*=' | kw= '/=' | kw= '%=' | (kw= '<' kw= '<' kw= '=' ) | (kw= '>' (kw= '>' )? kw= '>=' ) ) )
            // InternalMetaData.g:2066:2: (kw= '+=' | kw= '-=' | kw= '*=' | kw= '/=' | kw= '%=' | (kw= '<' kw= '<' kw= '=' ) | (kw= '>' (kw= '>' )? kw= '>=' ) )
            {
            // InternalMetaData.g:2066:2: (kw= '+=' | kw= '-=' | kw= '*=' | kw= '/=' | kw= '%=' | (kw= '<' kw= '<' kw= '=' ) | (kw= '>' (kw= '>' )? kw= '>=' ) )
            int alt32=7;
            switch ( input.LA(1) ) {
            case 51:
                {
                alt32=1;
                }
                break;
            case 52:
                {
                alt32=2;
                }
                break;
            case 53:
                {
                alt32=3;
                }
                break;
            case 54:
                {
                alt32=4;
                }
                break;
            case 55:
                {
                alt32=5;
                }
                break;
            case 56:
                {
                alt32=6;
                }
                break;
            case 57:
                {
                alt32=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }

            switch (alt32) {
                case 1 :
                    // InternalMetaData.g:2067:3: kw= '+='
                    {
                    kw=(Token)match(input,51,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getPlusSignEqualsSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:2073:3: kw= '-='
                    {
                    kw=(Token)match(input,52,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getHyphenMinusEqualsSignKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:2079:3: kw= '*='
                    {
                    kw=(Token)match(input,53,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getAsteriskEqualsSignKeyword_2());
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:2085:3: kw= '/='
                    {
                    kw=(Token)match(input,54,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getSolidusEqualsSignKeyword_3());
                      		
                    }

                    }
                    break;
                case 5 :
                    // InternalMetaData.g:2091:3: kw= '%='
                    {
                    kw=(Token)match(input,55,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getPercentSignEqualsSignKeyword_4());
                      		
                    }

                    }
                    break;
                case 6 :
                    // InternalMetaData.g:2097:3: (kw= '<' kw= '<' kw= '=' )
                    {
                    // InternalMetaData.g:2097:3: (kw= '<' kw= '<' kw= '=' )
                    // InternalMetaData.g:2098:4: kw= '<' kw= '<' kw= '='
                    {
                    kw=(Token)match(input,56,FOLLOW_37); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getLessThanSignKeyword_5_0());
                      			
                    }
                    kw=(Token)match(input,56,FOLLOW_17); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getLessThanSignKeyword_5_1());
                      			
                    }
                    kw=(Token)match(input,32,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getEqualsSignKeyword_5_2());
                      			
                    }

                    }


                    }
                    break;
                case 7 :
                    // InternalMetaData.g:2115:3: (kw= '>' (kw= '>' )? kw= '>=' )
                    {
                    // InternalMetaData.g:2115:3: (kw= '>' (kw= '>' )? kw= '>=' )
                    // InternalMetaData.g:2116:4: kw= '>' (kw= '>' )? kw= '>='
                    {
                    kw=(Token)match(input,57,FOLLOW_38); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getGreaterThanSignKeyword_6_0());
                      			
                    }
                    // InternalMetaData.g:2121:4: (kw= '>' )?
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( (LA31_0==57) ) {
                        alt31=1;
                    }
                    switch (alt31) {
                        case 1 :
                            // InternalMetaData.g:2122:5: kw= '>'
                            {
                            kw=(Token)match(input,57,FOLLOW_39); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(kw);
                              					newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getGreaterThanSignKeyword_6_1());
                              				
                            }

                            }
                            break;

                    }

                    kw=(Token)match(input,58,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpMultiAssignAccess().getGreaterThanSignEqualsSignKeyword_6_2());
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpMultiAssign"


    // $ANTLR start "entryRuleXOrExpression"
    // InternalMetaData.g:2138:1: entryRuleXOrExpression returns [EObject current=null] : iv_ruleXOrExpression= ruleXOrExpression EOF ;
    public final EObject entryRuleXOrExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXOrExpression = null;


        try {
            // InternalMetaData.g:2138:54: (iv_ruleXOrExpression= ruleXOrExpression EOF )
            // InternalMetaData.g:2139:2: iv_ruleXOrExpression= ruleXOrExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXOrExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXOrExpression=ruleXOrExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXOrExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXOrExpression"


    // $ANTLR start "ruleXOrExpression"
    // InternalMetaData.g:2145:1: ruleXOrExpression returns [EObject current=null] : (this_XAndExpression_0= ruleXAndExpression ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )* ) ;
    public final EObject ruleXOrExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XAndExpression_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2151:2: ( (this_XAndExpression_0= ruleXAndExpression ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )* ) )
            // InternalMetaData.g:2152:2: (this_XAndExpression_0= ruleXAndExpression ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )* )
            {
            // InternalMetaData.g:2152:2: (this_XAndExpression_0= ruleXAndExpression ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )* )
            // InternalMetaData.g:2153:3: this_XAndExpression_0= ruleXAndExpression ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXOrExpressionAccess().getXAndExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_40);
            this_XAndExpression_0=ruleXAndExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XAndExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2161:3: ( ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) ) )*
            loop33:
            do {
                int alt33=2;
                int LA33_0 = input.LA(1);

                if ( (LA33_0==59) ) {
                    int LA33_2 = input.LA(2);

                    if ( (synpred2_InternalMetaData()) ) {
                        alt33=1;
                    }


                }


                switch (alt33) {
            	case 1 :
            	    // InternalMetaData.g:2162:4: ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) ) ( (lv_rightOperand_3_0= ruleXAndExpression ) )
            	    {
            	    // InternalMetaData.g:2162:4: ( ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) ) )
            	    // InternalMetaData.g:2163:5: ( ( () ( ( ruleOpOr ) ) ) )=> ( () ( ( ruleOpOr ) ) )
            	    {
            	    // InternalMetaData.g:2173:5: ( () ( ( ruleOpOr ) ) )
            	    // InternalMetaData.g:2174:6: () ( ( ruleOpOr ) )
            	    {
            	    // InternalMetaData.g:2174:6: ()
            	    // InternalMetaData.g:2175:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:2181:6: ( ( ruleOpOr ) )
            	    // InternalMetaData.g:2182:7: ( ruleOpOr )
            	    {
            	    // InternalMetaData.g:2182:7: ( ruleOpOr )
            	    // InternalMetaData.g:2183:8: ruleOpOr
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXOrExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXOrExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpOr();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2199:4: ( (lv_rightOperand_3_0= ruleXAndExpression ) )
            	    // InternalMetaData.g:2200:5: (lv_rightOperand_3_0= ruleXAndExpression )
            	    {
            	    // InternalMetaData.g:2200:5: (lv_rightOperand_3_0= ruleXAndExpression )
            	    // InternalMetaData.g:2201:6: lv_rightOperand_3_0= ruleXAndExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXOrExpressionAccess().getRightOperandXAndExpressionParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_40);
            	    lv_rightOperand_3_0=ruleXAndExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXOrExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XAndExpression");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop33;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXOrExpression"


    // $ANTLR start "entryRuleOpOr"
    // InternalMetaData.g:2223:1: entryRuleOpOr returns [String current=null] : iv_ruleOpOr= ruleOpOr EOF ;
    public final String entryRuleOpOr() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpOr = null;


        try {
            // InternalMetaData.g:2223:44: (iv_ruleOpOr= ruleOpOr EOF )
            // InternalMetaData.g:2224:2: iv_ruleOpOr= ruleOpOr EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpOrRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpOr=ruleOpOr();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpOr.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpOr"


    // $ANTLR start "ruleOpOr"
    // InternalMetaData.g:2230:1: ruleOpOr returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : kw= '||' ;
    public final AntlrDatatypeRuleToken ruleOpOr() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2236:2: (kw= '||' )
            // InternalMetaData.g:2237:2: kw= '||'
            {
            kw=(Token)match(input,59,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(kw);
              		newLeafNode(kw, grammarAccess.getOpOrAccess().getVerticalLineVerticalLineKeyword());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpOr"


    // $ANTLR start "entryRuleXAndExpression"
    // InternalMetaData.g:2245:1: entryRuleXAndExpression returns [EObject current=null] : iv_ruleXAndExpression= ruleXAndExpression EOF ;
    public final EObject entryRuleXAndExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXAndExpression = null;


        try {
            // InternalMetaData.g:2245:55: (iv_ruleXAndExpression= ruleXAndExpression EOF )
            // InternalMetaData.g:2246:2: iv_ruleXAndExpression= ruleXAndExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXAndExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXAndExpression=ruleXAndExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXAndExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXAndExpression"


    // $ANTLR start "ruleXAndExpression"
    // InternalMetaData.g:2252:1: ruleXAndExpression returns [EObject current=null] : (this_XEqualityExpression_0= ruleXEqualityExpression ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )* ) ;
    public final EObject ruleXAndExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XEqualityExpression_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2258:2: ( (this_XEqualityExpression_0= ruleXEqualityExpression ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )* ) )
            // InternalMetaData.g:2259:2: (this_XEqualityExpression_0= ruleXEqualityExpression ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )* )
            {
            // InternalMetaData.g:2259:2: (this_XEqualityExpression_0= ruleXEqualityExpression ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )* )
            // InternalMetaData.g:2260:3: this_XEqualityExpression_0= ruleXEqualityExpression ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXAndExpressionAccess().getXEqualityExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_41);
            this_XEqualityExpression_0=ruleXEqualityExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XEqualityExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2268:3: ( ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) ) )*
            loop34:
            do {
                int alt34=2;
                int LA34_0 = input.LA(1);

                if ( (LA34_0==60) ) {
                    int LA34_2 = input.LA(2);

                    if ( (synpred3_InternalMetaData()) ) {
                        alt34=1;
                    }


                }


                switch (alt34) {
            	case 1 :
            	    // InternalMetaData.g:2269:4: ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) ) ( (lv_rightOperand_3_0= ruleXEqualityExpression ) )
            	    {
            	    // InternalMetaData.g:2269:4: ( ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) ) )
            	    // InternalMetaData.g:2270:5: ( ( () ( ( ruleOpAnd ) ) ) )=> ( () ( ( ruleOpAnd ) ) )
            	    {
            	    // InternalMetaData.g:2280:5: ( () ( ( ruleOpAnd ) ) )
            	    // InternalMetaData.g:2281:6: () ( ( ruleOpAnd ) )
            	    {
            	    // InternalMetaData.g:2281:6: ()
            	    // InternalMetaData.g:2282:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:2288:6: ( ( ruleOpAnd ) )
            	    // InternalMetaData.g:2289:7: ( ruleOpAnd )
            	    {
            	    // InternalMetaData.g:2289:7: ( ruleOpAnd )
            	    // InternalMetaData.g:2290:8: ruleOpAnd
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXAndExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXAndExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpAnd();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2306:4: ( (lv_rightOperand_3_0= ruleXEqualityExpression ) )
            	    // InternalMetaData.g:2307:5: (lv_rightOperand_3_0= ruleXEqualityExpression )
            	    {
            	    // InternalMetaData.g:2307:5: (lv_rightOperand_3_0= ruleXEqualityExpression )
            	    // InternalMetaData.g:2308:6: lv_rightOperand_3_0= ruleXEqualityExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXAndExpressionAccess().getRightOperandXEqualityExpressionParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_41);
            	    lv_rightOperand_3_0=ruleXEqualityExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXAndExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XEqualityExpression");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop34;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXAndExpression"


    // $ANTLR start "entryRuleOpAnd"
    // InternalMetaData.g:2330:1: entryRuleOpAnd returns [String current=null] : iv_ruleOpAnd= ruleOpAnd EOF ;
    public final String entryRuleOpAnd() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpAnd = null;


        try {
            // InternalMetaData.g:2330:45: (iv_ruleOpAnd= ruleOpAnd EOF )
            // InternalMetaData.g:2331:2: iv_ruleOpAnd= ruleOpAnd EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpAndRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpAnd=ruleOpAnd();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpAnd.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpAnd"


    // $ANTLR start "ruleOpAnd"
    // InternalMetaData.g:2337:1: ruleOpAnd returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : kw= '&&' ;
    public final AntlrDatatypeRuleToken ruleOpAnd() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2343:2: (kw= '&&' )
            // InternalMetaData.g:2344:2: kw= '&&'
            {
            kw=(Token)match(input,60,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(kw);
              		newLeafNode(kw, grammarAccess.getOpAndAccess().getAmpersandAmpersandKeyword());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpAnd"


    // $ANTLR start "entryRuleXEqualityExpression"
    // InternalMetaData.g:2352:1: entryRuleXEqualityExpression returns [EObject current=null] : iv_ruleXEqualityExpression= ruleXEqualityExpression EOF ;
    public final EObject entryRuleXEqualityExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXEqualityExpression = null;


        try {
            // InternalMetaData.g:2352:60: (iv_ruleXEqualityExpression= ruleXEqualityExpression EOF )
            // InternalMetaData.g:2353:2: iv_ruleXEqualityExpression= ruleXEqualityExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXEqualityExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXEqualityExpression=ruleXEqualityExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXEqualityExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXEqualityExpression"


    // $ANTLR start "ruleXEqualityExpression"
    // InternalMetaData.g:2359:1: ruleXEqualityExpression returns [EObject current=null] : (this_XRelationalExpression_0= ruleXRelationalExpression ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )* ) ;
    public final EObject ruleXEqualityExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XRelationalExpression_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2365:2: ( (this_XRelationalExpression_0= ruleXRelationalExpression ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )* ) )
            // InternalMetaData.g:2366:2: (this_XRelationalExpression_0= ruleXRelationalExpression ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )* )
            {
            // InternalMetaData.g:2366:2: (this_XRelationalExpression_0= ruleXRelationalExpression ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )* )
            // InternalMetaData.g:2367:3: this_XRelationalExpression_0= ruleXRelationalExpression ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXEqualityExpressionAccess().getXRelationalExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_42);
            this_XRelationalExpression_0=ruleXRelationalExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XRelationalExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2375:3: ( ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) ) )*
            loop35:
            do {
                int alt35=2;
                switch ( input.LA(1) ) {
                case 39:
                    {
                    int LA35_2 = input.LA(2);

                    if ( (synpred4_InternalMetaData()) ) {
                        alt35=1;
                    }


                    }
                    break;
                case 61:
                    {
                    int LA35_3 = input.LA(2);

                    if ( (synpred4_InternalMetaData()) ) {
                        alt35=1;
                    }


                    }
                    break;
                case 62:
                    {
                    int LA35_4 = input.LA(2);

                    if ( (synpred4_InternalMetaData()) ) {
                        alt35=1;
                    }


                    }
                    break;
                case 63:
                    {
                    int LA35_5 = input.LA(2);

                    if ( (synpred4_InternalMetaData()) ) {
                        alt35=1;
                    }


                    }
                    break;

                }

                switch (alt35) {
            	case 1 :
            	    // InternalMetaData.g:2376:4: ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) ) ( (lv_rightOperand_3_0= ruleXRelationalExpression ) )
            	    {
            	    // InternalMetaData.g:2376:4: ( ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) ) )
            	    // InternalMetaData.g:2377:5: ( ( () ( ( ruleOpEquality ) ) ) )=> ( () ( ( ruleOpEquality ) ) )
            	    {
            	    // InternalMetaData.g:2387:5: ( () ( ( ruleOpEquality ) ) )
            	    // InternalMetaData.g:2388:6: () ( ( ruleOpEquality ) )
            	    {
            	    // InternalMetaData.g:2388:6: ()
            	    // InternalMetaData.g:2389:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:2395:6: ( ( ruleOpEquality ) )
            	    // InternalMetaData.g:2396:7: ( ruleOpEquality )
            	    {
            	    // InternalMetaData.g:2396:7: ( ruleOpEquality )
            	    // InternalMetaData.g:2397:8: ruleOpEquality
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXEqualityExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXEqualityExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpEquality();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2413:4: ( (lv_rightOperand_3_0= ruleXRelationalExpression ) )
            	    // InternalMetaData.g:2414:5: (lv_rightOperand_3_0= ruleXRelationalExpression )
            	    {
            	    // InternalMetaData.g:2414:5: (lv_rightOperand_3_0= ruleXRelationalExpression )
            	    // InternalMetaData.g:2415:6: lv_rightOperand_3_0= ruleXRelationalExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXEqualityExpressionAccess().getRightOperandXRelationalExpressionParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_42);
            	    lv_rightOperand_3_0=ruleXRelationalExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXEqualityExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XRelationalExpression");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop35;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXEqualityExpression"


    // $ANTLR start "entryRuleOpEquality"
    // InternalMetaData.g:2437:1: entryRuleOpEquality returns [String current=null] : iv_ruleOpEquality= ruleOpEquality EOF ;
    public final String entryRuleOpEquality() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpEquality = null;


        try {
            // InternalMetaData.g:2437:50: (iv_ruleOpEquality= ruleOpEquality EOF )
            // InternalMetaData.g:2438:2: iv_ruleOpEquality= ruleOpEquality EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpEqualityRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpEquality=ruleOpEquality();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpEquality.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpEquality"


    // $ANTLR start "ruleOpEquality"
    // InternalMetaData.g:2444:1: ruleOpEquality returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '==' | kw= '!=' | kw= '===' | kw= '!==' ) ;
    public final AntlrDatatypeRuleToken ruleOpEquality() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2450:2: ( (kw= '==' | kw= '!=' | kw= '===' | kw= '!==' ) )
            // InternalMetaData.g:2451:2: (kw= '==' | kw= '!=' | kw= '===' | kw= '!==' )
            {
            // InternalMetaData.g:2451:2: (kw= '==' | kw= '!=' | kw= '===' | kw= '!==' )
            int alt36=4;
            switch ( input.LA(1) ) {
            case 39:
                {
                alt36=1;
                }
                break;
            case 61:
                {
                alt36=2;
                }
                break;
            case 62:
                {
                alt36=3;
                }
                break;
            case 63:
                {
                alt36=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 36, 0, input);

                throw nvae;
            }

            switch (alt36) {
                case 1 :
                    // InternalMetaData.g:2452:3: kw= '=='
                    {
                    kw=(Token)match(input,39,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpEqualityAccess().getEqualsSignEqualsSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:2458:3: kw= '!='
                    {
                    kw=(Token)match(input,61,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpEqualityAccess().getExclamationMarkEqualsSignKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:2464:3: kw= '==='
                    {
                    kw=(Token)match(input,62,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpEqualityAccess().getEqualsSignEqualsSignEqualsSignKeyword_2());
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:2470:3: kw= '!=='
                    {
                    kw=(Token)match(input,63,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpEqualityAccess().getExclamationMarkEqualsSignEqualsSignKeyword_3());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpEquality"


    // $ANTLR start "entryRuleXRelationalExpression"
    // InternalMetaData.g:2479:1: entryRuleXRelationalExpression returns [EObject current=null] : iv_ruleXRelationalExpression= ruleXRelationalExpression EOF ;
    public final EObject entryRuleXRelationalExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXRelationalExpression = null;


        try {
            // InternalMetaData.g:2479:62: (iv_ruleXRelationalExpression= ruleXRelationalExpression EOF )
            // InternalMetaData.g:2480:2: iv_ruleXRelationalExpression= ruleXRelationalExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXRelationalExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXRelationalExpression=ruleXRelationalExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXRelationalExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXRelationalExpression"


    // $ANTLR start "ruleXRelationalExpression"
    // InternalMetaData.g:2486:1: ruleXRelationalExpression returns [EObject current=null] : (this_XOtherOperatorExpression_0= ruleXOtherOperatorExpression ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )* ) ;
    public final EObject ruleXRelationalExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        EObject this_XOtherOperatorExpression_0 = null;

        EObject lv_type_3_0 = null;

        EObject lv_rightOperand_6_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2492:2: ( (this_XOtherOperatorExpression_0= ruleXOtherOperatorExpression ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )* ) )
            // InternalMetaData.g:2493:2: (this_XOtherOperatorExpression_0= ruleXOtherOperatorExpression ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )* )
            {
            // InternalMetaData.g:2493:2: (this_XOtherOperatorExpression_0= ruleXOtherOperatorExpression ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )* )
            // InternalMetaData.g:2494:3: this_XOtherOperatorExpression_0= ruleXOtherOperatorExpression ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXRelationalExpressionAccess().getXOtherOperatorExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_43);
            this_XOtherOperatorExpression_0=ruleXOtherOperatorExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XOtherOperatorExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2502:3: ( ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) ) | ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) ) )*
            loop37:
            do {
                int alt37=3;
                switch ( input.LA(1) ) {
                case 56:
                    {
                    int LA37_2 = input.LA(2);

                    if ( (synpred6_InternalMetaData()) ) {
                        alt37=2;
                    }


                    }
                    break;
                case 57:
                    {
                    int LA37_3 = input.LA(2);

                    if ( (synpred6_InternalMetaData()) ) {
                        alt37=2;
                    }


                    }
                    break;
                case 64:
                    {
                    int LA37_4 = input.LA(2);

                    if ( (synpred5_InternalMetaData()) ) {
                        alt37=1;
                    }


                    }
                    break;
                case 58:
                    {
                    int LA37_5 = input.LA(2);

                    if ( (synpred6_InternalMetaData()) ) {
                        alt37=2;
                    }


                    }
                    break;

                }

                switch (alt37) {
            	case 1 :
            	    // InternalMetaData.g:2503:4: ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )
            	    {
            	    // InternalMetaData.g:2503:4: ( ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )
            	    // InternalMetaData.g:2504:5: ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) )
            	    {
            	    // InternalMetaData.g:2504:5: ( ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' ) )
            	    // InternalMetaData.g:2505:6: ( ( () 'instanceof' ) )=> ( () otherlv_2= 'instanceof' )
            	    {
            	    // InternalMetaData.g:2511:6: ( () otherlv_2= 'instanceof' )
            	    // InternalMetaData.g:2512:7: () otherlv_2= 'instanceof'
            	    {
            	    // InternalMetaData.g:2512:7: ()
            	    // InternalMetaData.g:2513:8: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      								current = forceCreateModelElementAndSet(
            	      									grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0(),
            	      									current);
            	      							
            	    }

            	    }

            	    otherlv_2=(Token)match(input,64,FOLLOW_15); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							newLeafNode(otherlv_2, grammarAccess.getXRelationalExpressionAccess().getInstanceofKeyword_1_0_0_0_1());
            	      						
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:2525:5: ( (lv_type_3_0= ruleJvmTypeReference ) )
            	    // InternalMetaData.g:2526:6: (lv_type_3_0= ruleJvmTypeReference )
            	    {
            	    // InternalMetaData.g:2526:6: (lv_type_3_0= ruleJvmTypeReference )
            	    // InternalMetaData.g:2527:7: lv_type_3_0= ruleJvmTypeReference
            	    {
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getXRelationalExpressionAccess().getTypeJvmTypeReferenceParserRuleCall_1_0_1_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_43);
            	    lv_type_3_0=ruleJvmTypeReference();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElementForParent(grammarAccess.getXRelationalExpressionRule());
            	      							}
            	      							set(
            	      								current,
            	      								"type",
            	      								lv_type_3_0,
            	      								"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    // InternalMetaData.g:2546:4: ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) )
            	    {
            	    // InternalMetaData.g:2546:4: ( ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) ) )
            	    // InternalMetaData.g:2547:5: ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) ) ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) )
            	    {
            	    // InternalMetaData.g:2547:5: ( ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) ) )
            	    // InternalMetaData.g:2548:6: ( ( () ( ( ruleOpCompare ) ) ) )=> ( () ( ( ruleOpCompare ) ) )
            	    {
            	    // InternalMetaData.g:2558:6: ( () ( ( ruleOpCompare ) ) )
            	    // InternalMetaData.g:2559:7: () ( ( ruleOpCompare ) )
            	    {
            	    // InternalMetaData.g:2559:7: ()
            	    // InternalMetaData.g:2560:8: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      								current = forceCreateModelElementAndSet(
            	      									grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0(),
            	      									current);
            	      							
            	    }

            	    }

            	    // InternalMetaData.g:2566:7: ( ( ruleOpCompare ) )
            	    // InternalMetaData.g:2567:8: ( ruleOpCompare )
            	    {
            	    // InternalMetaData.g:2567:8: ( ruleOpCompare )
            	    // InternalMetaData.g:2568:9: ruleOpCompare
            	    {
            	    if ( state.backtracking==0 ) {

            	      									if (current==null) {
            	      										current = createModelElement(grammarAccess.getXRelationalExpressionRule());
            	      									}
            	      								
            	    }
            	    if ( state.backtracking==0 ) {

            	      									newCompositeNode(grammarAccess.getXRelationalExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_1_0_0_1_0());
            	      								
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpCompare();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									afterParserOrEnumRuleCall();
            	      								
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2584:5: ( (lv_rightOperand_6_0= ruleXOtherOperatorExpression ) )
            	    // InternalMetaData.g:2585:6: (lv_rightOperand_6_0= ruleXOtherOperatorExpression )
            	    {
            	    // InternalMetaData.g:2585:6: (lv_rightOperand_6_0= ruleXOtherOperatorExpression )
            	    // InternalMetaData.g:2586:7: lv_rightOperand_6_0= ruleXOtherOperatorExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getXRelationalExpressionAccess().getRightOperandXOtherOperatorExpressionParserRuleCall_1_1_1_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_43);
            	    lv_rightOperand_6_0=ruleXOtherOperatorExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElementForParent(grammarAccess.getXRelationalExpressionRule());
            	      							}
            	      							set(
            	      								current,
            	      								"rightOperand",
            	      								lv_rightOperand_6_0,
            	      								"org.eclipse.xtext.xbase.Xbase.XOtherOperatorExpression");
            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop37;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXRelationalExpression"


    // $ANTLR start "entryRuleOpCompare"
    // InternalMetaData.g:2609:1: entryRuleOpCompare returns [String current=null] : iv_ruleOpCompare= ruleOpCompare EOF ;
    public final String entryRuleOpCompare() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpCompare = null;


        try {
            // InternalMetaData.g:2609:49: (iv_ruleOpCompare= ruleOpCompare EOF )
            // InternalMetaData.g:2610:2: iv_ruleOpCompare= ruleOpCompare EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpCompareRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpCompare=ruleOpCompare();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpCompare.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpCompare"


    // $ANTLR start "ruleOpCompare"
    // InternalMetaData.g:2616:1: ruleOpCompare returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '>=' | (kw= '<' kw= '=' ) | kw= '>' | kw= '<' ) ;
    public final AntlrDatatypeRuleToken ruleOpCompare() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2622:2: ( (kw= '>=' | (kw= '<' kw= '=' ) | kw= '>' | kw= '<' ) )
            // InternalMetaData.g:2623:2: (kw= '>=' | (kw= '<' kw= '=' ) | kw= '>' | kw= '<' )
            {
            // InternalMetaData.g:2623:2: (kw= '>=' | (kw= '<' kw= '=' ) | kw= '>' | kw= '<' )
            int alt38=4;
            switch ( input.LA(1) ) {
            case 58:
                {
                alt38=1;
                }
                break;
            case 56:
                {
                int LA38_2 = input.LA(2);

                if ( (LA38_2==32) ) {
                    alt38=2;
                }
                else if ( (LA38_2==EOF||(LA38_2>=RULE_STRING && LA38_2<=RULE_DECIMAL)||LA38_2==15||(LA38_2>=41 && LA38_2<=42)||LA38_2==50||LA38_2==56||LA38_2==71||LA38_2==75||LA38_2==82||LA38_2==86||LA38_2==88||(LA38_2>=90 && LA38_2<=92)||(LA38_2>=95 && LA38_2<=107)||LA38_2==109) ) {
                    alt38=4;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 38, 2, input);

                    throw nvae;
                }
                }
                break;
            case 57:
                {
                alt38=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;
            }

            switch (alt38) {
                case 1 :
                    // InternalMetaData.g:2624:3: kw= '>='
                    {
                    kw=(Token)match(input,58,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpCompareAccess().getGreaterThanSignEqualsSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:2630:3: (kw= '<' kw= '=' )
                    {
                    // InternalMetaData.g:2630:3: (kw= '<' kw= '=' )
                    // InternalMetaData.g:2631:4: kw= '<' kw= '='
                    {
                    kw=(Token)match(input,56,FOLLOW_17); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpCompareAccess().getLessThanSignKeyword_1_0());
                      			
                    }
                    kw=(Token)match(input,32,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpCompareAccess().getEqualsSignKeyword_1_1());
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:2643:3: kw= '>'
                    {
                    kw=(Token)match(input,57,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpCompareAccess().getGreaterThanSignKeyword_2());
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:2649:3: kw= '<'
                    {
                    kw=(Token)match(input,56,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpCompareAccess().getLessThanSignKeyword_3());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpCompare"


    // $ANTLR start "entryRuleXOtherOperatorExpression"
    // InternalMetaData.g:2658:1: entryRuleXOtherOperatorExpression returns [EObject current=null] : iv_ruleXOtherOperatorExpression= ruleXOtherOperatorExpression EOF ;
    public final EObject entryRuleXOtherOperatorExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXOtherOperatorExpression = null;


        try {
            // InternalMetaData.g:2658:65: (iv_ruleXOtherOperatorExpression= ruleXOtherOperatorExpression EOF )
            // InternalMetaData.g:2659:2: iv_ruleXOtherOperatorExpression= ruleXOtherOperatorExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXOtherOperatorExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXOtherOperatorExpression=ruleXOtherOperatorExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXOtherOperatorExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXOtherOperatorExpression"


    // $ANTLR start "ruleXOtherOperatorExpression"
    // InternalMetaData.g:2665:1: ruleXOtherOperatorExpression returns [EObject current=null] : (this_XAdditiveExpression_0= ruleXAdditiveExpression ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )* ) ;
    public final EObject ruleXOtherOperatorExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XAdditiveExpression_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2671:2: ( (this_XAdditiveExpression_0= ruleXAdditiveExpression ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )* ) )
            // InternalMetaData.g:2672:2: (this_XAdditiveExpression_0= ruleXAdditiveExpression ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )* )
            {
            // InternalMetaData.g:2672:2: (this_XAdditiveExpression_0= ruleXAdditiveExpression ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )* )
            // InternalMetaData.g:2673:3: this_XAdditiveExpression_0= ruleXAdditiveExpression ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXOtherOperatorExpressionAccess().getXAdditiveExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_44);
            this_XAdditiveExpression_0=ruleXAdditiveExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XAdditiveExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2681:3: ( ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) ) )*
            loop39:
            do {
                int alt39=2;
                alt39 = dfa39.predict(input);
                switch (alt39) {
            	case 1 :
            	    // InternalMetaData.g:2682:4: ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) ) ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) )
            	    {
            	    // InternalMetaData.g:2682:4: ( ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) ) )
            	    // InternalMetaData.g:2683:5: ( ( () ( ( ruleOpOther ) ) ) )=> ( () ( ( ruleOpOther ) ) )
            	    {
            	    // InternalMetaData.g:2693:5: ( () ( ( ruleOpOther ) ) )
            	    // InternalMetaData.g:2694:6: () ( ( ruleOpOther ) )
            	    {
            	    // InternalMetaData.g:2694:6: ()
            	    // InternalMetaData.g:2695:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:2701:6: ( ( ruleOpOther ) )
            	    // InternalMetaData.g:2702:7: ( ruleOpOther )
            	    {
            	    // InternalMetaData.g:2702:7: ( ruleOpOther )
            	    // InternalMetaData.g:2703:8: ruleOpOther
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXOtherOperatorExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXOtherOperatorExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpOther();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2719:4: ( (lv_rightOperand_3_0= ruleXAdditiveExpression ) )
            	    // InternalMetaData.g:2720:5: (lv_rightOperand_3_0= ruleXAdditiveExpression )
            	    {
            	    // InternalMetaData.g:2720:5: (lv_rightOperand_3_0= ruleXAdditiveExpression )
            	    // InternalMetaData.g:2721:6: lv_rightOperand_3_0= ruleXAdditiveExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXOtherOperatorExpressionAccess().getRightOperandXAdditiveExpressionParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_44);
            	    lv_rightOperand_3_0=ruleXAdditiveExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXOtherOperatorExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XAdditiveExpression");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop39;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXOtherOperatorExpression"


    // $ANTLR start "entryRuleOpOther"
    // InternalMetaData.g:2743:1: entryRuleOpOther returns [String current=null] : iv_ruleOpOther= ruleOpOther EOF ;
    public final String entryRuleOpOther() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpOther = null;


        try {
            // InternalMetaData.g:2743:47: (iv_ruleOpOther= ruleOpOther EOF )
            // InternalMetaData.g:2744:2: iv_ruleOpOther= ruleOpOther EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpOtherRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpOther=ruleOpOther();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpOther.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpOther"


    // $ANTLR start "ruleOpOther"
    // InternalMetaData.g:2750:1: ruleOpOther returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '->' | kw= '..<' | (kw= '>' kw= '..' ) | kw= '..' | kw= '=>' | (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) ) | (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) ) | kw= '<>' | kw= '?:' ) ;
    public final AntlrDatatypeRuleToken ruleOpOther() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2756:2: ( (kw= '->' | kw= '..<' | (kw= '>' kw= '..' ) | kw= '..' | kw= '=>' | (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) ) | (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) ) | kw= '<>' | kw= '?:' ) )
            // InternalMetaData.g:2757:2: (kw= '->' | kw= '..<' | (kw= '>' kw= '..' ) | kw= '..' | kw= '=>' | (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) ) | (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) ) | kw= '<>' | kw= '?:' )
            {
            // InternalMetaData.g:2757:2: (kw= '->' | kw= '..<' | (kw= '>' kw= '..' ) | kw= '..' | kw= '=>' | (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) ) | (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) ) | kw= '<>' | kw= '?:' )
            int alt42=9;
            alt42 = dfa42.predict(input);
            switch (alt42) {
                case 1 :
                    // InternalMetaData.g:2758:3: kw= '->'
                    {
                    kw=(Token)match(input,65,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getHyphenMinusGreaterThanSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:2764:3: kw= '..<'
                    {
                    kw=(Token)match(input,66,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getFullStopFullStopLessThanSignKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:2770:3: (kw= '>' kw= '..' )
                    {
                    // InternalMetaData.g:2770:3: (kw= '>' kw= '..' )
                    // InternalMetaData.g:2771:4: kw= '>' kw= '..'
                    {
                    kw=(Token)match(input,57,FOLLOW_45); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpOtherAccess().getGreaterThanSignKeyword_2_0());
                      			
                    }
                    kw=(Token)match(input,67,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpOtherAccess().getFullStopFullStopKeyword_2_1());
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    // InternalMetaData.g:2783:3: kw= '..'
                    {
                    kw=(Token)match(input,67,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getFullStopFullStopKeyword_3());
                      		
                    }

                    }
                    break;
                case 5 :
                    // InternalMetaData.g:2789:3: kw= '=>'
                    {
                    kw=(Token)match(input,68,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getEqualsSignGreaterThanSignKeyword_4());
                      		
                    }

                    }
                    break;
                case 6 :
                    // InternalMetaData.g:2795:3: (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) )
                    {
                    // InternalMetaData.g:2795:3: (kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' ) )
                    // InternalMetaData.g:2796:4: kw= '>' ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' )
                    {
                    kw=(Token)match(input,57,FOLLOW_46); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpOtherAccess().getGreaterThanSignKeyword_5_0());
                      			
                    }
                    // InternalMetaData.g:2801:4: ( ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) ) | kw= '>' )
                    int alt40=2;
                    int LA40_0 = input.LA(1);

                    if ( (LA40_0==57) ) {
                        int LA40_1 = input.LA(2);

                        if ( (LA40_1==EOF||(LA40_1>=RULE_STRING && LA40_1<=RULE_DECIMAL)||LA40_1==15||(LA40_1>=41 && LA40_1<=42)||LA40_1==50||LA40_1==56||LA40_1==71||LA40_1==75||LA40_1==82||LA40_1==86||LA40_1==88||(LA40_1>=90 && LA40_1<=92)||(LA40_1>=95 && LA40_1<=107)||LA40_1==109) ) {
                            alt40=2;
                        }
                        else if ( (LA40_1==57) && (synpred8_InternalMetaData())) {
                            alt40=1;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return current;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 40, 1, input);

                            throw nvae;
                        }
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 40, 0, input);

                        throw nvae;
                    }
                    switch (alt40) {
                        case 1 :
                            // InternalMetaData.g:2802:5: ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) )
                            {
                            // InternalMetaData.g:2802:5: ( ( ( '>' '>' ) )=> (kw= '>' kw= '>' ) )
                            // InternalMetaData.g:2803:6: ( ( '>' '>' ) )=> (kw= '>' kw= '>' )
                            {
                            // InternalMetaData.g:2808:6: (kw= '>' kw= '>' )
                            // InternalMetaData.g:2809:7: kw= '>' kw= '>'
                            {
                            kw=(Token)match(input,57,FOLLOW_46); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							current.merge(kw);
                              							newLeafNode(kw, grammarAccess.getOpOtherAccess().getGreaterThanSignKeyword_5_1_0_0_0());
                              						
                            }
                            kw=(Token)match(input,57,FOLLOW_2); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							current.merge(kw);
                              							newLeafNode(kw, grammarAccess.getOpOtherAccess().getGreaterThanSignKeyword_5_1_0_0_1());
                              						
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:2822:5: kw= '>'
                            {
                            kw=(Token)match(input,57,FOLLOW_2); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(kw);
                              					newLeafNode(kw, grammarAccess.getOpOtherAccess().getGreaterThanSignKeyword_5_1_1());
                              				
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 7 :
                    // InternalMetaData.g:2830:3: (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) )
                    {
                    // InternalMetaData.g:2830:3: (kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' ) )
                    // InternalMetaData.g:2831:4: kw= '<' ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' )
                    {
                    kw=(Token)match(input,56,FOLLOW_47); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current.merge(kw);
                      				newLeafNode(kw, grammarAccess.getOpOtherAccess().getLessThanSignKeyword_6_0());
                      			
                    }
                    // InternalMetaData.g:2836:4: ( ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) ) | kw= '<' | kw= '=>' )
                    int alt41=3;
                    int LA41_0 = input.LA(1);

                    if ( (LA41_0==56) ) {
                        int LA41_1 = input.LA(2);

                        if ( (synpred9_InternalMetaData()) ) {
                            alt41=1;
                        }
                        else if ( (true) ) {
                            alt41=2;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return current;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 41, 1, input);

                            throw nvae;
                        }
                    }
                    else if ( (LA41_0==68) ) {
                        alt41=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 41, 0, input);

                        throw nvae;
                    }
                    switch (alt41) {
                        case 1 :
                            // InternalMetaData.g:2837:5: ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) )
                            {
                            // InternalMetaData.g:2837:5: ( ( ( '<' '<' ) )=> (kw= '<' kw= '<' ) )
                            // InternalMetaData.g:2838:6: ( ( '<' '<' ) )=> (kw= '<' kw= '<' )
                            {
                            // InternalMetaData.g:2843:6: (kw= '<' kw= '<' )
                            // InternalMetaData.g:2844:7: kw= '<' kw= '<'
                            {
                            kw=(Token)match(input,56,FOLLOW_37); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							current.merge(kw);
                              							newLeafNode(kw, grammarAccess.getOpOtherAccess().getLessThanSignKeyword_6_1_0_0_0());
                              						
                            }
                            kw=(Token)match(input,56,FOLLOW_2); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							current.merge(kw);
                              							newLeafNode(kw, grammarAccess.getOpOtherAccess().getLessThanSignKeyword_6_1_0_0_1());
                              						
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:2857:5: kw= '<'
                            {
                            kw=(Token)match(input,56,FOLLOW_2); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(kw);
                              					newLeafNode(kw, grammarAccess.getOpOtherAccess().getLessThanSignKeyword_6_1_1());
                              				
                            }

                            }
                            break;
                        case 3 :
                            // InternalMetaData.g:2863:5: kw= '=>'
                            {
                            kw=(Token)match(input,68,FOLLOW_2); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(kw);
                              					newLeafNode(kw, grammarAccess.getOpOtherAccess().getEqualsSignGreaterThanSignKeyword_6_1_2());
                              				
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 8 :
                    // InternalMetaData.g:2871:3: kw= '<>'
                    {
                    kw=(Token)match(input,69,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getLessThanSignGreaterThanSignKeyword_7());
                      		
                    }

                    }
                    break;
                case 9 :
                    // InternalMetaData.g:2877:3: kw= '?:'
                    {
                    kw=(Token)match(input,70,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpOtherAccess().getQuestionMarkColonKeyword_8());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpOther"


    // $ANTLR start "entryRuleXAdditiveExpression"
    // InternalMetaData.g:2886:1: entryRuleXAdditiveExpression returns [EObject current=null] : iv_ruleXAdditiveExpression= ruleXAdditiveExpression EOF ;
    public final EObject entryRuleXAdditiveExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXAdditiveExpression = null;


        try {
            // InternalMetaData.g:2886:60: (iv_ruleXAdditiveExpression= ruleXAdditiveExpression EOF )
            // InternalMetaData.g:2887:2: iv_ruleXAdditiveExpression= ruleXAdditiveExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXAdditiveExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXAdditiveExpression=ruleXAdditiveExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXAdditiveExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXAdditiveExpression"


    // $ANTLR start "ruleXAdditiveExpression"
    // InternalMetaData.g:2893:1: ruleXAdditiveExpression returns [EObject current=null] : (this_XMultiplicativeExpression_0= ruleXMultiplicativeExpression ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )* ) ;
    public final EObject ruleXAdditiveExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XMultiplicativeExpression_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:2899:2: ( (this_XMultiplicativeExpression_0= ruleXMultiplicativeExpression ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )* ) )
            // InternalMetaData.g:2900:2: (this_XMultiplicativeExpression_0= ruleXMultiplicativeExpression ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )* )
            {
            // InternalMetaData.g:2900:2: (this_XMultiplicativeExpression_0= ruleXMultiplicativeExpression ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )* )
            // InternalMetaData.g:2901:3: this_XMultiplicativeExpression_0= ruleXMultiplicativeExpression ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXAdditiveExpressionAccess().getXMultiplicativeExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_48);
            this_XMultiplicativeExpression_0=ruleXMultiplicativeExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XMultiplicativeExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:2909:3: ( ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) ) )*
            loop43:
            do {
                int alt43=2;
                int LA43_0 = input.LA(1);

                if ( (LA43_0==71) ) {
                    int LA43_2 = input.LA(2);

                    if ( (synpred10_InternalMetaData()) ) {
                        alt43=1;
                    }


                }
                else if ( (LA43_0==50) ) {
                    int LA43_3 = input.LA(2);

                    if ( (synpred10_InternalMetaData()) ) {
                        alt43=1;
                    }


                }


                switch (alt43) {
            	case 1 :
            	    // InternalMetaData.g:2910:4: ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) ) ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) )
            	    {
            	    // InternalMetaData.g:2910:4: ( ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) ) )
            	    // InternalMetaData.g:2911:5: ( ( () ( ( ruleOpAdd ) ) ) )=> ( () ( ( ruleOpAdd ) ) )
            	    {
            	    // InternalMetaData.g:2921:5: ( () ( ( ruleOpAdd ) ) )
            	    // InternalMetaData.g:2922:6: () ( ( ruleOpAdd ) )
            	    {
            	    // InternalMetaData.g:2922:6: ()
            	    // InternalMetaData.g:2923:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:2929:6: ( ( ruleOpAdd ) )
            	    // InternalMetaData.g:2930:7: ( ruleOpAdd )
            	    {
            	    // InternalMetaData.g:2930:7: ( ruleOpAdd )
            	    // InternalMetaData.g:2931:8: ruleOpAdd
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXAdditiveExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXAdditiveExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpAdd();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:2947:4: ( (lv_rightOperand_3_0= ruleXMultiplicativeExpression ) )
            	    // InternalMetaData.g:2948:5: (lv_rightOperand_3_0= ruleXMultiplicativeExpression )
            	    {
            	    // InternalMetaData.g:2948:5: (lv_rightOperand_3_0= ruleXMultiplicativeExpression )
            	    // InternalMetaData.g:2949:6: lv_rightOperand_3_0= ruleXMultiplicativeExpression
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXAdditiveExpressionAccess().getRightOperandXMultiplicativeExpressionParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_48);
            	    lv_rightOperand_3_0=ruleXMultiplicativeExpression();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXAdditiveExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XMultiplicativeExpression");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop43;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXAdditiveExpression"


    // $ANTLR start "entryRuleOpAdd"
    // InternalMetaData.g:2971:1: entryRuleOpAdd returns [String current=null] : iv_ruleOpAdd= ruleOpAdd EOF ;
    public final String entryRuleOpAdd() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpAdd = null;


        try {
            // InternalMetaData.g:2971:45: (iv_ruleOpAdd= ruleOpAdd EOF )
            // InternalMetaData.g:2972:2: iv_ruleOpAdd= ruleOpAdd EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpAddRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpAdd=ruleOpAdd();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpAdd.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpAdd"


    // $ANTLR start "ruleOpAdd"
    // InternalMetaData.g:2978:1: ruleOpAdd returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '+' | kw= '-' ) ;
    public final AntlrDatatypeRuleToken ruleOpAdd() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:2984:2: ( (kw= '+' | kw= '-' ) )
            // InternalMetaData.g:2985:2: (kw= '+' | kw= '-' )
            {
            // InternalMetaData.g:2985:2: (kw= '+' | kw= '-' )
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==71) ) {
                alt44=1;
            }
            else if ( (LA44_0==50) ) {
                alt44=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }
            switch (alt44) {
                case 1 :
                    // InternalMetaData.g:2986:3: kw= '+'
                    {
                    kw=(Token)match(input,71,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpAddAccess().getPlusSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:2992:3: kw= '-'
                    {
                    kw=(Token)match(input,50,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpAddAccess().getHyphenMinusKeyword_1());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpAdd"


    // $ANTLR start "entryRuleXMultiplicativeExpression"
    // InternalMetaData.g:3001:1: entryRuleXMultiplicativeExpression returns [EObject current=null] : iv_ruleXMultiplicativeExpression= ruleXMultiplicativeExpression EOF ;
    public final EObject entryRuleXMultiplicativeExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXMultiplicativeExpression = null;


        try {
            // InternalMetaData.g:3001:66: (iv_ruleXMultiplicativeExpression= ruleXMultiplicativeExpression EOF )
            // InternalMetaData.g:3002:2: iv_ruleXMultiplicativeExpression= ruleXMultiplicativeExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXMultiplicativeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXMultiplicativeExpression=ruleXMultiplicativeExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXMultiplicativeExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXMultiplicativeExpression"


    // $ANTLR start "ruleXMultiplicativeExpression"
    // InternalMetaData.g:3008:1: ruleXMultiplicativeExpression returns [EObject current=null] : (this_XUnaryOperation_0= ruleXUnaryOperation ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )* ) ;
    public final EObject ruleXMultiplicativeExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XUnaryOperation_0 = null;

        EObject lv_rightOperand_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3014:2: ( (this_XUnaryOperation_0= ruleXUnaryOperation ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )* ) )
            // InternalMetaData.g:3015:2: (this_XUnaryOperation_0= ruleXUnaryOperation ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )* )
            {
            // InternalMetaData.g:3015:2: (this_XUnaryOperation_0= ruleXUnaryOperation ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )* )
            // InternalMetaData.g:3016:3: this_XUnaryOperation_0= ruleXUnaryOperation ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXMultiplicativeExpressionAccess().getXUnaryOperationParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_49);
            this_XUnaryOperation_0=ruleXUnaryOperation();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XUnaryOperation_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:3024:3: ( ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) ) )*
            loop45:
            do {
                int alt45=2;
                switch ( input.LA(1) ) {
                case 72:
                    {
                    int LA45_2 = input.LA(2);

                    if ( (synpred11_InternalMetaData()) ) {
                        alt45=1;
                    }


                    }
                    break;
                case 73:
                    {
                    int LA45_3 = input.LA(2);

                    if ( (synpred11_InternalMetaData()) ) {
                        alt45=1;
                    }


                    }
                    break;
                case 49:
                    {
                    int LA45_4 = input.LA(2);

                    if ( (synpred11_InternalMetaData()) ) {
                        alt45=1;
                    }


                    }
                    break;
                case 74:
                    {
                    int LA45_5 = input.LA(2);

                    if ( (synpred11_InternalMetaData()) ) {
                        alt45=1;
                    }


                    }
                    break;

                }

                switch (alt45) {
            	case 1 :
            	    // InternalMetaData.g:3025:4: ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) ) ( (lv_rightOperand_3_0= ruleXUnaryOperation ) )
            	    {
            	    // InternalMetaData.g:3025:4: ( ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) ) )
            	    // InternalMetaData.g:3026:5: ( ( () ( ( ruleOpMulti ) ) ) )=> ( () ( ( ruleOpMulti ) ) )
            	    {
            	    // InternalMetaData.g:3036:5: ( () ( ( ruleOpMulti ) ) )
            	    // InternalMetaData.g:3037:6: () ( ( ruleOpMulti ) )
            	    {
            	    // InternalMetaData.g:3037:6: ()
            	    // InternalMetaData.g:3038:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    // InternalMetaData.g:3044:6: ( ( ruleOpMulti ) )
            	    // InternalMetaData.g:3045:7: ( ruleOpMulti )
            	    {
            	    // InternalMetaData.g:3045:7: ( ruleOpMulti )
            	    // InternalMetaData.g:3046:8: ruleOpMulti
            	    {
            	    if ( state.backtracking==0 ) {

            	      								if (current==null) {
            	      									current = createModelElement(grammarAccess.getXMultiplicativeExpressionRule());
            	      								}
            	      							
            	    }
            	    if ( state.backtracking==0 ) {

            	      								newCompositeNode(grammarAccess.getXMultiplicativeExpressionAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_1_0());
            	      							
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpMulti();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      								afterParserOrEnumRuleCall();
            	      							
            	    }

            	    }


            	    }


            	    }


            	    }

            	    // InternalMetaData.g:3062:4: ( (lv_rightOperand_3_0= ruleXUnaryOperation ) )
            	    // InternalMetaData.g:3063:5: (lv_rightOperand_3_0= ruleXUnaryOperation )
            	    {
            	    // InternalMetaData.g:3063:5: (lv_rightOperand_3_0= ruleXUnaryOperation )
            	    // InternalMetaData.g:3064:6: lv_rightOperand_3_0= ruleXUnaryOperation
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXMultiplicativeExpressionAccess().getRightOperandXUnaryOperationParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_49);
            	    lv_rightOperand_3_0=ruleXUnaryOperation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXMultiplicativeExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"rightOperand",
            	      							lv_rightOperand_3_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XUnaryOperation");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop45;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXMultiplicativeExpression"


    // $ANTLR start "entryRuleOpMulti"
    // InternalMetaData.g:3086:1: entryRuleOpMulti returns [String current=null] : iv_ruleOpMulti= ruleOpMulti EOF ;
    public final String entryRuleOpMulti() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpMulti = null;


        try {
            // InternalMetaData.g:3086:47: (iv_ruleOpMulti= ruleOpMulti EOF )
            // InternalMetaData.g:3087:2: iv_ruleOpMulti= ruleOpMulti EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpMultiRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpMulti=ruleOpMulti();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpMulti.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpMulti"


    // $ANTLR start "ruleOpMulti"
    // InternalMetaData.g:3093:1: ruleOpMulti returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '*' | kw= '**' | kw= '/' | kw= '%' ) ;
    public final AntlrDatatypeRuleToken ruleOpMulti() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:3099:2: ( (kw= '*' | kw= '**' | kw= '/' | kw= '%' ) )
            // InternalMetaData.g:3100:2: (kw= '*' | kw= '**' | kw= '/' | kw= '%' )
            {
            // InternalMetaData.g:3100:2: (kw= '*' | kw= '**' | kw= '/' | kw= '%' )
            int alt46=4;
            switch ( input.LA(1) ) {
            case 72:
                {
                alt46=1;
                }
                break;
            case 73:
                {
                alt46=2;
                }
                break;
            case 49:
                {
                alt46=3;
                }
                break;
            case 74:
                {
                alt46=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;
            }

            switch (alt46) {
                case 1 :
                    // InternalMetaData.g:3101:3: kw= '*'
                    {
                    kw=(Token)match(input,72,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAccess().getAsteriskKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:3107:3: kw= '**'
                    {
                    kw=(Token)match(input,73,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAccess().getAsteriskAsteriskKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:3113:3: kw= '/'
                    {
                    kw=(Token)match(input,49,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAccess().getSolidusKeyword_2());
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:3119:3: kw= '%'
                    {
                    kw=(Token)match(input,74,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpMultiAccess().getPercentSignKeyword_3());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpMulti"


    // $ANTLR start "entryRuleXUnaryOperation"
    // InternalMetaData.g:3128:1: entryRuleXUnaryOperation returns [EObject current=null] : iv_ruleXUnaryOperation= ruleXUnaryOperation EOF ;
    public final EObject entryRuleXUnaryOperation() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXUnaryOperation = null;


        try {
            // InternalMetaData.g:3128:56: (iv_ruleXUnaryOperation= ruleXUnaryOperation EOF )
            // InternalMetaData.g:3129:2: iv_ruleXUnaryOperation= ruleXUnaryOperation EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXUnaryOperationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXUnaryOperation=ruleXUnaryOperation();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXUnaryOperation; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXUnaryOperation"


    // $ANTLR start "ruleXUnaryOperation"
    // InternalMetaData.g:3135:1: ruleXUnaryOperation returns [EObject current=null] : ( ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) ) | this_XCastedExpression_3= ruleXCastedExpression ) ;
    public final EObject ruleXUnaryOperation() throws RecognitionException {
        EObject current = null;

        EObject lv_operand_2_0 = null;

        EObject this_XCastedExpression_3 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3141:2: ( ( ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) ) | this_XCastedExpression_3= ruleXCastedExpression ) )
            // InternalMetaData.g:3142:2: ( ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) ) | this_XCastedExpression_3= ruleXCastedExpression )
            {
            // InternalMetaData.g:3142:2: ( ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) ) | this_XCastedExpression_3= ruleXCastedExpression )
            int alt47=2;
            int LA47_0 = input.LA(1);

            if ( (LA47_0==50||LA47_0==71||LA47_0==75) ) {
                alt47=1;
            }
            else if ( ((LA47_0>=RULE_STRING && LA47_0<=RULE_DECIMAL)||LA47_0==15||(LA47_0>=41 && LA47_0<=42)||LA47_0==56||LA47_0==82||LA47_0==86||LA47_0==88||(LA47_0>=90 && LA47_0<=92)||(LA47_0>=95 && LA47_0<=107)||LA47_0==109) ) {
                alt47=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;
            }
            switch (alt47) {
                case 1 :
                    // InternalMetaData.g:3143:3: ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) )
                    {
                    // InternalMetaData.g:3143:3: ( () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) ) )
                    // InternalMetaData.g:3144:4: () ( ( ruleOpUnary ) ) ( (lv_operand_2_0= ruleXUnaryOperation ) )
                    {
                    // InternalMetaData.g:3144:4: ()
                    // InternalMetaData.g:3145:5: 
                    {
                    if ( state.backtracking==0 ) {

                      					current = forceCreateModelElement(
                      						grammarAccess.getXUnaryOperationAccess().getXUnaryOperationAction_0_0(),
                      						current);
                      				
                    }

                    }

                    // InternalMetaData.g:3151:4: ( ( ruleOpUnary ) )
                    // InternalMetaData.g:3152:5: ( ruleOpUnary )
                    {
                    // InternalMetaData.g:3152:5: ( ruleOpUnary )
                    // InternalMetaData.g:3153:6: ruleOpUnary
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXUnaryOperationRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXUnaryOperationAccess().getFeatureJvmIdentifiableElementCrossReference_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_18);
                    ruleOpUnary();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:3167:4: ( (lv_operand_2_0= ruleXUnaryOperation ) )
                    // InternalMetaData.g:3168:5: (lv_operand_2_0= ruleXUnaryOperation )
                    {
                    // InternalMetaData.g:3168:5: (lv_operand_2_0= ruleXUnaryOperation )
                    // InternalMetaData.g:3169:6: lv_operand_2_0= ruleXUnaryOperation
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXUnaryOperationAccess().getOperandXUnaryOperationParserRuleCall_0_2_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_operand_2_0=ruleXUnaryOperation();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXUnaryOperationRule());
                      						}
                      						set(
                      							current,
                      							"operand",
                      							lv_operand_2_0,
                      							"org.eclipse.xtext.xbase.Xbase.XUnaryOperation");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:3188:3: this_XCastedExpression_3= ruleXCastedExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXUnaryOperationAccess().getXCastedExpressionParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XCastedExpression_3=ruleXCastedExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XCastedExpression_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXUnaryOperation"


    // $ANTLR start "entryRuleOpUnary"
    // InternalMetaData.g:3200:1: entryRuleOpUnary returns [String current=null] : iv_ruleOpUnary= ruleOpUnary EOF ;
    public final String entryRuleOpUnary() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpUnary = null;


        try {
            // InternalMetaData.g:3200:47: (iv_ruleOpUnary= ruleOpUnary EOF )
            // InternalMetaData.g:3201:2: iv_ruleOpUnary= ruleOpUnary EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpUnaryRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpUnary=ruleOpUnary();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpUnary.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpUnary"


    // $ANTLR start "ruleOpUnary"
    // InternalMetaData.g:3207:1: ruleOpUnary returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '!' | kw= '-' | kw= '+' ) ;
    public final AntlrDatatypeRuleToken ruleOpUnary() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:3213:2: ( (kw= '!' | kw= '-' | kw= '+' ) )
            // InternalMetaData.g:3214:2: (kw= '!' | kw= '-' | kw= '+' )
            {
            // InternalMetaData.g:3214:2: (kw= '!' | kw= '-' | kw= '+' )
            int alt48=3;
            switch ( input.LA(1) ) {
            case 75:
                {
                alt48=1;
                }
                break;
            case 50:
                {
                alt48=2;
                }
                break;
            case 71:
                {
                alt48=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }

            switch (alt48) {
                case 1 :
                    // InternalMetaData.g:3215:3: kw= '!'
                    {
                    kw=(Token)match(input,75,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpUnaryAccess().getExclamationMarkKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:3221:3: kw= '-'
                    {
                    kw=(Token)match(input,50,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpUnaryAccess().getHyphenMinusKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:3227:3: kw= '+'
                    {
                    kw=(Token)match(input,71,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpUnaryAccess().getPlusSignKeyword_2());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpUnary"


    // $ANTLR start "entryRuleXCastedExpression"
    // InternalMetaData.g:3236:1: entryRuleXCastedExpression returns [EObject current=null] : iv_ruleXCastedExpression= ruleXCastedExpression EOF ;
    public final EObject entryRuleXCastedExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXCastedExpression = null;


        try {
            // InternalMetaData.g:3236:58: (iv_ruleXCastedExpression= ruleXCastedExpression EOF )
            // InternalMetaData.g:3237:2: iv_ruleXCastedExpression= ruleXCastedExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXCastedExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXCastedExpression=ruleXCastedExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXCastedExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXCastedExpression"


    // $ANTLR start "ruleXCastedExpression"
    // InternalMetaData.g:3243:1: ruleXCastedExpression returns [EObject current=null] : (this_XPostfixOperation_0= ruleXPostfixOperation ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )* ) ;
    public final EObject ruleXCastedExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        EObject this_XPostfixOperation_0 = null;

        EObject lv_type_3_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3249:2: ( (this_XPostfixOperation_0= ruleXPostfixOperation ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )* ) )
            // InternalMetaData.g:3250:2: (this_XPostfixOperation_0= ruleXPostfixOperation ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )* )
            {
            // InternalMetaData.g:3250:2: (this_XPostfixOperation_0= ruleXPostfixOperation ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )* )
            // InternalMetaData.g:3251:3: this_XPostfixOperation_0= ruleXPostfixOperation ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXCastedExpressionAccess().getXPostfixOperationParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_50);
            this_XPostfixOperation_0=ruleXPostfixOperation();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XPostfixOperation_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:3259:3: ( ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) ) )*
            loop49:
            do {
                int alt49=2;
                int LA49_0 = input.LA(1);

                if ( (LA49_0==76) ) {
                    int LA49_2 = input.LA(2);

                    if ( (synpred12_InternalMetaData()) ) {
                        alt49=1;
                    }


                }


                switch (alt49) {
            	case 1 :
            	    // InternalMetaData.g:3260:4: ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) ) ( (lv_type_3_0= ruleJvmTypeReference ) )
            	    {
            	    // InternalMetaData.g:3260:4: ( ( ( () 'as' ) )=> ( () otherlv_2= 'as' ) )
            	    // InternalMetaData.g:3261:5: ( ( () 'as' ) )=> ( () otherlv_2= 'as' )
            	    {
            	    // InternalMetaData.g:3267:5: ( () otherlv_2= 'as' )
            	    // InternalMetaData.g:3268:6: () otherlv_2= 'as'
            	    {
            	    // InternalMetaData.g:3268:6: ()
            	    // InternalMetaData.g:3269:7: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      							current = forceCreateModelElementAndSet(
            	      								grammarAccess.getXCastedExpressionAccess().getXCastedExpressionTargetAction_1_0_0_0(),
            	      								current);
            	      						
            	    }

            	    }

            	    otherlv_2=(Token)match(input,76,FOLLOW_15); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						newLeafNode(otherlv_2, grammarAccess.getXCastedExpressionAccess().getAsKeyword_1_0_0_1());
            	      					
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:3281:4: ( (lv_type_3_0= ruleJvmTypeReference ) )
            	    // InternalMetaData.g:3282:5: (lv_type_3_0= ruleJvmTypeReference )
            	    {
            	    // InternalMetaData.g:3282:5: (lv_type_3_0= ruleJvmTypeReference )
            	    // InternalMetaData.g:3283:6: lv_type_3_0= ruleJvmTypeReference
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXCastedExpressionAccess().getTypeJvmTypeReferenceParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_50);
            	    lv_type_3_0=ruleJvmTypeReference();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXCastedExpressionRule());
            	      						}
            	      						set(
            	      							current,
            	      							"type",
            	      							lv_type_3_0,
            	      							"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop49;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXCastedExpression"


    // $ANTLR start "entryRuleXPostfixOperation"
    // InternalMetaData.g:3305:1: entryRuleXPostfixOperation returns [EObject current=null] : iv_ruleXPostfixOperation= ruleXPostfixOperation EOF ;
    public final EObject entryRuleXPostfixOperation() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXPostfixOperation = null;


        try {
            // InternalMetaData.g:3305:58: (iv_ruleXPostfixOperation= ruleXPostfixOperation EOF )
            // InternalMetaData.g:3306:2: iv_ruleXPostfixOperation= ruleXPostfixOperation EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXPostfixOperationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXPostfixOperation=ruleXPostfixOperation();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXPostfixOperation; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXPostfixOperation"


    // $ANTLR start "ruleXPostfixOperation"
    // InternalMetaData.g:3312:1: ruleXPostfixOperation returns [EObject current=null] : (this_XMemberFeatureCall_0= ruleXMemberFeatureCall ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )? ) ;
    public final EObject ruleXPostfixOperation() throws RecognitionException {
        EObject current = null;

        EObject this_XMemberFeatureCall_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3318:2: ( (this_XMemberFeatureCall_0= ruleXMemberFeatureCall ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )? ) )
            // InternalMetaData.g:3319:2: (this_XMemberFeatureCall_0= ruleXMemberFeatureCall ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )? )
            {
            // InternalMetaData.g:3319:2: (this_XMemberFeatureCall_0= ruleXMemberFeatureCall ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )? )
            // InternalMetaData.g:3320:3: this_XMemberFeatureCall_0= ruleXMemberFeatureCall ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )?
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXPostfixOperationAccess().getXMemberFeatureCallParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_51);
            this_XMemberFeatureCall_0=ruleXMemberFeatureCall();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XMemberFeatureCall_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:3328:3: ( ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) ) )?
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==77) ) {
                int LA50_1 = input.LA(2);

                if ( (synpred13_InternalMetaData()) ) {
                    alt50=1;
                }
            }
            else if ( (LA50_0==78) ) {
                int LA50_2 = input.LA(2);

                if ( (synpred13_InternalMetaData()) ) {
                    alt50=1;
                }
            }
            switch (alt50) {
                case 1 :
                    // InternalMetaData.g:3329:4: ( ( () ( ( ruleOpPostfix ) ) ) )=> ( () ( ( ruleOpPostfix ) ) )
                    {
                    // InternalMetaData.g:3339:4: ( () ( ( ruleOpPostfix ) ) )
                    // InternalMetaData.g:3340:5: () ( ( ruleOpPostfix ) )
                    {
                    // InternalMetaData.g:3340:5: ()
                    // InternalMetaData.g:3341:6: 
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0(),
                      							current);
                      					
                    }

                    }

                    // InternalMetaData.g:3347:5: ( ( ruleOpPostfix ) )
                    // InternalMetaData.g:3348:6: ( ruleOpPostfix )
                    {
                    // InternalMetaData.g:3348:6: ( ruleOpPostfix )
                    // InternalMetaData.g:3349:7: ruleOpPostfix
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getXPostfixOperationRule());
                      							}
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXPostfixOperationAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    ruleOpPostfix();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXPostfixOperation"


    // $ANTLR start "entryRuleOpPostfix"
    // InternalMetaData.g:3369:1: entryRuleOpPostfix returns [String current=null] : iv_ruleOpPostfix= ruleOpPostfix EOF ;
    public final String entryRuleOpPostfix() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleOpPostfix = null;


        try {
            // InternalMetaData.g:3369:49: (iv_ruleOpPostfix= ruleOpPostfix EOF )
            // InternalMetaData.g:3370:2: iv_ruleOpPostfix= ruleOpPostfix EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getOpPostfixRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleOpPostfix=ruleOpPostfix();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleOpPostfix.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleOpPostfix"


    // $ANTLR start "ruleOpPostfix"
    // InternalMetaData.g:3376:1: ruleOpPostfix returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '++' | kw= '--' ) ;
    public final AntlrDatatypeRuleToken ruleOpPostfix() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:3382:2: ( (kw= '++' | kw= '--' ) )
            // InternalMetaData.g:3383:2: (kw= '++' | kw= '--' )
            {
            // InternalMetaData.g:3383:2: (kw= '++' | kw= '--' )
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( (LA51_0==77) ) {
                alt51=1;
            }
            else if ( (LA51_0==78) ) {
                alt51=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;
            }
            switch (alt51) {
                case 1 :
                    // InternalMetaData.g:3384:3: kw= '++'
                    {
                    kw=(Token)match(input,77,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpPostfixAccess().getPlusSignPlusSignKeyword_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:3390:3: kw= '--'
                    {
                    kw=(Token)match(input,78,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getOpPostfixAccess().getHyphenMinusHyphenMinusKeyword_1());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleOpPostfix"


    // $ANTLR start "entryRuleXMemberFeatureCall"
    // InternalMetaData.g:3399:1: entryRuleXMemberFeatureCall returns [EObject current=null] : iv_ruleXMemberFeatureCall= ruleXMemberFeatureCall EOF ;
    public final EObject entryRuleXMemberFeatureCall() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXMemberFeatureCall = null;


        try {
            // InternalMetaData.g:3399:59: (iv_ruleXMemberFeatureCall= ruleXMemberFeatureCall EOF )
            // InternalMetaData.g:3400:2: iv_ruleXMemberFeatureCall= ruleXMemberFeatureCall EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXMemberFeatureCallRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXMemberFeatureCall=ruleXMemberFeatureCall();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXMemberFeatureCall; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXMemberFeatureCall"


    // $ANTLR start "ruleXMemberFeatureCall"
    // InternalMetaData.g:3406:1: ruleXMemberFeatureCall returns [EObject current=null] : (this_XPrimaryExpression_0= ruleXPrimaryExpression ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )* ) ;
    public final EObject ruleXMemberFeatureCall() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        Token lv_explicitStatic_3_0=null;
        Token otherlv_8=null;
        Token lv_nullSafe_9_0=null;
        Token lv_explicitStatic_10_0=null;
        Token otherlv_11=null;
        Token otherlv_13=null;
        Token otherlv_15=null;
        Token lv_explicitOperationCall_17_0=null;
        Token otherlv_20=null;
        Token otherlv_22=null;
        EObject this_XPrimaryExpression_0 = null;

        EObject lv_value_6_0 = null;

        EObject lv_typeArguments_12_0 = null;

        EObject lv_typeArguments_14_0 = null;

        EObject lv_memberCallArguments_18_0 = null;

        EObject lv_memberCallArguments_19_0 = null;

        EObject lv_memberCallArguments_21_0 = null;

        EObject lv_memberCallArguments_23_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3412:2: ( (this_XPrimaryExpression_0= ruleXPrimaryExpression ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )* ) )
            // InternalMetaData.g:3413:2: (this_XPrimaryExpression_0= ruleXPrimaryExpression ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )* )
            {
            // InternalMetaData.g:3413:2: (this_XPrimaryExpression_0= ruleXPrimaryExpression ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )* )
            // InternalMetaData.g:3414:3: this_XPrimaryExpression_0= ruleXPrimaryExpression ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getXPrimaryExpressionParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_52);
            this_XPrimaryExpression_0=ruleXPrimaryExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XPrimaryExpression_0;
              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:3422:3: ( ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) ) | ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? ) )*
            loop60:
            do {
                int alt60=3;
                switch ( input.LA(1) ) {
                case 79:
                    {
                    int LA60_2 = input.LA(2);

                    if ( (synpred14_InternalMetaData()) ) {
                        alt60=1;
                    }
                    else if ( (synpred15_InternalMetaData()) ) {
                        alt60=2;
                    }


                    }
                    break;
                case 80:
                    {
                    int LA60_3 = input.LA(2);

                    if ( (synpred14_InternalMetaData()) ) {
                        alt60=1;
                    }
                    else if ( (synpred15_InternalMetaData()) ) {
                        alt60=2;
                    }


                    }
                    break;
                case 81:
                    {
                    int LA60_4 = input.LA(2);

                    if ( (synpred15_InternalMetaData()) ) {
                        alt60=2;
                    }


                    }
                    break;

                }

                switch (alt60) {
            	case 1 :
            	    // InternalMetaData.g:3423:4: ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) )
            	    {
            	    // InternalMetaData.g:3423:4: ( ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) ) )
            	    // InternalMetaData.g:3424:5: ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) ) ( (lv_value_6_0= ruleXAssignment ) )
            	    {
            	    // InternalMetaData.g:3424:5: ( ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )
            	    // InternalMetaData.g:3425:6: ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )=> ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign )
            	    {
            	    // InternalMetaData.g:3445:6: ( () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign )
            	    // InternalMetaData.g:3446:7: () (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign
            	    {
            	    // InternalMetaData.g:3446:7: ()
            	    // InternalMetaData.g:3447:8: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      								current = forceCreateModelElementAndSet(
            	      									grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0(),
            	      									current);
            	      							
            	    }

            	    }

            	    // InternalMetaData.g:3453:7: (otherlv_2= '.' | ( (lv_explicitStatic_3_0= '::' ) ) )
            	    int alt52=2;
            	    int LA52_0 = input.LA(1);

            	    if ( (LA52_0==79) ) {
            	        alt52=1;
            	    }
            	    else if ( (LA52_0==80) ) {
            	        alt52=2;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 52, 0, input);

            	        throw nvae;
            	    }
            	    switch (alt52) {
            	        case 1 :
            	            // InternalMetaData.g:3454:8: otherlv_2= '.'
            	            {
            	            otherlv_2=(Token)match(input,79,FOLLOW_53); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              								newLeafNode(otherlv_2, grammarAccess.getXMemberFeatureCallAccess().getFullStopKeyword_1_0_0_0_1_0());
            	              							
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // InternalMetaData.g:3459:8: ( (lv_explicitStatic_3_0= '::' ) )
            	            {
            	            // InternalMetaData.g:3459:8: ( (lv_explicitStatic_3_0= '::' ) )
            	            // InternalMetaData.g:3460:9: (lv_explicitStatic_3_0= '::' )
            	            {
            	            // InternalMetaData.g:3460:9: (lv_explicitStatic_3_0= '::' )
            	            // InternalMetaData.g:3461:10: lv_explicitStatic_3_0= '::'
            	            {
            	            lv_explicitStatic_3_0=(Token)match(input,80,FOLLOW_53); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              										newLeafNode(lv_explicitStatic_3_0, grammarAccess.getXMemberFeatureCallAccess().getExplicitStaticColonColonKeyword_1_0_0_0_1_1_0());
            	              									
            	            }
            	            if ( state.backtracking==0 ) {

            	              										if (current==null) {
            	              											current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	              										}
            	              										setWithLastConsumed(current, "explicitStatic", true, "::");
            	              									
            	            }

            	            }


            	            }


            	            }
            	            break;

            	    }

            	    // InternalMetaData.g:3474:7: ( ( ruleFeatureCallID ) )
            	    // InternalMetaData.g:3475:8: ( ruleFeatureCallID )
            	    {
            	    // InternalMetaData.g:3475:8: ( ruleFeatureCallID )
            	    // InternalMetaData.g:3476:9: ruleFeatureCallID
            	    {
            	    if ( state.backtracking==0 ) {

            	      									if (current==null) {
            	      										current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	      									}
            	      								
            	    }
            	    if ( state.backtracking==0 ) {

            	      									newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getFeatureJvmIdentifiableElementCrossReference_1_0_0_0_2_0());
            	      								
            	    }
            	    pushFollow(FOLLOW_17);
            	    ruleFeatureCallID();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      									afterParserOrEnumRuleCall();
            	      								
            	    }

            	    }


            	    }

            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getOpSingleAssignParserRuleCall_1_0_0_0_3());
            	      						
            	    }
            	    pushFollow(FOLLOW_18);
            	    ruleOpSingleAssign();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:3499:5: ( (lv_value_6_0= ruleXAssignment ) )
            	    // InternalMetaData.g:3500:6: (lv_value_6_0= ruleXAssignment )
            	    {
            	    // InternalMetaData.g:3500:6: (lv_value_6_0= ruleXAssignment )
            	    // InternalMetaData.g:3501:7: lv_value_6_0= ruleXAssignment
            	    {
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getValueXAssignmentParserRuleCall_1_0_1_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_52);
            	    lv_value_6_0=ruleXAssignment();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	      							}
            	      							set(
            	      								current,
            	      								"value",
            	      								lv_value_6_0,
            	      								"org.eclipse.xtext.xbase.Xbase.XAssignment");
            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    // InternalMetaData.g:3520:4: ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? )
            	    {
            	    // InternalMetaData.g:3520:4: ( ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )? )
            	    // InternalMetaData.g:3521:5: ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) ) (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )? ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )?
            	    {
            	    // InternalMetaData.g:3521:5: ( ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) ) )
            	    // InternalMetaData.g:3522:6: ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )=> ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) )
            	    {
            	    // InternalMetaData.g:3542:6: ( () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) ) )
            	    // InternalMetaData.g:3543:7: () (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) )
            	    {
            	    // InternalMetaData.g:3543:7: ()
            	    // InternalMetaData.g:3544:8: 
            	    {
            	    if ( state.backtracking==0 ) {

            	      								current = forceCreateModelElementAndSet(
            	      									grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0(),
            	      									current);
            	      							
            	    }

            	    }

            	    // InternalMetaData.g:3550:7: (otherlv_8= '.' | ( (lv_nullSafe_9_0= '?.' ) ) | ( (lv_explicitStatic_10_0= '::' ) ) )
            	    int alt53=3;
            	    switch ( input.LA(1) ) {
            	    case 79:
            	        {
            	        alt53=1;
            	        }
            	        break;
            	    case 81:
            	        {
            	        alt53=2;
            	        }
            	        break;
            	    case 80:
            	        {
            	        alt53=3;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return current;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 53, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt53) {
            	        case 1 :
            	            // InternalMetaData.g:3551:8: otherlv_8= '.'
            	            {
            	            otherlv_8=(Token)match(input,79,FOLLOW_54); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              								newLeafNode(otherlv_8, grammarAccess.getXMemberFeatureCallAccess().getFullStopKeyword_1_1_0_0_1_0());
            	              							
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // InternalMetaData.g:3556:8: ( (lv_nullSafe_9_0= '?.' ) )
            	            {
            	            // InternalMetaData.g:3556:8: ( (lv_nullSafe_9_0= '?.' ) )
            	            // InternalMetaData.g:3557:9: (lv_nullSafe_9_0= '?.' )
            	            {
            	            // InternalMetaData.g:3557:9: (lv_nullSafe_9_0= '?.' )
            	            // InternalMetaData.g:3558:10: lv_nullSafe_9_0= '?.'
            	            {
            	            lv_nullSafe_9_0=(Token)match(input,81,FOLLOW_54); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              										newLeafNode(lv_nullSafe_9_0, grammarAccess.getXMemberFeatureCallAccess().getNullSafeQuestionMarkFullStopKeyword_1_1_0_0_1_1_0());
            	              									
            	            }
            	            if ( state.backtracking==0 ) {

            	              										if (current==null) {
            	              											current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	              										}
            	              										setWithLastConsumed(current, "nullSafe", true, "?.");
            	              									
            	            }

            	            }


            	            }


            	            }
            	            break;
            	        case 3 :
            	            // InternalMetaData.g:3571:8: ( (lv_explicitStatic_10_0= '::' ) )
            	            {
            	            // InternalMetaData.g:3571:8: ( (lv_explicitStatic_10_0= '::' ) )
            	            // InternalMetaData.g:3572:9: (lv_explicitStatic_10_0= '::' )
            	            {
            	            // InternalMetaData.g:3572:9: (lv_explicitStatic_10_0= '::' )
            	            // InternalMetaData.g:3573:10: lv_explicitStatic_10_0= '::'
            	            {
            	            lv_explicitStatic_10_0=(Token)match(input,80,FOLLOW_54); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              										newLeafNode(lv_explicitStatic_10_0, grammarAccess.getXMemberFeatureCallAccess().getExplicitStaticColonColonKeyword_1_1_0_0_1_2_0());
            	              									
            	            }
            	            if ( state.backtracking==0 ) {

            	              										if (current==null) {
            	              											current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	              										}
            	              										setWithLastConsumed(current, "explicitStatic", true, "::");
            	              									
            	            }

            	            }


            	            }


            	            }
            	            break;

            	    }


            	    }


            	    }

            	    // InternalMetaData.g:3588:5: (otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>' )?
            	    int alt55=2;
            	    int LA55_0 = input.LA(1);

            	    if ( (LA55_0==56) ) {
            	        alt55=1;
            	    }
            	    switch (alt55) {
            	        case 1 :
            	            // InternalMetaData.g:3589:6: otherlv_11= '<' ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) ) (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )* otherlv_15= '>'
            	            {
            	            otherlv_11=(Token)match(input,56,FOLLOW_55); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              						newLeafNode(otherlv_11, grammarAccess.getXMemberFeatureCallAccess().getLessThanSignKeyword_1_1_1_0());
            	              					
            	            }
            	            // InternalMetaData.g:3593:6: ( (lv_typeArguments_12_0= ruleJvmArgumentTypeReference ) )
            	            // InternalMetaData.g:3594:7: (lv_typeArguments_12_0= ruleJvmArgumentTypeReference )
            	            {
            	            // InternalMetaData.g:3594:7: (lv_typeArguments_12_0= ruleJvmArgumentTypeReference )
            	            // InternalMetaData.g:3595:8: lv_typeArguments_12_0= ruleJvmArgumentTypeReference
            	            {
            	            if ( state.backtracking==0 ) {

            	              								newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_1_1_1_1_0());
            	              							
            	            }
            	            pushFollow(FOLLOW_56);
            	            lv_typeArguments_12_0=ruleJvmArgumentTypeReference();

            	            state._fsp--;
            	            if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              								if (current==null) {
            	              									current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	              								}
            	              								add(
            	              									current,
            	              									"typeArguments",
            	              									lv_typeArguments_12_0,
            	              									"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
            	              								afterParserOrEnumRuleCall();
            	              							
            	            }

            	            }


            	            }

            	            // InternalMetaData.g:3612:6: (otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) ) )*
            	            loop54:
            	            do {
            	                int alt54=2;
            	                int LA54_0 = input.LA(1);

            	                if ( (LA54_0==36) ) {
            	                    alt54=1;
            	                }


            	                switch (alt54) {
            	            	case 1 :
            	            	    // InternalMetaData.g:3613:7: otherlv_13= ',' ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) )
            	            	    {
            	            	    otherlv_13=(Token)match(input,36,FOLLOW_55); if (state.failed) return current;
            	            	    if ( state.backtracking==0 ) {

            	            	      							newLeafNode(otherlv_13, grammarAccess.getXMemberFeatureCallAccess().getCommaKeyword_1_1_1_2_0());
            	            	      						
            	            	    }
            	            	    // InternalMetaData.g:3617:7: ( (lv_typeArguments_14_0= ruleJvmArgumentTypeReference ) )
            	            	    // InternalMetaData.g:3618:8: (lv_typeArguments_14_0= ruleJvmArgumentTypeReference )
            	            	    {
            	            	    // InternalMetaData.g:3618:8: (lv_typeArguments_14_0= ruleJvmArgumentTypeReference )
            	            	    // InternalMetaData.g:3619:9: lv_typeArguments_14_0= ruleJvmArgumentTypeReference
            	            	    {
            	            	    if ( state.backtracking==0 ) {

            	            	      									newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_1_1_1_2_1_0());
            	            	      								
            	            	    }
            	            	    pushFollow(FOLLOW_56);
            	            	    lv_typeArguments_14_0=ruleJvmArgumentTypeReference();

            	            	    state._fsp--;
            	            	    if (state.failed) return current;
            	            	    if ( state.backtracking==0 ) {

            	            	      									if (current==null) {
            	            	      										current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	            	      									}
            	            	      									add(
            	            	      										current,
            	            	      										"typeArguments",
            	            	      										lv_typeArguments_14_0,
            	            	      										"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
            	            	      									afterParserOrEnumRuleCall();
            	            	      								
            	            	    }

            	            	    }


            	            	    }


            	            	    }
            	            	    break;

            	            	default :
            	            	    break loop54;
            	                }
            	            } while (true);

            	            otherlv_15=(Token)match(input,57,FOLLOW_54); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              						newLeafNode(otherlv_15, grammarAccess.getXMemberFeatureCallAccess().getGreaterThanSignKeyword_1_1_1_3());
            	              					
            	            }

            	            }
            	            break;

            	    }

            	    // InternalMetaData.g:3642:5: ( ( ruleIdOrSuper ) )
            	    // InternalMetaData.g:3643:6: ( ruleIdOrSuper )
            	    {
            	    // InternalMetaData.g:3643:6: ( ruleIdOrSuper )
            	    // InternalMetaData.g:3644:7: ruleIdOrSuper
            	    {
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	      							}
            	      						
            	    }
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getFeatureJvmIdentifiableElementCrossReference_1_1_2_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_57);
            	    ruleIdOrSuper();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:3658:5: ( ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')' )?
            	    int alt58=2;
            	    alt58 = dfa58.predict(input);
            	    switch (alt58) {
            	        case 1 :
            	            // InternalMetaData.g:3659:6: ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )? otherlv_22= ')'
            	            {
            	            // InternalMetaData.g:3659:6: ( ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' ) )
            	            // InternalMetaData.g:3660:7: ( ( '(' ) )=> (lv_explicitOperationCall_17_0= '(' )
            	            {
            	            // InternalMetaData.g:3664:7: (lv_explicitOperationCall_17_0= '(' )
            	            // InternalMetaData.g:3665:8: lv_explicitOperationCall_17_0= '('
            	            {
            	            lv_explicitOperationCall_17_0=(Token)match(input,41,FOLLOW_58); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              								newLeafNode(lv_explicitOperationCall_17_0, grammarAccess.getXMemberFeatureCallAccess().getExplicitOperationCallLeftParenthesisKeyword_1_1_3_0_0());
            	              							
            	            }
            	            if ( state.backtracking==0 ) {

            	              								if (current==null) {
            	              									current = createModelElement(grammarAccess.getXMemberFeatureCallRule());
            	              								}
            	              								setWithLastConsumed(current, "explicitOperationCall", true, "(");
            	              							
            	            }

            	            }


            	            }

            	            // InternalMetaData.g:3677:6: ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) ) | ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* ) )?
            	            int alt57=3;
            	            alt57 = dfa57.predict(input);
            	            switch (alt57) {
            	                case 1 :
            	                    // InternalMetaData.g:3678:7: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) )
            	                    {
            	                    // InternalMetaData.g:3678:7: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure ) )
            	                    // InternalMetaData.g:3679:8: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_memberCallArguments_18_0= ruleXShortClosure )
            	                    {
            	                    // InternalMetaData.g:3704:8: (lv_memberCallArguments_18_0= ruleXShortClosure )
            	                    // InternalMetaData.g:3705:9: lv_memberCallArguments_18_0= ruleXShortClosure
            	                    {
            	                    if ( state.backtracking==0 ) {

            	                      									newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getMemberCallArgumentsXShortClosureParserRuleCall_1_1_3_1_0_0());
            	                      								
            	                    }
            	                    pushFollow(FOLLOW_26);
            	                    lv_memberCallArguments_18_0=ruleXShortClosure();

            	                    state._fsp--;
            	                    if (state.failed) return current;
            	                    if ( state.backtracking==0 ) {

            	                      									if (current==null) {
            	                      										current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	                      									}
            	                      									add(
            	                      										current,
            	                      										"memberCallArguments",
            	                      										lv_memberCallArguments_18_0,
            	                      										"org.eclipse.xtext.xbase.Xbase.XShortClosure");
            	                      									afterParserOrEnumRuleCall();
            	                      								
            	                    }

            	                    }


            	                    }


            	                    }
            	                    break;
            	                case 2 :
            	                    // InternalMetaData.g:3723:7: ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* )
            	                    {
            	                    // InternalMetaData.g:3723:7: ( ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )* )
            	                    // InternalMetaData.g:3724:8: ( (lv_memberCallArguments_19_0= ruleXExpression ) ) (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )*
            	                    {
            	                    // InternalMetaData.g:3724:8: ( (lv_memberCallArguments_19_0= ruleXExpression ) )
            	                    // InternalMetaData.g:3725:9: (lv_memberCallArguments_19_0= ruleXExpression )
            	                    {
            	                    // InternalMetaData.g:3725:9: (lv_memberCallArguments_19_0= ruleXExpression )
            	                    // InternalMetaData.g:3726:10: lv_memberCallArguments_19_0= ruleXExpression
            	                    {
            	                    if ( state.backtracking==0 ) {

            	                      										newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getMemberCallArgumentsXExpressionParserRuleCall_1_1_3_1_1_0_0());
            	                      									
            	                    }
            	                    pushFollow(FOLLOW_59);
            	                    lv_memberCallArguments_19_0=ruleXExpression();

            	                    state._fsp--;
            	                    if (state.failed) return current;
            	                    if ( state.backtracking==0 ) {

            	                      										if (current==null) {
            	                      											current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	                      										}
            	                      										add(
            	                      											current,
            	                      											"memberCallArguments",
            	                      											lv_memberCallArguments_19_0,
            	                      											"org.eclipse.xtext.xbase.Xbase.XExpression");
            	                      										afterParserOrEnumRuleCall();
            	                      									
            	                    }

            	                    }


            	                    }

            	                    // InternalMetaData.g:3743:8: (otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) ) )*
            	                    loop56:
            	                    do {
            	                        int alt56=2;
            	                        int LA56_0 = input.LA(1);

            	                        if ( (LA56_0==36) ) {
            	                            alt56=1;
            	                        }


            	                        switch (alt56) {
            	                    	case 1 :
            	                    	    // InternalMetaData.g:3744:9: otherlv_20= ',' ( (lv_memberCallArguments_21_0= ruleXExpression ) )
            	                    	    {
            	                    	    otherlv_20=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
            	                    	    if ( state.backtracking==0 ) {

            	                    	      									newLeafNode(otherlv_20, grammarAccess.getXMemberFeatureCallAccess().getCommaKeyword_1_1_3_1_1_1_0());
            	                    	      								
            	                    	    }
            	                    	    // InternalMetaData.g:3748:9: ( (lv_memberCallArguments_21_0= ruleXExpression ) )
            	                    	    // InternalMetaData.g:3749:10: (lv_memberCallArguments_21_0= ruleXExpression )
            	                    	    {
            	                    	    // InternalMetaData.g:3749:10: (lv_memberCallArguments_21_0= ruleXExpression )
            	                    	    // InternalMetaData.g:3750:11: lv_memberCallArguments_21_0= ruleXExpression
            	                    	    {
            	                    	    if ( state.backtracking==0 ) {

            	                    	      											newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getMemberCallArgumentsXExpressionParserRuleCall_1_1_3_1_1_1_1_0());
            	                    	      										
            	                    	    }
            	                    	    pushFollow(FOLLOW_59);
            	                    	    lv_memberCallArguments_21_0=ruleXExpression();

            	                    	    state._fsp--;
            	                    	    if (state.failed) return current;
            	                    	    if ( state.backtracking==0 ) {

            	                    	      											if (current==null) {
            	                    	      												current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	                    	      											}
            	                    	      											add(
            	                    	      												current,
            	                    	      												"memberCallArguments",
            	                    	      												lv_memberCallArguments_21_0,
            	                    	      												"org.eclipse.xtext.xbase.Xbase.XExpression");
            	                    	      											afterParserOrEnumRuleCall();
            	                    	      										
            	                    	    }

            	                    	    }


            	                    	    }


            	                    	    }
            	                    	    break;

            	                    	default :
            	                    	    break loop56;
            	                        }
            	                    } while (true);


            	                    }


            	                    }
            	                    break;

            	            }

            	            otherlv_22=(Token)match(input,43,FOLLOW_60); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              						newLeafNode(otherlv_22, grammarAccess.getXMemberFeatureCallAccess().getRightParenthesisKeyword_1_1_3_2());
            	              					
            	            }

            	            }
            	            break;

            	    }

            	    // InternalMetaData.g:3775:5: ( ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure ) )?
            	    int alt59=2;
            	    alt59 = dfa59.predict(input);
            	    switch (alt59) {
            	        case 1 :
            	            // InternalMetaData.g:3776:6: ( ( () '[' ) )=> (lv_memberCallArguments_23_0= ruleXClosure )
            	            {
            	            // InternalMetaData.g:3782:6: (lv_memberCallArguments_23_0= ruleXClosure )
            	            // InternalMetaData.g:3783:7: lv_memberCallArguments_23_0= ruleXClosure
            	            {
            	            if ( state.backtracking==0 ) {

            	              							newCompositeNode(grammarAccess.getXMemberFeatureCallAccess().getMemberCallArgumentsXClosureParserRuleCall_1_1_4_0());
            	              						
            	            }
            	            pushFollow(FOLLOW_52);
            	            lv_memberCallArguments_23_0=ruleXClosure();

            	            state._fsp--;
            	            if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              							if (current==null) {
            	              								current = createModelElementForParent(grammarAccess.getXMemberFeatureCallRule());
            	              							}
            	              							add(
            	              								current,
            	              								"memberCallArguments",
            	              								lv_memberCallArguments_23_0,
            	              								"org.eclipse.xtext.xbase.Xbase.XClosure");
            	              							afterParserOrEnumRuleCall();
            	              						
            	            }

            	            }


            	            }
            	            break;

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop60;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXMemberFeatureCall"


    // $ANTLR start "entryRuleXPrimaryExpression"
    // InternalMetaData.g:3806:1: entryRuleXPrimaryExpression returns [EObject current=null] : iv_ruleXPrimaryExpression= ruleXPrimaryExpression EOF ;
    public final EObject entryRuleXPrimaryExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXPrimaryExpression = null;


        try {
            // InternalMetaData.g:3806:59: (iv_ruleXPrimaryExpression= ruleXPrimaryExpression EOF )
            // InternalMetaData.g:3807:2: iv_ruleXPrimaryExpression= ruleXPrimaryExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXPrimaryExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXPrimaryExpression=ruleXPrimaryExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXPrimaryExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXPrimaryExpression"


    // $ANTLR start "ruleXPrimaryExpression"
    // InternalMetaData.g:3813:1: ruleXPrimaryExpression returns [EObject current=null] : (this_XConstructorCall_0= ruleXConstructorCall | this_XBlockExpression_1= ruleXBlockExpression | this_XSwitchExpression_2= ruleXSwitchExpression | ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression ) | this_XFeatureCall_4= ruleXFeatureCall | this_XLiteral_5= ruleXLiteral | this_XIfExpression_6= ruleXIfExpression | ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression ) | this_XBasicForLoopExpression_8= ruleXBasicForLoopExpression | this_XWhileExpression_9= ruleXWhileExpression | this_XDoWhileExpression_10= ruleXDoWhileExpression | this_XThrowExpression_11= ruleXThrowExpression | this_XReturnExpression_12= ruleXReturnExpression | this_XTryCatchFinallyExpression_13= ruleXTryCatchFinallyExpression | this_XParenthesizedExpression_14= ruleXParenthesizedExpression ) ;
    public final EObject ruleXPrimaryExpression() throws RecognitionException {
        EObject current = null;

        EObject this_XConstructorCall_0 = null;

        EObject this_XBlockExpression_1 = null;

        EObject this_XSwitchExpression_2 = null;

        EObject this_XSynchronizedExpression_3 = null;

        EObject this_XFeatureCall_4 = null;

        EObject this_XLiteral_5 = null;

        EObject this_XIfExpression_6 = null;

        EObject this_XForLoopExpression_7 = null;

        EObject this_XBasicForLoopExpression_8 = null;

        EObject this_XWhileExpression_9 = null;

        EObject this_XDoWhileExpression_10 = null;

        EObject this_XThrowExpression_11 = null;

        EObject this_XReturnExpression_12 = null;

        EObject this_XTryCatchFinallyExpression_13 = null;

        EObject this_XParenthesizedExpression_14 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3819:2: ( (this_XConstructorCall_0= ruleXConstructorCall | this_XBlockExpression_1= ruleXBlockExpression | this_XSwitchExpression_2= ruleXSwitchExpression | ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression ) | this_XFeatureCall_4= ruleXFeatureCall | this_XLiteral_5= ruleXLiteral | this_XIfExpression_6= ruleXIfExpression | ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression ) | this_XBasicForLoopExpression_8= ruleXBasicForLoopExpression | this_XWhileExpression_9= ruleXWhileExpression | this_XDoWhileExpression_10= ruleXDoWhileExpression | this_XThrowExpression_11= ruleXThrowExpression | this_XReturnExpression_12= ruleXReturnExpression | this_XTryCatchFinallyExpression_13= ruleXTryCatchFinallyExpression | this_XParenthesizedExpression_14= ruleXParenthesizedExpression ) )
            // InternalMetaData.g:3820:2: (this_XConstructorCall_0= ruleXConstructorCall | this_XBlockExpression_1= ruleXBlockExpression | this_XSwitchExpression_2= ruleXSwitchExpression | ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression ) | this_XFeatureCall_4= ruleXFeatureCall | this_XLiteral_5= ruleXLiteral | this_XIfExpression_6= ruleXIfExpression | ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression ) | this_XBasicForLoopExpression_8= ruleXBasicForLoopExpression | this_XWhileExpression_9= ruleXWhileExpression | this_XDoWhileExpression_10= ruleXDoWhileExpression | this_XThrowExpression_11= ruleXThrowExpression | this_XReturnExpression_12= ruleXReturnExpression | this_XTryCatchFinallyExpression_13= ruleXTryCatchFinallyExpression | this_XParenthesizedExpression_14= ruleXParenthesizedExpression )
            {
            // InternalMetaData.g:3820:2: (this_XConstructorCall_0= ruleXConstructorCall | this_XBlockExpression_1= ruleXBlockExpression | this_XSwitchExpression_2= ruleXSwitchExpression | ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression ) | this_XFeatureCall_4= ruleXFeatureCall | this_XLiteral_5= ruleXLiteral | this_XIfExpression_6= ruleXIfExpression | ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression ) | this_XBasicForLoopExpression_8= ruleXBasicForLoopExpression | this_XWhileExpression_9= ruleXWhileExpression | this_XDoWhileExpression_10= ruleXDoWhileExpression | this_XThrowExpression_11= ruleXThrowExpression | this_XReturnExpression_12= ruleXReturnExpression | this_XTryCatchFinallyExpression_13= ruleXTryCatchFinallyExpression | this_XParenthesizedExpression_14= ruleXParenthesizedExpression )
            int alt61=15;
            alt61 = dfa61.predict(input);
            switch (alt61) {
                case 1 :
                    // InternalMetaData.g:3821:3: this_XConstructorCall_0= ruleXConstructorCall
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXConstructorCallParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XConstructorCall_0=ruleXConstructorCall();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XConstructorCall_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:3830:3: this_XBlockExpression_1= ruleXBlockExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXBlockExpressionParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XBlockExpression_1=ruleXBlockExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XBlockExpression_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:3839:3: this_XSwitchExpression_2= ruleXSwitchExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXSwitchExpressionParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XSwitchExpression_2=ruleXSwitchExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XSwitchExpression_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:3848:3: ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression )
                    {
                    // InternalMetaData.g:3848:3: ( ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression )
                    // InternalMetaData.g:3849:4: ( ( () 'synchronized' '(' ) )=>this_XSynchronizedExpression_3= ruleXSynchronizedExpression
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXSynchronizedExpressionParserRuleCall_3());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_XSynchronizedExpression_3=ruleXSynchronizedExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_XSynchronizedExpression_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    // InternalMetaData.g:3866:3: this_XFeatureCall_4= ruleXFeatureCall
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXFeatureCallParserRuleCall_4());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XFeatureCall_4=ruleXFeatureCall();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XFeatureCall_4;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 6 :
                    // InternalMetaData.g:3875:3: this_XLiteral_5= ruleXLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXLiteralParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XLiteral_5=ruleXLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XLiteral_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    // InternalMetaData.g:3884:3: this_XIfExpression_6= ruleXIfExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXIfExpressionParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XIfExpression_6=ruleXIfExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XIfExpression_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 8 :
                    // InternalMetaData.g:3893:3: ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression )
                    {
                    // InternalMetaData.g:3893:3: ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression )
                    // InternalMetaData.g:3894:4: ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=>this_XForLoopExpression_7= ruleXForLoopExpression
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXForLoopExpressionParserRuleCall_7());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_XForLoopExpression_7=ruleXForLoopExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_XForLoopExpression_7;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 9 :
                    // InternalMetaData.g:3917:3: this_XBasicForLoopExpression_8= ruleXBasicForLoopExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXBasicForLoopExpressionParserRuleCall_8());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XBasicForLoopExpression_8=ruleXBasicForLoopExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XBasicForLoopExpression_8;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 10 :
                    // InternalMetaData.g:3926:3: this_XWhileExpression_9= ruleXWhileExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXWhileExpressionParserRuleCall_9());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XWhileExpression_9=ruleXWhileExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XWhileExpression_9;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 11 :
                    // InternalMetaData.g:3935:3: this_XDoWhileExpression_10= ruleXDoWhileExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXDoWhileExpressionParserRuleCall_10());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XDoWhileExpression_10=ruleXDoWhileExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XDoWhileExpression_10;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 12 :
                    // InternalMetaData.g:3944:3: this_XThrowExpression_11= ruleXThrowExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXThrowExpressionParserRuleCall_11());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XThrowExpression_11=ruleXThrowExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XThrowExpression_11;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 13 :
                    // InternalMetaData.g:3953:3: this_XReturnExpression_12= ruleXReturnExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXReturnExpressionParserRuleCall_12());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XReturnExpression_12=ruleXReturnExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XReturnExpression_12;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 14 :
                    // InternalMetaData.g:3962:3: this_XTryCatchFinallyExpression_13= ruleXTryCatchFinallyExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXTryCatchFinallyExpressionParserRuleCall_13());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XTryCatchFinallyExpression_13=ruleXTryCatchFinallyExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XTryCatchFinallyExpression_13;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 15 :
                    // InternalMetaData.g:3971:3: this_XParenthesizedExpression_14= ruleXParenthesizedExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXPrimaryExpressionAccess().getXParenthesizedExpressionParserRuleCall_14());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XParenthesizedExpression_14=ruleXParenthesizedExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XParenthesizedExpression_14;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXPrimaryExpression"


    // $ANTLR start "entryRuleXLiteral"
    // InternalMetaData.g:3983:1: entryRuleXLiteral returns [EObject current=null] : iv_ruleXLiteral= ruleXLiteral EOF ;
    public final EObject entryRuleXLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXLiteral = null;


        try {
            // InternalMetaData.g:3983:49: (iv_ruleXLiteral= ruleXLiteral EOF )
            // InternalMetaData.g:3984:2: iv_ruleXLiteral= ruleXLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXLiteral=ruleXLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXLiteral"


    // $ANTLR start "ruleXLiteral"
    // InternalMetaData.g:3990:1: ruleXLiteral returns [EObject current=null] : (this_XCollectionLiteral_0= ruleXCollectionLiteral | ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure ) | this_XBooleanLiteral_2= ruleXBooleanLiteral | this_XNumberLiteral_3= ruleXNumberLiteral | this_XNullLiteral_4= ruleXNullLiteral | this_XStringLiteral_5= ruleXStringLiteral | this_XTypeLiteral_6= ruleXTypeLiteral ) ;
    public final EObject ruleXLiteral() throws RecognitionException {
        EObject current = null;

        EObject this_XCollectionLiteral_0 = null;

        EObject this_XClosure_1 = null;

        EObject this_XBooleanLiteral_2 = null;

        EObject this_XNumberLiteral_3 = null;

        EObject this_XNullLiteral_4 = null;

        EObject this_XStringLiteral_5 = null;

        EObject this_XTypeLiteral_6 = null;



        	enterRule();

        try {
            // InternalMetaData.g:3996:2: ( (this_XCollectionLiteral_0= ruleXCollectionLiteral | ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure ) | this_XBooleanLiteral_2= ruleXBooleanLiteral | this_XNumberLiteral_3= ruleXNumberLiteral | this_XNullLiteral_4= ruleXNullLiteral | this_XStringLiteral_5= ruleXStringLiteral | this_XTypeLiteral_6= ruleXTypeLiteral ) )
            // InternalMetaData.g:3997:2: (this_XCollectionLiteral_0= ruleXCollectionLiteral | ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure ) | this_XBooleanLiteral_2= ruleXBooleanLiteral | this_XNumberLiteral_3= ruleXNumberLiteral | this_XNullLiteral_4= ruleXNullLiteral | this_XStringLiteral_5= ruleXStringLiteral | this_XTypeLiteral_6= ruleXTypeLiteral )
            {
            // InternalMetaData.g:3997:2: (this_XCollectionLiteral_0= ruleXCollectionLiteral | ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure ) | this_XBooleanLiteral_2= ruleXBooleanLiteral | this_XNumberLiteral_3= ruleXNumberLiteral | this_XNullLiteral_4= ruleXNullLiteral | this_XStringLiteral_5= ruleXStringLiteral | this_XTypeLiteral_6= ruleXTypeLiteral )
            int alt62=7;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==42) ) {
                alt62=1;
            }
            else if ( (LA62_0==82) && (synpred21_InternalMetaData())) {
                alt62=2;
            }
            else if ( ((LA62_0>=101 && LA62_0<=102)) ) {
                alt62=3;
            }
            else if ( ((LA62_0>=RULE_HEX && LA62_0<=RULE_DECIMAL)) ) {
                alt62=4;
            }
            else if ( (LA62_0==103) ) {
                alt62=5;
            }
            else if ( (LA62_0==RULE_STRING) ) {
                alt62=6;
            }
            else if ( (LA62_0==104) ) {
                alt62=7;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;
            }
            switch (alt62) {
                case 1 :
                    // InternalMetaData.g:3998:3: this_XCollectionLiteral_0= ruleXCollectionLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXCollectionLiteralParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XCollectionLiteral_0=ruleXCollectionLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XCollectionLiteral_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:4007:3: ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure )
                    {
                    // InternalMetaData.g:4007:3: ( ( ( () '[' ) )=>this_XClosure_1= ruleXClosure )
                    // InternalMetaData.g:4008:4: ( ( () '[' ) )=>this_XClosure_1= ruleXClosure
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getXLiteralAccess().getXClosureParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_XClosure_1=ruleXClosure();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_XClosure_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:4024:3: this_XBooleanLiteral_2= ruleXBooleanLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXBooleanLiteralParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XBooleanLiteral_2=ruleXBooleanLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XBooleanLiteral_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:4033:3: this_XNumberLiteral_3= ruleXNumberLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXNumberLiteralParserRuleCall_3());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XNumberLiteral_3=ruleXNumberLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XNumberLiteral_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 5 :
                    // InternalMetaData.g:4042:3: this_XNullLiteral_4= ruleXNullLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXNullLiteralParserRuleCall_4());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XNullLiteral_4=ruleXNullLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XNullLiteral_4;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 6 :
                    // InternalMetaData.g:4051:3: this_XStringLiteral_5= ruleXStringLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXStringLiteralParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XStringLiteral_5=ruleXStringLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XStringLiteral_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    // InternalMetaData.g:4060:3: this_XTypeLiteral_6= ruleXTypeLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXLiteralAccess().getXTypeLiteralParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XTypeLiteral_6=ruleXTypeLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XTypeLiteral_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXLiteral"


    // $ANTLR start "entryRuleXCollectionLiteral"
    // InternalMetaData.g:4072:1: entryRuleXCollectionLiteral returns [EObject current=null] : iv_ruleXCollectionLiteral= ruleXCollectionLiteral EOF ;
    public final EObject entryRuleXCollectionLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXCollectionLiteral = null;


        try {
            // InternalMetaData.g:4072:59: (iv_ruleXCollectionLiteral= ruleXCollectionLiteral EOF )
            // InternalMetaData.g:4073:2: iv_ruleXCollectionLiteral= ruleXCollectionLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXCollectionLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXCollectionLiteral=ruleXCollectionLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXCollectionLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXCollectionLiteral"


    // $ANTLR start "ruleXCollectionLiteral"
    // InternalMetaData.g:4079:1: ruleXCollectionLiteral returns [EObject current=null] : (this_XSetLiteral_0= ruleXSetLiteral | this_XListLiteral_1= ruleXListLiteral ) ;
    public final EObject ruleXCollectionLiteral() throws RecognitionException {
        EObject current = null;

        EObject this_XSetLiteral_0 = null;

        EObject this_XListLiteral_1 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4085:2: ( (this_XSetLiteral_0= ruleXSetLiteral | this_XListLiteral_1= ruleXListLiteral ) )
            // InternalMetaData.g:4086:2: (this_XSetLiteral_0= ruleXSetLiteral | this_XListLiteral_1= ruleXListLiteral )
            {
            // InternalMetaData.g:4086:2: (this_XSetLiteral_0= ruleXSetLiteral | this_XListLiteral_1= ruleXListLiteral )
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==42) ) {
                int LA63_1 = input.LA(2);

                if ( (LA63_1==82) ) {
                    alt63=2;
                }
                else if ( (LA63_1==15) ) {
                    alt63=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 63, 1, input);

                    throw nvae;
                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;
            }
            switch (alt63) {
                case 1 :
                    // InternalMetaData.g:4087:3: this_XSetLiteral_0= ruleXSetLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXCollectionLiteralAccess().getXSetLiteralParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XSetLiteral_0=ruleXSetLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XSetLiteral_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:4096:3: this_XListLiteral_1= ruleXListLiteral
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXCollectionLiteralAccess().getXListLiteralParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XListLiteral_1=ruleXListLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XListLiteral_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXCollectionLiteral"


    // $ANTLR start "entryRuleXSetLiteral"
    // InternalMetaData.g:4108:1: entryRuleXSetLiteral returns [EObject current=null] : iv_ruleXSetLiteral= ruleXSetLiteral EOF ;
    public final EObject entryRuleXSetLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXSetLiteral = null;


        try {
            // InternalMetaData.g:4108:52: (iv_ruleXSetLiteral= ruleXSetLiteral EOF )
            // InternalMetaData.g:4109:2: iv_ruleXSetLiteral= ruleXSetLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXSetLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXSetLiteral=ruleXSetLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXSetLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXSetLiteral"


    // $ANTLR start "ruleXSetLiteral"
    // InternalMetaData.g:4115:1: ruleXSetLiteral returns [EObject current=null] : ( () otherlv_1= '#' otherlv_2= '{' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= '}' ) ;
    public final EObject ruleXSetLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_elements_3_0 = null;

        EObject lv_elements_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4121:2: ( ( () otherlv_1= '#' otherlv_2= '{' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= '}' ) )
            // InternalMetaData.g:4122:2: ( () otherlv_1= '#' otherlv_2= '{' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= '}' )
            {
            // InternalMetaData.g:4122:2: ( () otherlv_1= '#' otherlv_2= '{' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= '}' )
            // InternalMetaData.g:4123:3: () otherlv_1= '#' otherlv_2= '{' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= '}'
            {
            // InternalMetaData.g:4123:3: ()
            // InternalMetaData.g:4124:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXSetLiteralAccess().getXSetLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,42,FOLLOW_6); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXSetLiteralAccess().getNumberSignKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,15,FOLLOW_61); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXSetLiteralAccess().getLeftCurlyBracketKeyword_2());
              		
            }
            // InternalMetaData.g:4138:3: ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )?
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( ((LA65_0>=RULE_STRING && LA65_0<=RULE_DECIMAL)||LA65_0==15||(LA65_0>=41 && LA65_0<=42)||LA65_0==50||LA65_0==56||LA65_0==71||LA65_0==75||LA65_0==82||LA65_0==86||LA65_0==88||(LA65_0>=90 && LA65_0<=92)||(LA65_0>=95 && LA65_0<=107)||LA65_0==109) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    // InternalMetaData.g:4139:4: ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )*
                    {
                    // InternalMetaData.g:4139:4: ( (lv_elements_3_0= ruleXExpression ) )
                    // InternalMetaData.g:4140:5: (lv_elements_3_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4140:5: (lv_elements_3_0= ruleXExpression )
                    // InternalMetaData.g:4141:6: lv_elements_3_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXSetLiteralAccess().getElementsXExpressionParserRuleCall_3_0_0());
                      					
                    }
                    pushFollow(FOLLOW_62);
                    lv_elements_3_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXSetLiteralRule());
                      						}
                      						add(
                      							current,
                      							"elements",
                      							lv_elements_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:4158:4: (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )*
                    loop64:
                    do {
                        int alt64=2;
                        int LA64_0 = input.LA(1);

                        if ( (LA64_0==36) ) {
                            alt64=1;
                        }


                        switch (alt64) {
                    	case 1 :
                    	    // InternalMetaData.g:4159:5: otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) )
                    	    {
                    	    otherlv_4=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_4, grammarAccess.getXSetLiteralAccess().getCommaKeyword_3_1_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:4163:5: ( (lv_elements_5_0= ruleXExpression ) )
                    	    // InternalMetaData.g:4164:6: (lv_elements_5_0= ruleXExpression )
                    	    {
                    	    // InternalMetaData.g:4164:6: (lv_elements_5_0= ruleXExpression )
                    	    // InternalMetaData.g:4165:7: lv_elements_5_0= ruleXExpression
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXSetLiteralAccess().getElementsXExpressionParserRuleCall_3_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_62);
                    	    lv_elements_5_0=ruleXExpression();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXSetLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"elements",
                    	      								lv_elements_5_0,
                    	      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop64;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_6=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getXSetLiteralAccess().getRightCurlyBracketKeyword_4());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXSetLiteral"


    // $ANTLR start "entryRuleXListLiteral"
    // InternalMetaData.g:4192:1: entryRuleXListLiteral returns [EObject current=null] : iv_ruleXListLiteral= ruleXListLiteral EOF ;
    public final EObject entryRuleXListLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXListLiteral = null;


        try {
            // InternalMetaData.g:4192:53: (iv_ruleXListLiteral= ruleXListLiteral EOF )
            // InternalMetaData.g:4193:2: iv_ruleXListLiteral= ruleXListLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXListLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXListLiteral=ruleXListLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXListLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXListLiteral"


    // $ANTLR start "ruleXListLiteral"
    // InternalMetaData.g:4199:1: ruleXListLiteral returns [EObject current=null] : ( () otherlv_1= '#' otherlv_2= '[' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= ']' ) ;
    public final EObject ruleXListLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_elements_3_0 = null;

        EObject lv_elements_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4205:2: ( ( () otherlv_1= '#' otherlv_2= '[' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= ']' ) )
            // InternalMetaData.g:4206:2: ( () otherlv_1= '#' otherlv_2= '[' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= ']' )
            {
            // InternalMetaData.g:4206:2: ( () otherlv_1= '#' otherlv_2= '[' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= ']' )
            // InternalMetaData.g:4207:3: () otherlv_1= '#' otherlv_2= '[' ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )? otherlv_6= ']'
            {
            // InternalMetaData.g:4207:3: ()
            // InternalMetaData.g:4208:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXListLiteralAccess().getXListLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,42,FOLLOW_63); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXListLiteralAccess().getNumberSignKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,82,FOLLOW_64); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXListLiteralAccess().getLeftSquareBracketKeyword_2());
              		
            }
            // InternalMetaData.g:4222:3: ( ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )* )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( ((LA67_0>=RULE_STRING && LA67_0<=RULE_DECIMAL)||LA67_0==15||(LA67_0>=41 && LA67_0<=42)||LA67_0==50||LA67_0==56||LA67_0==71||LA67_0==75||LA67_0==82||LA67_0==86||LA67_0==88||(LA67_0>=90 && LA67_0<=92)||(LA67_0>=95 && LA67_0<=107)||LA67_0==109) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // InternalMetaData.g:4223:4: ( (lv_elements_3_0= ruleXExpression ) ) (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )*
                    {
                    // InternalMetaData.g:4223:4: ( (lv_elements_3_0= ruleXExpression ) )
                    // InternalMetaData.g:4224:5: (lv_elements_3_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4224:5: (lv_elements_3_0= ruleXExpression )
                    // InternalMetaData.g:4225:6: lv_elements_3_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXListLiteralAccess().getElementsXExpressionParserRuleCall_3_0_0());
                      					
                    }
                    pushFollow(FOLLOW_65);
                    lv_elements_3_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXListLiteralRule());
                      						}
                      						add(
                      							current,
                      							"elements",
                      							lv_elements_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:4242:4: (otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) ) )*
                    loop66:
                    do {
                        int alt66=2;
                        int LA66_0 = input.LA(1);

                        if ( (LA66_0==36) ) {
                            alt66=1;
                        }


                        switch (alt66) {
                    	case 1 :
                    	    // InternalMetaData.g:4243:5: otherlv_4= ',' ( (lv_elements_5_0= ruleXExpression ) )
                    	    {
                    	    otherlv_4=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_4, grammarAccess.getXListLiteralAccess().getCommaKeyword_3_1_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:4247:5: ( (lv_elements_5_0= ruleXExpression ) )
                    	    // InternalMetaData.g:4248:6: (lv_elements_5_0= ruleXExpression )
                    	    {
                    	    // InternalMetaData.g:4248:6: (lv_elements_5_0= ruleXExpression )
                    	    // InternalMetaData.g:4249:7: lv_elements_5_0= ruleXExpression
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXListLiteralAccess().getElementsXExpressionParserRuleCall_3_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_65);
                    	    lv_elements_5_0=ruleXExpression();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXListLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"elements",
                    	      								lv_elements_5_0,
                    	      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop66;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_6=(Token)match(input,83,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getXListLiteralAccess().getRightSquareBracketKeyword_4());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXListLiteral"


    // $ANTLR start "entryRuleXClosure"
    // InternalMetaData.g:4276:1: entryRuleXClosure returns [EObject current=null] : iv_ruleXClosure= ruleXClosure EOF ;
    public final EObject entryRuleXClosure() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXClosure = null;


        try {
            // InternalMetaData.g:4276:49: (iv_ruleXClosure= ruleXClosure EOF )
            // InternalMetaData.g:4277:2: iv_ruleXClosure= ruleXClosure EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXClosureRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXClosure=ruleXClosure();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXClosure; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXClosure"


    // $ANTLR start "ruleXClosure"
    // InternalMetaData.g:4283:1: ruleXClosure returns [EObject current=null] : ( ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) ) ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )? ( (lv_expression_6_0= ruleXExpressionInClosure ) ) otherlv_7= ']' ) ;
    public final EObject ruleXClosure() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token lv_explicitSyntax_5_0=null;
        Token otherlv_7=null;
        EObject lv_declaredFormalParameters_2_0 = null;

        EObject lv_declaredFormalParameters_4_0 = null;

        EObject lv_expression_6_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4289:2: ( ( ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) ) ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )? ( (lv_expression_6_0= ruleXExpressionInClosure ) ) otherlv_7= ']' ) )
            // InternalMetaData.g:4290:2: ( ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) ) ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )? ( (lv_expression_6_0= ruleXExpressionInClosure ) ) otherlv_7= ']' )
            {
            // InternalMetaData.g:4290:2: ( ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) ) ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )? ( (lv_expression_6_0= ruleXExpressionInClosure ) ) otherlv_7= ']' )
            // InternalMetaData.g:4291:3: ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) ) ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )? ( (lv_expression_6_0= ruleXExpressionInClosure ) ) otherlv_7= ']'
            {
            // InternalMetaData.g:4291:3: ( ( ( () '[' ) )=> ( () otherlv_1= '[' ) )
            // InternalMetaData.g:4292:4: ( ( () '[' ) )=> ( () otherlv_1= '[' )
            {
            // InternalMetaData.g:4298:4: ( () otherlv_1= '[' )
            // InternalMetaData.g:4299:5: () otherlv_1= '['
            {
            // InternalMetaData.g:4299:5: ()
            // InternalMetaData.g:4300:6: 
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getXClosureAccess().getXClosureAction_0_0_0(),
              							current);
              					
            }

            }

            otherlv_1=(Token)match(input,82,FOLLOW_66); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getXClosureAccess().getLeftSquareBracketKeyword_0_0_1());
              				
            }

            }


            }

            // InternalMetaData.g:4312:3: ( ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) ) )?
            int alt70=2;
            alt70 = dfa70.predict(input);
            switch (alt70) {
                case 1 :
                    // InternalMetaData.g:4313:4: ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) )
                    {
                    // InternalMetaData.g:4336:4: ( ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) ) )
                    // InternalMetaData.g:4337:5: ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_5_0= '|' ) )
                    {
                    // InternalMetaData.g:4337:5: ( ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )* )?
                    int alt69=2;
                    int LA69_0 = input.LA(1);

                    if ( (LA69_0==RULE_ID||LA69_0==41||LA69_0==68) ) {
                        alt69=1;
                    }
                    switch (alt69) {
                        case 1 :
                            // InternalMetaData.g:4338:6: ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) ) (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )*
                            {
                            // InternalMetaData.g:4338:6: ( (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter ) )
                            // InternalMetaData.g:4339:7: (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter )
                            {
                            // InternalMetaData.g:4339:7: (lv_declaredFormalParameters_2_0= ruleJvmFormalParameter )
                            // InternalMetaData.g:4340:8: lv_declaredFormalParameters_2_0= ruleJvmFormalParameter
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getXClosureAccess().getDeclaredFormalParametersJvmFormalParameterParserRuleCall_1_0_0_0_0());
                              							
                            }
                            pushFollow(FOLLOW_67);
                            lv_declaredFormalParameters_2_0=ruleJvmFormalParameter();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getXClosureRule());
                              								}
                              								add(
                              									current,
                              									"declaredFormalParameters",
                              									lv_declaredFormalParameters_2_0,
                              									"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }

                            // InternalMetaData.g:4357:6: (otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) ) )*
                            loop68:
                            do {
                                int alt68=2;
                                int LA68_0 = input.LA(1);

                                if ( (LA68_0==36) ) {
                                    alt68=1;
                                }


                                switch (alt68) {
                            	case 1 :
                            	    // InternalMetaData.g:4358:7: otherlv_3= ',' ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) )
                            	    {
                            	    otherlv_3=(Token)match(input,36,FOLLOW_15); if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      							newLeafNode(otherlv_3, grammarAccess.getXClosureAccess().getCommaKeyword_1_0_0_1_0());
                            	      						
                            	    }
                            	    // InternalMetaData.g:4362:7: ( (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter ) )
                            	    // InternalMetaData.g:4363:8: (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter )
                            	    {
                            	    // InternalMetaData.g:4363:8: (lv_declaredFormalParameters_4_0= ruleJvmFormalParameter )
                            	    // InternalMetaData.g:4364:9: lv_declaredFormalParameters_4_0= ruleJvmFormalParameter
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getXClosureAccess().getDeclaredFormalParametersJvmFormalParameterParserRuleCall_1_0_0_1_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_67);
                            	    lv_declaredFormalParameters_4_0=ruleJvmFormalParameter();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getXClosureRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"declaredFormalParameters",
                            	      										lv_declaredFormalParameters_4_0,
                            	      										"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop68;
                                }
                            } while (true);


                            }
                            break;

                    }

                    // InternalMetaData.g:4383:5: ( (lv_explicitSyntax_5_0= '|' ) )
                    // InternalMetaData.g:4384:6: (lv_explicitSyntax_5_0= '|' )
                    {
                    // InternalMetaData.g:4384:6: (lv_explicitSyntax_5_0= '|' )
                    // InternalMetaData.g:4385:7: lv_explicitSyntax_5_0= '|'
                    {
                    lv_explicitSyntax_5_0=(Token)match(input,84,FOLLOW_68); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_explicitSyntax_5_0, grammarAccess.getXClosureAccess().getExplicitSyntaxVerticalLineKeyword_1_0_1_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getXClosureRule());
                      							}
                      							setWithLastConsumed(current, "explicitSyntax", true, "|");
                      						
                    }

                    }


                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:4399:3: ( (lv_expression_6_0= ruleXExpressionInClosure ) )
            // InternalMetaData.g:4400:4: (lv_expression_6_0= ruleXExpressionInClosure )
            {
            // InternalMetaData.g:4400:4: (lv_expression_6_0= ruleXExpressionInClosure )
            // InternalMetaData.g:4401:5: lv_expression_6_0= ruleXExpressionInClosure
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXClosureAccess().getExpressionXExpressionInClosureParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_expression_6_0=ruleXExpressionInClosure();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXClosureRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_6_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpressionInClosure");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_7=(Token)match(input,83,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_7, grammarAccess.getXClosureAccess().getRightSquareBracketKeyword_3());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXClosure"


    // $ANTLR start "entryRuleXExpressionInClosure"
    // InternalMetaData.g:4426:1: entryRuleXExpressionInClosure returns [EObject current=null] : iv_ruleXExpressionInClosure= ruleXExpressionInClosure EOF ;
    public final EObject entryRuleXExpressionInClosure() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXExpressionInClosure = null;


        try {
            // InternalMetaData.g:4426:61: (iv_ruleXExpressionInClosure= ruleXExpressionInClosure EOF )
            // InternalMetaData.g:4427:2: iv_ruleXExpressionInClosure= ruleXExpressionInClosure EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXExpressionInClosureRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXExpressionInClosure=ruleXExpressionInClosure();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXExpressionInClosure; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXExpressionInClosure"


    // $ANTLR start "ruleXExpressionInClosure"
    // InternalMetaData.g:4433:1: ruleXExpressionInClosure returns [EObject current=null] : ( () ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )* ) ;
    public final EObject ruleXExpressionInClosure() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        EObject lv_expressions_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4439:2: ( ( () ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )* ) )
            // InternalMetaData.g:4440:2: ( () ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )* )
            {
            // InternalMetaData.g:4440:2: ( () ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )* )
            // InternalMetaData.g:4441:3: () ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )*
            {
            // InternalMetaData.g:4441:3: ()
            // InternalMetaData.g:4442:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXExpressionInClosureAccess().getXBlockExpressionAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:4448:3: ( ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )? )*
            loop72:
            do {
                int alt72=2;
                int LA72_0 = input.LA(1);

                if ( ((LA72_0>=RULE_STRING && LA72_0<=RULE_DECIMAL)||LA72_0==15||(LA72_0>=41 && LA72_0<=42)||LA72_0==50||LA72_0==56||LA72_0==71||LA72_0==75||LA72_0==82||LA72_0==86||LA72_0==88||(LA72_0>=90 && LA72_0<=107)||LA72_0==109) ) {
                    alt72=1;
                }


                switch (alt72) {
            	case 1 :
            	    // InternalMetaData.g:4449:4: ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_2= ';' )?
            	    {
            	    // InternalMetaData.g:4449:4: ( (lv_expressions_1_0= ruleXExpressionOrVarDeclaration ) )
            	    // InternalMetaData.g:4450:5: (lv_expressions_1_0= ruleXExpressionOrVarDeclaration )
            	    {
            	    // InternalMetaData.g:4450:5: (lv_expressions_1_0= ruleXExpressionOrVarDeclaration )
            	    // InternalMetaData.g:4451:6: lv_expressions_1_0= ruleXExpressionOrVarDeclaration
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXExpressionInClosureAccess().getExpressionsXExpressionOrVarDeclarationParserRuleCall_1_0_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_70);
            	    lv_expressions_1_0=ruleXExpressionOrVarDeclaration();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXExpressionInClosureRule());
            	      						}
            	      						add(
            	      							current,
            	      							"expressions",
            	      							lv_expressions_1_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XExpressionOrVarDeclaration");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:4468:4: (otherlv_2= ';' )?
            	    int alt71=2;
            	    int LA71_0 = input.LA(1);

            	    if ( (LA71_0==85) ) {
            	        alt71=1;
            	    }
            	    switch (alt71) {
            	        case 1 :
            	            // InternalMetaData.g:4469:5: otherlv_2= ';'
            	            {
            	            otherlv_2=(Token)match(input,85,FOLLOW_71); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              					newLeafNode(otherlv_2, grammarAccess.getXExpressionInClosureAccess().getSemicolonKeyword_1_1());
            	              				
            	            }

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop72;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXExpressionInClosure"


    // $ANTLR start "entryRuleXShortClosure"
    // InternalMetaData.g:4479:1: entryRuleXShortClosure returns [EObject current=null] : iv_ruleXShortClosure= ruleXShortClosure EOF ;
    public final EObject entryRuleXShortClosure() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXShortClosure = null;


        try {
            // InternalMetaData.g:4479:54: (iv_ruleXShortClosure= ruleXShortClosure EOF )
            // InternalMetaData.g:4480:2: iv_ruleXShortClosure= ruleXShortClosure EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXShortClosureRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXShortClosure=ruleXShortClosure();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXShortClosure; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXShortClosure"


    // $ANTLR start "ruleXShortClosure"
    // InternalMetaData.g:4486:1: ruleXShortClosure returns [EObject current=null] : ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) ) ( (lv_expression_5_0= ruleXExpression ) ) ) ;
    public final EObject ruleXShortClosure() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        Token lv_explicitSyntax_4_0=null;
        EObject lv_declaredFormalParameters_1_0 = null;

        EObject lv_declaredFormalParameters_3_0 = null;

        EObject lv_expression_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4492:2: ( ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) ) ( (lv_expression_5_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:4493:2: ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) ) ( (lv_expression_5_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:4493:2: ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) ) ( (lv_expression_5_0= ruleXExpression ) ) )
            // InternalMetaData.g:4494:3: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) ) ( (lv_expression_5_0= ruleXExpression ) )
            {
            // InternalMetaData.g:4494:3: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) ) )
            // InternalMetaData.g:4495:4: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) )
            {
            // InternalMetaData.g:4520:4: ( () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) ) )
            // InternalMetaData.g:4521:5: () ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )? ( (lv_explicitSyntax_4_0= '|' ) )
            {
            // InternalMetaData.g:4521:5: ()
            // InternalMetaData.g:4522:6: 
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getXShortClosureAccess().getXClosureAction_0_0_0(),
              							current);
              					
            }

            }

            // InternalMetaData.g:4528:5: ( ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )* )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==RULE_ID||LA74_0==41||LA74_0==68) ) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    // InternalMetaData.g:4529:6: ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) ) (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )*
                    {
                    // InternalMetaData.g:4529:6: ( (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter ) )
                    // InternalMetaData.g:4530:7: (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter )
                    {
                    // InternalMetaData.g:4530:7: (lv_declaredFormalParameters_1_0= ruleJvmFormalParameter )
                    // InternalMetaData.g:4531:8: lv_declaredFormalParameters_1_0= ruleJvmFormalParameter
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getXShortClosureAccess().getDeclaredFormalParametersJvmFormalParameterParserRuleCall_0_0_1_0_0());
                      							
                    }
                    pushFollow(FOLLOW_67);
                    lv_declaredFormalParameters_1_0=ruleJvmFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getXShortClosureRule());
                      								}
                      								add(
                      									current,
                      									"declaredFormalParameters",
                      									lv_declaredFormalParameters_1_0,
                      									"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }

                    // InternalMetaData.g:4548:6: (otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) ) )*
                    loop73:
                    do {
                        int alt73=2;
                        int LA73_0 = input.LA(1);

                        if ( (LA73_0==36) ) {
                            alt73=1;
                        }


                        switch (alt73) {
                    	case 1 :
                    	    // InternalMetaData.g:4549:7: otherlv_2= ',' ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) )
                    	    {
                    	    otherlv_2=(Token)match(input,36,FOLLOW_15); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							newLeafNode(otherlv_2, grammarAccess.getXShortClosureAccess().getCommaKeyword_0_0_1_1_0());
                    	      						
                    	    }
                    	    // InternalMetaData.g:4553:7: ( (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter ) )
                    	    // InternalMetaData.g:4554:8: (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter )
                    	    {
                    	    // InternalMetaData.g:4554:8: (lv_declaredFormalParameters_3_0= ruleJvmFormalParameter )
                    	    // InternalMetaData.g:4555:9: lv_declaredFormalParameters_3_0= ruleJvmFormalParameter
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      									newCompositeNode(grammarAccess.getXShortClosureAccess().getDeclaredFormalParametersJvmFormalParameterParserRuleCall_0_0_1_1_1_0());
                    	      								
                    	    }
                    	    pushFollow(FOLLOW_67);
                    	    lv_declaredFormalParameters_3_0=ruleJvmFormalParameter();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      									if (current==null) {
                    	      										current = createModelElementForParent(grammarAccess.getXShortClosureRule());
                    	      									}
                    	      									add(
                    	      										current,
                    	      										"declaredFormalParameters",
                    	      										lv_declaredFormalParameters_3_0,
                    	      										"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                    	      									afterParserOrEnumRuleCall();
                    	      								
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop73;
                        }
                    } while (true);


                    }
                    break;

            }

            // InternalMetaData.g:4574:5: ( (lv_explicitSyntax_4_0= '|' ) )
            // InternalMetaData.g:4575:6: (lv_explicitSyntax_4_0= '|' )
            {
            // InternalMetaData.g:4575:6: (lv_explicitSyntax_4_0= '|' )
            // InternalMetaData.g:4576:7: lv_explicitSyntax_4_0= '|'
            {
            lv_explicitSyntax_4_0=(Token)match(input,84,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							newLeafNode(lv_explicitSyntax_4_0, grammarAccess.getXShortClosureAccess().getExplicitSyntaxVerticalLineKeyword_0_0_2_0());
              						
            }
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElement(grammarAccess.getXShortClosureRule());
              							}
              							setWithLastConsumed(current, "explicitSyntax", true, "|");
              						
            }

            }


            }


            }


            }

            // InternalMetaData.g:4590:3: ( (lv_expression_5_0= ruleXExpression ) )
            // InternalMetaData.g:4591:4: (lv_expression_5_0= ruleXExpression )
            {
            // InternalMetaData.g:4591:4: (lv_expression_5_0= ruleXExpression )
            // InternalMetaData.g:4592:5: lv_expression_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXShortClosureAccess().getExpressionXExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXShortClosureRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXShortClosure"


    // $ANTLR start "entryRuleXParenthesizedExpression"
    // InternalMetaData.g:4613:1: entryRuleXParenthesizedExpression returns [EObject current=null] : iv_ruleXParenthesizedExpression= ruleXParenthesizedExpression EOF ;
    public final EObject entryRuleXParenthesizedExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXParenthesizedExpression = null;


        try {
            // InternalMetaData.g:4613:65: (iv_ruleXParenthesizedExpression= ruleXParenthesizedExpression EOF )
            // InternalMetaData.g:4614:2: iv_ruleXParenthesizedExpression= ruleXParenthesizedExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXParenthesizedExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXParenthesizedExpression=ruleXParenthesizedExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXParenthesizedExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXParenthesizedExpression"


    // $ANTLR start "ruleXParenthesizedExpression"
    // InternalMetaData.g:4620:1: ruleXParenthesizedExpression returns [EObject current=null] : (otherlv_0= '(' this_XExpression_1= ruleXExpression otherlv_2= ')' ) ;
    public final EObject ruleXParenthesizedExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject this_XExpression_1 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4626:2: ( (otherlv_0= '(' this_XExpression_1= ruleXExpression otherlv_2= ')' ) )
            // InternalMetaData.g:4627:2: (otherlv_0= '(' this_XExpression_1= ruleXExpression otherlv_2= ')' )
            {
            // InternalMetaData.g:4627:2: (otherlv_0= '(' this_XExpression_1= ruleXExpression otherlv_2= ')' )
            // InternalMetaData.g:4628:3: otherlv_0= '(' this_XExpression_1= ruleXExpression otherlv_2= ')'
            {
            otherlv_0=(Token)match(input,41,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getXParenthesizedExpressionAccess().getLeftParenthesisKeyword_0());
              		
            }
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getXParenthesizedExpressionAccess().getXExpressionParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_26);
            this_XExpression_1=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_XExpression_1;
              			afterParserOrEnumRuleCall();
              		
            }
            otherlv_2=(Token)match(input,43,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXParenthesizedExpressionAccess().getRightParenthesisKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXParenthesizedExpression"


    // $ANTLR start "entryRuleXIfExpression"
    // InternalMetaData.g:4648:1: entryRuleXIfExpression returns [EObject current=null] : iv_ruleXIfExpression= ruleXIfExpression EOF ;
    public final EObject entryRuleXIfExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXIfExpression = null;


        try {
            // InternalMetaData.g:4648:54: (iv_ruleXIfExpression= ruleXIfExpression EOF )
            // InternalMetaData.g:4649:2: iv_ruleXIfExpression= ruleXIfExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXIfExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXIfExpression=ruleXIfExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXIfExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXIfExpression"


    // $ANTLR start "ruleXIfExpression"
    // InternalMetaData.g:4655:1: ruleXIfExpression returns [EObject current=null] : ( () otherlv_1= 'if' otherlv_2= '(' ( (lv_if_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_then_5_0= ruleXExpression ) ) ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )? ) ;
    public final EObject ruleXIfExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_if_3_0 = null;

        EObject lv_then_5_0 = null;

        EObject lv_else_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4661:2: ( ( () otherlv_1= 'if' otherlv_2= '(' ( (lv_if_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_then_5_0= ruleXExpression ) ) ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )? ) )
            // InternalMetaData.g:4662:2: ( () otherlv_1= 'if' otherlv_2= '(' ( (lv_if_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_then_5_0= ruleXExpression ) ) ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )? )
            {
            // InternalMetaData.g:4662:2: ( () otherlv_1= 'if' otherlv_2= '(' ( (lv_if_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_then_5_0= ruleXExpression ) ) ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )? )
            // InternalMetaData.g:4663:3: () otherlv_1= 'if' otherlv_2= '(' ( (lv_if_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_then_5_0= ruleXExpression ) ) ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )?
            {
            // InternalMetaData.g:4663:3: ()
            // InternalMetaData.g:4664:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXIfExpressionAccess().getXIfExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,86,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXIfExpressionAccess().getIfKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,41,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXIfExpressionAccess().getLeftParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:4678:3: ( (lv_if_3_0= ruleXExpression ) )
            // InternalMetaData.g:4679:4: (lv_if_3_0= ruleXExpression )
            {
            // InternalMetaData.g:4679:4: (lv_if_3_0= ruleXExpression )
            // InternalMetaData.g:4680:5: lv_if_3_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXIfExpressionAccess().getIfXExpressionParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_if_3_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXIfExpressionRule());
              					}
              					set(
              						current,
              						"if",
              						lv_if_3_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_4=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getXIfExpressionAccess().getRightParenthesisKeyword_4());
              		
            }
            // InternalMetaData.g:4701:3: ( (lv_then_5_0= ruleXExpression ) )
            // InternalMetaData.g:4702:4: (lv_then_5_0= ruleXExpression )
            {
            // InternalMetaData.g:4702:4: (lv_then_5_0= ruleXExpression )
            // InternalMetaData.g:4703:5: lv_then_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXIfExpressionAccess().getThenXExpressionParserRuleCall_5_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_then_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXIfExpressionRule());
              					}
              					set(
              						current,
              						"then",
              						lv_then_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:4720:3: ( ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) ) )?
            int alt75=2;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==87) ) {
                int LA75_1 = input.LA(2);

                if ( (synpred25_InternalMetaData()) ) {
                    alt75=1;
                }
            }
            switch (alt75) {
                case 1 :
                    // InternalMetaData.g:4721:4: ( ( 'else' )=>otherlv_6= 'else' ) ( (lv_else_7_0= ruleXExpression ) )
                    {
                    // InternalMetaData.g:4721:4: ( ( 'else' )=>otherlv_6= 'else' )
                    // InternalMetaData.g:4722:5: ( 'else' )=>otherlv_6= 'else'
                    {
                    otherlv_6=(Token)match(input,87,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_6, grammarAccess.getXIfExpressionAccess().getElseKeyword_6_0());
                      				
                    }

                    }

                    // InternalMetaData.g:4728:4: ( (lv_else_7_0= ruleXExpression ) )
                    // InternalMetaData.g:4729:5: (lv_else_7_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4729:5: (lv_else_7_0= ruleXExpression )
                    // InternalMetaData.g:4730:6: lv_else_7_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXIfExpressionAccess().getElseXExpressionParserRuleCall_6_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_else_7_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXIfExpressionRule());
                      						}
                      						set(
                      							current,
                      							"else",
                      							lv_else_7_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXIfExpression"


    // $ANTLR start "entryRuleXSwitchExpression"
    // InternalMetaData.g:4752:1: entryRuleXSwitchExpression returns [EObject current=null] : iv_ruleXSwitchExpression= ruleXSwitchExpression EOF ;
    public final EObject entryRuleXSwitchExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXSwitchExpression = null;


        try {
            // InternalMetaData.g:4752:58: (iv_ruleXSwitchExpression= ruleXSwitchExpression EOF )
            // InternalMetaData.g:4753:2: iv_ruleXSwitchExpression= ruleXSwitchExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXSwitchExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXSwitchExpression=ruleXSwitchExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXSwitchExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXSwitchExpression"


    // $ANTLR start "ruleXSwitchExpression"
    // InternalMetaData.g:4759:1: ruleXSwitchExpression returns [EObject current=null] : ( () otherlv_1= 'switch' ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) ) otherlv_10= '{' ( (lv_cases_11_0= ruleXCasePart ) )* (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )? otherlv_15= '}' ) ;
    public final EObject ruleXSwitchExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token otherlv_10=null;
        Token otherlv_12=null;
        Token otherlv_13=null;
        Token otherlv_15=null;
        EObject lv_declaredParam_3_0 = null;

        EObject lv_switch_5_0 = null;

        EObject lv_declaredParam_7_0 = null;

        EObject lv_switch_9_0 = null;

        EObject lv_cases_11_0 = null;

        EObject lv_default_14_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4765:2: ( ( () otherlv_1= 'switch' ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) ) otherlv_10= '{' ( (lv_cases_11_0= ruleXCasePart ) )* (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )? otherlv_15= '}' ) )
            // InternalMetaData.g:4766:2: ( () otherlv_1= 'switch' ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) ) otherlv_10= '{' ( (lv_cases_11_0= ruleXCasePart ) )* (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )? otherlv_15= '}' )
            {
            // InternalMetaData.g:4766:2: ( () otherlv_1= 'switch' ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) ) otherlv_10= '{' ( (lv_cases_11_0= ruleXCasePart ) )* (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )? otherlv_15= '}' )
            // InternalMetaData.g:4767:3: () otherlv_1= 'switch' ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) ) otherlv_10= '{' ( (lv_cases_11_0= ruleXCasePart ) )* (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )? otherlv_15= '}'
            {
            // InternalMetaData.g:4767:3: ()
            // InternalMetaData.g:4768:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXSwitchExpressionAccess().getXSwitchExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,88,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXSwitchExpressionAccess().getSwitchKeyword_1());
              		
            }
            // InternalMetaData.g:4778:3: ( ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' ) | ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) ) )
            int alt77=2;
            alt77 = dfa77.predict(input);
            switch (alt77) {
                case 1 :
                    // InternalMetaData.g:4779:4: ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' )
                    {
                    // InternalMetaData.g:4779:4: ( ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')' )
                    // InternalMetaData.g:4780:5: ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_switch_5_0= ruleXExpression ) ) otherlv_6= ')'
                    {
                    // InternalMetaData.g:4780:5: ( ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) )
                    // InternalMetaData.g:4781:6: ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' )
                    {
                    // InternalMetaData.g:4791:6: (otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' )
                    // InternalMetaData.g:4792:7: otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':'
                    {
                    otherlv_2=(Token)match(input,41,FOLLOW_15); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(otherlv_2, grammarAccess.getXSwitchExpressionAccess().getLeftParenthesisKeyword_2_0_0_0_0());
                      						
                    }
                    // InternalMetaData.g:4796:7: ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) )
                    // InternalMetaData.g:4797:8: (lv_declaredParam_3_0= ruleJvmFormalParameter )
                    {
                    // InternalMetaData.g:4797:8: (lv_declaredParam_3_0= ruleJvmFormalParameter )
                    // InternalMetaData.g:4798:9: lv_declaredParam_3_0= ruleJvmFormalParameter
                    {
                    if ( state.backtracking==0 ) {

                      									newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getDeclaredParamJvmFormalParameterParserRuleCall_2_0_0_0_1_0());
                      								
                    }
                    pushFollow(FOLLOW_74);
                    lv_declaredParam_3_0=ruleJvmFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      									if (current==null) {
                      										current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
                      									}
                      									set(
                      										current,
                      										"declaredParam",
                      										lv_declaredParam_3_0,
                      										"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                      									afterParserOrEnumRuleCall();
                      								
                    }

                    }


                    }

                    otherlv_4=(Token)match(input,29,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(otherlv_4, grammarAccess.getXSwitchExpressionAccess().getColonKeyword_2_0_0_0_2());
                      						
                    }

                    }


                    }

                    // InternalMetaData.g:4821:5: ( (lv_switch_5_0= ruleXExpression ) )
                    // InternalMetaData.g:4822:6: (lv_switch_5_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4822:6: (lv_switch_5_0= ruleXExpression )
                    // InternalMetaData.g:4823:7: lv_switch_5_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getSwitchXExpressionParserRuleCall_2_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_26);
                    lv_switch_5_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
                      							}
                      							set(
                      								current,
                      								"switch",
                      								lv_switch_5_0,
                      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_6=(Token)match(input,43,FOLLOW_6); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_6, grammarAccess.getXSwitchExpressionAccess().getRightParenthesisKeyword_2_0_2());
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:4846:4: ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) )
                    {
                    // InternalMetaData.g:4846:4: ( ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) ) )
                    // InternalMetaData.g:4847:5: ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )? ( (lv_switch_9_0= ruleXExpression ) )
                    {
                    // InternalMetaData.g:4847:5: ( ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' ) )?
                    int alt76=2;
                    alt76 = dfa76.predict(input);
                    switch (alt76) {
                        case 1 :
                            // InternalMetaData.g:4848:6: ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' )
                            {
                            // InternalMetaData.g:4857:6: ( ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':' )
                            // InternalMetaData.g:4858:7: ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) ) otherlv_8= ':'
                            {
                            // InternalMetaData.g:4858:7: ( (lv_declaredParam_7_0= ruleJvmFormalParameter ) )
                            // InternalMetaData.g:4859:8: (lv_declaredParam_7_0= ruleJvmFormalParameter )
                            {
                            // InternalMetaData.g:4859:8: (lv_declaredParam_7_0= ruleJvmFormalParameter )
                            // InternalMetaData.g:4860:9: lv_declaredParam_7_0= ruleJvmFormalParameter
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getDeclaredParamJvmFormalParameterParserRuleCall_2_1_0_0_0_0());
                              								
                            }
                            pushFollow(FOLLOW_74);
                            lv_declaredParam_7_0=ruleJvmFormalParameter();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
                              									}
                              									set(
                              										current,
                              										"declaredParam",
                              										lv_declaredParam_7_0,
                              										"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }

                            otherlv_8=(Token)match(input,29,FOLLOW_18); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_8, grammarAccess.getXSwitchExpressionAccess().getColonKeyword_2_1_0_0_1());
                              						
                            }

                            }


                            }
                            break;

                    }

                    // InternalMetaData.g:4883:5: ( (lv_switch_9_0= ruleXExpression ) )
                    // InternalMetaData.g:4884:6: (lv_switch_9_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4884:6: (lv_switch_9_0= ruleXExpression )
                    // InternalMetaData.g:4885:7: lv_switch_9_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getSwitchXExpressionParserRuleCall_2_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_6);
                    lv_switch_9_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
                      							}
                      							set(
                      								current,
                      								"switch",
                      								lv_switch_9_0,
                      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }


                    }
                    break;

            }

            otherlv_10=(Token)match(input,15,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_10, grammarAccess.getXSwitchExpressionAccess().getLeftCurlyBracketKeyword_3());
              		
            }
            // InternalMetaData.g:4908:3: ( (lv_cases_11_0= ruleXCasePart ) )*
            loop78:
            do {
                int alt78=2;
                int LA78_0 = input.LA(1);

                if ( (LA78_0==RULE_ID||LA78_0==29||LA78_0==36||LA78_0==41||LA78_0==68||LA78_0==89) ) {
                    alt78=1;
                }


                switch (alt78) {
            	case 1 :
            	    // InternalMetaData.g:4909:4: (lv_cases_11_0= ruleXCasePart )
            	    {
            	    // InternalMetaData.g:4909:4: (lv_cases_11_0= ruleXCasePart )
            	    // InternalMetaData.g:4910:5: lv_cases_11_0= ruleXCasePart
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getCasesXCasePartParserRuleCall_4_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_75);
            	    lv_cases_11_0=ruleXCasePart();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
            	      					}
            	      					add(
            	      						current,
            	      						"cases",
            	      						lv_cases_11_0,
            	      						"org.eclipse.xtext.xbase.Xbase.XCasePart");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop78;
                }
            } while (true);

            // InternalMetaData.g:4927:3: (otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) ) )?
            int alt79=2;
            int LA79_0 = input.LA(1);

            if ( (LA79_0==31) ) {
                alt79=1;
            }
            switch (alt79) {
                case 1 :
                    // InternalMetaData.g:4928:4: otherlv_12= 'default' otherlv_13= ':' ( (lv_default_14_0= ruleXExpression ) )
                    {
                    otherlv_12=(Token)match(input,31,FOLLOW_74); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_12, grammarAccess.getXSwitchExpressionAccess().getDefaultKeyword_5_0());
                      			
                    }
                    otherlv_13=(Token)match(input,29,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_13, grammarAccess.getXSwitchExpressionAccess().getColonKeyword_5_1());
                      			
                    }
                    // InternalMetaData.g:4936:4: ( (lv_default_14_0= ruleXExpression ) )
                    // InternalMetaData.g:4937:5: (lv_default_14_0= ruleXExpression )
                    {
                    // InternalMetaData.g:4937:5: (lv_default_14_0= ruleXExpression )
                    // InternalMetaData.g:4938:6: lv_default_14_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXSwitchExpressionAccess().getDefaultXExpressionParserRuleCall_5_2_0());
                      					
                    }
                    pushFollow(FOLLOW_76);
                    lv_default_14_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXSwitchExpressionRule());
                      						}
                      						set(
                      							current,
                      							"default",
                      							lv_default_14_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_15=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_15, grammarAccess.getXSwitchExpressionAccess().getRightCurlyBracketKeyword_6());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXSwitchExpression"


    // $ANTLR start "entryRuleXCasePart"
    // InternalMetaData.g:4964:1: entryRuleXCasePart returns [EObject current=null] : iv_ruleXCasePart= ruleXCasePart EOF ;
    public final EObject entryRuleXCasePart() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXCasePart = null;


        try {
            // InternalMetaData.g:4964:50: (iv_ruleXCasePart= ruleXCasePart EOF )
            // InternalMetaData.g:4965:2: iv_ruleXCasePart= ruleXCasePart EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXCasePartRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXCasePart=ruleXCasePart();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXCasePart; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXCasePart"


    // $ANTLR start "ruleXCasePart"
    // InternalMetaData.g:4971:1: ruleXCasePart returns [EObject current=null] : ( () ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )? (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )? ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) ) ) ;
    public final EObject ruleXCasePart() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        Token otherlv_4=null;
        Token lv_fallThrough_6_0=null;
        EObject lv_typeGuard_1_0 = null;

        EObject lv_case_3_0 = null;

        EObject lv_then_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:4977:2: ( ( () ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )? (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )? ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) ) ) )
            // InternalMetaData.g:4978:2: ( () ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )? (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )? ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) ) )
            {
            // InternalMetaData.g:4978:2: ( () ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )? (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )? ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) ) )
            // InternalMetaData.g:4979:3: () ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )? (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )? ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) )
            {
            // InternalMetaData.g:4979:3: ()
            // InternalMetaData.g:4980:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXCasePartAccess().getXCasePartAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:4986:3: ( (lv_typeGuard_1_0= ruleJvmTypeReference ) )?
            int alt80=2;
            int LA80_0 = input.LA(1);

            if ( (LA80_0==RULE_ID||LA80_0==41||LA80_0==68) ) {
                alt80=1;
            }
            switch (alt80) {
                case 1 :
                    // InternalMetaData.g:4987:4: (lv_typeGuard_1_0= ruleJvmTypeReference )
                    {
                    // InternalMetaData.g:4987:4: (lv_typeGuard_1_0= ruleJvmTypeReference )
                    // InternalMetaData.g:4988:5: lv_typeGuard_1_0= ruleJvmTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getXCasePartAccess().getTypeGuardJvmTypeReferenceParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_77);
                    lv_typeGuard_1_0=ruleJvmTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getXCasePartRule());
                      					}
                      					set(
                      						current,
                      						"typeGuard",
                      						lv_typeGuard_1_0,
                      						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            // InternalMetaData.g:5005:3: (otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) ) )?
            int alt81=2;
            int LA81_0 = input.LA(1);

            if ( (LA81_0==89) ) {
                alt81=1;
            }
            switch (alt81) {
                case 1 :
                    // InternalMetaData.g:5006:4: otherlv_2= 'case' ( (lv_case_3_0= ruleXExpression ) )
                    {
                    otherlv_2=(Token)match(input,89,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getXCasePartAccess().getCaseKeyword_2_0());
                      			
                    }
                    // InternalMetaData.g:5010:4: ( (lv_case_3_0= ruleXExpression ) )
                    // InternalMetaData.g:5011:5: (lv_case_3_0= ruleXExpression )
                    {
                    // InternalMetaData.g:5011:5: (lv_case_3_0= ruleXExpression )
                    // InternalMetaData.g:5012:6: lv_case_3_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXCasePartAccess().getCaseXExpressionParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_78);
                    lv_case_3_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXCasePartRule());
                      						}
                      						set(
                      							current,
                      							"case",
                      							lv_case_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:5030:3: ( (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) ) | ( (lv_fallThrough_6_0= ',' ) ) )
            int alt82=2;
            int LA82_0 = input.LA(1);

            if ( (LA82_0==29) ) {
                alt82=1;
            }
            else if ( (LA82_0==36) ) {
                alt82=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;
            }
            switch (alt82) {
                case 1 :
                    // InternalMetaData.g:5031:4: (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) )
                    {
                    // InternalMetaData.g:5031:4: (otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) ) )
                    // InternalMetaData.g:5032:5: otherlv_4= ':' ( (lv_then_5_0= ruleXExpression ) )
                    {
                    otherlv_4=(Token)match(input,29,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_4, grammarAccess.getXCasePartAccess().getColonKeyword_3_0_0());
                      				
                    }
                    // InternalMetaData.g:5036:5: ( (lv_then_5_0= ruleXExpression ) )
                    // InternalMetaData.g:5037:6: (lv_then_5_0= ruleXExpression )
                    {
                    // InternalMetaData.g:5037:6: (lv_then_5_0= ruleXExpression )
                    // InternalMetaData.g:5038:7: lv_then_5_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXCasePartAccess().getThenXExpressionParserRuleCall_3_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_then_5_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getXCasePartRule());
                      							}
                      							set(
                      								current,
                      								"then",
                      								lv_then_5_0,
                      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:5057:4: ( (lv_fallThrough_6_0= ',' ) )
                    {
                    // InternalMetaData.g:5057:4: ( (lv_fallThrough_6_0= ',' ) )
                    // InternalMetaData.g:5058:5: (lv_fallThrough_6_0= ',' )
                    {
                    // InternalMetaData.g:5058:5: (lv_fallThrough_6_0= ',' )
                    // InternalMetaData.g:5059:6: lv_fallThrough_6_0= ','
                    {
                    lv_fallThrough_6_0=(Token)match(input,36,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_fallThrough_6_0, grammarAccess.getXCasePartAccess().getFallThroughCommaKeyword_3_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXCasePartRule());
                      						}
                      						setWithLastConsumed(current, "fallThrough", true, ",");
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXCasePart"


    // $ANTLR start "entryRuleXForLoopExpression"
    // InternalMetaData.g:5076:1: entryRuleXForLoopExpression returns [EObject current=null] : iv_ruleXForLoopExpression= ruleXForLoopExpression EOF ;
    public final EObject entryRuleXForLoopExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXForLoopExpression = null;


        try {
            // InternalMetaData.g:5076:59: (iv_ruleXForLoopExpression= ruleXForLoopExpression EOF )
            // InternalMetaData.g:5077:2: iv_ruleXForLoopExpression= ruleXForLoopExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXForLoopExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXForLoopExpression=ruleXForLoopExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXForLoopExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXForLoopExpression"


    // $ANTLR start "ruleXForLoopExpression"
    // InternalMetaData.g:5083:1: ruleXForLoopExpression returns [EObject current=null] : ( ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_forExpression_5_0= ruleXExpression ) ) otherlv_6= ')' ( (lv_eachExpression_7_0= ruleXExpression ) ) ) ;
    public final EObject ruleXForLoopExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_declaredParam_3_0 = null;

        EObject lv_forExpression_5_0 = null;

        EObject lv_eachExpression_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5089:2: ( ( ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_forExpression_5_0= ruleXExpression ) ) otherlv_6= ')' ( (lv_eachExpression_7_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:5090:2: ( ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_forExpression_5_0= ruleXExpression ) ) otherlv_6= ')' ( (lv_eachExpression_7_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:5090:2: ( ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_forExpression_5_0= ruleXExpression ) ) otherlv_6= ')' ( (lv_eachExpression_7_0= ruleXExpression ) ) )
            // InternalMetaData.g:5091:3: ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) ) ( (lv_forExpression_5_0= ruleXExpression ) ) otherlv_6= ')' ( (lv_eachExpression_7_0= ruleXExpression ) )
            {
            // InternalMetaData.g:5091:3: ( ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' ) )
            // InternalMetaData.g:5092:4: ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )=> ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' )
            {
            // InternalMetaData.g:5105:4: ( () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':' )
            // InternalMetaData.g:5106:5: () otherlv_1= 'for' otherlv_2= '(' ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) ) otherlv_4= ':'
            {
            // InternalMetaData.g:5106:5: ()
            // InternalMetaData.g:5107:6: 
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getXForLoopExpressionAccess().getXForLoopExpressionAction_0_0_0(),
              							current);
              					
            }

            }

            otherlv_1=(Token)match(input,90,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getXForLoopExpressionAccess().getForKeyword_0_0_1());
              				
            }
            otherlv_2=(Token)match(input,41,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_2, grammarAccess.getXForLoopExpressionAccess().getLeftParenthesisKeyword_0_0_2());
              				
            }
            // InternalMetaData.g:5121:5: ( (lv_declaredParam_3_0= ruleJvmFormalParameter ) )
            // InternalMetaData.g:5122:6: (lv_declaredParam_3_0= ruleJvmFormalParameter )
            {
            // InternalMetaData.g:5122:6: (lv_declaredParam_3_0= ruleJvmFormalParameter )
            // InternalMetaData.g:5123:7: lv_declaredParam_3_0= ruleJvmFormalParameter
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getXForLoopExpressionAccess().getDeclaredParamJvmFormalParameterParserRuleCall_0_0_3_0());
              						
            }
            pushFollow(FOLLOW_74);
            lv_declaredParam_3_0=ruleJvmFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getXForLoopExpressionRule());
              							}
              							set(
              								current,
              								"declaredParam",
              								lv_declaredParam_3_0,
              								"org.eclipse.xtext.xbase.Xbase.JvmFormalParameter");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }

            otherlv_4=(Token)match(input,29,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_4, grammarAccess.getXForLoopExpressionAccess().getColonKeyword_0_0_4());
              				
            }

            }


            }

            // InternalMetaData.g:5146:3: ( (lv_forExpression_5_0= ruleXExpression ) )
            // InternalMetaData.g:5147:4: (lv_forExpression_5_0= ruleXExpression )
            {
            // InternalMetaData.g:5147:4: (lv_forExpression_5_0= ruleXExpression )
            // InternalMetaData.g:5148:5: lv_forExpression_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXForLoopExpressionAccess().getForExpressionXExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_forExpression_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXForLoopExpressionRule());
              					}
              					set(
              						current,
              						"forExpression",
              						lv_forExpression_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_6=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getXForLoopExpressionAccess().getRightParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:5169:3: ( (lv_eachExpression_7_0= ruleXExpression ) )
            // InternalMetaData.g:5170:4: (lv_eachExpression_7_0= ruleXExpression )
            {
            // InternalMetaData.g:5170:4: (lv_eachExpression_7_0= ruleXExpression )
            // InternalMetaData.g:5171:5: lv_eachExpression_7_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXForLoopExpressionAccess().getEachExpressionXExpressionParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_eachExpression_7_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXForLoopExpressionRule());
              					}
              					set(
              						current,
              						"eachExpression",
              						lv_eachExpression_7_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXForLoopExpression"


    // $ANTLR start "entryRuleXBasicForLoopExpression"
    // InternalMetaData.g:5192:1: entryRuleXBasicForLoopExpression returns [EObject current=null] : iv_ruleXBasicForLoopExpression= ruleXBasicForLoopExpression EOF ;
    public final EObject entryRuleXBasicForLoopExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXBasicForLoopExpression = null;


        try {
            // InternalMetaData.g:5192:64: (iv_ruleXBasicForLoopExpression= ruleXBasicForLoopExpression EOF )
            // InternalMetaData.g:5193:2: iv_ruleXBasicForLoopExpression= ruleXBasicForLoopExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXBasicForLoopExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXBasicForLoopExpression=ruleXBasicForLoopExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXBasicForLoopExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXBasicForLoopExpression"


    // $ANTLR start "ruleXBasicForLoopExpression"
    // InternalMetaData.g:5199:1: ruleXBasicForLoopExpression returns [EObject current=null] : ( () otherlv_1= 'for' otherlv_2= '(' ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )? otherlv_6= ';' ( (lv_expression_7_0= ruleXExpression ) )? otherlv_8= ';' ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )? otherlv_12= ')' ( (lv_eachExpression_13_0= ruleXExpression ) ) ) ;
    public final EObject ruleXBasicForLoopExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        Token otherlv_8=null;
        Token otherlv_10=null;
        Token otherlv_12=null;
        EObject lv_initExpressions_3_0 = null;

        EObject lv_initExpressions_5_0 = null;

        EObject lv_expression_7_0 = null;

        EObject lv_updateExpressions_9_0 = null;

        EObject lv_updateExpressions_11_0 = null;

        EObject lv_eachExpression_13_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5205:2: ( ( () otherlv_1= 'for' otherlv_2= '(' ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )? otherlv_6= ';' ( (lv_expression_7_0= ruleXExpression ) )? otherlv_8= ';' ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )? otherlv_12= ')' ( (lv_eachExpression_13_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:5206:2: ( () otherlv_1= 'for' otherlv_2= '(' ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )? otherlv_6= ';' ( (lv_expression_7_0= ruleXExpression ) )? otherlv_8= ';' ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )? otherlv_12= ')' ( (lv_eachExpression_13_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:5206:2: ( () otherlv_1= 'for' otherlv_2= '(' ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )? otherlv_6= ';' ( (lv_expression_7_0= ruleXExpression ) )? otherlv_8= ';' ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )? otherlv_12= ')' ( (lv_eachExpression_13_0= ruleXExpression ) ) )
            // InternalMetaData.g:5207:3: () otherlv_1= 'for' otherlv_2= '(' ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )? otherlv_6= ';' ( (lv_expression_7_0= ruleXExpression ) )? otherlv_8= ';' ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )? otherlv_12= ')' ( (lv_eachExpression_13_0= ruleXExpression ) )
            {
            // InternalMetaData.g:5207:3: ()
            // InternalMetaData.g:5208:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXBasicForLoopExpressionAccess().getXBasicForLoopExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,90,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXBasicForLoopExpressionAccess().getForKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,41,FOLLOW_79); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXBasicForLoopExpressionAccess().getLeftParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:5222:3: ( ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )* )?
            int alt84=2;
            int LA84_0 = input.LA(1);

            if ( ((LA84_0>=RULE_STRING && LA84_0<=RULE_DECIMAL)||LA84_0==15||(LA84_0>=41 && LA84_0<=42)||LA84_0==50||LA84_0==56||LA84_0==71||LA84_0==75||LA84_0==82||LA84_0==86||LA84_0==88||(LA84_0>=90 && LA84_0<=107)||LA84_0==109) ) {
                alt84=1;
            }
            switch (alt84) {
                case 1 :
                    // InternalMetaData.g:5223:4: ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )*
                    {
                    // InternalMetaData.g:5223:4: ( (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration ) )
                    // InternalMetaData.g:5224:5: (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration )
                    {
                    // InternalMetaData.g:5224:5: (lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration )
                    // InternalMetaData.g:5225:6: lv_initExpressions_3_0= ruleXExpressionOrVarDeclaration
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getInitExpressionsXExpressionOrVarDeclarationParserRuleCall_3_0_0());
                      					
                    }
                    pushFollow(FOLLOW_80);
                    lv_initExpressions_3_0=ruleXExpressionOrVarDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
                      						}
                      						add(
                      							current,
                      							"initExpressions",
                      							lv_initExpressions_3_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpressionOrVarDeclaration");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:5242:4: (otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) ) )*
                    loop83:
                    do {
                        int alt83=2;
                        int LA83_0 = input.LA(1);

                        if ( (LA83_0==36) ) {
                            alt83=1;
                        }


                        switch (alt83) {
                    	case 1 :
                    	    // InternalMetaData.g:5243:5: otherlv_4= ',' ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) )
                    	    {
                    	    otherlv_4=(Token)match(input,36,FOLLOW_81); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_4, grammarAccess.getXBasicForLoopExpressionAccess().getCommaKeyword_3_1_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:5247:5: ( (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration ) )
                    	    // InternalMetaData.g:5248:6: (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration )
                    	    {
                    	    // InternalMetaData.g:5248:6: (lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration )
                    	    // InternalMetaData.g:5249:7: lv_initExpressions_5_0= ruleXExpressionOrVarDeclaration
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getInitExpressionsXExpressionOrVarDeclarationParserRuleCall_3_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_80);
                    	    lv_initExpressions_5_0=ruleXExpressionOrVarDeclaration();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"initExpressions",
                    	      								lv_initExpressions_5_0,
                    	      								"org.eclipse.xtext.xbase.Xbase.XExpressionOrVarDeclaration");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop83;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_6=(Token)match(input,85,FOLLOW_82); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getXBasicForLoopExpressionAccess().getSemicolonKeyword_4());
              		
            }
            // InternalMetaData.g:5272:3: ( (lv_expression_7_0= ruleXExpression ) )?
            int alt85=2;
            int LA85_0 = input.LA(1);

            if ( ((LA85_0>=RULE_STRING && LA85_0<=RULE_DECIMAL)||LA85_0==15||(LA85_0>=41 && LA85_0<=42)||LA85_0==50||LA85_0==56||LA85_0==71||LA85_0==75||LA85_0==82||LA85_0==86||LA85_0==88||(LA85_0>=90 && LA85_0<=92)||(LA85_0>=95 && LA85_0<=107)||LA85_0==109) ) {
                alt85=1;
            }
            switch (alt85) {
                case 1 :
                    // InternalMetaData.g:5273:4: (lv_expression_7_0= ruleXExpression )
                    {
                    // InternalMetaData.g:5273:4: (lv_expression_7_0= ruleXExpression )
                    // InternalMetaData.g:5274:5: lv_expression_7_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getExpressionXExpressionParserRuleCall_5_0());
                      				
                    }
                    pushFollow(FOLLOW_83);
                    lv_expression_7_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
                      					}
                      					set(
                      						current,
                      						"expression",
                      						lv_expression_7_0,
                      						"org.eclipse.xtext.xbase.Xbase.XExpression");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            otherlv_8=(Token)match(input,85,FOLLOW_84); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_8, grammarAccess.getXBasicForLoopExpressionAccess().getSemicolonKeyword_6());
              		
            }
            // InternalMetaData.g:5295:3: ( ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )* )?
            int alt87=2;
            int LA87_0 = input.LA(1);

            if ( ((LA87_0>=RULE_STRING && LA87_0<=RULE_DECIMAL)||LA87_0==15||(LA87_0>=41 && LA87_0<=42)||LA87_0==50||LA87_0==56||LA87_0==71||LA87_0==75||LA87_0==82||LA87_0==86||LA87_0==88||(LA87_0>=90 && LA87_0<=92)||(LA87_0>=95 && LA87_0<=107)||LA87_0==109) ) {
                alt87=1;
            }
            switch (alt87) {
                case 1 :
                    // InternalMetaData.g:5296:4: ( (lv_updateExpressions_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )*
                    {
                    // InternalMetaData.g:5296:4: ( (lv_updateExpressions_9_0= ruleXExpression ) )
                    // InternalMetaData.g:5297:5: (lv_updateExpressions_9_0= ruleXExpression )
                    {
                    // InternalMetaData.g:5297:5: (lv_updateExpressions_9_0= ruleXExpression )
                    // InternalMetaData.g:5298:6: lv_updateExpressions_9_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getUpdateExpressionsXExpressionParserRuleCall_7_0_0());
                      					
                    }
                    pushFollow(FOLLOW_59);
                    lv_updateExpressions_9_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
                      						}
                      						add(
                      							current,
                      							"updateExpressions",
                      							lv_updateExpressions_9_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:5315:4: (otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) ) )*
                    loop86:
                    do {
                        int alt86=2;
                        int LA86_0 = input.LA(1);

                        if ( (LA86_0==36) ) {
                            alt86=1;
                        }


                        switch (alt86) {
                    	case 1 :
                    	    // InternalMetaData.g:5316:5: otherlv_10= ',' ( (lv_updateExpressions_11_0= ruleXExpression ) )
                    	    {
                    	    otherlv_10=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_10, grammarAccess.getXBasicForLoopExpressionAccess().getCommaKeyword_7_1_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:5320:5: ( (lv_updateExpressions_11_0= ruleXExpression ) )
                    	    // InternalMetaData.g:5321:6: (lv_updateExpressions_11_0= ruleXExpression )
                    	    {
                    	    // InternalMetaData.g:5321:6: (lv_updateExpressions_11_0= ruleXExpression )
                    	    // InternalMetaData.g:5322:7: lv_updateExpressions_11_0= ruleXExpression
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getUpdateExpressionsXExpressionParserRuleCall_7_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_59);
                    	    lv_updateExpressions_11_0=ruleXExpression();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"updateExpressions",
                    	      								lv_updateExpressions_11_0,
                    	      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop86;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_12=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_12, grammarAccess.getXBasicForLoopExpressionAccess().getRightParenthesisKeyword_8());
              		
            }
            // InternalMetaData.g:5345:3: ( (lv_eachExpression_13_0= ruleXExpression ) )
            // InternalMetaData.g:5346:4: (lv_eachExpression_13_0= ruleXExpression )
            {
            // InternalMetaData.g:5346:4: (lv_eachExpression_13_0= ruleXExpression )
            // InternalMetaData.g:5347:5: lv_eachExpression_13_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXBasicForLoopExpressionAccess().getEachExpressionXExpressionParserRuleCall_9_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_eachExpression_13_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXBasicForLoopExpressionRule());
              					}
              					set(
              						current,
              						"eachExpression",
              						lv_eachExpression_13_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXBasicForLoopExpression"


    // $ANTLR start "entryRuleXWhileExpression"
    // InternalMetaData.g:5368:1: entryRuleXWhileExpression returns [EObject current=null] : iv_ruleXWhileExpression= ruleXWhileExpression EOF ;
    public final EObject entryRuleXWhileExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXWhileExpression = null;


        try {
            // InternalMetaData.g:5368:57: (iv_ruleXWhileExpression= ruleXWhileExpression EOF )
            // InternalMetaData.g:5369:2: iv_ruleXWhileExpression= ruleXWhileExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXWhileExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXWhileExpression=ruleXWhileExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXWhileExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXWhileExpression"


    // $ANTLR start "ruleXWhileExpression"
    // InternalMetaData.g:5375:1: ruleXWhileExpression returns [EObject current=null] : ( () otherlv_1= 'while' otherlv_2= '(' ( (lv_predicate_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_body_5_0= ruleXExpression ) ) ) ;
    public final EObject ruleXWhileExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_predicate_3_0 = null;

        EObject lv_body_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5381:2: ( ( () otherlv_1= 'while' otherlv_2= '(' ( (lv_predicate_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_body_5_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:5382:2: ( () otherlv_1= 'while' otherlv_2= '(' ( (lv_predicate_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_body_5_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:5382:2: ( () otherlv_1= 'while' otherlv_2= '(' ( (lv_predicate_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_body_5_0= ruleXExpression ) ) )
            // InternalMetaData.g:5383:3: () otherlv_1= 'while' otherlv_2= '(' ( (lv_predicate_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_body_5_0= ruleXExpression ) )
            {
            // InternalMetaData.g:5383:3: ()
            // InternalMetaData.g:5384:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXWhileExpressionAccess().getXWhileExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,91,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXWhileExpressionAccess().getWhileKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,41,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXWhileExpressionAccess().getLeftParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:5398:3: ( (lv_predicate_3_0= ruleXExpression ) )
            // InternalMetaData.g:5399:4: (lv_predicate_3_0= ruleXExpression )
            {
            // InternalMetaData.g:5399:4: (lv_predicate_3_0= ruleXExpression )
            // InternalMetaData.g:5400:5: lv_predicate_3_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXWhileExpressionAccess().getPredicateXExpressionParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_predicate_3_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXWhileExpressionRule());
              					}
              					set(
              						current,
              						"predicate",
              						lv_predicate_3_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_4=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getXWhileExpressionAccess().getRightParenthesisKeyword_4());
              		
            }
            // InternalMetaData.g:5421:3: ( (lv_body_5_0= ruleXExpression ) )
            // InternalMetaData.g:5422:4: (lv_body_5_0= ruleXExpression )
            {
            // InternalMetaData.g:5422:4: (lv_body_5_0= ruleXExpression )
            // InternalMetaData.g:5423:5: lv_body_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXWhileExpressionAccess().getBodyXExpressionParserRuleCall_5_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_body_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXWhileExpressionRule());
              					}
              					set(
              						current,
              						"body",
              						lv_body_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXWhileExpression"


    // $ANTLR start "entryRuleXDoWhileExpression"
    // InternalMetaData.g:5444:1: entryRuleXDoWhileExpression returns [EObject current=null] : iv_ruleXDoWhileExpression= ruleXDoWhileExpression EOF ;
    public final EObject entryRuleXDoWhileExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXDoWhileExpression = null;


        try {
            // InternalMetaData.g:5444:59: (iv_ruleXDoWhileExpression= ruleXDoWhileExpression EOF )
            // InternalMetaData.g:5445:2: iv_ruleXDoWhileExpression= ruleXDoWhileExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXDoWhileExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXDoWhileExpression=ruleXDoWhileExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXDoWhileExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXDoWhileExpression"


    // $ANTLR start "ruleXDoWhileExpression"
    // InternalMetaData.g:5451:1: ruleXDoWhileExpression returns [EObject current=null] : ( () otherlv_1= 'do' ( (lv_body_2_0= ruleXExpression ) ) otherlv_3= 'while' otherlv_4= '(' ( (lv_predicate_5_0= ruleXExpression ) ) otherlv_6= ')' ) ;
    public final EObject ruleXDoWhileExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_body_2_0 = null;

        EObject lv_predicate_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5457:2: ( ( () otherlv_1= 'do' ( (lv_body_2_0= ruleXExpression ) ) otherlv_3= 'while' otherlv_4= '(' ( (lv_predicate_5_0= ruleXExpression ) ) otherlv_6= ')' ) )
            // InternalMetaData.g:5458:2: ( () otherlv_1= 'do' ( (lv_body_2_0= ruleXExpression ) ) otherlv_3= 'while' otherlv_4= '(' ( (lv_predicate_5_0= ruleXExpression ) ) otherlv_6= ')' )
            {
            // InternalMetaData.g:5458:2: ( () otherlv_1= 'do' ( (lv_body_2_0= ruleXExpression ) ) otherlv_3= 'while' otherlv_4= '(' ( (lv_predicate_5_0= ruleXExpression ) ) otherlv_6= ')' )
            // InternalMetaData.g:5459:3: () otherlv_1= 'do' ( (lv_body_2_0= ruleXExpression ) ) otherlv_3= 'while' otherlv_4= '(' ( (lv_predicate_5_0= ruleXExpression ) ) otherlv_6= ')'
            {
            // InternalMetaData.g:5459:3: ()
            // InternalMetaData.g:5460:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXDoWhileExpressionAccess().getXDoWhileExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,92,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXDoWhileExpressionAccess().getDoKeyword_1());
              		
            }
            // InternalMetaData.g:5470:3: ( (lv_body_2_0= ruleXExpression ) )
            // InternalMetaData.g:5471:4: (lv_body_2_0= ruleXExpression )
            {
            // InternalMetaData.g:5471:4: (lv_body_2_0= ruleXExpression )
            // InternalMetaData.g:5472:5: lv_body_2_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXDoWhileExpressionAccess().getBodyXExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_85);
            lv_body_2_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXDoWhileExpressionRule());
              					}
              					set(
              						current,
              						"body",
              						lv_body_2_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,91,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getXDoWhileExpressionAccess().getWhileKeyword_3());
              		
            }
            otherlv_4=(Token)match(input,41,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getXDoWhileExpressionAccess().getLeftParenthesisKeyword_4());
              		
            }
            // InternalMetaData.g:5497:3: ( (lv_predicate_5_0= ruleXExpression ) )
            // InternalMetaData.g:5498:4: (lv_predicate_5_0= ruleXExpression )
            {
            // InternalMetaData.g:5498:4: (lv_predicate_5_0= ruleXExpression )
            // InternalMetaData.g:5499:5: lv_predicate_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXDoWhileExpressionAccess().getPredicateXExpressionParserRuleCall_5_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_predicate_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXDoWhileExpressionRule());
              					}
              					set(
              						current,
              						"predicate",
              						lv_predicate_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_6=(Token)match(input,43,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getXDoWhileExpressionAccess().getRightParenthesisKeyword_6());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXDoWhileExpression"


    // $ANTLR start "entryRuleXBlockExpression"
    // InternalMetaData.g:5524:1: entryRuleXBlockExpression returns [EObject current=null] : iv_ruleXBlockExpression= ruleXBlockExpression EOF ;
    public final EObject entryRuleXBlockExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXBlockExpression = null;


        try {
            // InternalMetaData.g:5524:57: (iv_ruleXBlockExpression= ruleXBlockExpression EOF )
            // InternalMetaData.g:5525:2: iv_ruleXBlockExpression= ruleXBlockExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXBlockExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXBlockExpression=ruleXBlockExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXBlockExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXBlockExpression"


    // $ANTLR start "ruleXBlockExpression"
    // InternalMetaData.g:5531:1: ruleXBlockExpression returns [EObject current=null] : ( () otherlv_1= '{' ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )* otherlv_4= '}' ) ;
    public final EObject ruleXBlockExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_4=null;
        EObject lv_expressions_2_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5537:2: ( ( () otherlv_1= '{' ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )* otherlv_4= '}' ) )
            // InternalMetaData.g:5538:2: ( () otherlv_1= '{' ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )* otherlv_4= '}' )
            {
            // InternalMetaData.g:5538:2: ( () otherlv_1= '{' ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )* otherlv_4= '}' )
            // InternalMetaData.g:5539:3: () otherlv_1= '{' ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )* otherlv_4= '}'
            {
            // InternalMetaData.g:5539:3: ()
            // InternalMetaData.g:5540:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXBlockExpressionAccess().getXBlockExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,15,FOLLOW_86); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXBlockExpressionAccess().getLeftCurlyBracketKeyword_1());
              		
            }
            // InternalMetaData.g:5550:3: ( ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )? )*
            loop89:
            do {
                int alt89=2;
                int LA89_0 = input.LA(1);

                if ( ((LA89_0>=RULE_STRING && LA89_0<=RULE_DECIMAL)||LA89_0==15||(LA89_0>=41 && LA89_0<=42)||LA89_0==50||LA89_0==56||LA89_0==71||LA89_0==75||LA89_0==82||LA89_0==86||LA89_0==88||(LA89_0>=90 && LA89_0<=107)||LA89_0==109) ) {
                    alt89=1;
                }


                switch (alt89) {
            	case 1 :
            	    // InternalMetaData.g:5551:4: ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) ) (otherlv_3= ';' )?
            	    {
            	    // InternalMetaData.g:5551:4: ( (lv_expressions_2_0= ruleXExpressionOrVarDeclaration ) )
            	    // InternalMetaData.g:5552:5: (lv_expressions_2_0= ruleXExpressionOrVarDeclaration )
            	    {
            	    // InternalMetaData.g:5552:5: (lv_expressions_2_0= ruleXExpressionOrVarDeclaration )
            	    // InternalMetaData.g:5553:6: lv_expressions_2_0= ruleXExpressionOrVarDeclaration
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getXBlockExpressionAccess().getExpressionsXExpressionOrVarDeclarationParserRuleCall_2_0_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_87);
            	    lv_expressions_2_0=ruleXExpressionOrVarDeclaration();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getXBlockExpressionRule());
            	      						}
            	      						add(
            	      							current,
            	      							"expressions",
            	      							lv_expressions_2_0,
            	      							"org.eclipse.xtext.xbase.Xbase.XExpressionOrVarDeclaration");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }

            	    // InternalMetaData.g:5570:4: (otherlv_3= ';' )?
            	    int alt88=2;
            	    int LA88_0 = input.LA(1);

            	    if ( (LA88_0==85) ) {
            	        alt88=1;
            	    }
            	    switch (alt88) {
            	        case 1 :
            	            // InternalMetaData.g:5571:5: otherlv_3= ';'
            	            {
            	            otherlv_3=(Token)match(input,85,FOLLOW_86); if (state.failed) return current;
            	            if ( state.backtracking==0 ) {

            	              					newLeafNode(otherlv_3, grammarAccess.getXBlockExpressionAccess().getSemicolonKeyword_2_1());
            	              				
            	            }

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop89;
                }
            } while (true);

            otherlv_4=(Token)match(input,20,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getXBlockExpressionAccess().getRightCurlyBracketKeyword_3());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXBlockExpression"


    // $ANTLR start "entryRuleXExpressionOrVarDeclaration"
    // InternalMetaData.g:5585:1: entryRuleXExpressionOrVarDeclaration returns [EObject current=null] : iv_ruleXExpressionOrVarDeclaration= ruleXExpressionOrVarDeclaration EOF ;
    public final EObject entryRuleXExpressionOrVarDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXExpressionOrVarDeclaration = null;


        try {
            // InternalMetaData.g:5585:68: (iv_ruleXExpressionOrVarDeclaration= ruleXExpressionOrVarDeclaration EOF )
            // InternalMetaData.g:5586:2: iv_ruleXExpressionOrVarDeclaration= ruleXExpressionOrVarDeclaration EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXExpressionOrVarDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXExpressionOrVarDeclaration=ruleXExpressionOrVarDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXExpressionOrVarDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXExpressionOrVarDeclaration"


    // $ANTLR start "ruleXExpressionOrVarDeclaration"
    // InternalMetaData.g:5592:1: ruleXExpressionOrVarDeclaration returns [EObject current=null] : (this_XVariableDeclaration_0= ruleXVariableDeclaration | this_XExpression_1= ruleXExpression ) ;
    public final EObject ruleXExpressionOrVarDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_XVariableDeclaration_0 = null;

        EObject this_XExpression_1 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5598:2: ( (this_XVariableDeclaration_0= ruleXVariableDeclaration | this_XExpression_1= ruleXExpression ) )
            // InternalMetaData.g:5599:2: (this_XVariableDeclaration_0= ruleXVariableDeclaration | this_XExpression_1= ruleXExpression )
            {
            // InternalMetaData.g:5599:2: (this_XVariableDeclaration_0= ruleXVariableDeclaration | this_XExpression_1= ruleXExpression )
            int alt90=2;
            int LA90_0 = input.LA(1);

            if ( ((LA90_0>=93 && LA90_0<=94)) ) {
                alt90=1;
            }
            else if ( ((LA90_0>=RULE_STRING && LA90_0<=RULE_DECIMAL)||LA90_0==15||(LA90_0>=41 && LA90_0<=42)||LA90_0==50||LA90_0==56||LA90_0==71||LA90_0==75||LA90_0==82||LA90_0==86||LA90_0==88||(LA90_0>=90 && LA90_0<=92)||(LA90_0>=95 && LA90_0<=107)||LA90_0==109) ) {
                alt90=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;
            }
            switch (alt90) {
                case 1 :
                    // InternalMetaData.g:5600:3: this_XVariableDeclaration_0= ruleXVariableDeclaration
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXExpressionOrVarDeclarationAccess().getXVariableDeclarationParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XVariableDeclaration_0=ruleXVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XVariableDeclaration_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:5609:3: this_XExpression_1= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getXExpressionOrVarDeclarationAccess().getXExpressionParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XExpression_1=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XExpression_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXExpressionOrVarDeclaration"


    // $ANTLR start "entryRuleXVariableDeclaration"
    // InternalMetaData.g:5621:1: entryRuleXVariableDeclaration returns [EObject current=null] : iv_ruleXVariableDeclaration= ruleXVariableDeclaration EOF ;
    public final EObject entryRuleXVariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXVariableDeclaration = null;


        try {
            // InternalMetaData.g:5621:61: (iv_ruleXVariableDeclaration= ruleXVariableDeclaration EOF )
            // InternalMetaData.g:5622:2: iv_ruleXVariableDeclaration= ruleXVariableDeclaration EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXVariableDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXVariableDeclaration=ruleXVariableDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXVariableDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXVariableDeclaration"


    // $ANTLR start "ruleXVariableDeclaration"
    // InternalMetaData.g:5628:1: ruleXVariableDeclaration returns [EObject current=null] : ( () ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' ) ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) ) (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )? ) ;
    public final EObject ruleXVariableDeclaration() throws RecognitionException {
        EObject current = null;

        Token lv_writeable_1_0=null;
        Token otherlv_2=null;
        Token otherlv_6=null;
        EObject lv_type_3_0 = null;

        AntlrDatatypeRuleToken lv_name_4_0 = null;

        AntlrDatatypeRuleToken lv_name_5_0 = null;

        EObject lv_right_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5634:2: ( ( () ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' ) ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) ) (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )? ) )
            // InternalMetaData.g:5635:2: ( () ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' ) ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) ) (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )? )
            {
            // InternalMetaData.g:5635:2: ( () ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' ) ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) ) (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )? )
            // InternalMetaData.g:5636:3: () ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' ) ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) ) (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )?
            {
            // InternalMetaData.g:5636:3: ()
            // InternalMetaData.g:5637:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXVariableDeclarationAccess().getXVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:5643:3: ( ( (lv_writeable_1_0= 'var' ) ) | otherlv_2= 'val' )
            int alt91=2;
            int LA91_0 = input.LA(1);

            if ( (LA91_0==93) ) {
                alt91=1;
            }
            else if ( (LA91_0==94) ) {
                alt91=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;
            }
            switch (alt91) {
                case 1 :
                    // InternalMetaData.g:5644:4: ( (lv_writeable_1_0= 'var' ) )
                    {
                    // InternalMetaData.g:5644:4: ( (lv_writeable_1_0= 'var' ) )
                    // InternalMetaData.g:5645:5: (lv_writeable_1_0= 'var' )
                    {
                    // InternalMetaData.g:5645:5: (lv_writeable_1_0= 'var' )
                    // InternalMetaData.g:5646:6: lv_writeable_1_0= 'var'
                    {
                    lv_writeable_1_0=(Token)match(input,93,FOLLOW_15); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_writeable_1_0, grammarAccess.getXVariableDeclarationAccess().getWriteableVarKeyword_1_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXVariableDeclarationRule());
                      						}
                      						setWithLastConsumed(current, "writeable", true, "var");
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:5659:4: otherlv_2= 'val'
                    {
                    otherlv_2=(Token)match(input,94,FOLLOW_15); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getXVariableDeclarationAccess().getValKeyword_1_1());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:5664:3: ( ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) ) | ( (lv_name_5_0= ruleValidID ) ) )
            int alt92=2;
            int LA92_0 = input.LA(1);

            if ( (LA92_0==RULE_ID) ) {
                int LA92_1 = input.LA(2);

                if ( (synpred29_InternalMetaData()) ) {
                    alt92=1;
                }
                else if ( (true) ) {
                    alt92=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 92, 1, input);

                    throw nvae;
                }
            }
            else if ( (LA92_0==41) && (synpred29_InternalMetaData())) {
                alt92=1;
            }
            else if ( (LA92_0==68) && (synpred29_InternalMetaData())) {
                alt92=1;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;
            }
            switch (alt92) {
                case 1 :
                    // InternalMetaData.g:5665:4: ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) )
                    {
                    // InternalMetaData.g:5665:4: ( ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) ) )
                    // InternalMetaData.g:5666:5: ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )=> ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) )
                    {
                    // InternalMetaData.g:5679:5: ( ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) ) )
                    // InternalMetaData.g:5680:6: ( (lv_type_3_0= ruleJvmTypeReference ) ) ( (lv_name_4_0= ruleValidID ) )
                    {
                    // InternalMetaData.g:5680:6: ( (lv_type_3_0= ruleJvmTypeReference ) )
                    // InternalMetaData.g:5681:7: (lv_type_3_0= ruleJvmTypeReference )
                    {
                    // InternalMetaData.g:5681:7: (lv_type_3_0= ruleJvmTypeReference )
                    // InternalMetaData.g:5682:8: lv_type_3_0= ruleJvmTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getXVariableDeclarationAccess().getTypeJvmTypeReferenceParserRuleCall_2_0_0_0_0());
                      							
                    }
                    pushFollow(FOLLOW_3);
                    lv_type_3_0=ruleJvmTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getXVariableDeclarationRule());
                      								}
                      								set(
                      									current,
                      									"type",
                      									lv_type_3_0,
                      									"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }

                    // InternalMetaData.g:5699:6: ( (lv_name_4_0= ruleValidID ) )
                    // InternalMetaData.g:5700:7: (lv_name_4_0= ruleValidID )
                    {
                    // InternalMetaData.g:5700:7: (lv_name_4_0= ruleValidID )
                    // InternalMetaData.g:5701:8: lv_name_4_0= ruleValidID
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getXVariableDeclarationAccess().getNameValidIDParserRuleCall_2_0_0_1_0());
                      							
                    }
                    pushFollow(FOLLOW_88);
                    lv_name_4_0=ruleValidID();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getXVariableDeclarationRule());
                      								}
                      								set(
                      									current,
                      									"name",
                      									lv_name_4_0,
                      									"org.eclipse.xtext.xbase.Xtype.ValidID");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:5721:4: ( (lv_name_5_0= ruleValidID ) )
                    {
                    // InternalMetaData.g:5721:4: ( (lv_name_5_0= ruleValidID ) )
                    // InternalMetaData.g:5722:5: (lv_name_5_0= ruleValidID )
                    {
                    // InternalMetaData.g:5722:5: (lv_name_5_0= ruleValidID )
                    // InternalMetaData.g:5723:6: lv_name_5_0= ruleValidID
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXVariableDeclarationAccess().getNameValidIDParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_88);
                    lv_name_5_0=ruleValidID();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXVariableDeclarationRule());
                      						}
                      						set(
                      							current,
                      							"name",
                      							lv_name_5_0,
                      							"org.eclipse.xtext.xbase.Xtype.ValidID");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:5741:3: (otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) ) )?
            int alt93=2;
            int LA93_0 = input.LA(1);

            if ( (LA93_0==32) ) {
                alt93=1;
            }
            switch (alt93) {
                case 1 :
                    // InternalMetaData.g:5742:4: otherlv_6= '=' ( (lv_right_7_0= ruleXExpression ) )
                    {
                    otherlv_6=(Token)match(input,32,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_6, grammarAccess.getXVariableDeclarationAccess().getEqualsSignKeyword_3_0());
                      			
                    }
                    // InternalMetaData.g:5746:4: ( (lv_right_7_0= ruleXExpression ) )
                    // InternalMetaData.g:5747:5: (lv_right_7_0= ruleXExpression )
                    {
                    // InternalMetaData.g:5747:5: (lv_right_7_0= ruleXExpression )
                    // InternalMetaData.g:5748:6: lv_right_7_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXVariableDeclarationAccess().getRightXExpressionParserRuleCall_3_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_right_7_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXVariableDeclarationRule());
                      						}
                      						set(
                      							current,
                      							"right",
                      							lv_right_7_0,
                      							"org.eclipse.xtext.xbase.Xbase.XExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXVariableDeclaration"


    // $ANTLR start "entryRuleJvmFormalParameter"
    // InternalMetaData.g:5770:1: entryRuleJvmFormalParameter returns [EObject current=null] : iv_ruleJvmFormalParameter= ruleJvmFormalParameter EOF ;
    public final EObject entryRuleJvmFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmFormalParameter = null;


        try {
            // InternalMetaData.g:5770:59: (iv_ruleJvmFormalParameter= ruleJvmFormalParameter EOF )
            // InternalMetaData.g:5771:2: iv_ruleJvmFormalParameter= ruleJvmFormalParameter EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmFormalParameter=ruleJvmFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmFormalParameter; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmFormalParameter"


    // $ANTLR start "ruleJvmFormalParameter"
    // InternalMetaData.g:5777:1: ruleJvmFormalParameter returns [EObject current=null] : ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) )? ( (lv_name_1_0= ruleValidID ) ) ) ;
    public final EObject ruleJvmFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject lv_parameterType_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5783:2: ( ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) )? ( (lv_name_1_0= ruleValidID ) ) ) )
            // InternalMetaData.g:5784:2: ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) )? ( (lv_name_1_0= ruleValidID ) ) )
            {
            // InternalMetaData.g:5784:2: ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) )? ( (lv_name_1_0= ruleValidID ) ) )
            // InternalMetaData.g:5785:3: ( (lv_parameterType_0_0= ruleJvmTypeReference ) )? ( (lv_name_1_0= ruleValidID ) )
            {
            // InternalMetaData.g:5785:3: ( (lv_parameterType_0_0= ruleJvmTypeReference ) )?
            int alt94=2;
            int LA94_0 = input.LA(1);

            if ( (LA94_0==RULE_ID) ) {
                int LA94_1 = input.LA(2);

                if ( (LA94_1==RULE_ID||LA94_1==56||LA94_1==79||LA94_1==82) ) {
                    alt94=1;
                }
            }
            else if ( (LA94_0==41||LA94_0==68) ) {
                alt94=1;
            }
            switch (alt94) {
                case 1 :
                    // InternalMetaData.g:5786:4: (lv_parameterType_0_0= ruleJvmTypeReference )
                    {
                    // InternalMetaData.g:5786:4: (lv_parameterType_0_0= ruleJvmTypeReference )
                    // InternalMetaData.g:5787:5: lv_parameterType_0_0= ruleJvmTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getJvmFormalParameterAccess().getParameterTypeJvmTypeReferenceParserRuleCall_0_0());
                      				
                    }
                    pushFollow(FOLLOW_3);
                    lv_parameterType_0_0=ruleJvmTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getJvmFormalParameterRule());
                      					}
                      					set(
                      						current,
                      						"parameterType",
                      						lv_parameterType_0_0,
                      						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            // InternalMetaData.g:5804:3: ( (lv_name_1_0= ruleValidID ) )
            // InternalMetaData.g:5805:4: (lv_name_1_0= ruleValidID )
            {
            // InternalMetaData.g:5805:4: (lv_name_1_0= ruleValidID )
            // InternalMetaData.g:5806:5: lv_name_1_0= ruleValidID
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmFormalParameterAccess().getNameValidIDParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_name_1_0=ruleValidID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getJvmFormalParameterRule());
              					}
              					set(
              						current,
              						"name",
              						lv_name_1_0,
              						"org.eclipse.xtext.xbase.Xtype.ValidID");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmFormalParameter"


    // $ANTLR start "entryRuleFullJvmFormalParameter"
    // InternalMetaData.g:5827:1: entryRuleFullJvmFormalParameter returns [EObject current=null] : iv_ruleFullJvmFormalParameter= ruleFullJvmFormalParameter EOF ;
    public final EObject entryRuleFullJvmFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFullJvmFormalParameter = null;


        try {
            // InternalMetaData.g:5827:63: (iv_ruleFullJvmFormalParameter= ruleFullJvmFormalParameter EOF )
            // InternalMetaData.g:5828:2: iv_ruleFullJvmFormalParameter= ruleFullJvmFormalParameter EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFullJvmFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFullJvmFormalParameter=ruleFullJvmFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFullJvmFormalParameter; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleFullJvmFormalParameter"


    // $ANTLR start "ruleFullJvmFormalParameter"
    // InternalMetaData.g:5834:1: ruleFullJvmFormalParameter returns [EObject current=null] : ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) ) ( (lv_name_1_0= ruleValidID ) ) ) ;
    public final EObject ruleFullJvmFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject lv_parameterType_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5840:2: ( ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) ) ( (lv_name_1_0= ruleValidID ) ) ) )
            // InternalMetaData.g:5841:2: ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) ) ( (lv_name_1_0= ruleValidID ) ) )
            {
            // InternalMetaData.g:5841:2: ( ( (lv_parameterType_0_0= ruleJvmTypeReference ) ) ( (lv_name_1_0= ruleValidID ) ) )
            // InternalMetaData.g:5842:3: ( (lv_parameterType_0_0= ruleJvmTypeReference ) ) ( (lv_name_1_0= ruleValidID ) )
            {
            // InternalMetaData.g:5842:3: ( (lv_parameterType_0_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:5843:4: (lv_parameterType_0_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:5843:4: (lv_parameterType_0_0= ruleJvmTypeReference )
            // InternalMetaData.g:5844:5: lv_parameterType_0_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getFullJvmFormalParameterAccess().getParameterTypeJvmTypeReferenceParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_3);
            lv_parameterType_0_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getFullJvmFormalParameterRule());
              					}
              					set(
              						current,
              						"parameterType",
              						lv_parameterType_0_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:5861:3: ( (lv_name_1_0= ruleValidID ) )
            // InternalMetaData.g:5862:4: (lv_name_1_0= ruleValidID )
            {
            // InternalMetaData.g:5862:4: (lv_name_1_0= ruleValidID )
            // InternalMetaData.g:5863:5: lv_name_1_0= ruleValidID
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getFullJvmFormalParameterAccess().getNameValidIDParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_name_1_0=ruleValidID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getFullJvmFormalParameterRule());
              					}
              					set(
              						current,
              						"name",
              						lv_name_1_0,
              						"org.eclipse.xtext.xbase.Xtype.ValidID");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleFullJvmFormalParameter"


    // $ANTLR start "entryRuleXFeatureCall"
    // InternalMetaData.g:5884:1: entryRuleXFeatureCall returns [EObject current=null] : iv_ruleXFeatureCall= ruleXFeatureCall EOF ;
    public final EObject entryRuleXFeatureCall() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXFeatureCall = null;


        try {
            // InternalMetaData.g:5884:53: (iv_ruleXFeatureCall= ruleXFeatureCall EOF )
            // InternalMetaData.g:5885:2: iv_ruleXFeatureCall= ruleXFeatureCall EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXFeatureCallRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXFeatureCall=ruleXFeatureCall();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXFeatureCall; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXFeatureCall"


    // $ANTLR start "ruleXFeatureCall"
    // InternalMetaData.g:5891:1: ruleXFeatureCall returns [EObject current=null] : ( () (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )? ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )? ) ;
    public final EObject ruleXFeatureCall() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token lv_explicitOperationCall_7_0=null;
        Token otherlv_10=null;
        Token otherlv_12=null;
        EObject lv_typeArguments_2_0 = null;

        EObject lv_typeArguments_4_0 = null;

        EObject lv_featureCallArguments_8_0 = null;

        EObject lv_featureCallArguments_9_0 = null;

        EObject lv_featureCallArguments_11_0 = null;

        EObject lv_featureCallArguments_13_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:5897:2: ( ( () (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )? ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )? ) )
            // InternalMetaData.g:5898:2: ( () (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )? ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )? )
            {
            // InternalMetaData.g:5898:2: ( () (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )? ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )? )
            // InternalMetaData.g:5899:3: () (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )? ( ( ruleIdOrSuper ) ) ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )? ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )?
            {
            // InternalMetaData.g:5899:3: ()
            // InternalMetaData.g:5900:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXFeatureCallAccess().getXFeatureCallAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:5906:3: (otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' )?
            int alt96=2;
            int LA96_0 = input.LA(1);

            if ( (LA96_0==56) ) {
                alt96=1;
            }
            switch (alt96) {
                case 1 :
                    // InternalMetaData.g:5907:4: otherlv_1= '<' ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>'
                    {
                    otherlv_1=(Token)match(input,56,FOLLOW_55); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getXFeatureCallAccess().getLessThanSignKeyword_1_0());
                      			
                    }
                    // InternalMetaData.g:5911:4: ( (lv_typeArguments_2_0= ruleJvmArgumentTypeReference ) )
                    // InternalMetaData.g:5912:5: (lv_typeArguments_2_0= ruleJvmArgumentTypeReference )
                    {
                    // InternalMetaData.g:5912:5: (lv_typeArguments_2_0= ruleJvmArgumentTypeReference )
                    // InternalMetaData.g:5913:6: lv_typeArguments_2_0= ruleJvmArgumentTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXFeatureCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_56);
                    lv_typeArguments_2_0=ruleJvmArgumentTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                      						}
                      						add(
                      							current,
                      							"typeArguments",
                      							lv_typeArguments_2_0,
                      							"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:5930:4: (otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) )*
                    loop95:
                    do {
                        int alt95=2;
                        int LA95_0 = input.LA(1);

                        if ( (LA95_0==36) ) {
                            alt95=1;
                        }


                        switch (alt95) {
                    	case 1 :
                    	    // InternalMetaData.g:5931:5: otherlv_3= ',' ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) )
                    	    {
                    	    otherlv_3=(Token)match(input,36,FOLLOW_55); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_3, grammarAccess.getXFeatureCallAccess().getCommaKeyword_1_2_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:5935:5: ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) )
                    	    // InternalMetaData.g:5936:6: (lv_typeArguments_4_0= ruleJvmArgumentTypeReference )
                    	    {
                    	    // InternalMetaData.g:5936:6: (lv_typeArguments_4_0= ruleJvmArgumentTypeReference )
                    	    // InternalMetaData.g:5937:7: lv_typeArguments_4_0= ruleJvmArgumentTypeReference
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXFeatureCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_1_2_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_56);
                    	    lv_typeArguments_4_0=ruleJvmArgumentTypeReference();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"typeArguments",
                    	      								lv_typeArguments_4_0,
                    	      								"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop95;
                        }
                    } while (true);

                    otherlv_5=(Token)match(input,57,FOLLOW_54); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_5, grammarAccess.getXFeatureCallAccess().getGreaterThanSignKeyword_1_3());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:5960:3: ( ( ruleIdOrSuper ) )
            // InternalMetaData.g:5961:4: ( ruleIdOrSuper )
            {
            // InternalMetaData.g:5961:4: ( ruleIdOrSuper )
            // InternalMetaData.g:5962:5: ruleIdOrSuper
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getXFeatureCallRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXFeatureCallAccess().getFeatureJvmIdentifiableElementCrossReference_2_0());
              				
            }
            pushFollow(FOLLOW_89);
            ruleIdOrSuper();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:5976:3: ( ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')' )?
            int alt99=2;
            alt99 = dfa99.predict(input);
            switch (alt99) {
                case 1 :
                    // InternalMetaData.g:5977:4: ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )? otherlv_12= ')'
                    {
                    // InternalMetaData.g:5977:4: ( ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' ) )
                    // InternalMetaData.g:5978:5: ( ( '(' ) )=> (lv_explicitOperationCall_7_0= '(' )
                    {
                    // InternalMetaData.g:5982:5: (lv_explicitOperationCall_7_0= '(' )
                    // InternalMetaData.g:5983:6: lv_explicitOperationCall_7_0= '('
                    {
                    lv_explicitOperationCall_7_0=(Token)match(input,41,FOLLOW_58); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_explicitOperationCall_7_0, grammarAccess.getXFeatureCallAccess().getExplicitOperationCallLeftParenthesisKeyword_3_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXFeatureCallRule());
                      						}
                      						setWithLastConsumed(current, "explicitOperationCall", true, "(");
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:5995:4: ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) ) | ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* ) )?
                    int alt98=3;
                    alt98 = dfa98.predict(input);
                    switch (alt98) {
                        case 1 :
                            // InternalMetaData.g:5996:5: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) )
                            {
                            // InternalMetaData.g:5996:5: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure ) )
                            // InternalMetaData.g:5997:6: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_featureCallArguments_8_0= ruleXShortClosure )
                            {
                            // InternalMetaData.g:6022:6: (lv_featureCallArguments_8_0= ruleXShortClosure )
                            // InternalMetaData.g:6023:7: lv_featureCallArguments_8_0= ruleXShortClosure
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getXFeatureCallAccess().getFeatureCallArgumentsXShortClosureParserRuleCall_3_1_0_0());
                              						
                            }
                            pushFollow(FOLLOW_26);
                            lv_featureCallArguments_8_0=ruleXShortClosure();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                              							}
                              							add(
                              								current,
                              								"featureCallArguments",
                              								lv_featureCallArguments_8_0,
                              								"org.eclipse.xtext.xbase.Xbase.XShortClosure");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:6041:5: ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* )
                            {
                            // InternalMetaData.g:6041:5: ( ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )* )
                            // InternalMetaData.g:6042:6: ( (lv_featureCallArguments_9_0= ruleXExpression ) ) (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )*
                            {
                            // InternalMetaData.g:6042:6: ( (lv_featureCallArguments_9_0= ruleXExpression ) )
                            // InternalMetaData.g:6043:7: (lv_featureCallArguments_9_0= ruleXExpression )
                            {
                            // InternalMetaData.g:6043:7: (lv_featureCallArguments_9_0= ruleXExpression )
                            // InternalMetaData.g:6044:8: lv_featureCallArguments_9_0= ruleXExpression
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getXFeatureCallAccess().getFeatureCallArgumentsXExpressionParserRuleCall_3_1_1_0_0());
                              							
                            }
                            pushFollow(FOLLOW_59);
                            lv_featureCallArguments_9_0=ruleXExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                              								}
                              								add(
                              									current,
                              									"featureCallArguments",
                              									lv_featureCallArguments_9_0,
                              									"org.eclipse.xtext.xbase.Xbase.XExpression");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }

                            // InternalMetaData.g:6061:6: (otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) ) )*
                            loop97:
                            do {
                                int alt97=2;
                                int LA97_0 = input.LA(1);

                                if ( (LA97_0==36) ) {
                                    alt97=1;
                                }


                                switch (alt97) {
                            	case 1 :
                            	    // InternalMetaData.g:6062:7: otherlv_10= ',' ( (lv_featureCallArguments_11_0= ruleXExpression ) )
                            	    {
                            	    otherlv_10=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      							newLeafNode(otherlv_10, grammarAccess.getXFeatureCallAccess().getCommaKeyword_3_1_1_1_0());
                            	      						
                            	    }
                            	    // InternalMetaData.g:6066:7: ( (lv_featureCallArguments_11_0= ruleXExpression ) )
                            	    // InternalMetaData.g:6067:8: (lv_featureCallArguments_11_0= ruleXExpression )
                            	    {
                            	    // InternalMetaData.g:6067:8: (lv_featureCallArguments_11_0= ruleXExpression )
                            	    // InternalMetaData.g:6068:9: lv_featureCallArguments_11_0= ruleXExpression
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getXFeatureCallAccess().getFeatureCallArgumentsXExpressionParserRuleCall_3_1_1_1_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_59);
                            	    lv_featureCallArguments_11_0=ruleXExpression();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"featureCallArguments",
                            	      										lv_featureCallArguments_11_0,
                            	      										"org.eclipse.xtext.xbase.Xbase.XExpression");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop97;
                                }
                            } while (true);


                            }


                            }
                            break;

                    }

                    otherlv_12=(Token)match(input,43,FOLLOW_90); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_12, grammarAccess.getXFeatureCallAccess().getRightParenthesisKeyword_3_2());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:6093:3: ( ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure ) )?
            int alt100=2;
            alt100 = dfa100.predict(input);
            switch (alt100) {
                case 1 :
                    // InternalMetaData.g:6094:4: ( ( () '[' ) )=> (lv_featureCallArguments_13_0= ruleXClosure )
                    {
                    // InternalMetaData.g:6100:4: (lv_featureCallArguments_13_0= ruleXClosure )
                    // InternalMetaData.g:6101:5: lv_featureCallArguments_13_0= ruleXClosure
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getXFeatureCallAccess().getFeatureCallArgumentsXClosureParserRuleCall_4_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_featureCallArguments_13_0=ruleXClosure();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getXFeatureCallRule());
                      					}
                      					add(
                      						current,
                      						"featureCallArguments",
                      						lv_featureCallArguments_13_0,
                      						"org.eclipse.xtext.xbase.Xbase.XClosure");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXFeatureCall"


    // $ANTLR start "entryRuleFeatureCallID"
    // InternalMetaData.g:6122:1: entryRuleFeatureCallID returns [String current=null] : iv_ruleFeatureCallID= ruleFeatureCallID EOF ;
    public final String entryRuleFeatureCallID() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleFeatureCallID = null;


        try {
            // InternalMetaData.g:6122:53: (iv_ruleFeatureCallID= ruleFeatureCallID EOF )
            // InternalMetaData.g:6123:2: iv_ruleFeatureCallID= ruleFeatureCallID EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFeatureCallIDRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFeatureCallID=ruleFeatureCallID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFeatureCallID.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleFeatureCallID"


    // $ANTLR start "ruleFeatureCallID"
    // InternalMetaData.g:6129:1: ruleFeatureCallID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_ValidID_0= ruleValidID | kw= 'extends' | kw= 'static' | kw= 'import' | kw= 'extension' ) ;
    public final AntlrDatatypeRuleToken ruleFeatureCallID() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_ValidID_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6135:2: ( (this_ValidID_0= ruleValidID | kw= 'extends' | kw= 'static' | kw= 'import' | kw= 'extension' ) )
            // InternalMetaData.g:6136:2: (this_ValidID_0= ruleValidID | kw= 'extends' | kw= 'static' | kw= 'import' | kw= 'extension' )
            {
            // InternalMetaData.g:6136:2: (this_ValidID_0= ruleValidID | kw= 'extends' | kw= 'static' | kw= 'import' | kw= 'extension' )
            int alt101=5;
            switch ( input.LA(1) ) {
            case RULE_ID:
                {
                alt101=1;
                }
                break;
            case 95:
                {
                alt101=2;
                }
                break;
            case 96:
                {
                alt101=3;
                }
                break;
            case 97:
                {
                alt101=4;
                }
                break;
            case 98:
                {
                alt101=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 101, 0, input);

                throw nvae;
            }

            switch (alt101) {
                case 1 :
                    // InternalMetaData.g:6137:3: this_ValidID_0= ruleValidID
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getFeatureCallIDAccess().getValidIDParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ValidID_0=ruleValidID();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(this_ValidID_0);
                      		
                    }
                    if ( state.backtracking==0 ) {

                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:6148:3: kw= 'extends'
                    {
                    kw=(Token)match(input,95,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getFeatureCallIDAccess().getExtendsKeyword_1());
                      		
                    }

                    }
                    break;
                case 3 :
                    // InternalMetaData.g:6154:3: kw= 'static'
                    {
                    kw=(Token)match(input,96,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getFeatureCallIDAccess().getStaticKeyword_2());
                      		
                    }

                    }
                    break;
                case 4 :
                    // InternalMetaData.g:6160:3: kw= 'import'
                    {
                    kw=(Token)match(input,97,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getFeatureCallIDAccess().getImportKeyword_3());
                      		
                    }

                    }
                    break;
                case 5 :
                    // InternalMetaData.g:6166:3: kw= 'extension'
                    {
                    kw=(Token)match(input,98,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getFeatureCallIDAccess().getExtensionKeyword_4());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleFeatureCallID"


    // $ANTLR start "entryRuleIdOrSuper"
    // InternalMetaData.g:6175:1: entryRuleIdOrSuper returns [String current=null] : iv_ruleIdOrSuper= ruleIdOrSuper EOF ;
    public final String entryRuleIdOrSuper() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleIdOrSuper = null;


        try {
            // InternalMetaData.g:6175:49: (iv_ruleIdOrSuper= ruleIdOrSuper EOF )
            // InternalMetaData.g:6176:2: iv_ruleIdOrSuper= ruleIdOrSuper EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIdOrSuperRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleIdOrSuper=ruleIdOrSuper();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleIdOrSuper.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleIdOrSuper"


    // $ANTLR start "ruleIdOrSuper"
    // InternalMetaData.g:6182:1: ruleIdOrSuper returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_FeatureCallID_0= ruleFeatureCallID | kw= 'super' ) ;
    public final AntlrDatatypeRuleToken ruleIdOrSuper() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_FeatureCallID_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6188:2: ( (this_FeatureCallID_0= ruleFeatureCallID | kw= 'super' ) )
            // InternalMetaData.g:6189:2: (this_FeatureCallID_0= ruleFeatureCallID | kw= 'super' )
            {
            // InternalMetaData.g:6189:2: (this_FeatureCallID_0= ruleFeatureCallID | kw= 'super' )
            int alt102=2;
            int LA102_0 = input.LA(1);

            if ( (LA102_0==RULE_ID||(LA102_0>=95 && LA102_0<=98)) ) {
                alt102=1;
            }
            else if ( (LA102_0==99) ) {
                alt102=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 102, 0, input);

                throw nvae;
            }
            switch (alt102) {
                case 1 :
                    // InternalMetaData.g:6190:3: this_FeatureCallID_0= ruleFeatureCallID
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIdOrSuperAccess().getFeatureCallIDParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_FeatureCallID_0=ruleFeatureCallID();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(this_FeatureCallID_0);
                      		
                    }
                    if ( state.backtracking==0 ) {

                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:6201:3: kw= 'super'
                    {
                    kw=(Token)match(input,99,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(kw);
                      			newLeafNode(kw, grammarAccess.getIdOrSuperAccess().getSuperKeyword_1());
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleIdOrSuper"


    // $ANTLR start "entryRuleXConstructorCall"
    // InternalMetaData.g:6210:1: entryRuleXConstructorCall returns [EObject current=null] : iv_ruleXConstructorCall= ruleXConstructorCall EOF ;
    public final EObject entryRuleXConstructorCall() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXConstructorCall = null;


        try {
            // InternalMetaData.g:6210:57: (iv_ruleXConstructorCall= ruleXConstructorCall EOF )
            // InternalMetaData.g:6211:2: iv_ruleXConstructorCall= ruleXConstructorCall EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXConstructorCallRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXConstructorCall=ruleXConstructorCall();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXConstructorCall; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXConstructorCall"


    // $ANTLR start "ruleXConstructorCall"
    // InternalMetaData.g:6217:1: ruleXConstructorCall returns [EObject current=null] : ( () otherlv_1= 'new' ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )? ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )? ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )? ) ;
    public final EObject ruleXConstructorCall() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token lv_explicitConstructorCall_8_0=null;
        Token otherlv_11=null;
        Token otherlv_13=null;
        EObject lv_typeArguments_4_0 = null;

        EObject lv_typeArguments_6_0 = null;

        EObject lv_arguments_9_0 = null;

        EObject lv_arguments_10_0 = null;

        EObject lv_arguments_12_0 = null;

        EObject lv_arguments_14_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6223:2: ( ( () otherlv_1= 'new' ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )? ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )? ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )? ) )
            // InternalMetaData.g:6224:2: ( () otherlv_1= 'new' ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )? ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )? ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )? )
            {
            // InternalMetaData.g:6224:2: ( () otherlv_1= 'new' ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )? ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )? ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )? )
            // InternalMetaData.g:6225:3: () otherlv_1= 'new' ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )? ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )? ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )?
            {
            // InternalMetaData.g:6225:3: ()
            // InternalMetaData.g:6226:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXConstructorCallAccess().getXConstructorCallAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,100,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXConstructorCallAccess().getNewKeyword_1());
              		
            }
            // InternalMetaData.g:6236:3: ( ( ruleQualifiedName ) )
            // InternalMetaData.g:6237:4: ( ruleQualifiedName )
            {
            // InternalMetaData.g:6237:4: ( ruleQualifiedName )
            // InternalMetaData.g:6238:5: ruleQualifiedName
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getXConstructorCallRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXConstructorCallAccess().getConstructorJvmConstructorCrossReference_2_0());
              				
            }
            pushFollow(FOLLOW_91);
            ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:6252:3: ( ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>' )?
            int alt104=2;
            alt104 = dfa104.predict(input);
            switch (alt104) {
                case 1 :
                    // InternalMetaData.g:6253:4: ( ( '<' )=>otherlv_3= '<' ) ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) ) (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )* otherlv_7= '>'
                    {
                    // InternalMetaData.g:6253:4: ( ( '<' )=>otherlv_3= '<' )
                    // InternalMetaData.g:6254:5: ( '<' )=>otherlv_3= '<'
                    {
                    otherlv_3=(Token)match(input,56,FOLLOW_55); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_3, grammarAccess.getXConstructorCallAccess().getLessThanSignKeyword_3_0());
                      				
                    }

                    }

                    // InternalMetaData.g:6260:4: ( (lv_typeArguments_4_0= ruleJvmArgumentTypeReference ) )
                    // InternalMetaData.g:6261:5: (lv_typeArguments_4_0= ruleJvmArgumentTypeReference )
                    {
                    // InternalMetaData.g:6261:5: (lv_typeArguments_4_0= ruleJvmArgumentTypeReference )
                    // InternalMetaData.g:6262:6: lv_typeArguments_4_0= ruleJvmArgumentTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXConstructorCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_3_1_0());
                      					
                    }
                    pushFollow(FOLLOW_56);
                    lv_typeArguments_4_0=ruleJvmArgumentTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                      						}
                      						add(
                      							current,
                      							"typeArguments",
                      							lv_typeArguments_4_0,
                      							"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:6279:4: (otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) ) )*
                    loop103:
                    do {
                        int alt103=2;
                        int LA103_0 = input.LA(1);

                        if ( (LA103_0==36) ) {
                            alt103=1;
                        }


                        switch (alt103) {
                    	case 1 :
                    	    // InternalMetaData.g:6280:5: otherlv_5= ',' ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) )
                    	    {
                    	    otherlv_5=(Token)match(input,36,FOLLOW_55); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_5, grammarAccess.getXConstructorCallAccess().getCommaKeyword_3_2_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:6284:5: ( (lv_typeArguments_6_0= ruleJvmArgumentTypeReference ) )
                    	    // InternalMetaData.g:6285:6: (lv_typeArguments_6_0= ruleJvmArgumentTypeReference )
                    	    {
                    	    // InternalMetaData.g:6285:6: (lv_typeArguments_6_0= ruleJvmArgumentTypeReference )
                    	    // InternalMetaData.g:6286:7: lv_typeArguments_6_0= ruleJvmArgumentTypeReference
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXConstructorCallAccess().getTypeArgumentsJvmArgumentTypeReferenceParserRuleCall_3_2_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_56);
                    	    lv_typeArguments_6_0=ruleJvmArgumentTypeReference();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"typeArguments",
                    	      								lv_typeArguments_6_0,
                    	      								"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop103;
                        }
                    } while (true);

                    otherlv_7=(Token)match(input,57,FOLLOW_89); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_7, grammarAccess.getXConstructorCallAccess().getGreaterThanSignKeyword_3_3());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:6309:3: ( ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')' )?
            int alt107=2;
            alt107 = dfa107.predict(input);
            switch (alt107) {
                case 1 :
                    // InternalMetaData.g:6310:4: ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) ) ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )? otherlv_13= ')'
                    {
                    // InternalMetaData.g:6310:4: ( ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' ) )
                    // InternalMetaData.g:6311:5: ( ( '(' ) )=> (lv_explicitConstructorCall_8_0= '(' )
                    {
                    // InternalMetaData.g:6315:5: (lv_explicitConstructorCall_8_0= '(' )
                    // InternalMetaData.g:6316:6: lv_explicitConstructorCall_8_0= '('
                    {
                    lv_explicitConstructorCall_8_0=(Token)match(input,41,FOLLOW_58); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_explicitConstructorCall_8_0, grammarAccess.getXConstructorCallAccess().getExplicitConstructorCallLeftParenthesisKeyword_4_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXConstructorCallRule());
                      						}
                      						setWithLastConsumed(current, "explicitConstructorCall", true, "(");
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:6328:4: ( ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) ) | ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* ) )?
                    int alt106=3;
                    alt106 = dfa106.predict(input);
                    switch (alt106) {
                        case 1 :
                            // InternalMetaData.g:6329:5: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) )
                            {
                            // InternalMetaData.g:6329:5: ( ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure ) )
                            // InternalMetaData.g:6330:6: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )=> (lv_arguments_9_0= ruleXShortClosure )
                            {
                            // InternalMetaData.g:6355:6: (lv_arguments_9_0= ruleXShortClosure )
                            // InternalMetaData.g:6356:7: lv_arguments_9_0= ruleXShortClosure
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getXConstructorCallAccess().getArgumentsXShortClosureParserRuleCall_4_1_0_0());
                              						
                            }
                            pushFollow(FOLLOW_26);
                            lv_arguments_9_0=ruleXShortClosure();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                              							}
                              							add(
                              								current,
                              								"arguments",
                              								lv_arguments_9_0,
                              								"org.eclipse.xtext.xbase.Xbase.XShortClosure");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:6374:5: ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* )
                            {
                            // InternalMetaData.g:6374:5: ( ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )* )
                            // InternalMetaData.g:6375:6: ( (lv_arguments_10_0= ruleXExpression ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )*
                            {
                            // InternalMetaData.g:6375:6: ( (lv_arguments_10_0= ruleXExpression ) )
                            // InternalMetaData.g:6376:7: (lv_arguments_10_0= ruleXExpression )
                            {
                            // InternalMetaData.g:6376:7: (lv_arguments_10_0= ruleXExpression )
                            // InternalMetaData.g:6377:8: lv_arguments_10_0= ruleXExpression
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getXConstructorCallAccess().getArgumentsXExpressionParserRuleCall_4_1_1_0_0());
                              							
                            }
                            pushFollow(FOLLOW_59);
                            lv_arguments_10_0=ruleXExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                              								}
                              								add(
                              									current,
                              									"arguments",
                              									lv_arguments_10_0,
                              									"org.eclipse.xtext.xbase.Xbase.XExpression");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }

                            // InternalMetaData.g:6394:6: (otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) ) )*
                            loop105:
                            do {
                                int alt105=2;
                                int LA105_0 = input.LA(1);

                                if ( (LA105_0==36) ) {
                                    alt105=1;
                                }


                                switch (alt105) {
                            	case 1 :
                            	    // InternalMetaData.g:6395:7: otherlv_11= ',' ( (lv_arguments_12_0= ruleXExpression ) )
                            	    {
                            	    otherlv_11=(Token)match(input,36,FOLLOW_18); if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      							newLeafNode(otherlv_11, grammarAccess.getXConstructorCallAccess().getCommaKeyword_4_1_1_1_0());
                            	      						
                            	    }
                            	    // InternalMetaData.g:6399:7: ( (lv_arguments_12_0= ruleXExpression ) )
                            	    // InternalMetaData.g:6400:8: (lv_arguments_12_0= ruleXExpression )
                            	    {
                            	    // InternalMetaData.g:6400:8: (lv_arguments_12_0= ruleXExpression )
                            	    // InternalMetaData.g:6401:9: lv_arguments_12_0= ruleXExpression
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getXConstructorCallAccess().getArgumentsXExpressionParserRuleCall_4_1_1_1_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_59);
                            	    lv_arguments_12_0=ruleXExpression();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"arguments",
                            	      										lv_arguments_12_0,
                            	      										"org.eclipse.xtext.xbase.Xbase.XExpression");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop105;
                                }
                            } while (true);


                            }


                            }
                            break;

                    }

                    otherlv_13=(Token)match(input,43,FOLLOW_90); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_13, grammarAccess.getXConstructorCallAccess().getRightParenthesisKeyword_4_2());
                      			
                    }

                    }
                    break;

            }

            // InternalMetaData.g:6426:3: ( ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure ) )?
            int alt108=2;
            alt108 = dfa108.predict(input);
            switch (alt108) {
                case 1 :
                    // InternalMetaData.g:6427:4: ( ( () '[' ) )=> (lv_arguments_14_0= ruleXClosure )
                    {
                    // InternalMetaData.g:6433:4: (lv_arguments_14_0= ruleXClosure )
                    // InternalMetaData.g:6434:5: lv_arguments_14_0= ruleXClosure
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getXConstructorCallAccess().getArgumentsXClosureParserRuleCall_5_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_arguments_14_0=ruleXClosure();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getXConstructorCallRule());
                      					}
                      					add(
                      						current,
                      						"arguments",
                      						lv_arguments_14_0,
                      						"org.eclipse.xtext.xbase.Xbase.XClosure");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXConstructorCall"


    // $ANTLR start "entryRuleXBooleanLiteral"
    // InternalMetaData.g:6455:1: entryRuleXBooleanLiteral returns [EObject current=null] : iv_ruleXBooleanLiteral= ruleXBooleanLiteral EOF ;
    public final EObject entryRuleXBooleanLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXBooleanLiteral = null;


        try {
            // InternalMetaData.g:6455:56: (iv_ruleXBooleanLiteral= ruleXBooleanLiteral EOF )
            // InternalMetaData.g:6456:2: iv_ruleXBooleanLiteral= ruleXBooleanLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXBooleanLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXBooleanLiteral=ruleXBooleanLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXBooleanLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXBooleanLiteral"


    // $ANTLR start "ruleXBooleanLiteral"
    // InternalMetaData.g:6462:1: ruleXBooleanLiteral returns [EObject current=null] : ( () (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) ) ) ;
    public final EObject ruleXBooleanLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token lv_isTrue_2_0=null;


        	enterRule();

        try {
            // InternalMetaData.g:6468:2: ( ( () (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) ) ) )
            // InternalMetaData.g:6469:2: ( () (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) ) )
            {
            // InternalMetaData.g:6469:2: ( () (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) ) )
            // InternalMetaData.g:6470:3: () (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) )
            {
            // InternalMetaData.g:6470:3: ()
            // InternalMetaData.g:6471:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXBooleanLiteralAccess().getXBooleanLiteralAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:6477:3: (otherlv_1= 'false' | ( (lv_isTrue_2_0= 'true' ) ) )
            int alt109=2;
            int LA109_0 = input.LA(1);

            if ( (LA109_0==101) ) {
                alt109=1;
            }
            else if ( (LA109_0==102) ) {
                alt109=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 109, 0, input);

                throw nvae;
            }
            switch (alt109) {
                case 1 :
                    // InternalMetaData.g:6478:4: otherlv_1= 'false'
                    {
                    otherlv_1=(Token)match(input,101,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getXBooleanLiteralAccess().getFalseKeyword_1_0());
                      			
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:6483:4: ( (lv_isTrue_2_0= 'true' ) )
                    {
                    // InternalMetaData.g:6483:4: ( (lv_isTrue_2_0= 'true' ) )
                    // InternalMetaData.g:6484:5: (lv_isTrue_2_0= 'true' )
                    {
                    // InternalMetaData.g:6484:5: (lv_isTrue_2_0= 'true' )
                    // InternalMetaData.g:6485:6: lv_isTrue_2_0= 'true'
                    {
                    lv_isTrue_2_0=(Token)match(input,102,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_isTrue_2_0, grammarAccess.getXBooleanLiteralAccess().getIsTrueTrueKeyword_1_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXBooleanLiteralRule());
                      						}
                      						setWithLastConsumed(current, "isTrue", true, "true");
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXBooleanLiteral"


    // $ANTLR start "entryRuleXNullLiteral"
    // InternalMetaData.g:6502:1: entryRuleXNullLiteral returns [EObject current=null] : iv_ruleXNullLiteral= ruleXNullLiteral EOF ;
    public final EObject entryRuleXNullLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXNullLiteral = null;


        try {
            // InternalMetaData.g:6502:53: (iv_ruleXNullLiteral= ruleXNullLiteral EOF )
            // InternalMetaData.g:6503:2: iv_ruleXNullLiteral= ruleXNullLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXNullLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXNullLiteral=ruleXNullLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXNullLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXNullLiteral"


    // $ANTLR start "ruleXNullLiteral"
    // InternalMetaData.g:6509:1: ruleXNullLiteral returns [EObject current=null] : ( () otherlv_1= 'null' ) ;
    public final EObject ruleXNullLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            // InternalMetaData.g:6515:2: ( ( () otherlv_1= 'null' ) )
            // InternalMetaData.g:6516:2: ( () otherlv_1= 'null' )
            {
            // InternalMetaData.g:6516:2: ( () otherlv_1= 'null' )
            // InternalMetaData.g:6517:3: () otherlv_1= 'null'
            {
            // InternalMetaData.g:6517:3: ()
            // InternalMetaData.g:6518:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXNullLiteralAccess().getXNullLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,103,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXNullLiteralAccess().getNullKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXNullLiteral"


    // $ANTLR start "entryRuleXNumberLiteral"
    // InternalMetaData.g:6532:1: entryRuleXNumberLiteral returns [EObject current=null] : iv_ruleXNumberLiteral= ruleXNumberLiteral EOF ;
    public final EObject entryRuleXNumberLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXNumberLiteral = null;


        try {
            // InternalMetaData.g:6532:55: (iv_ruleXNumberLiteral= ruleXNumberLiteral EOF )
            // InternalMetaData.g:6533:2: iv_ruleXNumberLiteral= ruleXNumberLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXNumberLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXNumberLiteral=ruleXNumberLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXNumberLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXNumberLiteral"


    // $ANTLR start "ruleXNumberLiteral"
    // InternalMetaData.g:6539:1: ruleXNumberLiteral returns [EObject current=null] : ( () ( (lv_value_1_0= ruleNumber ) ) ) ;
    public final EObject ruleXNumberLiteral() throws RecognitionException {
        EObject current = null;

        AntlrDatatypeRuleToken lv_value_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6545:2: ( ( () ( (lv_value_1_0= ruleNumber ) ) ) )
            // InternalMetaData.g:6546:2: ( () ( (lv_value_1_0= ruleNumber ) ) )
            {
            // InternalMetaData.g:6546:2: ( () ( (lv_value_1_0= ruleNumber ) ) )
            // InternalMetaData.g:6547:3: () ( (lv_value_1_0= ruleNumber ) )
            {
            // InternalMetaData.g:6547:3: ()
            // InternalMetaData.g:6548:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXNumberLiteralAccess().getXNumberLiteralAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:6554:3: ( (lv_value_1_0= ruleNumber ) )
            // InternalMetaData.g:6555:4: (lv_value_1_0= ruleNumber )
            {
            // InternalMetaData.g:6555:4: (lv_value_1_0= ruleNumber )
            // InternalMetaData.g:6556:5: lv_value_1_0= ruleNumber
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXNumberLiteralAccess().getValueNumberParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_value_1_0=ruleNumber();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXNumberLiteralRule());
              					}
              					set(
              						current,
              						"value",
              						lv_value_1_0,
              						"org.eclipse.xtext.xbase.Xbase.Number");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXNumberLiteral"


    // $ANTLR start "entryRuleXStringLiteral"
    // InternalMetaData.g:6577:1: entryRuleXStringLiteral returns [EObject current=null] : iv_ruleXStringLiteral= ruleXStringLiteral EOF ;
    public final EObject entryRuleXStringLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXStringLiteral = null;


        try {
            // InternalMetaData.g:6577:55: (iv_ruleXStringLiteral= ruleXStringLiteral EOF )
            // InternalMetaData.g:6578:2: iv_ruleXStringLiteral= ruleXStringLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXStringLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXStringLiteral=ruleXStringLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXStringLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXStringLiteral"


    // $ANTLR start "ruleXStringLiteral"
    // InternalMetaData.g:6584:1: ruleXStringLiteral returns [EObject current=null] : ( () ( (lv_value_1_0= RULE_STRING ) ) ) ;
    public final EObject ruleXStringLiteral() throws RecognitionException {
        EObject current = null;

        Token lv_value_1_0=null;


        	enterRule();

        try {
            // InternalMetaData.g:6590:2: ( ( () ( (lv_value_1_0= RULE_STRING ) ) ) )
            // InternalMetaData.g:6591:2: ( () ( (lv_value_1_0= RULE_STRING ) ) )
            {
            // InternalMetaData.g:6591:2: ( () ( (lv_value_1_0= RULE_STRING ) ) )
            // InternalMetaData.g:6592:3: () ( (lv_value_1_0= RULE_STRING ) )
            {
            // InternalMetaData.g:6592:3: ()
            // InternalMetaData.g:6593:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXStringLiteralAccess().getXStringLiteralAction_0(),
              					current);
              			
            }

            }

            // InternalMetaData.g:6599:3: ( (lv_value_1_0= RULE_STRING ) )
            // InternalMetaData.g:6600:4: (lv_value_1_0= RULE_STRING )
            {
            // InternalMetaData.g:6600:4: (lv_value_1_0= RULE_STRING )
            // InternalMetaData.g:6601:5: lv_value_1_0= RULE_STRING
            {
            lv_value_1_0=(Token)match(input,RULE_STRING,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(lv_value_1_0, grammarAccess.getXStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0());
              				
            }
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getXStringLiteralRule());
              					}
              					setWithLastConsumed(
              						current,
              						"value",
              						lv_value_1_0,
              						"org.eclipse.xtext.xbase.Xtype.STRING");
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXStringLiteral"


    // $ANTLR start "entryRuleXTypeLiteral"
    // InternalMetaData.g:6621:1: entryRuleXTypeLiteral returns [EObject current=null] : iv_ruleXTypeLiteral= ruleXTypeLiteral EOF ;
    public final EObject entryRuleXTypeLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXTypeLiteral = null;


        try {
            // InternalMetaData.g:6621:53: (iv_ruleXTypeLiteral= ruleXTypeLiteral EOF )
            // InternalMetaData.g:6622:2: iv_ruleXTypeLiteral= ruleXTypeLiteral EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXTypeLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXTypeLiteral=ruleXTypeLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXTypeLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXTypeLiteral"


    // $ANTLR start "ruleXTypeLiteral"
    // InternalMetaData.g:6628:1: ruleXTypeLiteral returns [EObject current=null] : ( () otherlv_1= 'typeof' otherlv_2= '(' ( ( ruleQualifiedName ) ) ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )* otherlv_5= ')' ) ;
    public final EObject ruleXTypeLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_5=null;
        AntlrDatatypeRuleToken lv_arrayDimensions_4_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6634:2: ( ( () otherlv_1= 'typeof' otherlv_2= '(' ( ( ruleQualifiedName ) ) ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )* otherlv_5= ')' ) )
            // InternalMetaData.g:6635:2: ( () otherlv_1= 'typeof' otherlv_2= '(' ( ( ruleQualifiedName ) ) ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )* otherlv_5= ')' )
            {
            // InternalMetaData.g:6635:2: ( () otherlv_1= 'typeof' otherlv_2= '(' ( ( ruleQualifiedName ) ) ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )* otherlv_5= ')' )
            // InternalMetaData.g:6636:3: () otherlv_1= 'typeof' otherlv_2= '(' ( ( ruleQualifiedName ) ) ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )* otherlv_5= ')'
            {
            // InternalMetaData.g:6636:3: ()
            // InternalMetaData.g:6637:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXTypeLiteralAccess().getXTypeLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,104,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXTypeLiteralAccess().getTypeofKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,41,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getXTypeLiteralAccess().getLeftParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:6651:3: ( ( ruleQualifiedName ) )
            // InternalMetaData.g:6652:4: ( ruleQualifiedName )
            {
            // InternalMetaData.g:6652:4: ( ruleQualifiedName )
            // InternalMetaData.g:6653:5: ruleQualifiedName
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getXTypeLiteralRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXTypeLiteralAccess().getTypeJvmTypeCrossReference_3_0());
              				
            }
            pushFollow(FOLLOW_92);
            ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:6667:3: ( (lv_arrayDimensions_4_0= ruleArrayBrackets ) )*
            loop110:
            do {
                int alt110=2;
                int LA110_0 = input.LA(1);

                if ( (LA110_0==82) ) {
                    alt110=1;
                }


                switch (alt110) {
            	case 1 :
            	    // InternalMetaData.g:6668:4: (lv_arrayDimensions_4_0= ruleArrayBrackets )
            	    {
            	    // InternalMetaData.g:6668:4: (lv_arrayDimensions_4_0= ruleArrayBrackets )
            	    // InternalMetaData.g:6669:5: lv_arrayDimensions_4_0= ruleArrayBrackets
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getXTypeLiteralAccess().getArrayDimensionsArrayBracketsParserRuleCall_4_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_92);
            	    lv_arrayDimensions_4_0=ruleArrayBrackets();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getXTypeLiteralRule());
            	      					}
            	      					add(
            	      						current,
            	      						"arrayDimensions",
            	      						lv_arrayDimensions_4_0,
            	      						"org.eclipse.xtext.xbase.Xtype.ArrayBrackets");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop110;
                }
            } while (true);

            otherlv_5=(Token)match(input,43,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getXTypeLiteralAccess().getRightParenthesisKeyword_5());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXTypeLiteral"


    // $ANTLR start "entryRuleXThrowExpression"
    // InternalMetaData.g:6694:1: entryRuleXThrowExpression returns [EObject current=null] : iv_ruleXThrowExpression= ruleXThrowExpression EOF ;
    public final EObject entryRuleXThrowExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXThrowExpression = null;


        try {
            // InternalMetaData.g:6694:57: (iv_ruleXThrowExpression= ruleXThrowExpression EOF )
            // InternalMetaData.g:6695:2: iv_ruleXThrowExpression= ruleXThrowExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXThrowExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXThrowExpression=ruleXThrowExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXThrowExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXThrowExpression"


    // $ANTLR start "ruleXThrowExpression"
    // InternalMetaData.g:6701:1: ruleXThrowExpression returns [EObject current=null] : ( () otherlv_1= 'throw' ( (lv_expression_2_0= ruleXExpression ) ) ) ;
    public final EObject ruleXThrowExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6707:2: ( ( () otherlv_1= 'throw' ( (lv_expression_2_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:6708:2: ( () otherlv_1= 'throw' ( (lv_expression_2_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:6708:2: ( () otherlv_1= 'throw' ( (lv_expression_2_0= ruleXExpression ) ) )
            // InternalMetaData.g:6709:3: () otherlv_1= 'throw' ( (lv_expression_2_0= ruleXExpression ) )
            {
            // InternalMetaData.g:6709:3: ()
            // InternalMetaData.g:6710:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXThrowExpressionAccess().getXThrowExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,105,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXThrowExpressionAccess().getThrowKeyword_1());
              		
            }
            // InternalMetaData.g:6720:3: ( (lv_expression_2_0= ruleXExpression ) )
            // InternalMetaData.g:6721:4: (lv_expression_2_0= ruleXExpression )
            {
            // InternalMetaData.g:6721:4: (lv_expression_2_0= ruleXExpression )
            // InternalMetaData.g:6722:5: lv_expression_2_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXThrowExpressionAccess().getExpressionXExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXThrowExpressionRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXThrowExpression"


    // $ANTLR start "entryRuleXReturnExpression"
    // InternalMetaData.g:6743:1: entryRuleXReturnExpression returns [EObject current=null] : iv_ruleXReturnExpression= ruleXReturnExpression EOF ;
    public final EObject entryRuleXReturnExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXReturnExpression = null;


        try {
            // InternalMetaData.g:6743:58: (iv_ruleXReturnExpression= ruleXReturnExpression EOF )
            // InternalMetaData.g:6744:2: iv_ruleXReturnExpression= ruleXReturnExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXReturnExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXReturnExpression=ruleXReturnExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXReturnExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXReturnExpression"


    // $ANTLR start "ruleXReturnExpression"
    // InternalMetaData.g:6750:1: ruleXReturnExpression returns [EObject current=null] : ( () otherlv_1= 'return' ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )? ) ;
    public final EObject ruleXReturnExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6756:2: ( ( () otherlv_1= 'return' ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )? ) )
            // InternalMetaData.g:6757:2: ( () otherlv_1= 'return' ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )? )
            {
            // InternalMetaData.g:6757:2: ( () otherlv_1= 'return' ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )? )
            // InternalMetaData.g:6758:3: () otherlv_1= 'return' ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )?
            {
            // InternalMetaData.g:6758:3: ()
            // InternalMetaData.g:6759:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXReturnExpressionAccess().getXReturnExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,106,FOLLOW_93); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXReturnExpressionAccess().getReturnKeyword_1());
              		
            }
            // InternalMetaData.g:6769:3: ( ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression ) )?
            int alt111=2;
            alt111 = dfa111.predict(input);
            switch (alt111) {
                case 1 :
                    // InternalMetaData.g:6770:4: ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )=> (lv_expression_2_0= ruleXExpression )
                    {
                    // InternalMetaData.g:6771:4: (lv_expression_2_0= ruleXExpression )
                    // InternalMetaData.g:6772:5: lv_expression_2_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getXReturnExpressionAccess().getExpressionXExpressionParserRuleCall_2_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_2_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getXReturnExpressionRule());
                      					}
                      					set(
                      						current,
                      						"expression",
                      						lv_expression_2_0,
                      						"org.eclipse.xtext.xbase.Xbase.XExpression");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXReturnExpression"


    // $ANTLR start "entryRuleXTryCatchFinallyExpression"
    // InternalMetaData.g:6793:1: entryRuleXTryCatchFinallyExpression returns [EObject current=null] : iv_ruleXTryCatchFinallyExpression= ruleXTryCatchFinallyExpression EOF ;
    public final EObject entryRuleXTryCatchFinallyExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXTryCatchFinallyExpression = null;


        try {
            // InternalMetaData.g:6793:67: (iv_ruleXTryCatchFinallyExpression= ruleXTryCatchFinallyExpression EOF )
            // InternalMetaData.g:6794:2: iv_ruleXTryCatchFinallyExpression= ruleXTryCatchFinallyExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXTryCatchFinallyExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXTryCatchFinallyExpression=ruleXTryCatchFinallyExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXTryCatchFinallyExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXTryCatchFinallyExpression"


    // $ANTLR start "ruleXTryCatchFinallyExpression"
    // InternalMetaData.g:6800:1: ruleXTryCatchFinallyExpression returns [EObject current=null] : ( () otherlv_1= 'try' ( (lv_expression_2_0= ruleXExpression ) ) ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) ) ) ;
    public final EObject ruleXTryCatchFinallyExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_4=null;
        Token otherlv_6=null;
        EObject lv_expression_2_0 = null;

        EObject lv_catchClauses_3_0 = null;

        EObject lv_finallyExpression_5_0 = null;

        EObject lv_finallyExpression_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6806:2: ( ( () otherlv_1= 'try' ( (lv_expression_2_0= ruleXExpression ) ) ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) ) ) )
            // InternalMetaData.g:6807:2: ( () otherlv_1= 'try' ( (lv_expression_2_0= ruleXExpression ) ) ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) ) )
            {
            // InternalMetaData.g:6807:2: ( () otherlv_1= 'try' ( (lv_expression_2_0= ruleXExpression ) ) ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) ) )
            // InternalMetaData.g:6808:3: () otherlv_1= 'try' ( (lv_expression_2_0= ruleXExpression ) ) ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) )
            {
            // InternalMetaData.g:6808:3: ()
            // InternalMetaData.g:6809:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getXTryCatchFinallyExpressionAccess().getXTryCatchFinallyExpressionAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,107,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXTryCatchFinallyExpressionAccess().getTryKeyword_1());
              		
            }
            // InternalMetaData.g:6819:3: ( (lv_expression_2_0= ruleXExpression ) )
            // InternalMetaData.g:6820:4: (lv_expression_2_0= ruleXExpression )
            {
            // InternalMetaData.g:6820:4: (lv_expression_2_0= ruleXExpression )
            // InternalMetaData.g:6821:5: lv_expression_2_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXTryCatchFinallyExpressionAccess().getExpressionXExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_94);
            lv_expression_2_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXTryCatchFinallyExpressionRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:6838:3: ( ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? ) | (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) ) )
            int alt114=2;
            int LA114_0 = input.LA(1);

            if ( (LA114_0==110) ) {
                alt114=1;
            }
            else if ( (LA114_0==108) ) {
                alt114=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 114, 0, input);

                throw nvae;
            }
            switch (alt114) {
                case 1 :
                    // InternalMetaData.g:6839:4: ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? )
                    {
                    // InternalMetaData.g:6839:4: ( ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )? )
                    // InternalMetaData.g:6840:5: ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+ ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )?
                    {
                    // InternalMetaData.g:6840:5: ( ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause ) )+
                    int cnt112=0;
                    loop112:
                    do {
                        int alt112=2;
                        int LA112_0 = input.LA(1);

                        if ( (LA112_0==110) ) {
                            int LA112_2 = input.LA(2);

                            if ( (synpred38_InternalMetaData()) ) {
                                alt112=1;
                            }


                        }


                        switch (alt112) {
                    	case 1 :
                    	    // InternalMetaData.g:6841:6: ( 'catch' )=> (lv_catchClauses_3_0= ruleXCatchClause )
                    	    {
                    	    // InternalMetaData.g:6842:6: (lv_catchClauses_3_0= ruleXCatchClause )
                    	    // InternalMetaData.g:6843:7: lv_catchClauses_3_0= ruleXCatchClause
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getXTryCatchFinallyExpressionAccess().getCatchClausesXCatchClauseParserRuleCall_3_0_0_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_95);
                    	    lv_catchClauses_3_0=ruleXCatchClause();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getXTryCatchFinallyExpressionRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"catchClauses",
                    	      								lv_catchClauses_3_0,
                    	      								"org.eclipse.xtext.xbase.Xbase.XCatchClause");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt112 >= 1 ) break loop112;
                    	    if (state.backtracking>0) {state.failed=true; return current;}
                                EarlyExitException eee =
                                    new EarlyExitException(112, input);
                                throw eee;
                        }
                        cnt112++;
                    } while (true);

                    // InternalMetaData.g:6860:5: ( ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) ) )?
                    int alt113=2;
                    int LA113_0 = input.LA(1);

                    if ( (LA113_0==108) ) {
                        int LA113_1 = input.LA(2);

                        if ( (synpred39_InternalMetaData()) ) {
                            alt113=1;
                        }
                    }
                    switch (alt113) {
                        case 1 :
                            // InternalMetaData.g:6861:6: ( ( 'finally' )=>otherlv_4= 'finally' ) ( (lv_finallyExpression_5_0= ruleXExpression ) )
                            {
                            // InternalMetaData.g:6861:6: ( ( 'finally' )=>otherlv_4= 'finally' )
                            // InternalMetaData.g:6862:7: ( 'finally' )=>otherlv_4= 'finally'
                            {
                            otherlv_4=(Token)match(input,108,FOLLOW_18); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_4, grammarAccess.getXTryCatchFinallyExpressionAccess().getFinallyKeyword_3_0_1_0());
                              						
                            }

                            }

                            // InternalMetaData.g:6868:6: ( (lv_finallyExpression_5_0= ruleXExpression ) )
                            // InternalMetaData.g:6869:7: (lv_finallyExpression_5_0= ruleXExpression )
                            {
                            // InternalMetaData.g:6869:7: (lv_finallyExpression_5_0= ruleXExpression )
                            // InternalMetaData.g:6870:8: lv_finallyExpression_5_0= ruleXExpression
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getXTryCatchFinallyExpressionAccess().getFinallyExpressionXExpressionParserRuleCall_3_0_1_1_0());
                              							
                            }
                            pushFollow(FOLLOW_2);
                            lv_finallyExpression_5_0=ruleXExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getXTryCatchFinallyExpressionRule());
                              								}
                              								set(
                              									current,
                              									"finallyExpression",
                              									lv_finallyExpression_5_0,
                              									"org.eclipse.xtext.xbase.Xbase.XExpression");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:6890:4: (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) )
                    {
                    // InternalMetaData.g:6890:4: (otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) ) )
                    // InternalMetaData.g:6891:5: otherlv_6= 'finally' ( (lv_finallyExpression_7_0= ruleXExpression ) )
                    {
                    otherlv_6=(Token)match(input,108,FOLLOW_18); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_6, grammarAccess.getXTryCatchFinallyExpressionAccess().getFinallyKeyword_3_1_0());
                      				
                    }
                    // InternalMetaData.g:6895:5: ( (lv_finallyExpression_7_0= ruleXExpression ) )
                    // InternalMetaData.g:6896:6: (lv_finallyExpression_7_0= ruleXExpression )
                    {
                    // InternalMetaData.g:6896:6: (lv_finallyExpression_7_0= ruleXExpression )
                    // InternalMetaData.g:6897:7: lv_finallyExpression_7_0= ruleXExpression
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXTryCatchFinallyExpressionAccess().getFinallyExpressionXExpressionParserRuleCall_3_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_finallyExpression_7_0=ruleXExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getXTryCatchFinallyExpressionRule());
                      							}
                      							set(
                      								current,
                      								"finallyExpression",
                      								lv_finallyExpression_7_0,
                      								"org.eclipse.xtext.xbase.Xbase.XExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXTryCatchFinallyExpression"


    // $ANTLR start "entryRuleXSynchronizedExpression"
    // InternalMetaData.g:6920:1: entryRuleXSynchronizedExpression returns [EObject current=null] : iv_ruleXSynchronizedExpression= ruleXSynchronizedExpression EOF ;
    public final EObject entryRuleXSynchronizedExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXSynchronizedExpression = null;


        try {
            // InternalMetaData.g:6920:64: (iv_ruleXSynchronizedExpression= ruleXSynchronizedExpression EOF )
            // InternalMetaData.g:6921:2: iv_ruleXSynchronizedExpression= ruleXSynchronizedExpression EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXSynchronizedExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXSynchronizedExpression=ruleXSynchronizedExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXSynchronizedExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXSynchronizedExpression"


    // $ANTLR start "ruleXSynchronizedExpression"
    // InternalMetaData.g:6927:1: ruleXSynchronizedExpression returns [EObject current=null] : ( ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) ) ( (lv_param_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_expression_5_0= ruleXExpression ) ) ) ;
    public final EObject ruleXSynchronizedExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_param_3_0 = null;

        EObject lv_expression_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:6933:2: ( ( ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) ) ( (lv_param_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_expression_5_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:6934:2: ( ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) ) ( (lv_param_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_expression_5_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:6934:2: ( ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) ) ( (lv_param_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_expression_5_0= ruleXExpression ) ) )
            // InternalMetaData.g:6935:3: ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) ) ( (lv_param_3_0= ruleXExpression ) ) otherlv_4= ')' ( (lv_expression_5_0= ruleXExpression ) )
            {
            // InternalMetaData.g:6935:3: ( ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' ) )
            // InternalMetaData.g:6936:4: ( ( () 'synchronized' '(' ) )=> ( () otherlv_1= 'synchronized' otherlv_2= '(' )
            {
            // InternalMetaData.g:6943:4: ( () otherlv_1= 'synchronized' otherlv_2= '(' )
            // InternalMetaData.g:6944:5: () otherlv_1= 'synchronized' otherlv_2= '('
            {
            // InternalMetaData.g:6944:5: ()
            // InternalMetaData.g:6945:6: 
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getXSynchronizedExpressionAccess().getXSynchronizedExpressionAction_0_0_0(),
              							current);
              					
            }

            }

            otherlv_1=(Token)match(input,109,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getXSynchronizedExpressionAccess().getSynchronizedKeyword_0_0_1());
              				
            }
            otherlv_2=(Token)match(input,41,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_2, grammarAccess.getXSynchronizedExpressionAccess().getLeftParenthesisKeyword_0_0_2());
              				
            }

            }


            }

            // InternalMetaData.g:6961:3: ( (lv_param_3_0= ruleXExpression ) )
            // InternalMetaData.g:6962:4: (lv_param_3_0= ruleXExpression )
            {
            // InternalMetaData.g:6962:4: (lv_param_3_0= ruleXExpression )
            // InternalMetaData.g:6963:5: lv_param_3_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXSynchronizedExpressionAccess().getParamXExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_param_3_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXSynchronizedExpressionRule());
              					}
              					set(
              						current,
              						"param",
              						lv_param_3_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_4=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getXSynchronizedExpressionAccess().getRightParenthesisKeyword_2());
              		
            }
            // InternalMetaData.g:6984:3: ( (lv_expression_5_0= ruleXExpression ) )
            // InternalMetaData.g:6985:4: (lv_expression_5_0= ruleXExpression )
            {
            // InternalMetaData.g:6985:4: (lv_expression_5_0= ruleXExpression )
            // InternalMetaData.g:6986:5: lv_expression_5_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXSynchronizedExpressionAccess().getExpressionXExpressionParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_5_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXSynchronizedExpressionRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_5_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXSynchronizedExpression"


    // $ANTLR start "entryRuleXCatchClause"
    // InternalMetaData.g:7007:1: entryRuleXCatchClause returns [EObject current=null] : iv_ruleXCatchClause= ruleXCatchClause EOF ;
    public final EObject entryRuleXCatchClause() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXCatchClause = null;


        try {
            // InternalMetaData.g:7007:53: (iv_ruleXCatchClause= ruleXCatchClause EOF )
            // InternalMetaData.g:7008:2: iv_ruleXCatchClause= ruleXCatchClause EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXCatchClauseRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXCatchClause=ruleXCatchClause();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXCatchClause; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXCatchClause"


    // $ANTLR start "ruleXCatchClause"
    // InternalMetaData.g:7014:1: ruleXCatchClause returns [EObject current=null] : ( ( ( 'catch' )=>otherlv_0= 'catch' ) otherlv_1= '(' ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) ) otherlv_3= ')' ( (lv_expression_4_0= ruleXExpression ) ) ) ;
    public final EObject ruleXCatchClause() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_declaredParam_2_0 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7020:2: ( ( ( ( 'catch' )=>otherlv_0= 'catch' ) otherlv_1= '(' ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) ) otherlv_3= ')' ( (lv_expression_4_0= ruleXExpression ) ) ) )
            // InternalMetaData.g:7021:2: ( ( ( 'catch' )=>otherlv_0= 'catch' ) otherlv_1= '(' ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) ) otherlv_3= ')' ( (lv_expression_4_0= ruleXExpression ) ) )
            {
            // InternalMetaData.g:7021:2: ( ( ( 'catch' )=>otherlv_0= 'catch' ) otherlv_1= '(' ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) ) otherlv_3= ')' ( (lv_expression_4_0= ruleXExpression ) ) )
            // InternalMetaData.g:7022:3: ( ( 'catch' )=>otherlv_0= 'catch' ) otherlv_1= '(' ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) ) otherlv_3= ')' ( (lv_expression_4_0= ruleXExpression ) )
            {
            // InternalMetaData.g:7022:3: ( ( 'catch' )=>otherlv_0= 'catch' )
            // InternalMetaData.g:7023:4: ( 'catch' )=>otherlv_0= 'catch'
            {
            otherlv_0=(Token)match(input,110,FOLLOW_24); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				newLeafNode(otherlv_0, grammarAccess.getXCatchClauseAccess().getCatchKeyword_0());
              			
            }

            }

            otherlv_1=(Token)match(input,41,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getXCatchClauseAccess().getLeftParenthesisKeyword_1());
              		
            }
            // InternalMetaData.g:7033:3: ( (lv_declaredParam_2_0= ruleFullJvmFormalParameter ) )
            // InternalMetaData.g:7034:4: (lv_declaredParam_2_0= ruleFullJvmFormalParameter )
            {
            // InternalMetaData.g:7034:4: (lv_declaredParam_2_0= ruleFullJvmFormalParameter )
            // InternalMetaData.g:7035:5: lv_declaredParam_2_0= ruleFullJvmFormalParameter
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXCatchClauseAccess().getDeclaredParamFullJvmFormalParameterParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_26);
            lv_declaredParam_2_0=ruleFullJvmFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXCatchClauseRule());
              					}
              					set(
              						current,
              						"declaredParam",
              						lv_declaredParam_2_0,
              						"org.eclipse.xtext.xbase.Xbase.FullJvmFormalParameter");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,43,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getXCatchClauseAccess().getRightParenthesisKeyword_3());
              		
            }
            // InternalMetaData.g:7056:3: ( (lv_expression_4_0= ruleXExpression ) )
            // InternalMetaData.g:7057:4: (lv_expression_4_0= ruleXExpression )
            {
            // InternalMetaData.g:7057:4: (lv_expression_4_0= ruleXExpression )
            // InternalMetaData.g:7058:5: lv_expression_4_0= ruleXExpression
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXCatchClauseAccess().getExpressionXExpressionParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_4_0=ruleXExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXCatchClauseRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_4_0,
              						"org.eclipse.xtext.xbase.Xbase.XExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXCatchClause"


    // $ANTLR start "entryRuleQualifiedName"
    // InternalMetaData.g:7079:1: entryRuleQualifiedName returns [String current=null] : iv_ruleQualifiedName= ruleQualifiedName EOF ;
    public final String entryRuleQualifiedName() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleQualifiedName = null;


        try {
            // InternalMetaData.g:7079:53: (iv_ruleQualifiedName= ruleQualifiedName EOF )
            // InternalMetaData.g:7080:2: iv_ruleQualifiedName= ruleQualifiedName EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getQualifiedNameRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleQualifiedName=ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleQualifiedName.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleQualifiedName"


    // $ANTLR start "ruleQualifiedName"
    // InternalMetaData.g:7086:1: ruleQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_ValidID_0= ruleValidID ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )* ) ;
    public final AntlrDatatypeRuleToken ruleQualifiedName() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_ValidID_0 = null;

        AntlrDatatypeRuleToken this_ValidID_2 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7092:2: ( (this_ValidID_0= ruleValidID ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )* ) )
            // InternalMetaData.g:7093:2: (this_ValidID_0= ruleValidID ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )* )
            {
            // InternalMetaData.g:7093:2: (this_ValidID_0= ruleValidID ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )* )
            // InternalMetaData.g:7094:3: this_ValidID_0= ruleValidID ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )*
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getQualifiedNameAccess().getValidIDParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_96);
            this_ValidID_0=ruleValidID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(this_ValidID_0);
              		
            }
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }
            // InternalMetaData.g:7104:3: ( ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID )*
            loop115:
            do {
                int alt115=2;
                int LA115_0 = input.LA(1);

                if ( (LA115_0==79) ) {
                    int LA115_2 = input.LA(2);

                    if ( (LA115_2==RULE_ID) ) {
                        int LA115_3 = input.LA(3);

                        if ( (synpred42_InternalMetaData()) ) {
                            alt115=1;
                        }


                    }


                }


                switch (alt115) {
            	case 1 :
            	    // InternalMetaData.g:7105:4: ( ( '.' )=>kw= '.' ) this_ValidID_2= ruleValidID
            	    {
            	    // InternalMetaData.g:7105:4: ( ( '.' )=>kw= '.' )
            	    // InternalMetaData.g:7106:5: ( '.' )=>kw= '.'
            	    {
            	    kw=(Token)match(input,79,FOLLOW_3); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					current.merge(kw);
            	      					newLeafNode(kw, grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0());
            	      				
            	    }

            	    }

            	    if ( state.backtracking==0 ) {

            	      				newCompositeNode(grammarAccess.getQualifiedNameAccess().getValidIDParserRuleCall_1_1());
            	      			
            	    }
            	    pushFollow(FOLLOW_96);
            	    this_ValidID_2=ruleValidID();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				current.merge(this_ValidID_2);
            	      			
            	    }
            	    if ( state.backtracking==0 ) {

            	      				afterParserOrEnumRuleCall();
            	      			
            	    }

            	    }
            	    break;

            	default :
            	    break loop115;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleQualifiedName"


    // $ANTLR start "entryRuleNumber"
    // InternalMetaData.g:7128:1: entryRuleNumber returns [String current=null] : iv_ruleNumber= ruleNumber EOF ;
    public final String entryRuleNumber() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleNumber = null;



        	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();

        try {
            // InternalMetaData.g:7130:2: (iv_ruleNumber= ruleNumber EOF )
            // InternalMetaData.g:7131:2: iv_ruleNumber= ruleNumber EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNumberRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleNumber=ruleNumber();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNumber.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {

            	myHiddenTokenState.restore();

        }
        return current;
    }
    // $ANTLR end "entryRuleNumber"


    // $ANTLR start "ruleNumber"
    // InternalMetaData.g:7140:1: ruleNumber returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_HEX_0= RULE_HEX | ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? ) ) ;
    public final AntlrDatatypeRuleToken ruleNumber() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_HEX_0=null;
        Token this_INT_1=null;
        Token this_DECIMAL_2=null;
        Token kw=null;
        Token this_INT_4=null;
        Token this_DECIMAL_5=null;


        	enterRule();
        	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();

        try {
            // InternalMetaData.g:7147:2: ( (this_HEX_0= RULE_HEX | ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? ) ) )
            // InternalMetaData.g:7148:2: (this_HEX_0= RULE_HEX | ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? ) )
            {
            // InternalMetaData.g:7148:2: (this_HEX_0= RULE_HEX | ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? ) )
            int alt119=2;
            int LA119_0 = input.LA(1);

            if ( (LA119_0==RULE_HEX) ) {
                alt119=1;
            }
            else if ( ((LA119_0>=RULE_INT && LA119_0<=RULE_DECIMAL)) ) {
                alt119=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;
            }
            switch (alt119) {
                case 1 :
                    // InternalMetaData.g:7149:3: this_HEX_0= RULE_HEX
                    {
                    this_HEX_0=(Token)match(input,RULE_HEX,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current.merge(this_HEX_0);
                      		
                    }
                    if ( state.backtracking==0 ) {

                      			newLeafNode(this_HEX_0, grammarAccess.getNumberAccess().getHEXTerminalRuleCall_0());
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:7157:3: ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? )
                    {
                    // InternalMetaData.g:7157:3: ( (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )? )
                    // InternalMetaData.g:7158:4: (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL ) (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )?
                    {
                    // InternalMetaData.g:7158:4: (this_INT_1= RULE_INT | this_DECIMAL_2= RULE_DECIMAL )
                    int alt116=2;
                    int LA116_0 = input.LA(1);

                    if ( (LA116_0==RULE_INT) ) {
                        alt116=1;
                    }
                    else if ( (LA116_0==RULE_DECIMAL) ) {
                        alt116=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 116, 0, input);

                        throw nvae;
                    }
                    switch (alt116) {
                        case 1 :
                            // InternalMetaData.g:7159:5: this_INT_1= RULE_INT
                            {
                            this_INT_1=(Token)match(input,RULE_INT,FOLLOW_96); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(this_INT_1);
                              				
                            }
                            if ( state.backtracking==0 ) {

                              					newLeafNode(this_INT_1, grammarAccess.getNumberAccess().getINTTerminalRuleCall_1_0_0());
                              				
                            }

                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:7167:5: this_DECIMAL_2= RULE_DECIMAL
                            {
                            this_DECIMAL_2=(Token)match(input,RULE_DECIMAL,FOLLOW_96); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(this_DECIMAL_2);
                              				
                            }
                            if ( state.backtracking==0 ) {

                              					newLeafNode(this_DECIMAL_2, grammarAccess.getNumberAccess().getDECIMALTerminalRuleCall_1_0_1());
                              				
                            }

                            }
                            break;

                    }

                    // InternalMetaData.g:7175:4: (kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL ) )?
                    int alt118=2;
                    int LA118_0 = input.LA(1);

                    if ( (LA118_0==79) ) {
                        int LA118_1 = input.LA(2);

                        if ( ((LA118_1>=RULE_INT && LA118_1<=RULE_DECIMAL)) ) {
                            alt118=1;
                        }
                    }
                    switch (alt118) {
                        case 1 :
                            // InternalMetaData.g:7176:5: kw= '.' (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL )
                            {
                            kw=(Token)match(input,79,FOLLOW_97); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current.merge(kw);
                              					newLeafNode(kw, grammarAccess.getNumberAccess().getFullStopKeyword_1_1_0());
                              				
                            }
                            // InternalMetaData.g:7181:5: (this_INT_4= RULE_INT | this_DECIMAL_5= RULE_DECIMAL )
                            int alt117=2;
                            int LA117_0 = input.LA(1);

                            if ( (LA117_0==RULE_INT) ) {
                                alt117=1;
                            }
                            else if ( (LA117_0==RULE_DECIMAL) ) {
                                alt117=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return current;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 117, 0, input);

                                throw nvae;
                            }
                            switch (alt117) {
                                case 1 :
                                    // InternalMetaData.g:7182:6: this_INT_4= RULE_INT
                                    {
                                    this_INT_4=(Token)match(input,RULE_INT,FOLLOW_2); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      						current.merge(this_INT_4);
                                      					
                                    }
                                    if ( state.backtracking==0 ) {

                                      						newLeafNode(this_INT_4, grammarAccess.getNumberAccess().getINTTerminalRuleCall_1_1_1_0());
                                      					
                                    }

                                    }
                                    break;
                                case 2 :
                                    // InternalMetaData.g:7190:6: this_DECIMAL_5= RULE_DECIMAL
                                    {
                                    this_DECIMAL_5=(Token)match(input,RULE_DECIMAL,FOLLOW_2); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      						current.merge(this_DECIMAL_5);
                                      					
                                    }
                                    if ( state.backtracking==0 ) {

                                      						newLeafNode(this_DECIMAL_5, grammarAccess.getNumberAccess().getDECIMALTerminalRuleCall_1_1_1_1());
                                      					
                                    }

                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {

            	myHiddenTokenState.restore();

        }
        return current;
    }
    // $ANTLR end "ruleNumber"


    // $ANTLR start "entryRuleJvmTypeReference"
    // InternalMetaData.g:7207:1: entryRuleJvmTypeReference returns [EObject current=null] : iv_ruleJvmTypeReference= ruleJvmTypeReference EOF ;
    public final EObject entryRuleJvmTypeReference() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmTypeReference = null;


        try {
            // InternalMetaData.g:7207:57: (iv_ruleJvmTypeReference= ruleJvmTypeReference EOF )
            // InternalMetaData.g:7208:2: iv_ruleJvmTypeReference= ruleJvmTypeReference EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmTypeReferenceRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmTypeReference=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmTypeReference; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmTypeReference"


    // $ANTLR start "ruleJvmTypeReference"
    // InternalMetaData.g:7214:1: ruleJvmTypeReference returns [EObject current=null] : ( (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* ) | this_XFunctionTypeRef_3= ruleXFunctionTypeRef ) ;
    public final EObject ruleJvmTypeReference() throws RecognitionException {
        EObject current = null;

        EObject this_JvmParameterizedTypeReference_0 = null;

        EObject this_XFunctionTypeRef_3 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7220:2: ( ( (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* ) | this_XFunctionTypeRef_3= ruleXFunctionTypeRef ) )
            // InternalMetaData.g:7221:2: ( (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* ) | this_XFunctionTypeRef_3= ruleXFunctionTypeRef )
            {
            // InternalMetaData.g:7221:2: ( (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* ) | this_XFunctionTypeRef_3= ruleXFunctionTypeRef )
            int alt121=2;
            int LA121_0 = input.LA(1);

            if ( (LA121_0==RULE_ID) ) {
                alt121=1;
            }
            else if ( (LA121_0==41||LA121_0==68) ) {
                alt121=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 121, 0, input);

                throw nvae;
            }
            switch (alt121) {
                case 1 :
                    // InternalMetaData.g:7222:3: (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* )
                    {
                    // InternalMetaData.g:7222:3: (this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )* )
                    // InternalMetaData.g:7223:4: this_JvmParameterizedTypeReference_0= ruleJvmParameterizedTypeReference ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )*
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getJvmTypeReferenceAccess().getJvmParameterizedTypeReferenceParserRuleCall_0_0());
                      			
                    }
                    pushFollow(FOLLOW_90);
                    this_JvmParameterizedTypeReference_0=ruleJvmParameterizedTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_JvmParameterizedTypeReference_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }
                    // InternalMetaData.g:7231:4: ( ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets ) )*
                    loop120:
                    do {
                        int alt120=2;
                        int LA120_0 = input.LA(1);

                        if ( (LA120_0==82) ) {
                            int LA120_2 = input.LA(2);

                            if ( (LA120_2==83) ) {
                                int LA120_3 = input.LA(3);

                                if ( (synpred43_InternalMetaData()) ) {
                                    alt120=1;
                                }


                            }


                        }


                        switch (alt120) {
                    	case 1 :
                    	    // InternalMetaData.g:7232:5: ( ( () ruleArrayBrackets ) )=> ( () ruleArrayBrackets )
                    	    {
                    	    // InternalMetaData.g:7238:5: ( () ruleArrayBrackets )
                    	    // InternalMetaData.g:7239:6: () ruleArrayBrackets
                    	    {
                    	    // InternalMetaData.g:7239:6: ()
                    	    // InternalMetaData.g:7240:7: 
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							current = forceCreateModelElementAndSet(
                    	      								grammarAccess.getJvmTypeReferenceAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0(),
                    	      								current);
                    	      						
                    	    }

                    	    }

                    	    if ( state.backtracking==0 ) {

                    	      						newCompositeNode(grammarAccess.getJvmTypeReferenceAccess().getArrayBracketsParserRuleCall_0_1_0_1());
                    	      					
                    	    }
                    	    pushFollow(FOLLOW_90);
                    	    ruleArrayBrackets();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						afterParserOrEnumRuleCall();
                    	      					
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop120;
                        }
                    } while (true);


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:7257:3: this_XFunctionTypeRef_3= ruleXFunctionTypeRef
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getJvmTypeReferenceAccess().getXFunctionTypeRefParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_XFunctionTypeRef_3=ruleXFunctionTypeRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_XFunctionTypeRef_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmTypeReference"


    // $ANTLR start "entryRuleArrayBrackets"
    // InternalMetaData.g:7269:1: entryRuleArrayBrackets returns [String current=null] : iv_ruleArrayBrackets= ruleArrayBrackets EOF ;
    public final String entryRuleArrayBrackets() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleArrayBrackets = null;


        try {
            // InternalMetaData.g:7269:53: (iv_ruleArrayBrackets= ruleArrayBrackets EOF )
            // InternalMetaData.g:7270:2: iv_ruleArrayBrackets= ruleArrayBrackets EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getArrayBracketsRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleArrayBrackets=ruleArrayBrackets();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleArrayBrackets.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleArrayBrackets"


    // $ANTLR start "ruleArrayBrackets"
    // InternalMetaData.g:7276:1: ruleArrayBrackets returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (kw= '[' kw= ']' ) ;
    public final AntlrDatatypeRuleToken ruleArrayBrackets() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            // InternalMetaData.g:7282:2: ( (kw= '[' kw= ']' ) )
            // InternalMetaData.g:7283:2: (kw= '[' kw= ']' )
            {
            // InternalMetaData.g:7283:2: (kw= '[' kw= ']' )
            // InternalMetaData.g:7284:3: kw= '[' kw= ']'
            {
            kw=(Token)match(input,82,FOLLOW_69); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(kw);
              			newLeafNode(kw, grammarAccess.getArrayBracketsAccess().getLeftSquareBracketKeyword_0());
              		
            }
            kw=(Token)match(input,83,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(kw);
              			newLeafNode(kw, grammarAccess.getArrayBracketsAccess().getRightSquareBracketKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleArrayBrackets"


    // $ANTLR start "entryRuleXFunctionTypeRef"
    // InternalMetaData.g:7298:1: entryRuleXFunctionTypeRef returns [EObject current=null] : iv_ruleXFunctionTypeRef= ruleXFunctionTypeRef EOF ;
    public final EObject entryRuleXFunctionTypeRef() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXFunctionTypeRef = null;


        try {
            // InternalMetaData.g:7298:57: (iv_ruleXFunctionTypeRef= ruleXFunctionTypeRef EOF )
            // InternalMetaData.g:7299:2: iv_ruleXFunctionTypeRef= ruleXFunctionTypeRef EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXFunctionTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXFunctionTypeRef=ruleXFunctionTypeRef();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXFunctionTypeRef; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXFunctionTypeRef"


    // $ANTLR start "ruleXFunctionTypeRef"
    // InternalMetaData.g:7305:1: ruleXFunctionTypeRef returns [EObject current=null] : ( (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )? otherlv_5= '=>' ( (lv_returnType_6_0= ruleJvmTypeReference ) ) ) ;
    public final EObject ruleXFunctionTypeRef() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        EObject lv_paramTypes_1_0 = null;

        EObject lv_paramTypes_3_0 = null;

        EObject lv_returnType_6_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7311:2: ( ( (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )? otherlv_5= '=>' ( (lv_returnType_6_0= ruleJvmTypeReference ) ) ) )
            // InternalMetaData.g:7312:2: ( (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )? otherlv_5= '=>' ( (lv_returnType_6_0= ruleJvmTypeReference ) ) )
            {
            // InternalMetaData.g:7312:2: ( (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )? otherlv_5= '=>' ( (lv_returnType_6_0= ruleJvmTypeReference ) ) )
            // InternalMetaData.g:7313:3: (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )? otherlv_5= '=>' ( (lv_returnType_6_0= ruleJvmTypeReference ) )
            {
            // InternalMetaData.g:7313:3: (otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')' )?
            int alt124=2;
            int LA124_0 = input.LA(1);

            if ( (LA124_0==41) ) {
                alt124=1;
            }
            switch (alt124) {
                case 1 :
                    // InternalMetaData.g:7314:4: otherlv_0= '(' ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )? otherlv_4= ')'
                    {
                    otherlv_0=(Token)match(input,41,FOLLOW_98); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_0, grammarAccess.getXFunctionTypeRefAccess().getLeftParenthesisKeyword_0_0());
                      			
                    }
                    // InternalMetaData.g:7318:4: ( ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )* )?
                    int alt123=2;
                    int LA123_0 = input.LA(1);

                    if ( (LA123_0==RULE_ID||LA123_0==41||LA123_0==68) ) {
                        alt123=1;
                    }
                    switch (alt123) {
                        case 1 :
                            // InternalMetaData.g:7319:5: ( (lv_paramTypes_1_0= ruleJvmTypeReference ) ) (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )*
                            {
                            // InternalMetaData.g:7319:5: ( (lv_paramTypes_1_0= ruleJvmTypeReference ) )
                            // InternalMetaData.g:7320:6: (lv_paramTypes_1_0= ruleJvmTypeReference )
                            {
                            // InternalMetaData.g:7320:6: (lv_paramTypes_1_0= ruleJvmTypeReference )
                            // InternalMetaData.g:7321:7: lv_paramTypes_1_0= ruleJvmTypeReference
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getXFunctionTypeRefAccess().getParamTypesJvmTypeReferenceParserRuleCall_0_1_0_0());
                              						
                            }
                            pushFollow(FOLLOW_59);
                            lv_paramTypes_1_0=ruleJvmTypeReference();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getXFunctionTypeRefRule());
                              							}
                              							add(
                              								current,
                              								"paramTypes",
                              								lv_paramTypes_1_0,
                              								"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }

                            // InternalMetaData.g:7338:5: (otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) ) )*
                            loop122:
                            do {
                                int alt122=2;
                                int LA122_0 = input.LA(1);

                                if ( (LA122_0==36) ) {
                                    alt122=1;
                                }


                                switch (alt122) {
                            	case 1 :
                            	    // InternalMetaData.g:7339:6: otherlv_2= ',' ( (lv_paramTypes_3_0= ruleJvmTypeReference ) )
                            	    {
                            	    otherlv_2=(Token)match(input,36,FOLLOW_15); if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      						newLeafNode(otherlv_2, grammarAccess.getXFunctionTypeRefAccess().getCommaKeyword_0_1_1_0());
                            	      					
                            	    }
                            	    // InternalMetaData.g:7343:6: ( (lv_paramTypes_3_0= ruleJvmTypeReference ) )
                            	    // InternalMetaData.g:7344:7: (lv_paramTypes_3_0= ruleJvmTypeReference )
                            	    {
                            	    // InternalMetaData.g:7344:7: (lv_paramTypes_3_0= ruleJvmTypeReference )
                            	    // InternalMetaData.g:7345:8: lv_paramTypes_3_0= ruleJvmTypeReference
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      								newCompositeNode(grammarAccess.getXFunctionTypeRefAccess().getParamTypesJvmTypeReferenceParserRuleCall_0_1_1_1_0());
                            	      							
                            	    }
                            	    pushFollow(FOLLOW_59);
                            	    lv_paramTypes_3_0=ruleJvmTypeReference();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      								if (current==null) {
                            	      									current = createModelElementForParent(grammarAccess.getXFunctionTypeRefRule());
                            	      								}
                            	      								add(
                            	      									current,
                            	      									"paramTypes",
                            	      									lv_paramTypes_3_0,
                            	      									"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
                            	      								afterParserOrEnumRuleCall();
                            	      							
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop122;
                                }
                            } while (true);


                            }
                            break;

                    }

                    otherlv_4=(Token)match(input,43,FOLLOW_99); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_4, grammarAccess.getXFunctionTypeRefAccess().getRightParenthesisKeyword_0_2());
                      			
                    }

                    }
                    break;

            }

            otherlv_5=(Token)match(input,68,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getXFunctionTypeRefAccess().getEqualsSignGreaterThanSignKeyword_1());
              		
            }
            // InternalMetaData.g:7373:3: ( (lv_returnType_6_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:7374:4: (lv_returnType_6_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:7374:4: (lv_returnType_6_0= ruleJvmTypeReference )
            // InternalMetaData.g:7375:5: lv_returnType_6_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getXFunctionTypeRefAccess().getReturnTypeJvmTypeReferenceParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_returnType_6_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getXFunctionTypeRefRule());
              					}
              					set(
              						current,
              						"returnType",
              						lv_returnType_6_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXFunctionTypeRef"


    // $ANTLR start "entryRuleJvmParameterizedTypeReference"
    // InternalMetaData.g:7396:1: entryRuleJvmParameterizedTypeReference returns [EObject current=null] : iv_ruleJvmParameterizedTypeReference= ruleJvmParameterizedTypeReference EOF ;
    public final EObject entryRuleJvmParameterizedTypeReference() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmParameterizedTypeReference = null;


        try {
            // InternalMetaData.g:7396:70: (iv_ruleJvmParameterizedTypeReference= ruleJvmParameterizedTypeReference EOF )
            // InternalMetaData.g:7397:2: iv_ruleJvmParameterizedTypeReference= ruleJvmParameterizedTypeReference EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmParameterizedTypeReference=ruleJvmParameterizedTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmParameterizedTypeReference; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmParameterizedTypeReference"


    // $ANTLR start "ruleJvmParameterizedTypeReference"
    // InternalMetaData.g:7403:1: ruleJvmParameterizedTypeReference returns [EObject current=null] : ( ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )? ) ;
    public final EObject ruleJvmParameterizedTypeReference() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_7=null;
        Token otherlv_9=null;
        Token otherlv_11=null;
        Token otherlv_13=null;
        EObject lv_arguments_2_0 = null;

        EObject lv_arguments_4_0 = null;

        EObject lv_arguments_10_0 = null;

        EObject lv_arguments_12_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7409:2: ( ( ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )? ) )
            // InternalMetaData.g:7410:2: ( ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )? )
            {
            // InternalMetaData.g:7410:2: ( ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )? )
            // InternalMetaData.g:7411:3: ( ( ruleQualifiedName ) ) ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )?
            {
            // InternalMetaData.g:7411:3: ( ( ruleQualifiedName ) )
            // InternalMetaData.g:7412:4: ( ruleQualifiedName )
            {
            // InternalMetaData.g:7412:4: ( ruleQualifiedName )
            // InternalMetaData.g:7413:5: ruleQualifiedName
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getJvmParameterizedTypeReferenceRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getTypeJvmTypeCrossReference_0_0());
              				
            }
            pushFollow(FOLLOW_100);
            ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            // InternalMetaData.g:7427:3: ( ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )* )?
            int alt129=2;
            alt129 = dfa129.predict(input);
            switch (alt129) {
                case 1 :
                    // InternalMetaData.g:7428:4: ( ( '<' )=>otherlv_1= '<' ) ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) ) (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )* otherlv_5= '>' ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )*
                    {
                    // InternalMetaData.g:7428:4: ( ( '<' )=>otherlv_1= '<' )
                    // InternalMetaData.g:7429:5: ( '<' )=>otherlv_1= '<'
                    {
                    otherlv_1=(Token)match(input,56,FOLLOW_55); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_1, grammarAccess.getJvmParameterizedTypeReferenceAccess().getLessThanSignKeyword_1_0());
                      				
                    }

                    }

                    // InternalMetaData.g:7435:4: ( (lv_arguments_2_0= ruleJvmArgumentTypeReference ) )
                    // InternalMetaData.g:7436:5: (lv_arguments_2_0= ruleJvmArgumentTypeReference )
                    {
                    // InternalMetaData.g:7436:5: (lv_arguments_2_0= ruleJvmArgumentTypeReference )
                    // InternalMetaData.g:7437:6: lv_arguments_2_0= ruleJvmArgumentTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getArgumentsJvmArgumentTypeReferenceParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_56);
                    lv_arguments_2_0=ruleJvmArgumentTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getJvmParameterizedTypeReferenceRule());
                      						}
                      						add(
                      							current,
                      							"arguments",
                      							lv_arguments_2_0,
                      							"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    // InternalMetaData.g:7454:4: (otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) ) )*
                    loop125:
                    do {
                        int alt125=2;
                        int LA125_0 = input.LA(1);

                        if ( (LA125_0==36) ) {
                            alt125=1;
                        }


                        switch (alt125) {
                    	case 1 :
                    	    // InternalMetaData.g:7455:5: otherlv_3= ',' ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) )
                    	    {
                    	    otherlv_3=(Token)match(input,36,FOLLOW_55); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_3, grammarAccess.getJvmParameterizedTypeReferenceAccess().getCommaKeyword_1_2_0());
                    	      				
                    	    }
                    	    // InternalMetaData.g:7459:5: ( (lv_arguments_4_0= ruleJvmArgumentTypeReference ) )
                    	    // InternalMetaData.g:7460:6: (lv_arguments_4_0= ruleJvmArgumentTypeReference )
                    	    {
                    	    // InternalMetaData.g:7460:6: (lv_arguments_4_0= ruleJvmArgumentTypeReference )
                    	    // InternalMetaData.g:7461:7: lv_arguments_4_0= ruleJvmArgumentTypeReference
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getArgumentsJvmArgumentTypeReferenceParserRuleCall_1_2_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_56);
                    	    lv_arguments_4_0=ruleJvmArgumentTypeReference();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getJvmParameterizedTypeReferenceRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"arguments",
                    	      								lv_arguments_4_0,
                    	      								"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop125;
                        }
                    } while (true);

                    otherlv_5=(Token)match(input,57,FOLLOW_96); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_5, grammarAccess.getJvmParameterizedTypeReferenceAccess().getGreaterThanSignKeyword_1_3());
                      			
                    }
                    // InternalMetaData.g:7483:4: ( ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )? )*
                    loop128:
                    do {
                        int alt128=2;
                        int LA128_0 = input.LA(1);

                        if ( (LA128_0==79) ) {
                            int LA128_2 = input.LA(2);

                            if ( (LA128_2==RULE_ID) ) {
                                int LA128_3 = input.LA(3);

                                if ( (synpred45_InternalMetaData()) ) {
                                    alt128=1;
                                }


                            }


                        }


                        switch (alt128) {
                    	case 1 :
                    	    // InternalMetaData.g:7484:5: ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) ) ( ( ruleValidID ) ) ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )?
                    	    {
                    	    // InternalMetaData.g:7484:5: ( ( ( () '.' ) )=> ( () otherlv_7= '.' ) )
                    	    // InternalMetaData.g:7485:6: ( ( () '.' ) )=> ( () otherlv_7= '.' )
                    	    {
                    	    // InternalMetaData.g:7491:6: ( () otherlv_7= '.' )
                    	    // InternalMetaData.g:7492:7: () otherlv_7= '.'
                    	    {
                    	    // InternalMetaData.g:7492:7: ()
                    	    // InternalMetaData.g:7493:8: 
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      								current = forceCreateModelElementAndSet(
                    	      									grammarAccess.getJvmParameterizedTypeReferenceAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0(),
                    	      									current);
                    	      							
                    	    }

                    	    }

                    	    otherlv_7=(Token)match(input,79,FOLLOW_3); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							newLeafNode(otherlv_7, grammarAccess.getJvmParameterizedTypeReferenceAccess().getFullStopKeyword_1_4_0_0_1());
                    	      						
                    	    }

                    	    }


                    	    }

                    	    // InternalMetaData.g:7505:5: ( ( ruleValidID ) )
                    	    // InternalMetaData.g:7506:6: ( ruleValidID )
                    	    {
                    	    // InternalMetaData.g:7506:6: ( ruleValidID )
                    	    // InternalMetaData.g:7507:7: ruleValidID
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElement(grammarAccess.getJvmParameterizedTypeReferenceRule());
                    	      							}
                    	      						
                    	    }
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getTypeJvmTypeCrossReference_1_4_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_101);
                    	    ruleValidID();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }

                    	    // InternalMetaData.g:7521:5: ( ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>' )?
                    	    int alt127=2;
                    	    alt127 = dfa127.predict(input);
                    	    switch (alt127) {
                    	        case 1 :
                    	            // InternalMetaData.g:7522:6: ( ( '<' )=>otherlv_9= '<' ) ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) ) (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )* otherlv_13= '>'
                    	            {
                    	            // InternalMetaData.g:7522:6: ( ( '<' )=>otherlv_9= '<' )
                    	            // InternalMetaData.g:7523:7: ( '<' )=>otherlv_9= '<'
                    	            {
                    	            otherlv_9=(Token)match(input,56,FOLLOW_55); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              							newLeafNode(otherlv_9, grammarAccess.getJvmParameterizedTypeReferenceAccess().getLessThanSignKeyword_1_4_2_0());
                    	              						
                    	            }

                    	            }

                    	            // InternalMetaData.g:7529:6: ( (lv_arguments_10_0= ruleJvmArgumentTypeReference ) )
                    	            // InternalMetaData.g:7530:7: (lv_arguments_10_0= ruleJvmArgumentTypeReference )
                    	            {
                    	            // InternalMetaData.g:7530:7: (lv_arguments_10_0= ruleJvmArgumentTypeReference )
                    	            // InternalMetaData.g:7531:8: lv_arguments_10_0= ruleJvmArgumentTypeReference
                    	            {
                    	            if ( state.backtracking==0 ) {

                    	              								newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getArgumentsJvmArgumentTypeReferenceParserRuleCall_1_4_2_1_0());
                    	              							
                    	            }
                    	            pushFollow(FOLLOW_56);
                    	            lv_arguments_10_0=ruleJvmArgumentTypeReference();

                    	            state._fsp--;
                    	            if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              								if (current==null) {
                    	              									current = createModelElementForParent(grammarAccess.getJvmParameterizedTypeReferenceRule());
                    	              								}
                    	              								add(
                    	              									current,
                    	              									"arguments",
                    	              									lv_arguments_10_0,
                    	              									"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                    	              								afterParserOrEnumRuleCall();
                    	              							
                    	            }

                    	            }


                    	            }

                    	            // InternalMetaData.g:7548:6: (otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) ) )*
                    	            loop126:
                    	            do {
                    	                int alt126=2;
                    	                int LA126_0 = input.LA(1);

                    	                if ( (LA126_0==36) ) {
                    	                    alt126=1;
                    	                }


                    	                switch (alt126) {
                    	            	case 1 :
                    	            	    // InternalMetaData.g:7549:7: otherlv_11= ',' ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) )
                    	            	    {
                    	            	    otherlv_11=(Token)match(input,36,FOLLOW_55); if (state.failed) return current;
                    	            	    if ( state.backtracking==0 ) {

                    	            	      							newLeafNode(otherlv_11, grammarAccess.getJvmParameterizedTypeReferenceAccess().getCommaKeyword_1_4_2_2_0());
                    	            	      						
                    	            	    }
                    	            	    // InternalMetaData.g:7553:7: ( (lv_arguments_12_0= ruleJvmArgumentTypeReference ) )
                    	            	    // InternalMetaData.g:7554:8: (lv_arguments_12_0= ruleJvmArgumentTypeReference )
                    	            	    {
                    	            	    // InternalMetaData.g:7554:8: (lv_arguments_12_0= ruleJvmArgumentTypeReference )
                    	            	    // InternalMetaData.g:7555:9: lv_arguments_12_0= ruleJvmArgumentTypeReference
                    	            	    {
                    	            	    if ( state.backtracking==0 ) {

                    	            	      									newCompositeNode(grammarAccess.getJvmParameterizedTypeReferenceAccess().getArgumentsJvmArgumentTypeReferenceParserRuleCall_1_4_2_2_1_0());
                    	            	      								
                    	            	    }
                    	            	    pushFollow(FOLLOW_56);
                    	            	    lv_arguments_12_0=ruleJvmArgumentTypeReference();

                    	            	    state._fsp--;
                    	            	    if (state.failed) return current;
                    	            	    if ( state.backtracking==0 ) {

                    	            	      									if (current==null) {
                    	            	      										current = createModelElementForParent(grammarAccess.getJvmParameterizedTypeReferenceRule());
                    	            	      									}
                    	            	      									add(
                    	            	      										current,
                    	            	      										"arguments",
                    	            	      										lv_arguments_12_0,
                    	            	      										"org.eclipse.xtext.xbase.Xtype.JvmArgumentTypeReference");
                    	            	      									afterParserOrEnumRuleCall();
                    	            	      								
                    	            	    }

                    	            	    }


                    	            	    }


                    	            	    }
                    	            	    break;

                    	            	default :
                    	            	    break loop126;
                    	                }
                    	            } while (true);

                    	            otherlv_13=(Token)match(input,57,FOLLOW_96); if (state.failed) return current;
                    	            if ( state.backtracking==0 ) {

                    	              						newLeafNode(otherlv_13, grammarAccess.getJvmParameterizedTypeReferenceAccess().getGreaterThanSignKeyword_1_4_2_3());
                    	              					
                    	            }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop128;
                        }
                    } while (true);


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmParameterizedTypeReference"


    // $ANTLR start "entryRuleJvmArgumentTypeReference"
    // InternalMetaData.g:7584:1: entryRuleJvmArgumentTypeReference returns [EObject current=null] : iv_ruleJvmArgumentTypeReference= ruleJvmArgumentTypeReference EOF ;
    public final EObject entryRuleJvmArgumentTypeReference() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmArgumentTypeReference = null;


        try {
            // InternalMetaData.g:7584:65: (iv_ruleJvmArgumentTypeReference= ruleJvmArgumentTypeReference EOF )
            // InternalMetaData.g:7585:2: iv_ruleJvmArgumentTypeReference= ruleJvmArgumentTypeReference EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmArgumentTypeReferenceRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmArgumentTypeReference=ruleJvmArgumentTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmArgumentTypeReference; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmArgumentTypeReference"


    // $ANTLR start "ruleJvmArgumentTypeReference"
    // InternalMetaData.g:7591:1: ruleJvmArgumentTypeReference returns [EObject current=null] : (this_JvmTypeReference_0= ruleJvmTypeReference | this_JvmWildcardTypeReference_1= ruleJvmWildcardTypeReference ) ;
    public final EObject ruleJvmArgumentTypeReference() throws RecognitionException {
        EObject current = null;

        EObject this_JvmTypeReference_0 = null;

        EObject this_JvmWildcardTypeReference_1 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7597:2: ( (this_JvmTypeReference_0= ruleJvmTypeReference | this_JvmWildcardTypeReference_1= ruleJvmWildcardTypeReference ) )
            // InternalMetaData.g:7598:2: (this_JvmTypeReference_0= ruleJvmTypeReference | this_JvmWildcardTypeReference_1= ruleJvmWildcardTypeReference )
            {
            // InternalMetaData.g:7598:2: (this_JvmTypeReference_0= ruleJvmTypeReference | this_JvmWildcardTypeReference_1= ruleJvmWildcardTypeReference )
            int alt130=2;
            int LA130_0 = input.LA(1);

            if ( (LA130_0==RULE_ID||LA130_0==41||LA130_0==68) ) {
                alt130=1;
            }
            else if ( (LA130_0==111) ) {
                alt130=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 130, 0, input);

                throw nvae;
            }
            switch (alt130) {
                case 1 :
                    // InternalMetaData.g:7599:3: this_JvmTypeReference_0= ruleJvmTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getJvmArgumentTypeReferenceAccess().getJvmTypeReferenceParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JvmTypeReference_0=ruleJvmTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JvmTypeReference_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    // InternalMetaData.g:7608:3: this_JvmWildcardTypeReference_1= ruleJvmWildcardTypeReference
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getJvmArgumentTypeReferenceAccess().getJvmWildcardTypeReferenceParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JvmWildcardTypeReference_1=ruleJvmWildcardTypeReference();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JvmWildcardTypeReference_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmArgumentTypeReference"


    // $ANTLR start "entryRuleJvmWildcardTypeReference"
    // InternalMetaData.g:7620:1: entryRuleJvmWildcardTypeReference returns [EObject current=null] : iv_ruleJvmWildcardTypeReference= ruleJvmWildcardTypeReference EOF ;
    public final EObject entryRuleJvmWildcardTypeReference() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmWildcardTypeReference = null;


        try {
            // InternalMetaData.g:7620:65: (iv_ruleJvmWildcardTypeReference= ruleJvmWildcardTypeReference EOF )
            // InternalMetaData.g:7621:2: iv_ruleJvmWildcardTypeReference= ruleJvmWildcardTypeReference EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmWildcardTypeReferenceRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmWildcardTypeReference=ruleJvmWildcardTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmWildcardTypeReference; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmWildcardTypeReference"


    // $ANTLR start "ruleJvmWildcardTypeReference"
    // InternalMetaData.g:7627:1: ruleJvmWildcardTypeReference returns [EObject current=null] : ( () otherlv_1= '?' ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )? ) ;
    public final EObject ruleJvmWildcardTypeReference() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_constraints_2_0 = null;

        EObject lv_constraints_3_0 = null;

        EObject lv_constraints_4_0 = null;

        EObject lv_constraints_5_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7633:2: ( ( () otherlv_1= '?' ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )? ) )
            // InternalMetaData.g:7634:2: ( () otherlv_1= '?' ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )? )
            {
            // InternalMetaData.g:7634:2: ( () otherlv_1= '?' ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )? )
            // InternalMetaData.g:7635:3: () otherlv_1= '?' ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )?
            {
            // InternalMetaData.g:7635:3: ()
            // InternalMetaData.g:7636:4: 
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getJvmWildcardTypeReferenceAccess().getJvmWildcardTypeReferenceAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,111,FOLLOW_102); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getJvmWildcardTypeReferenceAccess().getQuestionMarkKeyword_1());
              		
            }
            // InternalMetaData.g:7646:3: ( ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* ) | ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* ) )?
            int alt133=3;
            int LA133_0 = input.LA(1);

            if ( (LA133_0==95) ) {
                alt133=1;
            }
            else if ( (LA133_0==99) ) {
                alt133=2;
            }
            switch (alt133) {
                case 1 :
                    // InternalMetaData.g:7647:4: ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* )
                    {
                    // InternalMetaData.g:7647:4: ( ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )* )
                    // InternalMetaData.g:7648:5: ( (lv_constraints_2_0= ruleJvmUpperBound ) ) ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )*
                    {
                    // InternalMetaData.g:7648:5: ( (lv_constraints_2_0= ruleJvmUpperBound ) )
                    // InternalMetaData.g:7649:6: (lv_constraints_2_0= ruleJvmUpperBound )
                    {
                    // InternalMetaData.g:7649:6: (lv_constraints_2_0= ruleJvmUpperBound )
                    // InternalMetaData.g:7650:7: lv_constraints_2_0= ruleJvmUpperBound
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getJvmWildcardTypeReferenceAccess().getConstraintsJvmUpperBoundParserRuleCall_2_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_103);
                    lv_constraints_2_0=ruleJvmUpperBound();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getJvmWildcardTypeReferenceRule());
                      							}
                      							add(
                      								current,
                      								"constraints",
                      								lv_constraints_2_0,
                      								"org.eclipse.xtext.xbase.Xtype.JvmUpperBound");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    // InternalMetaData.g:7667:5: ( (lv_constraints_3_0= ruleJvmUpperBoundAnded ) )*
                    loop131:
                    do {
                        int alt131=2;
                        int LA131_0 = input.LA(1);

                        if ( (LA131_0==112) ) {
                            alt131=1;
                        }


                        switch (alt131) {
                    	case 1 :
                    	    // InternalMetaData.g:7668:6: (lv_constraints_3_0= ruleJvmUpperBoundAnded )
                    	    {
                    	    // InternalMetaData.g:7668:6: (lv_constraints_3_0= ruleJvmUpperBoundAnded )
                    	    // InternalMetaData.g:7669:7: lv_constraints_3_0= ruleJvmUpperBoundAnded
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getJvmWildcardTypeReferenceAccess().getConstraintsJvmUpperBoundAndedParserRuleCall_2_0_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_103);
                    	    lv_constraints_3_0=ruleJvmUpperBoundAnded();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getJvmWildcardTypeReferenceRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"constraints",
                    	      								lv_constraints_3_0,
                    	      								"org.eclipse.xtext.xbase.Xtype.JvmUpperBoundAnded");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop131;
                        }
                    } while (true);


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:7688:4: ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* )
                    {
                    // InternalMetaData.g:7688:4: ( ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )* )
                    // InternalMetaData.g:7689:5: ( (lv_constraints_4_0= ruleJvmLowerBound ) ) ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )*
                    {
                    // InternalMetaData.g:7689:5: ( (lv_constraints_4_0= ruleJvmLowerBound ) )
                    // InternalMetaData.g:7690:6: (lv_constraints_4_0= ruleJvmLowerBound )
                    {
                    // InternalMetaData.g:7690:6: (lv_constraints_4_0= ruleJvmLowerBound )
                    // InternalMetaData.g:7691:7: lv_constraints_4_0= ruleJvmLowerBound
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getJvmWildcardTypeReferenceAccess().getConstraintsJvmLowerBoundParserRuleCall_2_1_0_0());
                      						
                    }
                    pushFollow(FOLLOW_103);
                    lv_constraints_4_0=ruleJvmLowerBound();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getJvmWildcardTypeReferenceRule());
                      							}
                      							add(
                      								current,
                      								"constraints",
                      								lv_constraints_4_0,
                      								"org.eclipse.xtext.xbase.Xtype.JvmLowerBound");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    // InternalMetaData.g:7708:5: ( (lv_constraints_5_0= ruleJvmLowerBoundAnded ) )*
                    loop132:
                    do {
                        int alt132=2;
                        int LA132_0 = input.LA(1);

                        if ( (LA132_0==112) ) {
                            alt132=1;
                        }


                        switch (alt132) {
                    	case 1 :
                    	    // InternalMetaData.g:7709:6: (lv_constraints_5_0= ruleJvmLowerBoundAnded )
                    	    {
                    	    // InternalMetaData.g:7709:6: (lv_constraints_5_0= ruleJvmLowerBoundAnded )
                    	    // InternalMetaData.g:7710:7: lv_constraints_5_0= ruleJvmLowerBoundAnded
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getJvmWildcardTypeReferenceAccess().getConstraintsJvmLowerBoundAndedParserRuleCall_2_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_103);
                    	    lv_constraints_5_0=ruleJvmLowerBoundAnded();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getJvmWildcardTypeReferenceRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"constraints",
                    	      								lv_constraints_5_0,
                    	      								"org.eclipse.xtext.xbase.Xtype.JvmLowerBoundAnded");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop132;
                        }
                    } while (true);


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmWildcardTypeReference"


    // $ANTLR start "entryRuleJvmUpperBound"
    // InternalMetaData.g:7733:1: entryRuleJvmUpperBound returns [EObject current=null] : iv_ruleJvmUpperBound= ruleJvmUpperBound EOF ;
    public final EObject entryRuleJvmUpperBound() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmUpperBound = null;


        try {
            // InternalMetaData.g:7733:54: (iv_ruleJvmUpperBound= ruleJvmUpperBound EOF )
            // InternalMetaData.g:7734:2: iv_ruleJvmUpperBound= ruleJvmUpperBound EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmUpperBoundRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmUpperBound=ruleJvmUpperBound();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmUpperBound; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmUpperBound"


    // $ANTLR start "ruleJvmUpperBound"
    // InternalMetaData.g:7740:1: ruleJvmUpperBound returns [EObject current=null] : (otherlv_0= 'extends' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) ;
    public final EObject ruleJvmUpperBound() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_typeReference_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7746:2: ( (otherlv_0= 'extends' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) )
            // InternalMetaData.g:7747:2: (otherlv_0= 'extends' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            {
            // InternalMetaData.g:7747:2: (otherlv_0= 'extends' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            // InternalMetaData.g:7748:3: otherlv_0= 'extends' ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            {
            otherlv_0=(Token)match(input,95,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getJvmUpperBoundAccess().getExtendsKeyword_0());
              		
            }
            // InternalMetaData.g:7752:3: ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:7753:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:7753:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            // InternalMetaData.g:7754:5: lv_typeReference_1_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmUpperBoundAccess().getTypeReferenceJvmTypeReferenceParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_typeReference_1_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getJvmUpperBoundRule());
              					}
              					set(
              						current,
              						"typeReference",
              						lv_typeReference_1_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmUpperBound"


    // $ANTLR start "entryRuleJvmUpperBoundAnded"
    // InternalMetaData.g:7775:1: entryRuleJvmUpperBoundAnded returns [EObject current=null] : iv_ruleJvmUpperBoundAnded= ruleJvmUpperBoundAnded EOF ;
    public final EObject entryRuleJvmUpperBoundAnded() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmUpperBoundAnded = null;


        try {
            // InternalMetaData.g:7775:59: (iv_ruleJvmUpperBoundAnded= ruleJvmUpperBoundAnded EOF )
            // InternalMetaData.g:7776:2: iv_ruleJvmUpperBoundAnded= ruleJvmUpperBoundAnded EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmUpperBoundAndedRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmUpperBoundAnded=ruleJvmUpperBoundAnded();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmUpperBoundAnded; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmUpperBoundAnded"


    // $ANTLR start "ruleJvmUpperBoundAnded"
    // InternalMetaData.g:7782:1: ruleJvmUpperBoundAnded returns [EObject current=null] : (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) ;
    public final EObject ruleJvmUpperBoundAnded() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_typeReference_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7788:2: ( (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) )
            // InternalMetaData.g:7789:2: (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            {
            // InternalMetaData.g:7789:2: (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            // InternalMetaData.g:7790:3: otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            {
            otherlv_0=(Token)match(input,112,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getJvmUpperBoundAndedAccess().getAmpersandKeyword_0());
              		
            }
            // InternalMetaData.g:7794:3: ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:7795:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:7795:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            // InternalMetaData.g:7796:5: lv_typeReference_1_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmUpperBoundAndedAccess().getTypeReferenceJvmTypeReferenceParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_typeReference_1_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getJvmUpperBoundAndedRule());
              					}
              					set(
              						current,
              						"typeReference",
              						lv_typeReference_1_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmUpperBoundAnded"


    // $ANTLR start "entryRuleJvmLowerBound"
    // InternalMetaData.g:7817:1: entryRuleJvmLowerBound returns [EObject current=null] : iv_ruleJvmLowerBound= ruleJvmLowerBound EOF ;
    public final EObject entryRuleJvmLowerBound() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmLowerBound = null;


        try {
            // InternalMetaData.g:7817:54: (iv_ruleJvmLowerBound= ruleJvmLowerBound EOF )
            // InternalMetaData.g:7818:2: iv_ruleJvmLowerBound= ruleJvmLowerBound EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmLowerBoundRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmLowerBound=ruleJvmLowerBound();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmLowerBound; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmLowerBound"


    // $ANTLR start "ruleJvmLowerBound"
    // InternalMetaData.g:7824:1: ruleJvmLowerBound returns [EObject current=null] : (otherlv_0= 'super' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) ;
    public final EObject ruleJvmLowerBound() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_typeReference_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7830:2: ( (otherlv_0= 'super' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) )
            // InternalMetaData.g:7831:2: (otherlv_0= 'super' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            {
            // InternalMetaData.g:7831:2: (otherlv_0= 'super' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            // InternalMetaData.g:7832:3: otherlv_0= 'super' ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            {
            otherlv_0=(Token)match(input,99,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getJvmLowerBoundAccess().getSuperKeyword_0());
              		
            }
            // InternalMetaData.g:7836:3: ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:7837:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:7837:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            // InternalMetaData.g:7838:5: lv_typeReference_1_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmLowerBoundAccess().getTypeReferenceJvmTypeReferenceParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_typeReference_1_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getJvmLowerBoundRule());
              					}
              					set(
              						current,
              						"typeReference",
              						lv_typeReference_1_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmLowerBound"


    // $ANTLR start "entryRuleJvmLowerBoundAnded"
    // InternalMetaData.g:7859:1: entryRuleJvmLowerBoundAnded returns [EObject current=null] : iv_ruleJvmLowerBoundAnded= ruleJvmLowerBoundAnded EOF ;
    public final EObject entryRuleJvmLowerBoundAnded() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleJvmLowerBoundAnded = null;


        try {
            // InternalMetaData.g:7859:59: (iv_ruleJvmLowerBoundAnded= ruleJvmLowerBoundAnded EOF )
            // InternalMetaData.g:7860:2: iv_ruleJvmLowerBoundAnded= ruleJvmLowerBoundAnded EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getJvmLowerBoundAndedRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleJvmLowerBoundAnded=ruleJvmLowerBoundAnded();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleJvmLowerBoundAnded; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleJvmLowerBoundAnded"


    // $ANTLR start "ruleJvmLowerBoundAnded"
    // InternalMetaData.g:7866:1: ruleJvmLowerBoundAnded returns [EObject current=null] : (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) ;
    public final EObject ruleJvmLowerBoundAnded() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_typeReference_1_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7872:2: ( (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) ) )
            // InternalMetaData.g:7873:2: (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            {
            // InternalMetaData.g:7873:2: (otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) ) )
            // InternalMetaData.g:7874:3: otherlv_0= '&' ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            {
            otherlv_0=(Token)match(input,112,FOLLOW_15); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getJvmLowerBoundAndedAccess().getAmpersandKeyword_0());
              		
            }
            // InternalMetaData.g:7878:3: ( (lv_typeReference_1_0= ruleJvmTypeReference ) )
            // InternalMetaData.g:7879:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            {
            // InternalMetaData.g:7879:4: (lv_typeReference_1_0= ruleJvmTypeReference )
            // InternalMetaData.g:7880:5: lv_typeReference_1_0= ruleJvmTypeReference
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getJvmLowerBoundAndedAccess().getTypeReferenceJvmTypeReferenceParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_typeReference_1_0=ruleJvmTypeReference();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getJvmLowerBoundAndedRule());
              					}
              					set(
              						current,
              						"typeReference",
              						lv_typeReference_1_0,
              						"org.eclipse.xtext.xbase.Xtype.JvmTypeReference");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleJvmLowerBoundAnded"


    // $ANTLR start "entryRuleQualifiedNameWithWildcard"
    // InternalMetaData.g:7901:1: entryRuleQualifiedNameWithWildcard returns [String current=null] : iv_ruleQualifiedNameWithWildcard= ruleQualifiedNameWithWildcard EOF ;
    public final String entryRuleQualifiedNameWithWildcard() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleQualifiedNameWithWildcard = null;


        try {
            // InternalMetaData.g:7901:65: (iv_ruleQualifiedNameWithWildcard= ruleQualifiedNameWithWildcard EOF )
            // InternalMetaData.g:7902:2: iv_ruleQualifiedNameWithWildcard= ruleQualifiedNameWithWildcard EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getQualifiedNameWithWildcardRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleQualifiedNameWithWildcard=ruleQualifiedNameWithWildcard();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleQualifiedNameWithWildcard.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleQualifiedNameWithWildcard"


    // $ANTLR start "ruleQualifiedNameWithWildcard"
    // InternalMetaData.g:7908:1: ruleQualifiedNameWithWildcard returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_QualifiedName_0= ruleQualifiedName kw= '.' kw= '*' ) ;
    public final AntlrDatatypeRuleToken ruleQualifiedNameWithWildcard() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_QualifiedName_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7914:2: ( (this_QualifiedName_0= ruleQualifiedName kw= '.' kw= '*' ) )
            // InternalMetaData.g:7915:2: (this_QualifiedName_0= ruleQualifiedName kw= '.' kw= '*' )
            {
            // InternalMetaData.g:7915:2: (this_QualifiedName_0= ruleQualifiedName kw= '.' kw= '*' )
            // InternalMetaData.g:7916:3: this_QualifiedName_0= ruleQualifiedName kw= '.' kw= '*'
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getQualifiedNameWithWildcardAccess().getQualifiedNameParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_104);
            this_QualifiedName_0=ruleQualifiedName();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(this_QualifiedName_0);
              		
            }
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }
            kw=(Token)match(input,79,FOLLOW_105); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(kw);
              			newLeafNode(kw, grammarAccess.getQualifiedNameWithWildcardAccess().getFullStopKeyword_1());
              		
            }
            kw=(Token)match(input,72,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current.merge(kw);
              			newLeafNode(kw, grammarAccess.getQualifiedNameWithWildcardAccess().getAsteriskKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleQualifiedNameWithWildcard"


    // $ANTLR start "entryRuleValidID"
    // InternalMetaData.g:7940:1: entryRuleValidID returns [String current=null] : iv_ruleValidID= ruleValidID EOF ;
    public final String entryRuleValidID() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleValidID = null;


        try {
            // InternalMetaData.g:7940:47: (iv_ruleValidID= ruleValidID EOF )
            // InternalMetaData.g:7941:2: iv_ruleValidID= ruleValidID EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getValidIDRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleValidID=ruleValidID();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleValidID.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleValidID"


    // $ANTLR start "ruleValidID"
    // InternalMetaData.g:7947:1: ruleValidID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : this_ID_0= RULE_ID ;
    public final AntlrDatatypeRuleToken ruleValidID() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_ID_0=null;


        	enterRule();

        try {
            // InternalMetaData.g:7953:2: (this_ID_0= RULE_ID )
            // InternalMetaData.g:7954:2: this_ID_0= RULE_ID
            {
            this_ID_0=(Token)match(input,RULE_ID,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_ID_0);
              	
            }
            if ( state.backtracking==0 ) {

              		newLeafNode(this_ID_0, grammarAccess.getValidIDAccess().getIDTerminalRuleCall());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleValidID"


    // $ANTLR start "entryRuleXImportSection"
    // InternalMetaData.g:7964:1: entryRuleXImportSection returns [EObject current=null] : iv_ruleXImportSection= ruleXImportSection EOF ;
    public final EObject entryRuleXImportSection() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXImportSection = null;


        try {
            // InternalMetaData.g:7964:55: (iv_ruleXImportSection= ruleXImportSection EOF )
            // InternalMetaData.g:7965:2: iv_ruleXImportSection= ruleXImportSection EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXImportSectionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXImportSection=ruleXImportSection();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXImportSection; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXImportSection"


    // $ANTLR start "ruleXImportSection"
    // InternalMetaData.g:7971:1: ruleXImportSection returns [EObject current=null] : ( (lv_importDeclarations_0_0= ruleXImportDeclaration ) )+ ;
    public final EObject ruleXImportSection() throws RecognitionException {
        EObject current = null;

        EObject lv_importDeclarations_0_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:7977:2: ( ( (lv_importDeclarations_0_0= ruleXImportDeclaration ) )+ )
            // InternalMetaData.g:7978:2: ( (lv_importDeclarations_0_0= ruleXImportDeclaration ) )+
            {
            // InternalMetaData.g:7978:2: ( (lv_importDeclarations_0_0= ruleXImportDeclaration ) )+
            int cnt134=0;
            loop134:
            do {
                int alt134=2;
                int LA134_0 = input.LA(1);

                if ( (LA134_0==97) ) {
                    alt134=1;
                }


                switch (alt134) {
            	case 1 :
            	    // InternalMetaData.g:7979:3: (lv_importDeclarations_0_0= ruleXImportDeclaration )
            	    {
            	    // InternalMetaData.g:7979:3: (lv_importDeclarations_0_0= ruleXImportDeclaration )
            	    // InternalMetaData.g:7980:4: lv_importDeclarations_0_0= ruleXImportDeclaration
            	    {
            	    if ( state.backtracking==0 ) {

            	      				newCompositeNode(grammarAccess.getXImportSectionAccess().getImportDeclarationsXImportDeclarationParserRuleCall_0());
            	      			
            	    }
            	    pushFollow(FOLLOW_106);
            	    lv_importDeclarations_0_0=ruleXImportDeclaration();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				if (current==null) {
            	      					current = createModelElementForParent(grammarAccess.getXImportSectionRule());
            	      				}
            	      				add(
            	      					current,
            	      					"importDeclarations",
            	      					lv_importDeclarations_0_0,
            	      					"org.eclipse.xtext.xbase.Xtype.XImportDeclaration");
            	      				afterParserOrEnumRuleCall();
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt134 >= 1 ) break loop134;
            	    if (state.backtracking>0) {state.failed=true; return current;}
                        EarlyExitException eee =
                            new EarlyExitException(134, input);
                        throw eee;
                }
                cnt134++;
            } while (true);


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXImportSection"


    // $ANTLR start "entryRuleXImportDeclaration"
    // InternalMetaData.g:8000:1: entryRuleXImportDeclaration returns [EObject current=null] : iv_ruleXImportDeclaration= ruleXImportDeclaration EOF ;
    public final EObject entryRuleXImportDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleXImportDeclaration = null;


        try {
            // InternalMetaData.g:8000:59: (iv_ruleXImportDeclaration= ruleXImportDeclaration EOF )
            // InternalMetaData.g:8001:2: iv_ruleXImportDeclaration= ruleXImportDeclaration EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getXImportDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleXImportDeclaration=ruleXImportDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleXImportDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleXImportDeclaration"


    // $ANTLR start "ruleXImportDeclaration"
    // InternalMetaData.g:8007:1: ruleXImportDeclaration returns [EObject current=null] : (otherlv_0= 'import' ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) ) (otherlv_8= ';' )? ) ;
    public final EObject ruleXImportDeclaration() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token lv_static_1_0=null;
        Token lv_extension_2_0=null;
        Token lv_wildcard_4_0=null;
        Token otherlv_8=null;
        AntlrDatatypeRuleToken lv_memberName_5_0 = null;

        AntlrDatatypeRuleToken lv_importedNamespace_7_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:8013:2: ( (otherlv_0= 'import' ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) ) (otherlv_8= ';' )? ) )
            // InternalMetaData.g:8014:2: (otherlv_0= 'import' ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) ) (otherlv_8= ';' )? )
            {
            // InternalMetaData.g:8014:2: (otherlv_0= 'import' ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) ) (otherlv_8= ';' )? )
            // InternalMetaData.g:8015:3: otherlv_0= 'import' ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) ) (otherlv_8= ';' )?
            {
            otherlv_0=(Token)match(input,97,FOLLOW_107); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getXImportDeclarationAccess().getImportKeyword_0());
              		
            }
            // InternalMetaData.g:8019:3: ( ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) ) | ( ( ruleQualifiedName ) ) | ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) ) )
            int alt137=3;
            alt137 = dfa137.predict(input);
            switch (alt137) {
                case 1 :
                    // InternalMetaData.g:8020:4: ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) )
                    {
                    // InternalMetaData.g:8020:4: ( ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) ) )
                    // InternalMetaData.g:8021:5: ( (lv_static_1_0= 'static' ) ) ( (lv_extension_2_0= 'extension' ) )? ( ( ruleQualifiedNameInStaticImport ) ) ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) )
                    {
                    // InternalMetaData.g:8021:5: ( (lv_static_1_0= 'static' ) )
                    // InternalMetaData.g:8022:6: (lv_static_1_0= 'static' )
                    {
                    // InternalMetaData.g:8022:6: (lv_static_1_0= 'static' )
                    // InternalMetaData.g:8023:7: lv_static_1_0= 'static'
                    {
                    lv_static_1_0=(Token)match(input,96,FOLLOW_108); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_static_1_0, grammarAccess.getXImportDeclarationAccess().getStaticStaticKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getXImportDeclarationRule());
                      							}
                      							setWithLastConsumed(current, "static", true, "static");
                      						
                    }

                    }


                    }

                    // InternalMetaData.g:8035:5: ( (lv_extension_2_0= 'extension' ) )?
                    int alt135=2;
                    int LA135_0 = input.LA(1);

                    if ( (LA135_0==98) ) {
                        alt135=1;
                    }
                    switch (alt135) {
                        case 1 :
                            // InternalMetaData.g:8036:6: (lv_extension_2_0= 'extension' )
                            {
                            // InternalMetaData.g:8036:6: (lv_extension_2_0= 'extension' )
                            // InternalMetaData.g:8037:7: lv_extension_2_0= 'extension'
                            {
                            lv_extension_2_0=(Token)match(input,98,FOLLOW_108); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(lv_extension_2_0, grammarAccess.getXImportDeclarationAccess().getExtensionExtensionKeyword_1_0_1_0());
                              						
                            }
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElement(grammarAccess.getXImportDeclarationRule());
                              							}
                              							setWithLastConsumed(current, "extension", true, "extension");
                              						
                            }

                            }


                            }
                            break;

                    }

                    // InternalMetaData.g:8049:5: ( ( ruleQualifiedNameInStaticImport ) )
                    // InternalMetaData.g:8050:6: ( ruleQualifiedNameInStaticImport )
                    {
                    // InternalMetaData.g:8050:6: ( ruleQualifiedNameInStaticImport )
                    // InternalMetaData.g:8051:7: ruleQualifiedNameInStaticImport
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getXImportDeclarationRule());
                      							}
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getXImportDeclarationAccess().getImportedTypeJvmDeclaredTypeCrossReference_1_0_2_0());
                      						
                    }
                    pushFollow(FOLLOW_109);
                    ruleQualifiedNameInStaticImport();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    // InternalMetaData.g:8065:5: ( ( (lv_wildcard_4_0= '*' ) ) | ( (lv_memberName_5_0= ruleValidID ) ) )
                    int alt136=2;
                    int LA136_0 = input.LA(1);

                    if ( (LA136_0==72) ) {
                        alt136=1;
                    }
                    else if ( (LA136_0==RULE_ID) ) {
                        alt136=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return current;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 136, 0, input);

                        throw nvae;
                    }
                    switch (alt136) {
                        case 1 :
                            // InternalMetaData.g:8066:6: ( (lv_wildcard_4_0= '*' ) )
                            {
                            // InternalMetaData.g:8066:6: ( (lv_wildcard_4_0= '*' ) )
                            // InternalMetaData.g:8067:7: (lv_wildcard_4_0= '*' )
                            {
                            // InternalMetaData.g:8067:7: (lv_wildcard_4_0= '*' )
                            // InternalMetaData.g:8068:8: lv_wildcard_4_0= '*'
                            {
                            lv_wildcard_4_0=(Token)match(input,72,FOLLOW_110); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								newLeafNode(lv_wildcard_4_0, grammarAccess.getXImportDeclarationAccess().getWildcardAsteriskKeyword_1_0_3_0_0());
                              							
                            }
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getXImportDeclarationRule());
                              								}
                              								setWithLastConsumed(current, "wildcard", true, "*");
                              							
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            // InternalMetaData.g:8081:6: ( (lv_memberName_5_0= ruleValidID ) )
                            {
                            // InternalMetaData.g:8081:6: ( (lv_memberName_5_0= ruleValidID ) )
                            // InternalMetaData.g:8082:7: (lv_memberName_5_0= ruleValidID )
                            {
                            // InternalMetaData.g:8082:7: (lv_memberName_5_0= ruleValidID )
                            // InternalMetaData.g:8083:8: lv_memberName_5_0= ruleValidID
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getXImportDeclarationAccess().getMemberNameValidIDParserRuleCall_1_0_3_1_0());
                              							
                            }
                            pushFollow(FOLLOW_110);
                            lv_memberName_5_0=ruleValidID();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getXImportDeclarationRule());
                              								}
                              								set(
                              									current,
                              									"memberName",
                              									lv_memberName_5_0,
                              									"org.eclipse.xtext.xbase.Xtype.ValidID");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:8103:4: ( ( ruleQualifiedName ) )
                    {
                    // InternalMetaData.g:8103:4: ( ( ruleQualifiedName ) )
                    // InternalMetaData.g:8104:5: ( ruleQualifiedName )
                    {
                    // InternalMetaData.g:8104:5: ( ruleQualifiedName )
                    // InternalMetaData.g:8105:6: ruleQualifiedName
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getXImportDeclarationRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXImportDeclarationAccess().getImportedTypeJvmDeclaredTypeCrossReference_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_110);
                    ruleQualifiedName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:8120:4: ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) )
                    {
                    // InternalMetaData.g:8120:4: ( (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard ) )
                    // InternalMetaData.g:8121:5: (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard )
                    {
                    // InternalMetaData.g:8121:5: (lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard )
                    // InternalMetaData.g:8122:6: lv_importedNamespace_7_0= ruleQualifiedNameWithWildcard
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getXImportDeclarationAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_2_0());
                      					
                    }
                    pushFollow(FOLLOW_110);
                    lv_importedNamespace_7_0=ruleQualifiedNameWithWildcard();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getXImportDeclarationRule());
                      						}
                      						set(
                      							current,
                      							"importedNamespace",
                      							lv_importedNamespace_7_0,
                      							"org.eclipse.xtext.xbase.Xtype.QualifiedNameWithWildcard");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }

            // InternalMetaData.g:8140:3: (otherlv_8= ';' )?
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==85) ) {
                alt138=1;
            }
            switch (alt138) {
                case 1 :
                    // InternalMetaData.g:8141:4: otherlv_8= ';'
                    {
                    otherlv_8=(Token)match(input,85,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_8, grammarAccess.getXImportDeclarationAccess().getSemicolonKeyword_2());
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleXImportDeclaration"


    // $ANTLR start "entryRuleQualifiedNameInStaticImport"
    // InternalMetaData.g:8150:1: entryRuleQualifiedNameInStaticImport returns [String current=null] : iv_ruleQualifiedNameInStaticImport= ruleQualifiedNameInStaticImport EOF ;
    public final String entryRuleQualifiedNameInStaticImport() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleQualifiedNameInStaticImport = null;


        try {
            // InternalMetaData.g:8150:67: (iv_ruleQualifiedNameInStaticImport= ruleQualifiedNameInStaticImport EOF )
            // InternalMetaData.g:8151:2: iv_ruleQualifiedNameInStaticImport= ruleQualifiedNameInStaticImport EOF
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getQualifiedNameInStaticImportRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleQualifiedNameInStaticImport=ruleQualifiedNameInStaticImport();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleQualifiedNameInStaticImport.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "entryRuleQualifiedNameInStaticImport"


    // $ANTLR start "ruleQualifiedNameInStaticImport"
    // InternalMetaData.g:8157:1: ruleQualifiedNameInStaticImport returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()] : (this_ValidID_0= ruleValidID kw= '.' )+ ;
    public final AntlrDatatypeRuleToken ruleQualifiedNameInStaticImport() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;
        AntlrDatatypeRuleToken this_ValidID_0 = null;



        	enterRule();

        try {
            // InternalMetaData.g:8163:2: ( (this_ValidID_0= ruleValidID kw= '.' )+ )
            // InternalMetaData.g:8164:2: (this_ValidID_0= ruleValidID kw= '.' )+
            {
            // InternalMetaData.g:8164:2: (this_ValidID_0= ruleValidID kw= '.' )+
            int cnt139=0;
            loop139:
            do {
                int alt139=2;
                int LA139_0 = input.LA(1);

                if ( (LA139_0==RULE_ID) ) {
                    int LA139_2 = input.LA(2);

                    if ( (LA139_2==79) ) {
                        alt139=1;
                    }


                }


                switch (alt139) {
            	case 1 :
            	    // InternalMetaData.g:8165:3: this_ValidID_0= ruleValidID kw= '.'
            	    {
            	    if ( state.backtracking==0 ) {

            	      			newCompositeNode(grammarAccess.getQualifiedNameInStaticImportAccess().getValidIDParserRuleCall_0());
            	      		
            	    }
            	    pushFollow(FOLLOW_104);
            	    this_ValidID_0=ruleValidID();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      			current.merge(this_ValidID_0);
            	      		
            	    }
            	    if ( state.backtracking==0 ) {

            	      			afterParserOrEnumRuleCall();
            	      		
            	    }
            	    kw=(Token)match(input,79,FOLLOW_111); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      			current.merge(kw);
            	      			newLeafNode(kw, grammarAccess.getQualifiedNameInStaticImportAccess().getFullStopKeyword_1());
            	      		
            	    }

            	    }
            	    break;

            	default :
            	    if ( cnt139 >= 1 ) break loop139;
            	    if (state.backtracking>0) {state.failed=true; return current;}
                        EarlyExitException eee =
                            new EarlyExitException(139, input);
                        throw eee;
                }
                cnt139++;
            } while (true);


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleQualifiedNameInStaticImport"


    // $ANTLR start "ruleMdOptionTargetType"
    // InternalMetaData.g:8184:1: ruleMdOptionTargetType returns [Enumerator current=null] : ( (enumLiteral_0= 'parents' ) | (enumLiteral_1= 'nodes' ) | (enumLiteral_2= 'edges' ) | (enumLiteral_3= 'ports' ) | (enumLiteral_4= 'labels' ) ) ;
    public final Enumerator ruleMdOptionTargetType() throws RecognitionException {
        Enumerator current = null;

        Token enumLiteral_0=null;
        Token enumLiteral_1=null;
        Token enumLiteral_2=null;
        Token enumLiteral_3=null;
        Token enumLiteral_4=null;


        	enterRule();

        try {
            // InternalMetaData.g:8190:2: ( ( (enumLiteral_0= 'parents' ) | (enumLiteral_1= 'nodes' ) | (enumLiteral_2= 'edges' ) | (enumLiteral_3= 'ports' ) | (enumLiteral_4= 'labels' ) ) )
            // InternalMetaData.g:8191:2: ( (enumLiteral_0= 'parents' ) | (enumLiteral_1= 'nodes' ) | (enumLiteral_2= 'edges' ) | (enumLiteral_3= 'ports' ) | (enumLiteral_4= 'labels' ) )
            {
            // InternalMetaData.g:8191:2: ( (enumLiteral_0= 'parents' ) | (enumLiteral_1= 'nodes' ) | (enumLiteral_2= 'edges' ) | (enumLiteral_3= 'ports' ) | (enumLiteral_4= 'labels' ) )
            int alt140=5;
            switch ( input.LA(1) ) {
            case 113:
                {
                alt140=1;
                }
                break;
            case 114:
                {
                alt140=2;
                }
                break;
            case 115:
                {
                alt140=3;
                }
                break;
            case 116:
                {
                alt140=4;
                }
                break;
            case 117:
                {
                alt140=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 140, 0, input);

                throw nvae;
            }

            switch (alt140) {
                case 1 :
                    // InternalMetaData.g:8192:3: (enumLiteral_0= 'parents' )
                    {
                    // InternalMetaData.g:8192:3: (enumLiteral_0= 'parents' )
                    // InternalMetaData.g:8193:4: enumLiteral_0= 'parents'
                    {
                    enumLiteral_0=(Token)match(input,113,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdOptionTargetTypeAccess().getParentsEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_0, grammarAccess.getMdOptionTargetTypeAccess().getParentsEnumLiteralDeclaration_0());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:8200:3: (enumLiteral_1= 'nodes' )
                    {
                    // InternalMetaData.g:8200:3: (enumLiteral_1= 'nodes' )
                    // InternalMetaData.g:8201:4: enumLiteral_1= 'nodes'
                    {
                    enumLiteral_1=(Token)match(input,114,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdOptionTargetTypeAccess().getNodesEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_1, grammarAccess.getMdOptionTargetTypeAccess().getNodesEnumLiteralDeclaration_1());
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:8208:3: (enumLiteral_2= 'edges' )
                    {
                    // InternalMetaData.g:8208:3: (enumLiteral_2= 'edges' )
                    // InternalMetaData.g:8209:4: enumLiteral_2= 'edges'
                    {
                    enumLiteral_2=(Token)match(input,115,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdOptionTargetTypeAccess().getEdgesEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_2, grammarAccess.getMdOptionTargetTypeAccess().getEdgesEnumLiteralDeclaration_2());
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    // InternalMetaData.g:8216:3: (enumLiteral_3= 'ports' )
                    {
                    // InternalMetaData.g:8216:3: (enumLiteral_3= 'ports' )
                    // InternalMetaData.g:8217:4: enumLiteral_3= 'ports'
                    {
                    enumLiteral_3=(Token)match(input,116,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdOptionTargetTypeAccess().getPortsEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_3, grammarAccess.getMdOptionTargetTypeAccess().getPortsEnumLiteralDeclaration_3());
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    // InternalMetaData.g:8224:3: (enumLiteral_4= 'labels' )
                    {
                    // InternalMetaData.g:8224:3: (enumLiteral_4= 'labels' )
                    // InternalMetaData.g:8225:4: enumLiteral_4= 'labels'
                    {
                    enumLiteral_4=(Token)match(input,117,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdOptionTargetTypeAccess().getLabelsEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_4, grammarAccess.getMdOptionTargetTypeAccess().getLabelsEnumLiteralDeclaration_4());
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdOptionTargetType"


    // $ANTLR start "ruleMdGraphFeature"
    // InternalMetaData.g:8235:1: ruleMdGraphFeature returns [Enumerator current=null] : ( (enumLiteral_0= 'self_loops' ) | (enumLiteral_1= 'inside_self_loops' ) | (enumLiteral_2= 'multi_edges' ) | (enumLiteral_3= 'edge_labels' ) | (enumLiteral_4= 'ports' ) | (enumLiteral_5= 'compound' ) | (enumLiteral_6= 'clusters' ) | (enumLiteral_7= 'disconnected' ) ) ;
    public final Enumerator ruleMdGraphFeature() throws RecognitionException {
        Enumerator current = null;

        Token enumLiteral_0=null;
        Token enumLiteral_1=null;
        Token enumLiteral_2=null;
        Token enumLiteral_3=null;
        Token enumLiteral_4=null;
        Token enumLiteral_5=null;
        Token enumLiteral_6=null;
        Token enumLiteral_7=null;


        	enterRule();

        try {
            // InternalMetaData.g:8241:2: ( ( (enumLiteral_0= 'self_loops' ) | (enumLiteral_1= 'inside_self_loops' ) | (enumLiteral_2= 'multi_edges' ) | (enumLiteral_3= 'edge_labels' ) | (enumLiteral_4= 'ports' ) | (enumLiteral_5= 'compound' ) | (enumLiteral_6= 'clusters' ) | (enumLiteral_7= 'disconnected' ) ) )
            // InternalMetaData.g:8242:2: ( (enumLiteral_0= 'self_loops' ) | (enumLiteral_1= 'inside_self_loops' ) | (enumLiteral_2= 'multi_edges' ) | (enumLiteral_3= 'edge_labels' ) | (enumLiteral_4= 'ports' ) | (enumLiteral_5= 'compound' ) | (enumLiteral_6= 'clusters' ) | (enumLiteral_7= 'disconnected' ) )
            {
            // InternalMetaData.g:8242:2: ( (enumLiteral_0= 'self_loops' ) | (enumLiteral_1= 'inside_self_loops' ) | (enumLiteral_2= 'multi_edges' ) | (enumLiteral_3= 'edge_labels' ) | (enumLiteral_4= 'ports' ) | (enumLiteral_5= 'compound' ) | (enumLiteral_6= 'clusters' ) | (enumLiteral_7= 'disconnected' ) )
            int alt141=8;
            switch ( input.LA(1) ) {
            case 118:
                {
                alt141=1;
                }
                break;
            case 119:
                {
                alt141=2;
                }
                break;
            case 120:
                {
                alt141=3;
                }
                break;
            case 121:
                {
                alt141=4;
                }
                break;
            case 116:
                {
                alt141=5;
                }
                break;
            case 122:
                {
                alt141=6;
                }
                break;
            case 123:
                {
                alt141=7;
                }
                break;
            case 124:
                {
                alt141=8;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 141, 0, input);

                throw nvae;
            }

            switch (alt141) {
                case 1 :
                    // InternalMetaData.g:8243:3: (enumLiteral_0= 'self_loops' )
                    {
                    // InternalMetaData.g:8243:3: (enumLiteral_0= 'self_loops' )
                    // InternalMetaData.g:8244:4: enumLiteral_0= 'self_loops'
                    {
                    enumLiteral_0=(Token)match(input,118,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getSelf_loopsEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_0, grammarAccess.getMdGraphFeatureAccess().getSelf_loopsEnumLiteralDeclaration_0());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    // InternalMetaData.g:8251:3: (enumLiteral_1= 'inside_self_loops' )
                    {
                    // InternalMetaData.g:8251:3: (enumLiteral_1= 'inside_self_loops' )
                    // InternalMetaData.g:8252:4: enumLiteral_1= 'inside_self_loops'
                    {
                    enumLiteral_1=(Token)match(input,119,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getInside_self_loopsEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_1, grammarAccess.getMdGraphFeatureAccess().getInside_self_loopsEnumLiteralDeclaration_1());
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    // InternalMetaData.g:8259:3: (enumLiteral_2= 'multi_edges' )
                    {
                    // InternalMetaData.g:8259:3: (enumLiteral_2= 'multi_edges' )
                    // InternalMetaData.g:8260:4: enumLiteral_2= 'multi_edges'
                    {
                    enumLiteral_2=(Token)match(input,120,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getMulti_edgesEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_2, grammarAccess.getMdGraphFeatureAccess().getMulti_edgesEnumLiteralDeclaration_2());
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    // InternalMetaData.g:8267:3: (enumLiteral_3= 'edge_labels' )
                    {
                    // InternalMetaData.g:8267:3: (enumLiteral_3= 'edge_labels' )
                    // InternalMetaData.g:8268:4: enumLiteral_3= 'edge_labels'
                    {
                    enumLiteral_3=(Token)match(input,121,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getEdge_labelsEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_3, grammarAccess.getMdGraphFeatureAccess().getEdge_labelsEnumLiteralDeclaration_3());
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    // InternalMetaData.g:8275:3: (enumLiteral_4= 'ports' )
                    {
                    // InternalMetaData.g:8275:3: (enumLiteral_4= 'ports' )
                    // InternalMetaData.g:8276:4: enumLiteral_4= 'ports'
                    {
                    enumLiteral_4=(Token)match(input,116,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getPortsEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_4, grammarAccess.getMdGraphFeatureAccess().getPortsEnumLiteralDeclaration_4());
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    // InternalMetaData.g:8283:3: (enumLiteral_5= 'compound' )
                    {
                    // InternalMetaData.g:8283:3: (enumLiteral_5= 'compound' )
                    // InternalMetaData.g:8284:4: enumLiteral_5= 'compound'
                    {
                    enumLiteral_5=(Token)match(input,122,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getCompoundEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_5, grammarAccess.getMdGraphFeatureAccess().getCompoundEnumLiteralDeclaration_5());
                      			
                    }

                    }


                    }
                    break;
                case 7 :
                    // InternalMetaData.g:8291:3: (enumLiteral_6= 'clusters' )
                    {
                    // InternalMetaData.g:8291:3: (enumLiteral_6= 'clusters' )
                    // InternalMetaData.g:8292:4: enumLiteral_6= 'clusters'
                    {
                    enumLiteral_6=(Token)match(input,123,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getClustersEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_6, grammarAccess.getMdGraphFeatureAccess().getClustersEnumLiteralDeclaration_6());
                      			
                    }

                    }


                    }
                    break;
                case 8 :
                    // InternalMetaData.g:8299:3: (enumLiteral_7= 'disconnected' )
                    {
                    // InternalMetaData.g:8299:3: (enumLiteral_7= 'disconnected' )
                    // InternalMetaData.g:8300:4: enumLiteral_7= 'disconnected'
                    {
                    enumLiteral_7=(Token)match(input,124,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = grammarAccess.getMdGraphFeatureAccess().getDisconnectedEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
                      				newLeafNode(enumLiteral_7, grammarAccess.getMdGraphFeatureAccess().getDisconnectedEnumLiteralDeclaration_7());
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    // $ANTLR end "ruleMdGraphFeature"

    // $ANTLR start synpred1_InternalMetaData
    public final void synpred1_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:1969:6: ( ( () ( ( ruleOpMultiAssign ) ) ) )
        // InternalMetaData.g:1969:7: ( () ( ( ruleOpMultiAssign ) ) )
        {
        // InternalMetaData.g:1969:7: ( () ( ( ruleOpMultiAssign ) ) )
        // InternalMetaData.g:1970:7: () ( ( ruleOpMultiAssign ) )
        {
        // InternalMetaData.g:1970:7: ()
        // InternalMetaData.g:1971:7: 
        {
        }

        // InternalMetaData.g:1972:7: ( ( ruleOpMultiAssign ) )
        // InternalMetaData.g:1973:8: ( ruleOpMultiAssign )
        {
        // InternalMetaData.g:1973:8: ( ruleOpMultiAssign )
        // InternalMetaData.g:1974:9: ruleOpMultiAssign
        {
        pushFollow(FOLLOW_2);
        ruleOpMultiAssign();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred1_InternalMetaData

    // $ANTLR start synpred2_InternalMetaData
    public final void synpred2_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2163:5: ( ( () ( ( ruleOpOr ) ) ) )
        // InternalMetaData.g:2163:6: ( () ( ( ruleOpOr ) ) )
        {
        // InternalMetaData.g:2163:6: ( () ( ( ruleOpOr ) ) )
        // InternalMetaData.g:2164:6: () ( ( ruleOpOr ) )
        {
        // InternalMetaData.g:2164:6: ()
        // InternalMetaData.g:2165:6: 
        {
        }

        // InternalMetaData.g:2166:6: ( ( ruleOpOr ) )
        // InternalMetaData.g:2167:7: ( ruleOpOr )
        {
        // InternalMetaData.g:2167:7: ( ruleOpOr )
        // InternalMetaData.g:2168:8: ruleOpOr
        {
        pushFollow(FOLLOW_2);
        ruleOpOr();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred2_InternalMetaData

    // $ANTLR start synpred3_InternalMetaData
    public final void synpred3_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2270:5: ( ( () ( ( ruleOpAnd ) ) ) )
        // InternalMetaData.g:2270:6: ( () ( ( ruleOpAnd ) ) )
        {
        // InternalMetaData.g:2270:6: ( () ( ( ruleOpAnd ) ) )
        // InternalMetaData.g:2271:6: () ( ( ruleOpAnd ) )
        {
        // InternalMetaData.g:2271:6: ()
        // InternalMetaData.g:2272:6: 
        {
        }

        // InternalMetaData.g:2273:6: ( ( ruleOpAnd ) )
        // InternalMetaData.g:2274:7: ( ruleOpAnd )
        {
        // InternalMetaData.g:2274:7: ( ruleOpAnd )
        // InternalMetaData.g:2275:8: ruleOpAnd
        {
        pushFollow(FOLLOW_2);
        ruleOpAnd();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred3_InternalMetaData

    // $ANTLR start synpred4_InternalMetaData
    public final void synpred4_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2377:5: ( ( () ( ( ruleOpEquality ) ) ) )
        // InternalMetaData.g:2377:6: ( () ( ( ruleOpEquality ) ) )
        {
        // InternalMetaData.g:2377:6: ( () ( ( ruleOpEquality ) ) )
        // InternalMetaData.g:2378:6: () ( ( ruleOpEquality ) )
        {
        // InternalMetaData.g:2378:6: ()
        // InternalMetaData.g:2379:6: 
        {
        }

        // InternalMetaData.g:2380:6: ( ( ruleOpEquality ) )
        // InternalMetaData.g:2381:7: ( ruleOpEquality )
        {
        // InternalMetaData.g:2381:7: ( ruleOpEquality )
        // InternalMetaData.g:2382:8: ruleOpEquality
        {
        pushFollow(FOLLOW_2);
        ruleOpEquality();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred4_InternalMetaData

    // $ANTLR start synpred5_InternalMetaData
    public final void synpred5_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2505:6: ( ( () 'instanceof' ) )
        // InternalMetaData.g:2505:7: ( () 'instanceof' )
        {
        // InternalMetaData.g:2505:7: ( () 'instanceof' )
        // InternalMetaData.g:2506:7: () 'instanceof'
        {
        // InternalMetaData.g:2506:7: ()
        // InternalMetaData.g:2507:7: 
        {
        }

        match(input,64,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred5_InternalMetaData

    // $ANTLR start synpred6_InternalMetaData
    public final void synpred6_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2548:6: ( ( () ( ( ruleOpCompare ) ) ) )
        // InternalMetaData.g:2548:7: ( () ( ( ruleOpCompare ) ) )
        {
        // InternalMetaData.g:2548:7: ( () ( ( ruleOpCompare ) ) )
        // InternalMetaData.g:2549:7: () ( ( ruleOpCompare ) )
        {
        // InternalMetaData.g:2549:7: ()
        // InternalMetaData.g:2550:7: 
        {
        }

        // InternalMetaData.g:2551:7: ( ( ruleOpCompare ) )
        // InternalMetaData.g:2552:8: ( ruleOpCompare )
        {
        // InternalMetaData.g:2552:8: ( ruleOpCompare )
        // InternalMetaData.g:2553:9: ruleOpCompare
        {
        pushFollow(FOLLOW_2);
        ruleOpCompare();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred6_InternalMetaData

    // $ANTLR start synpred7_InternalMetaData
    public final void synpred7_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2683:5: ( ( () ( ( ruleOpOther ) ) ) )
        // InternalMetaData.g:2683:6: ( () ( ( ruleOpOther ) ) )
        {
        // InternalMetaData.g:2683:6: ( () ( ( ruleOpOther ) ) )
        // InternalMetaData.g:2684:6: () ( ( ruleOpOther ) )
        {
        // InternalMetaData.g:2684:6: ()
        // InternalMetaData.g:2685:6: 
        {
        }

        // InternalMetaData.g:2686:6: ( ( ruleOpOther ) )
        // InternalMetaData.g:2687:7: ( ruleOpOther )
        {
        // InternalMetaData.g:2687:7: ( ruleOpOther )
        // InternalMetaData.g:2688:8: ruleOpOther
        {
        pushFollow(FOLLOW_2);
        ruleOpOther();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred7_InternalMetaData

    // $ANTLR start synpred8_InternalMetaData
    public final void synpred8_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2803:6: ( ( '>' '>' ) )
        // InternalMetaData.g:2803:7: ( '>' '>' )
        {
        // InternalMetaData.g:2803:7: ( '>' '>' )
        // InternalMetaData.g:2804:7: '>' '>'
        {
        match(input,57,FOLLOW_46); if (state.failed) return ;
        match(input,57,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred8_InternalMetaData

    // $ANTLR start synpred9_InternalMetaData
    public final void synpred9_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2838:6: ( ( '<' '<' ) )
        // InternalMetaData.g:2838:7: ( '<' '<' )
        {
        // InternalMetaData.g:2838:7: ( '<' '<' )
        // InternalMetaData.g:2839:7: '<' '<'
        {
        match(input,56,FOLLOW_37); if (state.failed) return ;
        match(input,56,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred9_InternalMetaData

    // $ANTLR start synpred10_InternalMetaData
    public final void synpred10_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:2911:5: ( ( () ( ( ruleOpAdd ) ) ) )
        // InternalMetaData.g:2911:6: ( () ( ( ruleOpAdd ) ) )
        {
        // InternalMetaData.g:2911:6: ( () ( ( ruleOpAdd ) ) )
        // InternalMetaData.g:2912:6: () ( ( ruleOpAdd ) )
        {
        // InternalMetaData.g:2912:6: ()
        // InternalMetaData.g:2913:6: 
        {
        }

        // InternalMetaData.g:2914:6: ( ( ruleOpAdd ) )
        // InternalMetaData.g:2915:7: ( ruleOpAdd )
        {
        // InternalMetaData.g:2915:7: ( ruleOpAdd )
        // InternalMetaData.g:2916:8: ruleOpAdd
        {
        pushFollow(FOLLOW_2);
        ruleOpAdd();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred10_InternalMetaData

    // $ANTLR start synpred11_InternalMetaData
    public final void synpred11_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3026:5: ( ( () ( ( ruleOpMulti ) ) ) )
        // InternalMetaData.g:3026:6: ( () ( ( ruleOpMulti ) ) )
        {
        // InternalMetaData.g:3026:6: ( () ( ( ruleOpMulti ) ) )
        // InternalMetaData.g:3027:6: () ( ( ruleOpMulti ) )
        {
        // InternalMetaData.g:3027:6: ()
        // InternalMetaData.g:3028:6: 
        {
        }

        // InternalMetaData.g:3029:6: ( ( ruleOpMulti ) )
        // InternalMetaData.g:3030:7: ( ruleOpMulti )
        {
        // InternalMetaData.g:3030:7: ( ruleOpMulti )
        // InternalMetaData.g:3031:8: ruleOpMulti
        {
        pushFollow(FOLLOW_2);
        ruleOpMulti();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred11_InternalMetaData

    // $ANTLR start synpred12_InternalMetaData
    public final void synpred12_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3261:5: ( ( () 'as' ) )
        // InternalMetaData.g:3261:6: ( () 'as' )
        {
        // InternalMetaData.g:3261:6: ( () 'as' )
        // InternalMetaData.g:3262:6: () 'as'
        {
        // InternalMetaData.g:3262:6: ()
        // InternalMetaData.g:3263:6: 
        {
        }

        match(input,76,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred12_InternalMetaData

    // $ANTLR start synpred13_InternalMetaData
    public final void synpred13_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3329:4: ( ( () ( ( ruleOpPostfix ) ) ) )
        // InternalMetaData.g:3329:5: ( () ( ( ruleOpPostfix ) ) )
        {
        // InternalMetaData.g:3329:5: ( () ( ( ruleOpPostfix ) ) )
        // InternalMetaData.g:3330:5: () ( ( ruleOpPostfix ) )
        {
        // InternalMetaData.g:3330:5: ()
        // InternalMetaData.g:3331:5: 
        {
        }

        // InternalMetaData.g:3332:5: ( ( ruleOpPostfix ) )
        // InternalMetaData.g:3333:6: ( ruleOpPostfix )
        {
        // InternalMetaData.g:3333:6: ( ruleOpPostfix )
        // InternalMetaData.g:3334:7: ruleOpPostfix
        {
        pushFollow(FOLLOW_2);
        ruleOpPostfix();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred13_InternalMetaData

    // $ANTLR start synpred14_InternalMetaData
    public final void synpred14_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3425:6: ( ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign ) )
        // InternalMetaData.g:3425:7: ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign )
        {
        // InternalMetaData.g:3425:7: ( () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign )
        // InternalMetaData.g:3426:7: () ( '.' | ( ( '::' ) ) ) ( ( ruleFeatureCallID ) ) ruleOpSingleAssign
        {
        // InternalMetaData.g:3426:7: ()
        // InternalMetaData.g:3427:7: 
        {
        }

        // InternalMetaData.g:3428:7: ( '.' | ( ( '::' ) ) )
        int alt142=2;
        int LA142_0 = input.LA(1);

        if ( (LA142_0==79) ) {
            alt142=1;
        }
        else if ( (LA142_0==80) ) {
            alt142=2;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 142, 0, input);

            throw nvae;
        }
        switch (alt142) {
            case 1 :
                // InternalMetaData.g:3429:8: '.'
                {
                match(input,79,FOLLOW_53); if (state.failed) return ;

                }
                break;
            case 2 :
                // InternalMetaData.g:3431:8: ( ( '::' ) )
                {
                // InternalMetaData.g:3431:8: ( ( '::' ) )
                // InternalMetaData.g:3432:9: ( '::' )
                {
                // InternalMetaData.g:3432:9: ( '::' )
                // InternalMetaData.g:3433:10: '::'
                {
                match(input,80,FOLLOW_53); if (state.failed) return ;

                }


                }


                }
                break;

        }

        // InternalMetaData.g:3437:7: ( ( ruleFeatureCallID ) )
        // InternalMetaData.g:3438:8: ( ruleFeatureCallID )
        {
        // InternalMetaData.g:3438:8: ( ruleFeatureCallID )
        // InternalMetaData.g:3439:9: ruleFeatureCallID
        {
        pushFollow(FOLLOW_17);
        ruleFeatureCallID();

        state._fsp--;
        if (state.failed) return ;

        }


        }

        pushFollow(FOLLOW_2);
        ruleOpSingleAssign();

        state._fsp--;
        if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred14_InternalMetaData

    // $ANTLR start synpred15_InternalMetaData
    public final void synpred15_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3522:6: ( ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) ) )
        // InternalMetaData.g:3522:7: ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) )
        {
        // InternalMetaData.g:3522:7: ( () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) ) )
        // InternalMetaData.g:3523:7: () ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) )
        {
        // InternalMetaData.g:3523:7: ()
        // InternalMetaData.g:3524:7: 
        {
        }

        // InternalMetaData.g:3525:7: ( '.' | ( ( '?.' ) ) | ( ( '::' ) ) )
        int alt143=3;
        switch ( input.LA(1) ) {
        case 79:
            {
            alt143=1;
            }
            break;
        case 81:
            {
            alt143=2;
            }
            break;
        case 80:
            {
            alt143=3;
            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 143, 0, input);

            throw nvae;
        }

        switch (alt143) {
            case 1 :
                // InternalMetaData.g:3526:8: '.'
                {
                match(input,79,FOLLOW_2); if (state.failed) return ;

                }
                break;
            case 2 :
                // InternalMetaData.g:3528:8: ( ( '?.' ) )
                {
                // InternalMetaData.g:3528:8: ( ( '?.' ) )
                // InternalMetaData.g:3529:9: ( '?.' )
                {
                // InternalMetaData.g:3529:9: ( '?.' )
                // InternalMetaData.g:3530:10: '?.'
                {
                match(input,81,FOLLOW_2); if (state.failed) return ;

                }


                }


                }
                break;
            case 3 :
                // InternalMetaData.g:3534:8: ( ( '::' ) )
                {
                // InternalMetaData.g:3534:8: ( ( '::' ) )
                // InternalMetaData.g:3535:9: ( '::' )
                {
                // InternalMetaData.g:3535:9: ( '::' )
                // InternalMetaData.g:3536:10: '::'
                {
                match(input,80,FOLLOW_2); if (state.failed) return ;

                }


                }


                }
                break;

        }


        }


        }
    }
    // $ANTLR end synpred15_InternalMetaData

    // $ANTLR start synpred16_InternalMetaData
    public final void synpred16_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3660:7: ( ( '(' ) )
        // InternalMetaData.g:3660:8: ( '(' )
        {
        // InternalMetaData.g:3660:8: ( '(' )
        // InternalMetaData.g:3661:8: '('
        {
        match(input,41,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred16_InternalMetaData

    // $ANTLR start synpred17_InternalMetaData
    public final void synpred17_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3679:8: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )
        // InternalMetaData.g:3679:9: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        {
        // InternalMetaData.g:3679:9: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        // InternalMetaData.g:3680:9: () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) )
        {
        // InternalMetaData.g:3680:9: ()
        // InternalMetaData.g:3681:9: 
        {
        }

        // InternalMetaData.g:3682:9: ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )?
        int alt145=2;
        int LA145_0 = input.LA(1);

        if ( (LA145_0==RULE_ID||LA145_0==41||LA145_0==68) ) {
            alt145=1;
        }
        switch (alt145) {
            case 1 :
                // InternalMetaData.g:3683:10: ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )*
                {
                // InternalMetaData.g:3683:10: ( ( ruleJvmFormalParameter ) )
                // InternalMetaData.g:3684:11: ( ruleJvmFormalParameter )
                {
                // InternalMetaData.g:3684:11: ( ruleJvmFormalParameter )
                // InternalMetaData.g:3685:12: ruleJvmFormalParameter
                {
                pushFollow(FOLLOW_67);
                ruleJvmFormalParameter();

                state._fsp--;
                if (state.failed) return ;

                }


                }

                // InternalMetaData.g:3688:10: ( ',' ( ( ruleJvmFormalParameter ) ) )*
                loop144:
                do {
                    int alt144=2;
                    int LA144_0 = input.LA(1);

                    if ( (LA144_0==36) ) {
                        alt144=1;
                    }


                    switch (alt144) {
                	case 1 :
                	    // InternalMetaData.g:3689:11: ',' ( ( ruleJvmFormalParameter ) )
                	    {
                	    match(input,36,FOLLOW_15); if (state.failed) return ;
                	    // InternalMetaData.g:3690:11: ( ( ruleJvmFormalParameter ) )
                	    // InternalMetaData.g:3691:12: ( ruleJvmFormalParameter )
                	    {
                	    // InternalMetaData.g:3691:12: ( ruleJvmFormalParameter )
                	    // InternalMetaData.g:3692:13: ruleJvmFormalParameter
                	    {
                	    pushFollow(FOLLOW_67);
                	    ruleJvmFormalParameter();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }


                	    }


                	    }
                	    break;

                	default :
                	    break loop144;
                    }
                } while (true);


                }
                break;

        }

        // InternalMetaData.g:3697:9: ( ( '|' ) )
        // InternalMetaData.g:3698:10: ( '|' )
        {
        // InternalMetaData.g:3698:10: ( '|' )
        // InternalMetaData.g:3699:11: '|'
        {
        match(input,84,FOLLOW_2); if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred17_InternalMetaData

    // $ANTLR start synpred18_InternalMetaData
    public final void synpred18_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3776:6: ( ( () '[' ) )
        // InternalMetaData.g:3776:7: ( () '[' )
        {
        // InternalMetaData.g:3776:7: ( () '[' )
        // InternalMetaData.g:3777:7: () '['
        {
        // InternalMetaData.g:3777:7: ()
        // InternalMetaData.g:3778:7: 
        {
        }

        match(input,82,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred18_InternalMetaData

    // $ANTLR start synpred19_InternalMetaData
    public final void synpred19_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3849:4: ( ( () 'synchronized' '(' ) )
        // InternalMetaData.g:3849:5: ( () 'synchronized' '(' )
        {
        // InternalMetaData.g:3849:5: ( () 'synchronized' '(' )
        // InternalMetaData.g:3850:5: () 'synchronized' '('
        {
        // InternalMetaData.g:3850:5: ()
        // InternalMetaData.g:3851:5: 
        {
        }

        match(input,109,FOLLOW_24); if (state.failed) return ;
        match(input,41,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred19_InternalMetaData

    // $ANTLR start synpred20_InternalMetaData
    public final void synpred20_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:3894:4: ( ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' ) )
        // InternalMetaData.g:3894:5: ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' )
        {
        // InternalMetaData.g:3894:5: ( () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':' )
        // InternalMetaData.g:3895:5: () 'for' '(' ( ( ruleJvmFormalParameter ) ) ':'
        {
        // InternalMetaData.g:3895:5: ()
        // InternalMetaData.g:3896:5: 
        {
        }

        match(input,90,FOLLOW_24); if (state.failed) return ;
        match(input,41,FOLLOW_15); if (state.failed) return ;
        // InternalMetaData.g:3899:5: ( ( ruleJvmFormalParameter ) )
        // InternalMetaData.g:3900:6: ( ruleJvmFormalParameter )
        {
        // InternalMetaData.g:3900:6: ( ruleJvmFormalParameter )
        // InternalMetaData.g:3901:7: ruleJvmFormalParameter
        {
        pushFollow(FOLLOW_74);
        ruleJvmFormalParameter();

        state._fsp--;
        if (state.failed) return ;

        }


        }

        match(input,29,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred20_InternalMetaData

    // $ANTLR start synpred21_InternalMetaData
    public final void synpred21_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:4008:4: ( ( () '[' ) )
        // InternalMetaData.g:4008:5: ( () '[' )
        {
        // InternalMetaData.g:4008:5: ( () '[' )
        // InternalMetaData.g:4009:5: () '['
        {
        // InternalMetaData.g:4009:5: ()
        // InternalMetaData.g:4010:5: 
        {
        }

        match(input,82,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred21_InternalMetaData

    // $ANTLR start synpred23_InternalMetaData
    public final void synpred23_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:4313:4: ( ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )
        // InternalMetaData.g:4313:5: ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        {
        // InternalMetaData.g:4313:5: ( ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        // InternalMetaData.g:4314:5: ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) )
        {
        // InternalMetaData.g:4314:5: ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )?
        int alt147=2;
        int LA147_0 = input.LA(1);

        if ( (LA147_0==RULE_ID||LA147_0==41||LA147_0==68) ) {
            alt147=1;
        }
        switch (alt147) {
            case 1 :
                // InternalMetaData.g:4315:6: ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )*
                {
                // InternalMetaData.g:4315:6: ( ( ruleJvmFormalParameter ) )
                // InternalMetaData.g:4316:7: ( ruleJvmFormalParameter )
                {
                // InternalMetaData.g:4316:7: ( ruleJvmFormalParameter )
                // InternalMetaData.g:4317:8: ruleJvmFormalParameter
                {
                pushFollow(FOLLOW_67);
                ruleJvmFormalParameter();

                state._fsp--;
                if (state.failed) return ;

                }


                }

                // InternalMetaData.g:4320:6: ( ',' ( ( ruleJvmFormalParameter ) ) )*
                loop146:
                do {
                    int alt146=2;
                    int LA146_0 = input.LA(1);

                    if ( (LA146_0==36) ) {
                        alt146=1;
                    }


                    switch (alt146) {
                	case 1 :
                	    // InternalMetaData.g:4321:7: ',' ( ( ruleJvmFormalParameter ) )
                	    {
                	    match(input,36,FOLLOW_15); if (state.failed) return ;
                	    // InternalMetaData.g:4322:7: ( ( ruleJvmFormalParameter ) )
                	    // InternalMetaData.g:4323:8: ( ruleJvmFormalParameter )
                	    {
                	    // InternalMetaData.g:4323:8: ( ruleJvmFormalParameter )
                	    // InternalMetaData.g:4324:9: ruleJvmFormalParameter
                	    {
                	    pushFollow(FOLLOW_67);
                	    ruleJvmFormalParameter();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }


                	    }


                	    }
                	    break;

                	default :
                	    break loop146;
                    }
                } while (true);


                }
                break;

        }

        // InternalMetaData.g:4329:5: ( ( '|' ) )
        // InternalMetaData.g:4330:6: ( '|' )
        {
        // InternalMetaData.g:4330:6: ( '|' )
        // InternalMetaData.g:4331:7: '|'
        {
        match(input,84,FOLLOW_2); if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred23_InternalMetaData

    // $ANTLR start synpred25_InternalMetaData
    public final void synpred25_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:4722:5: ( 'else' )
        // InternalMetaData.g:4722:6: 'else'
        {
        match(input,87,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred25_InternalMetaData

    // $ANTLR start synpred26_InternalMetaData
    public final void synpred26_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:4781:6: ( ( '(' ( ( ruleJvmFormalParameter ) ) ':' ) )
        // InternalMetaData.g:4781:7: ( '(' ( ( ruleJvmFormalParameter ) ) ':' )
        {
        // InternalMetaData.g:4781:7: ( '(' ( ( ruleJvmFormalParameter ) ) ':' )
        // InternalMetaData.g:4782:7: '(' ( ( ruleJvmFormalParameter ) ) ':'
        {
        match(input,41,FOLLOW_15); if (state.failed) return ;
        // InternalMetaData.g:4783:7: ( ( ruleJvmFormalParameter ) )
        // InternalMetaData.g:4784:8: ( ruleJvmFormalParameter )
        {
        // InternalMetaData.g:4784:8: ( ruleJvmFormalParameter )
        // InternalMetaData.g:4785:9: ruleJvmFormalParameter
        {
        pushFollow(FOLLOW_74);
        ruleJvmFormalParameter();

        state._fsp--;
        if (state.failed) return ;

        }


        }

        match(input,29,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred26_InternalMetaData

    // $ANTLR start synpred27_InternalMetaData
    public final void synpred27_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:4848:6: ( ( ( ( ruleJvmFormalParameter ) ) ':' ) )
        // InternalMetaData.g:4848:7: ( ( ( ruleJvmFormalParameter ) ) ':' )
        {
        // InternalMetaData.g:4848:7: ( ( ( ruleJvmFormalParameter ) ) ':' )
        // InternalMetaData.g:4849:7: ( ( ruleJvmFormalParameter ) ) ':'
        {
        // InternalMetaData.g:4849:7: ( ( ruleJvmFormalParameter ) )
        // InternalMetaData.g:4850:8: ( ruleJvmFormalParameter )
        {
        // InternalMetaData.g:4850:8: ( ruleJvmFormalParameter )
        // InternalMetaData.g:4851:9: ruleJvmFormalParameter
        {
        pushFollow(FOLLOW_74);
        ruleJvmFormalParameter();

        state._fsp--;
        if (state.failed) return ;

        }


        }

        match(input,29,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred27_InternalMetaData

    // $ANTLR start synpred29_InternalMetaData
    public final void synpred29_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:5666:5: ( ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) ) )
        // InternalMetaData.g:5666:6: ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) )
        {
        // InternalMetaData.g:5666:6: ( ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) ) )
        // InternalMetaData.g:5667:6: ( ( ruleJvmTypeReference ) ) ( ( ruleValidID ) )
        {
        // InternalMetaData.g:5667:6: ( ( ruleJvmTypeReference ) )
        // InternalMetaData.g:5668:7: ( ruleJvmTypeReference )
        {
        // InternalMetaData.g:5668:7: ( ruleJvmTypeReference )
        // InternalMetaData.g:5669:8: ruleJvmTypeReference
        {
        pushFollow(FOLLOW_3);
        ruleJvmTypeReference();

        state._fsp--;
        if (state.failed) return ;

        }


        }

        // InternalMetaData.g:5672:6: ( ( ruleValidID ) )
        // InternalMetaData.g:5673:7: ( ruleValidID )
        {
        // InternalMetaData.g:5673:7: ( ruleValidID )
        // InternalMetaData.g:5674:8: ruleValidID
        {
        pushFollow(FOLLOW_2);
        ruleValidID();

        state._fsp--;
        if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred29_InternalMetaData

    // $ANTLR start synpred30_InternalMetaData
    public final void synpred30_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:5978:5: ( ( '(' ) )
        // InternalMetaData.g:5978:6: ( '(' )
        {
        // InternalMetaData.g:5978:6: ( '(' )
        // InternalMetaData.g:5979:6: '('
        {
        match(input,41,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred30_InternalMetaData

    // $ANTLR start synpred31_InternalMetaData
    public final void synpred31_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:5997:6: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )
        // InternalMetaData.g:5997:7: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        {
        // InternalMetaData.g:5997:7: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        // InternalMetaData.g:5998:7: () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) )
        {
        // InternalMetaData.g:5998:7: ()
        // InternalMetaData.g:5999:7: 
        {
        }

        // InternalMetaData.g:6000:7: ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )?
        int alt151=2;
        int LA151_0 = input.LA(1);

        if ( (LA151_0==RULE_ID||LA151_0==41||LA151_0==68) ) {
            alt151=1;
        }
        switch (alt151) {
            case 1 :
                // InternalMetaData.g:6001:8: ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )*
                {
                // InternalMetaData.g:6001:8: ( ( ruleJvmFormalParameter ) )
                // InternalMetaData.g:6002:9: ( ruleJvmFormalParameter )
                {
                // InternalMetaData.g:6002:9: ( ruleJvmFormalParameter )
                // InternalMetaData.g:6003:10: ruleJvmFormalParameter
                {
                pushFollow(FOLLOW_67);
                ruleJvmFormalParameter();

                state._fsp--;
                if (state.failed) return ;

                }


                }

                // InternalMetaData.g:6006:8: ( ',' ( ( ruleJvmFormalParameter ) ) )*
                loop150:
                do {
                    int alt150=2;
                    int LA150_0 = input.LA(1);

                    if ( (LA150_0==36) ) {
                        alt150=1;
                    }


                    switch (alt150) {
                	case 1 :
                	    // InternalMetaData.g:6007:9: ',' ( ( ruleJvmFormalParameter ) )
                	    {
                	    match(input,36,FOLLOW_15); if (state.failed) return ;
                	    // InternalMetaData.g:6008:9: ( ( ruleJvmFormalParameter ) )
                	    // InternalMetaData.g:6009:10: ( ruleJvmFormalParameter )
                	    {
                	    // InternalMetaData.g:6009:10: ( ruleJvmFormalParameter )
                	    // InternalMetaData.g:6010:11: ruleJvmFormalParameter
                	    {
                	    pushFollow(FOLLOW_67);
                	    ruleJvmFormalParameter();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }


                	    }


                	    }
                	    break;

                	default :
                	    break loop150;
                    }
                } while (true);


                }
                break;

        }

        // InternalMetaData.g:6015:7: ( ( '|' ) )
        // InternalMetaData.g:6016:8: ( '|' )
        {
        // InternalMetaData.g:6016:8: ( '|' )
        // InternalMetaData.g:6017:9: '|'
        {
        match(input,84,FOLLOW_2); if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred31_InternalMetaData

    // $ANTLR start synpred32_InternalMetaData
    public final void synpred32_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6094:4: ( ( () '[' ) )
        // InternalMetaData.g:6094:5: ( () '[' )
        {
        // InternalMetaData.g:6094:5: ( () '[' )
        // InternalMetaData.g:6095:5: () '['
        {
        // InternalMetaData.g:6095:5: ()
        // InternalMetaData.g:6096:5: 
        {
        }

        match(input,82,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred32_InternalMetaData

    // $ANTLR start synpred33_InternalMetaData
    public final void synpred33_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6254:5: ( '<' )
        // InternalMetaData.g:6254:6: '<'
        {
        match(input,56,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred33_InternalMetaData

    // $ANTLR start synpred34_InternalMetaData
    public final void synpred34_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6311:5: ( ( '(' ) )
        // InternalMetaData.g:6311:6: ( '(' )
        {
        // InternalMetaData.g:6311:6: ( '(' )
        // InternalMetaData.g:6312:6: '('
        {
        match(input,41,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred34_InternalMetaData

    // $ANTLR start synpred35_InternalMetaData
    public final void synpred35_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6330:6: ( ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) ) )
        // InternalMetaData.g:6330:7: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        {
        // InternalMetaData.g:6330:7: ( () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) ) )
        // InternalMetaData.g:6331:7: () ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )? ( ( '|' ) )
        {
        // InternalMetaData.g:6331:7: ()
        // InternalMetaData.g:6332:7: 
        {
        }

        // InternalMetaData.g:6333:7: ( ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )* )?
        int alt153=2;
        int LA153_0 = input.LA(1);

        if ( (LA153_0==RULE_ID||LA153_0==41||LA153_0==68) ) {
            alt153=1;
        }
        switch (alt153) {
            case 1 :
                // InternalMetaData.g:6334:8: ( ( ruleJvmFormalParameter ) ) ( ',' ( ( ruleJvmFormalParameter ) ) )*
                {
                // InternalMetaData.g:6334:8: ( ( ruleJvmFormalParameter ) )
                // InternalMetaData.g:6335:9: ( ruleJvmFormalParameter )
                {
                // InternalMetaData.g:6335:9: ( ruleJvmFormalParameter )
                // InternalMetaData.g:6336:10: ruleJvmFormalParameter
                {
                pushFollow(FOLLOW_67);
                ruleJvmFormalParameter();

                state._fsp--;
                if (state.failed) return ;

                }


                }

                // InternalMetaData.g:6339:8: ( ',' ( ( ruleJvmFormalParameter ) ) )*
                loop152:
                do {
                    int alt152=2;
                    int LA152_0 = input.LA(1);

                    if ( (LA152_0==36) ) {
                        alt152=1;
                    }


                    switch (alt152) {
                	case 1 :
                	    // InternalMetaData.g:6340:9: ',' ( ( ruleJvmFormalParameter ) )
                	    {
                	    match(input,36,FOLLOW_15); if (state.failed) return ;
                	    // InternalMetaData.g:6341:9: ( ( ruleJvmFormalParameter ) )
                	    // InternalMetaData.g:6342:10: ( ruleJvmFormalParameter )
                	    {
                	    // InternalMetaData.g:6342:10: ( ruleJvmFormalParameter )
                	    // InternalMetaData.g:6343:11: ruleJvmFormalParameter
                	    {
                	    pushFollow(FOLLOW_67);
                	    ruleJvmFormalParameter();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }


                	    }


                	    }
                	    break;

                	default :
                	    break loop152;
                    }
                } while (true);


                }
                break;

        }

        // InternalMetaData.g:6348:7: ( ( '|' ) )
        // InternalMetaData.g:6349:8: ( '|' )
        {
        // InternalMetaData.g:6349:8: ( '|' )
        // InternalMetaData.g:6350:9: '|'
        {
        match(input,84,FOLLOW_2); if (state.failed) return ;

        }


        }


        }


        }
    }
    // $ANTLR end synpred35_InternalMetaData

    // $ANTLR start synpred36_InternalMetaData
    public final void synpred36_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6427:4: ( ( () '[' ) )
        // InternalMetaData.g:6427:5: ( () '[' )
        {
        // InternalMetaData.g:6427:5: ( () '[' )
        // InternalMetaData.g:6428:5: () '['
        {
        // InternalMetaData.g:6428:5: ()
        // InternalMetaData.g:6429:5: 
        {
        }

        match(input,82,FOLLOW_2); if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred36_InternalMetaData

    // $ANTLR start synpred37_InternalMetaData
    public final void synpred37_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6770:4: ( 'extends' | 'static' | 'import' | 'extension' | '!' | '-' | '+' | 'new' | '{' | 'switch' | 'synchronized' | '<' | 'super' | '#' | '[' | 'false' | 'true' | 'null' | 'typeof' | 'if' | 'for' | 'while' | 'do' | 'throw' | 'return' | 'try' | '(' | RULE_ID | RULE_HEX | RULE_INT | RULE_DECIMAL | RULE_STRING )
        // InternalMetaData.g:
        {
        if ( (input.LA(1)>=RULE_STRING && input.LA(1)<=RULE_DECIMAL)||input.LA(1)==15||(input.LA(1)>=41 && input.LA(1)<=42)||input.LA(1)==50||input.LA(1)==56||input.LA(1)==71||input.LA(1)==75||input.LA(1)==82||input.LA(1)==86||input.LA(1)==88||(input.LA(1)>=90 && input.LA(1)<=92)||(input.LA(1)>=95 && input.LA(1)<=107)||input.LA(1)==109 ) {
            input.consume();
            state.errorRecovery=false;state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        }
    }
    // $ANTLR end synpred37_InternalMetaData

    // $ANTLR start synpred38_InternalMetaData
    public final void synpred38_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6841:6: ( 'catch' )
        // InternalMetaData.g:6841:7: 'catch'
        {
        match(input,110,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred38_InternalMetaData

    // $ANTLR start synpred39_InternalMetaData
    public final void synpred39_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:6862:7: ( 'finally' )
        // InternalMetaData.g:6862:8: 'finally'
        {
        match(input,108,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred39_InternalMetaData

    // $ANTLR start synpred42_InternalMetaData
    public final void synpred42_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:7106:5: ( '.' )
        // InternalMetaData.g:7106:6: '.'
        {
        match(input,79,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred42_InternalMetaData

    // $ANTLR start synpred43_InternalMetaData
    public final void synpred43_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:7232:5: ( ( () ruleArrayBrackets ) )
        // InternalMetaData.g:7232:6: ( () ruleArrayBrackets )
        {
        // InternalMetaData.g:7232:6: ( () ruleArrayBrackets )
        // InternalMetaData.g:7233:6: () ruleArrayBrackets
        {
        // InternalMetaData.g:7233:6: ()
        // InternalMetaData.g:7234:6: 
        {
        }

        pushFollow(FOLLOW_2);
        ruleArrayBrackets();

        state._fsp--;
        if (state.failed) return ;

        }


        }
    }
    // $ANTLR end synpred43_InternalMetaData

    // $ANTLR start synpred44_InternalMetaData
    public final void synpred44_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:7429:5: ( '<' )
        // InternalMetaData.g:7429:6: '<'
        {
        match(input,56,FOLLOW_2); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred44_InternalMetaData

    // $ANTLR start synpred45_InternalMetaData
    public final void synpred45_InternalMetaData_fragment() throws RecognitionException {   
        // InternalMetaData.g:7485:6: ( ( () '.' ) )
        // InternalMetaData.g:7485:7: ( () '.' )
        {
        // InternalMetaData.g:7485:7: ( () '.' )
        // InternalMetaData.