/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.conversion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.internal.LayoutOptionProxy;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyValueValueConverter
extends AbstractValueConverter<Object> {
    private IDValueConverter idValueConverter;

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, final ElkGraphGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1<IDValueConverter> _function = new Procedures.Procedure1<IDValueConverter>(){

            public void apply(IDValueConverter it) {
                TerminalRule _iDRule = grammarAccess.getIDRule();
                it.setRule((AbstractRule)_iDRule);
            }
        };
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    public String toString(Object value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        if (value instanceof Boolean || value instanceof Number || value instanceof Enum) {
            return value.toString();
        }
        String _string = value.toString();
        return this.quoteIfNecessary(_string);
    }

    private String quoteIfNecessary(String s) {
        try {
            List _split = Strings.split((String)s, (String)".");
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return PropertyValueValueConverter.this.idValueConverter.toString((Object)it);
                }
            };
            List _map = ListExtensions.map((List)_split, (Functions.Function1)_function);
            return IterableExtensions.join((Iterable)_map, (CharSequence)".");
        }
        catch (Throwable _t) {
            if (_t instanceof ValueConverterException) {
                ValueConverterException cfr_ignored_0 = (ValueConverterException)_t;
                return "\"" + s + "\"";
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Object toValue(String string, INode node) throws ValueConverterException {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            EObject semanticElem;
            String unquotedString = this.unquoteIfNecessary(string);
            EObject _semanticElement = null;
            if (node != null) {
                _semanticElement = node.getSemanticElement();
            }
            if ((semanticElem = _semanticElement) instanceof ElkPropertyToValueMapEntryImpl) {
                Object value;
                IProperty _key = ((ElkPropertyToValueMapEntryImpl)semanticElem).getKey();
                LayoutOptionData option = this.toLayoutOption(_key);
                Object _parseValue = null;
                if (option != null) {
                    _parseValue = option.parseValue(unquotedString);
                }
                if ((value = _parseValue) != null) {
                    return value;
                }
            }
            return new LayoutOptionProxy(unquotedString);
        }
        return null;
    }

    private String unquoteIfNecessary(String s) {
        if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
            int _length = s.length();
            int _minus = _length - 1;
            return s.substring(1, _minus);
        }
        if (s.length() >= 1 && (Character.isJavaIdentifierStart(s.charAt(0)) || s.startsWith("^"))) {
            List _split = Strings.split((String)s, (String)".");
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return PropertyValueValueConverter.this.idValueConverter.toValue(it, null);
                }
            };
            List _map = ListExtensions.map((List)_split, (Functions.Function1)_function);
            return IterableExtensions.join((Iterable)_map, (CharSequence)".");
        }
        return s;
    }

    private LayoutOptionData toLayoutOption(IProperty<?> property) {
        if (property instanceof LayoutOptionData) {
            return (LayoutOptionData)property;
        }
        if (property != null) {
            LayoutMetaDataService _instance = LayoutMetaDataService.getInstance();
            String _id = property.getId();
            return _instance.getOptionData(_id);
        }
        return null;
    }
}

