/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.util.IDataObject;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public final class LayoutOptionData
implements ILayoutMetaData,
IProperty<Object>,
Comparable<IProperty<?>> {
    private final String id;
    private final String group;
    private final String[] legacyIds;
    private final Object defaultValue;
    private final Class<?> clazz;
    private final Type type;
    private final String name;
    private final String description;
    private final Set<Target> targets;
    private final List<Pair<LayoutOptionData, Object>> dependencies = Lists.newLinkedList();
    private String[] choices;
    private final Visibility visibility;
    private Object lowerBound;
    private Object upperBound;
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};

    public LayoutOptionData(String aid, String agroup, String aname, String adescription, Object adefaultValue, Object alowerBound, Object anupperBound, Type atype, Class<?> atypeClass, Set<Target> atargets, Visibility avisibility, String ... alegacyIds) {
        this.id = aid;
        this.group = agroup;
        this.name = aname;
        this.description = adescription;
        this.defaultValue = adefaultValue;
        this.lowerBound = alowerBound;
        this.upperBound = anupperBound;
        this.type = atype;
        this.clazz = atypeClass;
        this.targets = atargets == null ? EnumSet.noneOf(Target.class) : atargets;
        this.visibility = avisibility;
        this.legacyIds = alegacyIds;
    }

    private void checkEnumClass() {
        if (this.clazz == null || !this.clazz.isEnum()) {
            throw new IllegalStateException("Enumeration class expected for layout option " + this.id);
        }
    }

    private IDataObject createDataInstance() {
        if (this.clazz == null || !IDataObject.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException("IDataType class expected for layout option " + this.id);
        }
        try {
            return (IDataObject)this.clazz.newInstance();
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be instantiated.", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be accessed.", exception);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutOptionData) {
            return this.id.equals(((LayoutOptionData)obj).id);
        }
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }

    public String toString() {
        return "Layout Option: " + this.id;
    }

    public boolean canParseValue() {
        if (this.type == Type.UNDEFINED) {
            return false;
        }
        if (this.type == Type.OBJECT) {
            return this.clazz != null && IDataObject.class.isAssignableFrom(this.clazz);
        }
        return true;
    }

    public Object parseValue(String valueString) {
        if (valueString == null || valueString.equals("null")) {
            return null;
        }
        if (valueString.length() == 0 && this.type != Type.ENUMSET) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                if (valueString.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case INT: {
                try {
                    return Integer.valueOf(valueString);
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
            case DOUBLE: {
                try {
                    return Double.valueOf(valueString);
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
            case STRING: {
                return valueString;
            }
            case ENUM: {
                this.checkEnumClass();
                return this.enumForString(valueString);
            }
            case ENUMSET: {
                this.checkEnumClass();
                return this.enumSetForStringArray(this.clazz, valueString);
            }
            case OBJECT: {
                try {
                    IDataObject value = this.createDataInstance();
                    value.parse(valueString);
                    return value;
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    private <E extends Enum<E>> EnumSet<E> enumSetForStringArray(Class<E> leClazz, String leString) {
        String[] components;
        EnumSet<Enum> set = EnumSet.noneOf(leClazz);
        String[] stringArray = components = leString.split("[\\[\\]\\s,]+");
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            if (component.trim().length() != 0) {
                Object o = this.enumForString(component);
                if (o == null) {
                    return null;
                }
                set.add((Enum)leClazz.cast(o));
            }
            ++n2;
        }
        return set;
    }

    private Object enumForString(String leString) {
        try {
            Object value = Enum.valueOf(this.clazz, leString);
            return value;
        }
        catch (IllegalArgumentException exception) {
            try {
                int index = Integer.parseInt(leString);
                ?[] constants = this.clazz.getEnumConstants();
                if (index >= 0 && index < constants.length) {
                    return constants[index];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
    }

    public Object getDefaultDefault() {
        switch (this.type) {
            case STRING: {
                return "";
            }
            case BOOLEAN: {
                return Boolean.FALSE;
            }
            case INT: {
                return 0;
            }
            case DOUBLE: {
                return 0.0;
            }
            case ENUM: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return enums[0];
            }
            case ENUMSET: {
                this.checkEnumClass();
                return EnumSet.noneOf(this.clazz);
            }
            case OBJECT: {
                return null;
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    public String[] getChoices() {
        if (this.choices == null) {
            switch (this.type) {
                case ENUM: 
                case ENUMSET: {
                    this.checkEnumClass();
                    Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                    this.choices = new String[enums.length];
                    int i = 0;
                    while (i < enums.length) {
                        this.choices[i] = enums[i].toString();
                        ++i;
                    }
                    break;
                }
                case BOOLEAN: {
                    this.choices = BOOLEAN_CHOICES;
                    break;
                }
                default: {
                    this.choices = new String[0];
                }
            }
        }
        return this.choices;
    }

    public Enum<?> getEnumValue(int intValue) {
        switch (this.type) {
            case ENUM: 
            case ENUMSET: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return enums[intValue];
            }
        }
        return null;
    }

    public Set<Target> getTargets() {
        return this.targets;
    }

    public List<Pair<LayoutOptionData, Object>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object getDefault() {
        if (this.defaultValue instanceof Cloneable) {
            try {
                Method cloneMethod = this.defaultValue.getClass().getMethod("clone", new Class[0]);
                return cloneMethod.invoke(this.defaultValue, new Object[0]);
            }
            catch (Exception e) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    public Comparable<? super Object> getLowerBound() {
        if (this.lowerBound instanceof Comparable) {
            return (Comparable)this.lowerBound;
        }
        return Property.NEGATIVE_INFINITY;
    }

    public void setLowerBound(Object lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Comparable<? super Object> getUpperBound() {
        if (this.upperBound instanceof Comparable) {
            return (Comparable)this.upperBound;
        }
        return Property.POSITIVE_INFINITY;
    }

    public void setUpperBound(Object upperBound) {
        this.upperBound = upperBound;
    }

    public Class<?> getOptionClass() {
        return this.clazz;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String[] getLegacyIds() {
        return this.legacyIds;
    }

    public static enum Target {
        PARENTS,
        NODES,
        EDGES,
        PORTS,
        LABELS;

    }

    public static enum Type {
        UNDEFINED,
        BOOLEAN,
        INT,
        STRING,
        DOUBLE,
        ENUM,
        ENUMSET,
        OBJECT;

    }

    public static enum Visibility {
        VISIBLE,
        ADVANCED,
        HIDDEN;

    }
}

