/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SelfLoopPostProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Self-Loop post-processing", 1.0f);
        for (Layer layer : graph) {
            for (LNode node : layer.getNodes()) {
                for (LEdge edge : node.getOutgoingEdges()) {
                    if (!edge.isSelfLoop()) continue;
                    KVector offset = edge.getSource().getNode().getPosition();
                    edge.getBendPoints().offset(offset);
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    junctionPoints.offset(offset);
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(offset);
                    }
                }
            }
        }
        monitor.done();
    }
}

