/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.core.options.PortSide;

public class SelfLoopPort {
    private final LPort port;
    private PortSide portSide;
    private SelfLoopRoutingDirection direction;
    private int maximumLevel = 0;
    private Map<LEdge, Integer> edgeToLevelMap = new HashMap<LEdge, Integer>();
    private SelfLoopComponent component;
    private List<SelfLoopEdge> connectedEdges = new ArrayList<SelfLoopEdge>();
    private boolean isNonLoopPort = false;
    private int originalIndex;
    private double otherEdgeOffset;

    public SelfLoopPort(LPort port, SelfLoopComponent selfLoopComponent) {
        this.port = port;
        this.setOriginalIndex(port.getIndex());
        this.portSide = port.getSide();
        this.component = selfLoopComponent;
        this.isNonLoopPort = this.computeNonLoopPortProperty(port);
    }

    private boolean computeNonLoopPortProperty(LPort lPort) {
        for (LEdge edge : lPort.getConnectedEdges()) {
            LPort relevantPort = edge.getTarget() == lPort ? edge.getSource() : edge.getTarget();
            if (relevantPort.getNode() != lPort.getNode()) continue;
            return false;
        }
        return lPort.getConnectedEdges().iterator().hasNext();
    }

    public LPort getLPort() {
        return this.port;
    }

    public PortSide getPortSide() {
        return this.portSide;
    }

    public void setPortSide(PortSide side) {
        this.portSide = side;
    }

    public SelfLoopRoutingDirection getDirection() {
        return this.direction;
    }

    public void setDirection(SelfLoopRoutingDirection direction) {
        this.direction = direction;
    }

    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    public void setMaximumLevel(int level) {
        this.maximumLevel = level;
    }

    public int getEdgeLevel(LEdge edge) {
        Integer nonHyperEdgeLevel = this.edgeToLevelMap.get((Object)edge);
        return nonHyperEdgeLevel == null ? this.maximumLevel : nonHyperEdgeLevel;
    }

    public void setEdgeLevel(LEdge edge, int level) {
        this.edgeToLevelMap.put(edge, level);
    }

    public SelfLoopComponent getComponent() {
        return this.component;
    }

    public void setComponent(SelfLoopComponent component) {
        this.component = component;
    }

    public List<SelfLoopEdge> getConnectedEdges() {
        return this.connectedEdges;
    }

    public boolean isNonLoopPort() {
        return this.isNonLoopPort;
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public void setOriginalIndex(int originalIndex) {
        this.originalIndex = originalIndex;
    }

    public double getOtherEdgeOffset() {
        return this.otherEdgeOffset;
    }

    public void setOtherEdgeOffset(double otherEdgeOffset) {
        this.otherEdgeOffset = otherEdgeOffset;
    }

    public String toString() {
        return String.valueOf(this.port.toString()) + "(" + this.portSide + ", " + (Object)((Object)this.direction) + ")";
    }
}

