/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.routing;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.AbstractSelfLoopRouter;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public class OrthogonalSelfLoopRouter
extends AbstractSelfLoopRouter {
    @Override
    public void routeSideSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        lEdge.getBendPoints().addAll(new KVector[]{sourceBendPoint, targetBendPoint});
    }

    @Override
    public void routeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        KVector cornerBendPoint = OrthogonalSelfLoopRouter.computeSingleCornerBendPoint(sourceBendPoint, targetBendPoint, slEdge.getTarget().getPortSide());
        lEdge.getBendPoints().addAll(new KVector[]{sourceBendPoint, cornerBendPoint, targetBendPoint});
    }

    @Override
    public void routeOpposingSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopNode slNode = (SelfLoopNode)lEdge.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.add((Object)sourceBendPoint);
        bendPoints.addAll(cornerBendPoints);
        bendPoints.add((Object)targetBendPoint);
    }

    @Override
    public void routeThreeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopNode slNode = (SelfLoopNode)lEdge.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.add((Object)sourceBendPoint);
        bendPoints.addAll(cornerBendPoints);
        bendPoints.add((Object)targetBendPoint);
    }

    @Override
    public void routeFourCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopNode slNode = (SelfLoopNode)lEdge.getSource().getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        KVectorChain bendPoints = lEdge.getBendPoints();
        bendPoints.add((Object)sourceBendPoint);
        bendPoints.addAll(cornerBendPoints);
        bendPoints.add((Object)targetBendPoint);
    }
}

