/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing;

import org.eclipse.elk.alg.common.nodespacing.cellsystem.Cell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.ContainerArea;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.GridContainerCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.CellSystemConfigurator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.HorizontalPortPlacementSizeCalculator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.InsidePortLabelCellCreator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.LabelPlacer;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.NodeLabelCellCreator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.NodeSizeCalculator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortContextCreator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortLabelPlacementCalculator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortPlacementCalculator;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.VerticalPortPlacementSizeCalculator;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class NodeLabelAndSizeCalculator {
    private NodeLabelAndSizeCalculator() {
    }

    public static void process(GraphAdapters.GraphAdapter<?> graph) {
        graph.getNodes().forEach(node -> {
            KVector kVector = NodeLabelAndSizeCalculator.process(graph, node, true, false);
        });
    }

    public static KVector process(GraphAdapters.GraphAdapter<?> graph, GraphAdapters.NodeAdapter<?> node, boolean applyStuff, boolean ignoreInsidePortLabels) {
        NodeContext nodeContext = new NodeContext(graph, node);
        PortContextCreator.createPortContexts(nodeContext, ignoreInsidePortLabels);
        NodeLabelCellCreator.createNodeLabelCells(nodeContext, false, graph == null ? true : ((Direction)graph.getProperty(CoreOptions.DIRECTION)).isHorizontal());
        InsidePortLabelCellCreator.createInsidePortLabelCells(nodeContext);
        NodeLabelAndSizeUtilities.setupMinimumClientAreaSize(nodeContext);
        NodeLabelAndSizeUtilities.setupNodePaddingForPortsWithOffset(nodeContext);
        HorizontalPortPlacementSizeCalculator.calculateHorizontalPortPlacementSize(nodeContext);
        VerticalPortPlacementSizeCalculator.calculateVerticalPortPlacementSize(nodeContext);
        CellSystemConfigurator.configureCellSystemSizeContributions(nodeContext);
        NodeSizeCalculator.setNodeWidth(nodeContext);
        PortPlacementCalculator.placeHorizontalPorts(nodeContext);
        PortLabelPlacementCalculator.placeHorizontalPortLabels(nodeContext);
        CellSystemConfigurator.updateVerticalInsidePortLabelCellPadding(nodeContext);
        NodeSizeCalculator.setNodeHeight(nodeContext);
        if (!applyStuff) {
            return nodeContext.nodeSize;
        }
        NodeLabelAndSizeUtilities.offsetSouthernPortsByNodeSize(nodeContext);
        PortPlacementCalculator.placeVerticalPorts(nodeContext);
        PortLabelPlacementCalculator.placeVerticalPortLabels(nodeContext);
        LabelPlacer.placeLabels(nodeContext);
        NodeLabelAndSizeUtilities.setNodePadding(nodeContext);
        NodeLabelAndSizeUtilities.applyStuff(nodeContext);
        return nodeContext.nodeSize;
    }

    public static ElkPadding computeInsideNodeLabelPadding(GraphAdapters.GraphAdapter<?> graph, GraphAdapters.NodeAdapter<?> node) {
        ContainerArea row;
        Cell labelCell;
        ContainerArea col;
        NodeContext nodeContext = new NodeContext(null, node);
        NodeLabelCellCreator.createNodeLabelCells(nodeContext, true, graph == null ? true : ((Direction)graph.getProperty(CoreOptions.DIRECTION)).isHorizontal());
        GridContainerCell labelCellContainer = nodeContext.insideNodeLabelContainer;
        ElkPadding padding = new ElkPadding();
        ContainerArea[] containerAreaArray = ContainerArea.values();
        int n = containerAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            col = containerAreaArray[n2];
            labelCell = labelCellContainer.getCell(ContainerArea.BEGIN, col);
            if (labelCell != null) {
                padding.top = Math.max(padding.top, labelCell.getMinimumHeight());
            }
            ++n2;
        }
        containerAreaArray = ContainerArea.values();
        n = containerAreaArray.length;
        n2 = 0;
        while (n2 < n) {
            col = containerAreaArray[n2];
            labelCell = labelCellContainer.getCell(ContainerArea.END, col);
            if (labelCell != null) {
                padding.bottom = Math.max(padding.bottom, labelCell.getMinimumHeight());
            }
            ++n2;
        }
        containerAreaArray = ContainerArea.values();
        n = containerAreaArray.length;
        n2 = 0;
        while (n2 < n) {
            row = containerAreaArray[n2];
            labelCell = labelCellContainer.getCell(row, ContainerArea.BEGIN);
            if (labelCell != null) {
                padding.left = Math.max(padding.left, labelCell.getMinimumWidth());
            }
            ++n2;
        }
        containerAreaArray = ContainerArea.values();
        n = containerAreaArray.length;
        n2 = 0;
        while (n2 < n) {
            row = containerAreaArray[n2];
            labelCell = labelCellContainer.getCell(row, ContainerArea.END);
            if (labelCell != null) {
                padding.right = Math.max(padding.right, labelCell.getMinimumWidth());
            }
            ++n2;
        }
        if (padding.top > 0.0) {
            padding.top += labelCellContainer.getPadding().top;
            padding.top += labelCellContainer.getGap();
        }
        if (padding.bottom > 0.0) {
            padding.bottom += labelCellContainer.getPadding().bottom;
            padding.bottom += labelCellContainer.getGap();
        }
        if (padding.left > 0.0) {
            padding.left += labelCellContainer.getPadding().left;
            padding.left += labelCellContainer.getGap();
        }
        if (padding.right > 0.0) {
            padding.right += labelCellContainer.getPadding().right;
            padding.right += labelCellContainer.getGap();
        }
        return padding;
    }
}

