/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.ui.preferences;

import org.eclipse.embedcdt.packs.data.Repos;
import org.eclipse.embedcdt.packs.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRepoDialog
extends Dialog {
    private boolean fIsEdit;
    private String[] fData;
    private String[] fTypeSelections = Repos.TYPES;
    private Combo fTypeCombo;
    private Text fNameText;
    private Text fUrlText;
    private String fReturnType;
    private String fReturnName;
    private String fReturnUrl;

    protected NewRepoDialog(Shell parentShell, String[] data) {
        super(parentShell);
        this.fIsEdit = data != null;
        this.fData = data;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = this.fIsEdit ? Messages.NewSiteDialog_label_title_edit : Messages.NewSiteDialog_label_title_new;
        if (title != null) {
            shell.setText(title);
        }
    }

    protected String[] getData() {
        return new String[]{this.fReturnType, this.fReturnName, this.fReturnUrl};
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginWidth = 10;
        comp.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.widthHint = 400;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        comp.setLayoutData((Object)layoutData);
        Label typeLabel = new Label(comp, 16384);
        typeLabel.setText(Messages.NewSiteDialog_label_type);
        layoutData = new GridData();
        typeLabel.setLayoutData((Object)layoutData);
        this.fTypeCombo = new Combo(comp, 8);
        this.fTypeCombo.setItems(this.fTypeSelections);
        int ix = 0;
        if (this.fIsEdit) {
            int i = 0;
            while (i < this.fTypeSelections.length) {
                if (this.fData[0].equals(this.fTypeSelections[i])) {
                    ix = i;
                    break;
                }
                ++i;
            }
        }
        this.fTypeCombo.select(ix);
        this.fReturnType = this.fTypeSelections[ix];
        layoutData = new GridData();
        this.fTypeCombo.setLayoutData((Object)layoutData);
        Label nameLabel = new Label(comp, 16384);
        nameLabel.setText(Messages.NewSiteDialog_label_name);
        layoutData = new GridData();
        nameLabel.setLayoutData((Object)layoutData);
        this.fNameText = new Text(comp, 2052);
        if (this.fIsEdit) {
            this.fNameText.setText(this.fData[1]);
        } else {
            this.fNameText.setText("");
        }
        this.fReturnName = this.fNameText.getText();
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.fNameText.setLayoutData((Object)layoutData);
        Label urlLabel = new Label(comp, 16384);
        urlLabel.setText(Messages.NewSiteDialog_label_url);
        layoutData = new GridData();
        urlLabel.setLayoutData((Object)layoutData);
        this.fUrlText = new Text(comp, 2052);
        if (this.fIsEdit) {
            this.fUrlText.setText(this.fData[2]);
        } else {
            this.fUrlText.setText("");
        }
        this.fReturnUrl = this.fUrlText.getText();
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.fUrlText.setLayoutData((Object)layoutData);
        this.fTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRepoDialog.this.fReturnType = NewRepoDialog.this.fTypeCombo.getText();
            }
        });
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRepoDialog.this.fReturnName = NewRepoDialog.this.fNameText.getText();
            }
        });
        this.fUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRepoDialog.this.fReturnUrl = NewRepoDialog.this.fUrlText.getText();
            }
        });
        return comp;
    }
}

