/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.arm.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.arm.core.Activator;

public class ToolchainDefinition
extends org.eclipse.embedcdt.managedbuild.cross.core.ToolchainDefinition {
    public static final String XPACK_ARM_GCC = "xPack GNU Arm Embedded GCC";
    public static final String XPACK_AARCH64_GCC = "xPack GNU AArch64 Embedded GCC";
    public static final String GME_ARM_GCC = "GNU MCU Eclipse ARM Embedded GCC";
    public static final String GNU_TOOLS_FOR_ARM_EMBEDDED = "GNU Tools for ARM Embedded Processors";
    public static final String DEFAULT_TOOLCHAIN_NAME = "xPack GNU Arm Embedded GCC";
    protected static List<ToolchainDefinition> fgList = new ArrayList<ToolchainDefinition>();
    protected static String[] fgArchitectures = new String[]{"ARM (AArch32)", "ARM64 (AArch64)"};
    private static final String CUSTOM_TOOLCHAINS_EXTENSION_POINT_ID = "org.eclipse.embedcdt.managedbuild.cross.arm.core.toolchains";

    static {
        ToolchainDefinition tc = new ToolchainDefinition("xPack GNU Arm Embedded GCC", "arm-none-eabi-");
        tc.setId("435435382");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition(GNU_TOOLS_FOR_ARM_EMBEDDED, "arm-none-eabi-");
        tc.setId("1287942917");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro ARMv7 bare-metal EABI", "arm-none-eabi-");
        tc.setId("976189281");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro ARMv7 big-endian bare-metal EABI", "armeb-none-eabi-");
        tc.setId("1341156853");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro ARMv7 Linux GNU EABI HF", "arm-linux-gnueabihf-");
        tc.setId("4014586055");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro ARMv7 big-endian Linux GNU EABI HF", "armeb-linux-gnueabihf-");
        tc.setId("2561104475");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition(GME_ARM_GCC, "arm-none-eabi-");
        tc.setId("962691777");
        tc.setIsDeprecated(true);
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM EABI", "arm-none-eabi-");
        tc.setId("730666677");
        if (EclipseUtils.isWindows()) {
            tc.setWin("cs-make", "cs-rm");
        }
        tc.setIsDeprecated(true);
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM GNU/Linux", "arm-none-linux-gnueabi-");
        tc.setId("4162764353");
        if (EclipseUtils.isWindows()) {
            tc.setWin("cs-make", "cs-rm");
        }
        tc.setIsDeprecated(true);
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("devkitPro ARM EABI", "arm-eabi-");
        tc.setId("3695067803");
        tc.setIsDeprecated(true);
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Yagarto, Summon, etc. ARM EABI", "arm-none-eabi-");
        tc.setId("1195655929");
        tc.setIsDeprecated(true);
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition(XPACK_AARCH64_GCC, "aarch64-none-elf-", "aarch64");
        tc.setId("596462749");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro AArch64 bare-metal ELF", "aarch64-elf-", "aarch64");
        tc.setId("1871385609");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro AArch64 big-endian bare-metal ELF", "aarch64_be-elf-", "aarch64");
        tc.setId("2048201829");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro AArch64 Linux GNU", "aarch64-linux-gnu-", "aarch64");
        tc.setId("1246627524");
        ToolchainDefinition.addToolchain(tc);
        tc = new ToolchainDefinition("Linaro AArch64 big-endian Linux GNU", "aarch64_be-linux-gnu-", "aarch64");
        tc.setId("681852136");
        ToolchainDefinition.addToolchain(tc);
        ToolchainDefinition.addExtensionsToolchains(CUSTOM_TOOLCHAINS_EXTENSION_POINT_ID);
    }

    public ToolchainDefinition(String sName) {
        super(sName);
        this.fArchitecture = "arm";
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this(sName);
        this.fPrefix = sPrefix;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.fArchitecture = sArchitecture;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public void setArchitecture(String architecture) {
        assert (architecture.equals("arm") || architecture.equals("aarch64"));
        super.setArchitecture(architecture);
    }

    public static List<ToolchainDefinition> getList() {
        return fgList;
    }

    public static ToolchainDefinition getToolchain(int index) {
        return fgList.get(index);
    }

    public static ToolchainDefinition getToolchain(String index) {
        return fgList.get(Integer.parseInt(index));
    }

    public static int getSize() {
        return fgList.size();
    }

    public static void addToolchain(ToolchainDefinition toolchain) {
        fgList.add(toolchain);
    }

    public static int findToolchainByName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.fName.equals(sName)) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int findToolchainByFullName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            String sFullName = td.getFullName();
            if (sFullName.equals(sName)) {
                return i;
            }
            ++i;
        }
        return ToolchainDefinition.getDefault();
    }

    public static int findToolchainById(String sId) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.getId().equals(sId.trim())) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int getDefault() {
        return 0;
    }

    public static String[] getArchitectures() {
        return fgArchitectures;
    }

    public static String getArchitecture(int index) {
        return fgArchitectures[index];
    }

    public static void addExtensionsToolchains(String extensionPointId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                String cmdRm;
                String cmdMake;
                String architecture;
                String suffix;
                String prefix;
                String name;
                String id;
                IConfigurationElement element;
                block13: {
                    element = iConfigurationElementArray[n2];
                    id = element.getAttribute("id");
                    name = element.getAttribute("name");
                    if (id != null && !id.isEmpty()) {
                        try {
                            ToolchainDefinition.findToolchainById(id);
                            Activator.log((String)("Duplicate toolchain id '" + id + "', ignored."));
                            break block12;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            break block13;
                        }
                    }
                    try {
                        ToolchainDefinition.findToolchainByName(name);
                        Activator.log((String)("Duplicate toolchain name '" + name + "', ignored."));
                        break block12;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                ToolchainDefinition td = new ToolchainDefinition(name);
                if (id != null && !id.isEmpty()) {
                    td.setId(id);
                }
                if ((prefix = element.getAttribute("prefix")) != null && !prefix.isEmpty()) {
                    td.setPrefix(prefix);
                }
                if ((suffix = element.getAttribute("suffix")) != null && !suffix.isEmpty()) {
                    td.setSuffix(suffix);
                }
                if ((architecture = element.getAttribute("architecture")) != null && !architecture.isEmpty()) {
                    td.setArchitecture(architecture);
                }
                if ((cmdMake = element.getAttribute("make_cmd")) != null && !cmdMake.isEmpty()) {
                    td.setCmdMake(cmdMake);
                }
                if ((cmdRm = element.getAttribute("remove_cmd")) != null && !cmdRm.isEmpty()) {
                    td.setCmdRm(cmdRm);
                }
                fgList.add(td);
            }
            ++n2;
        }
    }
}

