/*******************************************************************************
 * Copyright (c) Philipps University of Marburg. All rights reserved. 
 * This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Philipps University of Marburg - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.refactor.refactoring.runtime.ltk.change;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.refactor.refactoring.runtime.history.EmfRefactorRefactoringDescriptor;
import org.eclipse.emf.refactor.refactoring.runtime.ltk.command.RefactoringCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/**
 * Class used for providing a LTK Change concerning redo
 * and undo functionality.
 * @generated NOT
 * @author Florian Mantz
 */
public class UndoRedoChange extends Change {
	
	/**
	 * Command from which the Change has been invoked.
	 */
	final RefactoringCommand command;
	
	/**
	 * EditingDomain object of the EMF model.
	 */
	final EditingDomain editingDomain;
	
	/**
	 * Name of the UndoRedoChange.
	 */
	final String name;
	
	/**
	 * Root object of the EMF model.
	 */
	final EObject root;
	
	/**
	 * Default constructor. 
	 * @param command Command from which the Change has been invoked.
	 * @param editingDomain EditingDomain object of the EMF model.
	 * @param name Name of the UndoRedoChange.
	 * @param root Root object of the EMF model.
	 */
	public UndoRedoChange(RefactoringCommand command,
			EditingDomain editingDomain, String name, EObject root) {
		super();
		this.command = command;
		this.editingDomain = editingDomain;
		this.name = name;
		this.root = root;
	}

	/**
	 * @see org.eclipse.ltk.core.refactoring.Change#getName()
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * @see org.eclipse.ltk.core.refactoring.Change#
	 * initializeValidationData(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public void initializeValidationData(IProgressMonitor pm) {
		// do nothing
	}

	/**
	 * @see org.eclipse.ltk.core.refactoring.Change#
	 * isValid(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public RefactoringStatus isValid(IProgressMonitor pm) 
					throws CoreException, OperationCanceledException {
		return new RefactoringStatus();
	}

	/**
	 * @see org.eclipse.ltk.core.refactoring.Change#
	 * perform(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public Change perform(IProgressMonitor pm) throws CoreException {
		editingDomain.getCommandStack().execute(command);
//		// Anpassung AW
		if (editingDomain instanceof TransactionalEditingDomain) {
			try {
				root.eResource().save(Collections.EMPTY_MAP);
				System.out.println("AW: manuelles speichern!");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
//		// END AW
		return new UndoRedoChange(command, editingDomain, name, root);
	}
	
	@Override
	public ChangeDescriptor getDescriptor() {
		return new RefactoringChangeDescriptor(new EmfRefactorRefactoringDescriptor("id", "project", "description", "comment", RefactoringDescriptor.NONE, null));
	}
	
	/**
	 * @see org.eclipse.ltk.core.refactoring.Change#getModifiedElement()
	 */
	@Override
	public Object getModifiedElement() {
		return root;
	}

}
