/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.codetomodel.listener;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import pum.simuref.codetomodel.listener.interfaces.IJavaToEmfRefactoring;
import pum.simuref.codetomodel.listener.manager.JavaToEmfRefactoringManager;
import pum.simuref.utils.InformationsGui;

class JavaRefactoringExecutionListener
implements IRefactoringExecutionListener {
    ArrayList<IJavaToEmfRefactoring> initialRefactorings;
    ArrayList<IJavaToEmfRefactoring> refactoringsToPerform = new ArrayList();

    JavaRefactoringExecutionListener() {
    }

    public void executionNotification(RefactoringExecutionEvent event) {
        int type = event.getEventType();
        RefactoringDescriptorProxy proxy = event.getDescriptor();
        RefactoringDescriptor ref = null;
        if (proxy != null) {
            ref = proxy.requestDescriptor((IProgressMonitor)new NullProgressMonitor());
        }
        if (type == 4) {
            this.inititializeRefactoring(ref);
        } else if (type == 1) {
            this.checkConditionsAndRunRefactoring(ref);
        }
    }

    private void inititializeRefactoring(RefactoringDescriptor ref) {
        try {
            JavaToEmfRefactoringManager.getInstance();
            this.initialRefactorings = JavaToEmfRefactoringManager.getMappedRefactorings(ref.getID());
            this.refactoringsToPerform.clear();
            if (this.initialRefactorings != null) {
                for (IJavaToEmfRefactoring refactoring : this.initialRefactorings) {
                    RefactoringContribution rc;
                    Map arg;
                    if (!refactoring.initialize(arg = (rc = RefactoringCore.getRefactoringContribution((String)ref.getID())).retrieveArgumentMap(ref))) continue;
                    this.refactoringsToPerform.add(refactoring);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void checkConditionsAndRunRefactoring(RefactoringDescriptor ref) {
        try {
            if (this.refactoringsToPerform != null) {
                for (IJavaToEmfRefactoring refactoring : this.refactoringsToPerform) {
                    if (refactoring == null) continue;
                    RefactoringStatus refactoringStatus = refactoring.checkConditions((IProgressMonitor)new NullProgressMonitor());
                    if (refactoringStatus.isOK()) {
                        refactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
                        continue;
                    }
                    InformationsGui.informRefactoringStatus((int)0, (RefactoringStatus)refactoringStatus);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

