/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.codetomodel.listener.core;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.interfaces.IController;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.emf.refactor.refactoring.managers.RefactoringManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import pum.simuref.codetomodel.listener.interfaces.IJavaToEmfRefactoring;
import pum.simuref.lock.Lock;
import pum.simuref.matching.MatchingFactory;
import pum.simuref.matching.codetomodel.IJavaToEmfMatching;

public abstract class JavaToEmfRefactoring
implements IJavaToEmfRefactoring {
    protected IJavaToEmfMatching matching;
    protected Refactoring modelRefactoring;
    protected RefactoringProcessor modelRefactoringProcessor;
    protected IController controller;
    protected IDataManagement dataManagement;

    public boolean initialize(String emfRefactoringId) {
        this.modelRefactoring = RefactoringManager.getById((String)emfRefactoringId);
        this.controller = this.modelRefactoring.getController();
        this.dataManagement = this.controller.getDataManagementObject();
        return Lock.getInstance().getLockCodeModel();
    }

    @Override
    public RefactoringStatus checkConditions(IProgressMonitor pm) {
        RefactoringStatus resultRefactoringStatus = new RefactoringStatus();
        try {
            resultRefactoringStatus = this.modelRefactoringProcessor.checkInitialConditions(pm);
            resultRefactoringStatus.merge(this.modelRefactoringProcessor.checkFinalConditions(pm, null));
            return resultRefactoringStatus;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return resultRefactoringStatus;
        }
    }

    protected void setJavaToEmfMatching(String matchingId) {
        this.matching = MatchingFactory.getFactory().getJavaToEmfMatching(matchingId);
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        return this.modelRefactoringProcessor.createChange(pm);
    }

    public void printMap(Map<String, String> refactoringMap) {
        for (Map.Entry<String, String> e : refactoringMap.entrySet()) {
            System.out.println(String.valueOf(e.getKey()) + "=" + e.getValue());
        }
    }

    @Override
    public String getEmfRefactoringId() {
        return this.modelRefactoring.getId();
    }
}

