/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.modeltocode.listener;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.refactor.refactoring.runtime.history.EmfRefactorRefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import pum.simuref.modeltocode.listener.interfaces.IEmfToJavaRefactoring;
import pum.simuref.modeltocode.listener.manager.EmfToJavaRefactoringManager;
import pum.simuref.utils.InformationsGui;

public class EmfRefactoringExecutionListener
implements IRefactoringExecutionListener {
    ArrayList<IEmfToJavaRefactoring> initialRefactorings;
    ArrayList<IEmfToJavaRefactoring> refactoringsToPerform = new ArrayList();

    public void executionNotification(RefactoringExecutionEvent event) {
        int type = event.getEventType();
        RefactoringDescriptorProxy proxy = event.getDescriptor();
        RefactoringDescriptor ref = null;
        if (proxy != null) {
            ref = proxy.requestDescriptor((IProgressMonitor)new NullProgressMonitor());
        }
        if (type == 4) {
            this.initializeRefactoring(ref);
        } else if (type == 1) {
            this.checkConditionsAndRunRefactoring(ref);
        }
    }

    private void initializeRefactoring(RefactoringDescriptor ref) {
        try {
            EmfToJavaRefactoringManager.getInstance();
            this.initialRefactorings = EmfToJavaRefactoringManager.getMappedRefactorings(ref.getID());
            this.refactoringsToPerform.clear();
            if (this.initialRefactorings != null) {
                EmfRefactorRefactoringDescriptor refDef = (EmfRefactorRefactoringDescriptor)ref;
                for (IEmfToJavaRefactoring refactoring : this.initialRefactorings) {
                    if (!refactoring.initialize(refDef.getIDataManagement())) continue;
                    this.refactoringsToPerform.add(refactoring);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void checkConditionsAndRunRefactoring(RefactoringDescriptor ref) {
        try {
            if (this.refactoringsToPerform != null) {
                for (IEmfToJavaRefactoring refactoring : this.refactoringsToPerform) {
                    if (refactoring == null) continue;
                    RefactoringStatus refactoringStatus = refactoring.checkConditions((IProgressMonitor)new NullProgressMonitor());
                    if (refactoringStatus.isOK()) {
                        refactoring.createChange((IProgressMonitor)new NullProgressMonitor()).perform((IProgressMonitor)new NullProgressMonitor());
                        continue;
                    }
                    InformationsGui.informRefactoringStatus((int)1, (RefactoringStatus)refactoringStatus);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

