package pum.simuref.modeltocode.participant.java;

import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.EncapsulateFieldDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Property;

import pum.simuref.configuration.managers.MappingManager;
import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.RefactoringArgumentsMapUtil;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;

public class HideAttributeParticipant extends EmfJavaRefactoringParticipant {
	
	private static final String JAVAREFACTORINGID = IJavaRefactorings.ENCAPSULATE_FIELD;
	private EncapsulateFieldDescriptor refactoringDescriptor;
	
	private Property fAttribute;
	private IField fIField;
	
	@Override
	protected boolean initialize(Object element) {
		fAttribute = (Property) contextElement;
		refactoringContribution = RefactoringCore.getRefactoringContribution(JAVAREFACTORINGID);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);

		Measurement.start();
		List<IField> candidates = matching.getMatchingIFieldsForEmfElement(fAttribute);
		Measurement.stop();
		
		fIField = InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidates);
		if (fIField == null)
			return false;

		String project = MappingManager.getInstance().getJavaProjectNameForEmfElement(fAttribute);
		String description = fArguments.toString();
		String comment = "Comment: " + fArguments.toString();
		int flags = 0;
		Map <String, String> arguments = RefactoringArgumentsMapUtil.getDefaultMap(JAVAREFACTORINGID);
		String input = fIField.getHandleIdentifier().replace(project+"=", "");
		RefactoringArgumentsMapUtil.customizeMap(arguments, JAVAREFACTORINGID, input, "set"+fAttribute.getName(), "get"+fAttribute.getName());
		refactoringDescriptor = (EncapsulateFieldDescriptor) refactoringContribution.createDescriptor(JAVAREFACTORINGID, project, description, comment, arguments, flags);

		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}
	
	@Override
	public String getName() {
		return "HideAttributeParticipant";
	}

}
