package pum.simuref.modeltocode.participant.java;

import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.PullUpDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

import pum.simuref.configuration.managers.MappingManager;
import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.RefactoringArgumentsMapUtil;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;

public class PullUpAttributeParticipant extends EmfJavaRefactoringParticipant {
	
	private PullUpDescriptor refactoringDescriptor;
	private static String JAVAREFACTORINGID = IJavaRefactorings.PULL_UP;
	
	private Property fProperty;
	private Class fClass;
	
	private IField fIField;
	private IType fIType;
	
	@Override
	protected boolean initialize(Object element) {
		fProperty = (Property) contextElement;
		String className = (String) fArguments.getEmfRefactoringArguments().getInPortByName("className").getValue(); 
		fClass = fProperty.getClass_().getSuperClass(className);
		refactoringContribution = RefactoringCore.getRefactoringContribution(IJavaRefactorings.PULL_UP);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);
		
		Measurement.start();
		List<IField> candidatesField = matching.getMatchingIFieldsForEmfElement(fProperty);
		List<IType> candidatesDestination = matching.getMatchingITypesForEmfElement(fClass);
		Measurement.stop();
		
		fIField = (IField) InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidatesField);
		if (fIField == null) 
			return false;
		
		fIType = (IType) InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidatesDestination);
		if (fIType == null)
			return false;
		
		String project = MappingManager.getInstance().getJavaProjectNameForEmfElement(fProperty);
		String description = fArguments.toString();
		String comment = "Comment: " + fArguments.toString();
		int flags = 0;
		String stringElement = fIField.getHandleIdentifier().replace("="+project, "");
		String stringDestination = fIType.getHandleIdentifier().replace("="+project, "");
		
		Map <String, String> arguments = RefactoringArgumentsMapUtil.getDefaultMap(IJavaRefactorings.PULL_UP);
		RefactoringArgumentsMapUtil.customizeMap(arguments, IJavaRefactorings.PULL_UP, stringDestination, stringElement);
		refactoringDescriptor = (PullUpDescriptor) refactoringContribution.createDescriptor(JAVAREFACTORINGID, project, description, comment, arguments, flags);

		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

	@Override
	public String getName() {
		return "PullUpAttributeParticipant";
	}
}
