package pum.simuref.modeltocode.participant.arguments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.refactor.refactoring.core.Port;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

/**
 * Allgemeiner Informationstrger fr die Refactoring Informationen
 * @author alex
 *
 */
public class EmfRefactoringArguments extends RefactoringArguments{
	
	/**
	 * 	Jedes Emf Refactor Refactoring verfgt ber dieses Interface. 
	 * 	Darber knnen die Informationen verallgemeinert abgegriffen werden.
	 * 	Als folge der Verallgemeinerung muss die Extrahierung der Informationen 
	 * 	verlagert werden.
	 */
	private IDataManagement emfRefactoringArguments;
	
	public EmfRefactoringArguments(IDataManagement dataManagement) {
		Assert.isNotNull(dataManagement);
		this.emfRefactoringArguments = dataManagement;
	}

	public IDataManagement getEmfRefactoringArguments() {
		return emfRefactoringArguments;
	}
	
	public String toString() {
		StringBuffer stringBuffer = new StringBuffer();
		for (Port port : emfRefactoringArguments.getInPorts()) {
			stringBuffer.append(port);
		}
		return stringBuffer.toString();
	}
	
}
