package pum.simuref.modeltocode.participant.management;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

import pum.simuref.modeltocode.participant.Activator;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.modeltocode.participant.participants.EmfParticipantExtensionPoint;


/**
 * Manager fr die ber die ExtensionPoints definierten Participants fr die EMF Refactor Refactorings.
 * @author alex
 *
 */
public class EmfParticipantManager {

	private EmfParticipantManager() {
		
	}
	
	/**
	 * 	Variable mit der ID des ExtensionPoints
	 * 	Instanz zum Ermitteln der registrierten Extensions.
	 */
	private static final String EMF_REFACTORING_PARTICIPANT_EXT_POINT = "emfRefactoringParticipant";
	private static EmfParticipantExtensionPoint fgEmfRefactoringInstance=
			new EmfParticipantExtensionPoint(Activator.getPluginId(), EMF_REFACTORING_PARTICIPANT_EXT_POINT, EmfJavaRefactoringParticipant.class);

	/**
	 * Ldt die Participants fr die EMF Refactor Refactorings
	 * @param id, die ID des EMF Refactorings
	 * @return Array mit den Participants fr das gegebene Refactoring. 
	 */
	public static RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, Object element, 
		RefactoringArguments arguments, SharableParticipants shared, String emfRefactoringId) {
		RefactoringParticipant[] participants= fgEmfRefactoringInstance.getParticipants(status, processor, element, arguments, null, null, shared, emfRefactoringId);
		EmfJavaRefactoringParticipant[] result= new EmfJavaRefactoringParticipant[participants.length];
		System.arraycopy(participants, 0, result, 0, participants.length);
		return result;
	}
}
