package pum.simuref.modeltocode.participant.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

import pum.simuref.matching.MatchingFactory;
import pum.simuref.matching.modeltocode.IEmfToJavaMatching;
import pum.simuref.modeltocode.participant.arguments.EmfRefactoringArguments;

abstract public class EmfJavaRefactoringParticipant extends RefactoringParticipant {
	
	protected final String SELECTEDEOBJECT = "selectedEObject";
	protected RefactoringContribution refactoringContribution;
	protected Refactoring refactoring;
	protected EObject contextElement;
	protected EmfRefactoringArguments fArguments;
	protected IEmfToJavaMatching matching;
	
	protected final void initialize(RefactoringArguments arguments) {
		fArguments = (EmfRefactoringArguments) arguments;
	}
	
	public EmfRefactoringArguments getArguments() {
		return fArguments;
	}
	
	
	public RefactoringStatus checkConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws OperationCanceledException {
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		System.out.println("checkConditions " + getName());
		try {
			refactoringStatus = refactoring.checkInitialConditions(pm);
			refactoringStatus.merge(refactoring.checkFinalConditions(pm));
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return refactoringStatus;
	}

	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {
		System.out.println("createChange " + getName());
		return refactoring.createChange(pm);
	}
	
	protected void setEmfToJavaMatching(String matchingId) {
		matching = MatchingFactory.getFactory().getEmfToJavaMatching(matchingId, contextElement);
	}
	
	public boolean initialize(RefactoringProcessor processor, Object element,
			RefactoringArguments arguments) {
		System.out.println("initialize with abstract JavaEmfRefactoringParticipant");
		this.fArguments = (EmfRefactoringArguments) arguments;
		if (fArguments.getEmfRefactoringArguments().getInPortByName(SELECTEDEOBJECT).getValue() instanceof EObject) {
			contextElement = (EObject) fArguments.getEmfRefactoringArguments().getInPortByName(SELECTEDEOBJECT).getValue();
		}
		// Lock
		if (!pum.simuref.lock.Lock.getInstance().getLockModelCode()) 
			return false;
		return super.initialize(processor, element, arguments);
	}
}
